//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "ConfigController.h"

@implementation ConfigController

- (id)init {
	if (self = [super init]) {
		self.title = NSLocalizedString(@"ConfigTitle", nil);
		
		UIImage* image = [UIImage imageNamed:@"config.png"];
		self.tabBarItem = [[[UITabBarItem alloc] 
							initWithTitle:NSLocalizedString(@"ConfigTitle", nil)
							image:image tag:1] autorelease];

		self.navigationItem.backBarButtonItem =
		[[[UIBarButtonItem alloc] initWithTitle:NSLocalizedString(@"ConfigBackButton", nil) style:UIBarButtonItemStyleBordered
										 target:nil action:nil] autorelease];
		
		self.tableViewStyle = UITableViewStyleGrouped;
	}
	return self;
}

- (void)createModel {
	// retrieve version
	NSString *version = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
	self.dataSource = [TTSectionedDataSource dataSourceWithObjects:
					   NSLocalizedString(@"ConfigSetting",nil),
					   [TTTableTextItem itemWithText:NSLocalizedString(@"ConfigServerInfo", nil) URL:@"tt://config/setting/server"],

					   NSLocalizedString(@"ConfigInformation",nil),
					   [TTTableTextItem itemWithText:[NSString stringWithFormat:NSLocalizedString(@"ConfingVersionInfo",nil), version]],
					   [TTTableTextItem itemWithText:NSLocalizedString(@"ConfigLicense", nil) URL:[NSString stringWithFormat:@"tt://common/text/%@/license", @"ConfigLicense"]],
					   [TTTableTextItem itemWithText:NSLocalizedString(@"ConfigCopyright", nil) URL:[NSString stringWithFormat:@"tt://common/text/%@/copyright", @"ConfigCopyright"]],
					   [TTTableTextItem itemWithText:NSLocalizedString(@"ConfigDevelopedBy", nil) URL:[NSString stringWithFormat:@"tt://common/text/%@/developedby", @"ConfigDevelopedBy"]],

					   nil];
}

@end