/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.entity;

import java.util.ArrayList;
import java.util.List;

import jp.sf.fess.Constants;

import org.seasar.framework.util.StringUtil;

public class SearchQuery {
    private String query;

    private List<SortField> sortFieldList = new ArrayList<SortField>();

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SearchQuery query(String query) {
        setQuery(query);
        return this;
    }

    public boolean queryExists() {
        return StringUtil.isNotBlank(query);
    }

    public void addSortField(String field, String order) {
        if (StringUtil.isNotBlank(field)
                && (Constants.ASC.equals(order) || Constants.DESC.equals(order))) {
            SortField sortField = new SortField();
            sortField.setField(field);
            sortField.setOrder(order);
            sortFieldList.add(sortField);
        }
    }

    public SearchQuery sortField(String field, String order) {
        addSortField(field, order);
        return this;
    }

    public SortField[] getSortFields() {
        return sortFieldList.toArray(new SortField[sortFieldList.size()]);
    }

    public static class SortField {
        private String field;

        private String order;

        public String getField() {
            return field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getOrder() {
            return order;
        }

        public void setOrder(String order) {
            this.order = order;
        }
    }
}
