/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeCQ;
import jp.sf.fess.db.cbean.nss.DataCrawlingConfigNss;
import jp.sf.fess.db.cbean.nss.LabelTypeNss;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of DATA_CONFIG_TO_LABEL_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataConfigToLabelTypeMappingCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected DataConfigToLabelTypeMappingCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    public String getTableSqlName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public DataConfigToLabelTypeMappingCQ query() {
        return getConditionQuery();
    }

    public DataConfigToLabelTypeMappingCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new DataConfigToLabelTypeMappingCQ(null,
                    getSqlClause(), getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void query(DataConfigToLabelTypeMappingCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<DataConfigToLabelTypeMappingCB> unionQuery) {
        final DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final DataConfigToLabelTypeMappingCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void query(DataConfigToLabelTypeMappingCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<DataConfigToLabelTypeMappingCB> unionQuery) {
        final DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final DataConfigToLabelTypeMappingCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============
    protected DataCrawlingConfigNss _nssDataCrawlingConfig;

    public DataCrawlingConfigNss getNssDataCrawlingConfig() {
        if (_nssDataCrawlingConfig == null) {
            _nssDataCrawlingConfig = new DataCrawlingConfigNss(null);
        }
        return _nssDataCrawlingConfig;
    }

    public DataCrawlingConfigNss setupSelect_DataCrawlingConfig() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryDataCrawlingConfig();
            }
        });
        if (_nssDataCrawlingConfig == null
                || !_nssDataCrawlingConfig.hasConditionQuery()) {
            _nssDataCrawlingConfig = new DataCrawlingConfigNss(query()
                    .queryDataCrawlingConfig());
        }
        return _nssDataCrawlingConfig;
    }

    protected LabelTypeNss _nssLabelType;

    public LabelTypeNss getNssLabelType() {
        if (_nssLabelType == null) {
            _nssLabelType = new LabelTypeNss(null);
        }
        return _nssLabelType;
    }

    public LabelTypeNss setupSelect_LabelType() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryLabelType();
            }
        });
        if (_nssLabelType == null || !_nssLabelType.hasConditionQuery()) {
            _nssLabelType = new LabelTypeNss(query().queryLabelType());
        }
        return _nssLabelType;
    }

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<DataConfigToLabelTypeMappingCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public DataConfigToLabelTypeMappingCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends
            AbstractSpecification<DataConfigToLabelTypeMappingCQ> {
        protected SpQyCall<DataConfigToLabelTypeMappingCQ> _myQyCall;

        protected DataCrawlingConfigCB.Specification _dataCrawlingConfig;

        protected LabelTypeCB.Specification _labelType;

        public Specification(ConditionBean baseCB,
                SpQyCall<DataConfigToLabelTypeMappingCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnDataConfigId() {
            doColumn("DATA_CONFIG_ID");
        }

        public void columnLabelTypeId() {
            doColumn("LABEL_TYPE_ID");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
            if (_myQyCall.qy().hasConditionQueryDataCrawlingConfig()) {
                columnDataConfigId(); // FK
            }
            if (_myQyCall.qy().hasConditionQueryLabelType()) {
                columnLabelTypeId(); // FK
            }
        }

        protected String getTableDbName() {
            return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
        }

        public DataCrawlingConfigCB.Specification specifyDataCrawlingConfig() {
            assertForeign("dataCrawlingConfig");
            if (_dataCrawlingConfig == null) {
                _dataCrawlingConfig = new DataCrawlingConfigCB.Specification(
                        _baseCB,
                        new SpQyCall<DataCrawlingConfigCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall
                                                .qy()
                                                .hasConditionQueryDataCrawlingConfig();
                            }

                            public DataCrawlingConfigCQ qy() {
                                return _myQyCall.qy().queryDataCrawlingConfig();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _dataCrawlingConfig;
        }

        public LabelTypeCB.Specification specifyLabelType() {
            assertForeign("labelType");
            if (_labelType == null) {
                _labelType = new LabelTypeCB.Specification(_baseCB,
                        new SpQyCall<LabelTypeCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall.qy()
                                                .hasConditionQueryLabelType();
                            }

                            public LabelTypeCQ qy() {
                                return _myQyCall.qy().queryLabelType();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _labelType;
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return DataConfigToLabelTypeMappingCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return DataConfigToLabelTypeMappingCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
