/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.validator;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.struts.action.ActionMessages;
import org.seasar.chronos.core.trigger.cron.CronExpression;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.validator.S2FieldChecks;

public class CronExpressionChecks extends S2FieldChecks {

    private static final long serialVersionUID = 1L;

    public static boolean validateCronExpression(Object bean,
            ValidatorAction validatorAction, Field field,
            ActionMessages errors, Validator validator,
            HttpServletRequest request) {
        String value = getValueAsString(bean, field);
        if (StringUtil.isNotBlank(value)) {
            if (!CronExpression.isValidExpression(value)) {
                addError(errors, field, validator, validatorAction, request);
                return false;
            }
        }
        return true;
    }

}
