/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.PathMappingDbm;
import jp.sf.fess.db.cbean.PathMappingCB;
import jp.sf.fess.db.exentity.PathMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of PATH_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, REGEX, REPLACEMENT, PROCESS_TYPE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsPathMappingBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "PATH_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return PathMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public PathMappingDbm getMyDBMeta() {
        return PathMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public PathMapping newMyEntity() {
        return new PathMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public PathMappingCB newMyConditionBean() {
        return new PathMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * int count = pathMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(PathMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(PathMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;PathMapping&gt;() {
     *     public void handle(PathMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of PathMapping. (NotNull)
     */
    public void selectCursor(PathMappingCB cb,
            EntityRowHandler<PathMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> void doSelectCursor(
            PathMappingCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<PathMapping>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * PathMapping pathMapping = pathMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (pathMapping != null) {
     *     ... = pathMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectEntity(PathMappingCB cb) {
        return doSelectEntity(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectEntity(
            final PathMappingCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * PathMapping pathMapping = pathMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = pathMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectEntityWithDeletedCheck(PathMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectEntityWithDeletedCheck(
            final PathMappingCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private PathMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        PathMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;PathMapping&gt; pathMappingList = pathMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (PathMapping pathMapping : pathMappingList) {
     *     ... = pathMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<PathMapping> selectList(PathMappingCB cb) {
        return doSelectList(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ListResultBean<ENTITY> doSelectList(
            PathMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;PathMapping&gt; page = pathMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (PathMapping pathMapping : page) {
     *     ... = pathMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<PathMapping> selectPage(PathMappingCB cb) {
        return doSelectPage(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> PagingResultBean<ENTITY> doSelectPage(
            PathMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, PathMappingCB>() {
                    public int callbackSelectCount(PathMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(PathMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * pathMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<PathMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends PathMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * pathMapping.setFoo...(value);
     * pathMapping.setBar...(value);
     * pathMappingBhv.<span style="color: #FD4747">insert</span>(pathMapping);
     * ... = pathMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param pathMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(PathMapping pathMapping) {
        assertEntityNotNull(pathMapping);
        delegateInsert(pathMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     pathMappingBhv.<span style="color: #FD4747">update</span>(pathMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final PathMapping pathMapping) {
        helpUpdateInternally(pathMapping,
                new InternalUpdateCallback<PathMapping>() {
                    public int callbackDelegateUpdate(PathMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">updateNonstrict</span>(pathMapping);
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final PathMapping pathMapping) {
        helpUpdateNonstrictInternally(pathMapping,
                new InternalUpdateNonstrictCallback<PathMapping>() {
                    public int callbackDelegateUpdateNonstrict(
                            PathMapping entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final PathMapping pathMapping) {
        helpInsertOrUpdateInternally(
                pathMapping,
                new InternalInsertOrUpdateCallback<PathMapping, PathMappingCB>() {
                    public void callbackInsert(PathMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(PathMapping entity) {
                        update(entity);
                    }

                    public PathMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(PathMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(PathMapping pathMapping) {
        helpInsertOrUpdateInternally(pathMapping,
                new InternalInsertOrUpdateNonstrictCallback<PathMapping>() {
                    public void callbackInsert(PathMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(PathMapping entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     pathMappingBhv.<span style="color: #FD4747">delete</span>(pathMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(PathMapping pathMapping) {
        helpDeleteInternally(pathMapping,
                new InternalDeleteCallback<PathMapping>() {
                    public int callbackDelegateDelete(PathMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">deleteNonstrict</span>(pathMapping);
     * </pre>
     * @param pathMapping Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(PathMapping pathMapping) {
        helpDeleteNonstrictInternally(pathMapping,
                new InternalDeleteNonstrictCallback<PathMapping>() {
                    public int callbackDelegateDeleteNonstrict(
                            PathMapping entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(pathMapping);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param pathMapping Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(PathMapping pathMapping) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                pathMapping,
                new InternalDeleteNonstrictIgnoreDeletedCallback<PathMapping>() {
                    public int callbackDelegateDeleteNonstrict(
                            PathMapping entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<PathMapping> pathMappingList) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        return delegateInsertList(pathMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<PathMapping> pathMappingList) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        return delegateUpdateList(pathMappingList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<PathMapping> pathMappingList) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        return delegateUpdateListNonstrict(pathMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<PathMapping> pathMappingList) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        return delegateDeleteList(pathMappingList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<PathMapping> pathMappingList) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        return delegateDeleteListNonstrict(pathMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//pathMapping.setPK...(value);</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">queryUpdate</span>(pathMapping, cb);
     * </pre>
     * @param pathMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(PathMapping pathMapping, PathMappingCB cb) {
        return delegateQueryUpdate(pathMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">queryDelete</span>(pathMapping, cb);
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(PathMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *         public void specify(PathMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     pathMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(pathMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(PathMapping pathMapping,
            final UpdateOption<PathMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(pathMapping,
                new InternalUpdateCallback<PathMapping>() {
                    public int callbackDelegateUpdate(PathMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *     public void specify(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * pathMappingBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(pathMapping, option);
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(PathMapping pathMapping,
            final UpdateOption<PathMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(pathMapping,
                new InternalUpdateNonstrictCallback<PathMapping>() {
                    public int callbackDelegateUpdateNonstrict(
                            PathMapping entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//pathMapping.setPK...(value);</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *     public void specify(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * pathMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(pathMapping, cb, option);
     * </pre>
     * @param pathMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(PathMapping pathMapping, PathMappingCB cb,
            final UpdateOption<PathMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(pathMapping, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        PathMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(PathMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends PathMapping> void delegateSelectCursor(
            PathMappingCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends PathMapping> List<ENTITY> delegateSelectList(
            PathMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(PathMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(PathMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(PathMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(PathMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(PathMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<PathMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<PathMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<PathMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<PathMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<PathMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(PathMapping e, PathMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(PathMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(PathMapping e,
            UpdateOption<PathMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(PathMapping e,
            UpdateOption<PathMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(PathMapping e, PathMappingCB cb,
            UpdateOption<PathMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected PathMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, PathMapping.class);
    }

    protected PathMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, PathMappingCB.class);
    }
}
