/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.ciq.CrawlingSessionInfoCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of CRAWLING_SESSION_INFO.
 * @author DBFlute(AutoGenerator)
 */
public class BsCrawlingSessionInfoCQ extends AbstractBsCrawlingSessionInfoCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected CrawlingSessionInfoCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsCrawlingSessionInfoCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from CRAWLING_SESSION_INFO) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public CrawlingSessionInfoCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new CrawlingSessionInfoCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join CRAWLING_SESSION_INFO on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public CrawlingSessionInfoCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        CrawlingSessionInfoCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _crawlingSessionId;

    public ConditionValue getCrawlingSessionId() {
        if (_crawlingSessionId == null) {
            _crawlingSessionId = nCV();
        }
        return _crawlingSessionId;
    }

    protected ConditionValue getCValueCrawlingSessionId() {
        return getCrawlingSessionId();
    }

    protected Map<String, CrawlingSessionCQ> _crawlingSessionId_InScopeSubQuery_CrawlingSessionMap;

    public Map<String, CrawlingSessionCQ> getCrawlingSessionId_InScopeSubQuery_CrawlingSession() {
        return _crawlingSessionId_InScopeSubQuery_CrawlingSessionMap;
    }

    public String keepCrawlingSessionId_InScopeSubQuery_CrawlingSession(
            CrawlingSessionCQ subQuery) {
        if (_crawlingSessionId_InScopeSubQuery_CrawlingSessionMap == null) {
            _crawlingSessionId_InScopeSubQuery_CrawlingSessionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_crawlingSessionId_InScopeSubQuery_CrawlingSessionMap.size() + 1);
        _crawlingSessionId_InScopeSubQuery_CrawlingSessionMap
                .put(key, subQuery);
        return "crawlingSessionId_InScopeSubQuery_CrawlingSession." + key;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_CrawlingSessionId_Asc() {
        regOBA("CRAWLING_SESSION_ID");
        return this;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_CrawlingSessionId_Desc() {
        regOBD("CRAWLING_SESSION_ID");
        return this;
    }

    protected ConditionValue _key;

    public ConditionValue getKey() {
        if (_key == null) {
            _key = nCV();
        }
        return _key;
    }

    protected ConditionValue getCValueKey() {
        return getKey();
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Key_Asc() {
        regOBA("KEY");
        return this;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Key_Desc() {
        regOBD("KEY");
        return this;
    }

    protected ConditionValue _value;

    public ConditionValue getValue() {
        if (_value == null) {
            _value = nCV();
        }
        return _value;
    }

    protected ConditionValue getCValueValue() {
        return getValue();
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Value_Asc() {
        regOBA("VALUE");
        return this;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_Value_Desc() {
        regOBD("VALUE");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsCrawlingSessionInfoCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsCrawlingSessionInfoCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsCrawlingSessionInfoCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsCrawlingSessionInfoCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        CrawlingSessionInfoCQ baseQuery = (CrawlingSessionInfoCQ) baseQueryAsSuper;
        CrawlingSessionInfoCQ unionQuery = (CrawlingSessionInfoCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryCrawlingSession()) {
            unionQuery.queryCrawlingSession().reflectRelationOnUnionQuery(
                    baseQuery.queryCrawlingSession(),
                    unionQuery.queryCrawlingSession());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    public CrawlingSessionCQ queryCrawlingSession() {
        return getConditionQueryCrawlingSession();
    }

    protected CrawlingSessionCQ _conditionQueryCrawlingSession;

    public CrawlingSessionCQ getConditionQueryCrawlingSession() {
        if (_conditionQueryCrawlingSession == null) {
            _conditionQueryCrawlingSession = xcreateQueryCrawlingSession();
            xsetupOuterJoinCrawlingSession();
        }
        return _conditionQueryCrawlingSession;
    }

    protected CrawlingSessionCQ xcreateQueryCrawlingSession() {
        String nrp = resolveNextRelationPath("CRAWLING_SESSION_INFO",
                "crawlingSession");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        CrawlingSessionCQ cq = new CrawlingSessionCQ(this, getSqlClause(), jan,
                getNextNestLevel());
        cq.xsetForeignPropertyName("crawlingSession");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinCrawlingSession() {
        CrawlingSessionCQ cq = getConditionQueryCrawlingSession();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("CRAWLING_SESSION_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryCrawlingSession() {
        return _conditionQueryCrawlingSession != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, CrawlingSessionInfoCQ> _scalarSubQueryMap;

    public Map<String, CrawlingSessionInfoCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(CrawlingSessionInfoCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, CrawlingSessionInfoCQ> _myselfInScopeSubQueryMap;

    public Map<String, CrawlingSessionInfoCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(CrawlingSessionInfoCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return CrawlingSessionInfoCB.class.getName();
    }

    String xCQ() {
        return CrawlingSessionInfoCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
