/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of WEB_CONFIG_TO_ROLE_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     ROLE_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     roleType, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToRoleTypeMapping implements Entity,
        Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK : ID : NotNull : BIGINT} */
    protected Long _id;

    /** WEB_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} */
    protected Long _webConfigId;

    /** ROLE_TYPE_ID: {NotNull : BIGINT : FK to ROLE_TYPE} */
    protected Long _roleTypeId;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The attribute of entity modified properties. (for S2Dao) */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "WEB_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    public String getTablePropertyName() { // as JavaBeansRule
        return "webConfigToRoleTypeMapping";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                          Classification Classifying
    //                                                          ==========================
    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    /** ROLE_TYPE as 'roleType'. */
    protected RoleType _parentRoleType;

    /**
     * ROLE_TYPE as 'roleType'. {without lazy-load}
     * @return The entity of foreign property 'roleType'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public RoleType getRoleType() {
        return _parentRoleType;
    }

    /**
     * ROLE_TYPE as 'roleType'.
     * @param roleType The entity of foreign property 'roleType'. (Nullable)
     */
    public void setRoleType(RoleType roleType) {
        _parentRoleType = roleType;
    }

    /** WEB_CRAWLING_CONFIG as 'webCrawlingConfig'. */
    protected WebCrawlingConfig _parentWebCrawlingConfig;

    /**
     * WEB_CRAWLING_CONFIG as 'webCrawlingConfig'. {without lazy-load}
     * @return The entity of foreign property 'webCrawlingConfig'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public WebCrawlingConfig getWebCrawlingConfig() {
        return _parentWebCrawlingConfig;
    }

    /**
     * WEB_CRAWLING_CONFIG as 'webCrawlingConfig'.
     * @param webCrawlingConfig The entity of foreign property 'webCrawlingConfig'. (Nullable)
     */
    public void setWebCrawlingConfig(WebCrawlingConfig webCrawlingConfig) {
        _parentWebCrawlingConfig = webCrawlingConfig;
    }

    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                       Determination
    //                                                                       =============
    public boolean hasPrimaryKeyValue() {
        if (_id == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If the primary-key of the other is same as this one, returns true.
     * @param other Other entity.
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsWebConfigToRoleTypeMapping)) {
            return false;
        }
        BsWebConfigToRoleTypeMapping otherEntity = (BsWebConfigToRoleTypeMapping) other;
        if (!helpComparingValue(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean helpComparingValue(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.equals(value2);
    }

    /**
     * Calculates hash-code from primary-key.
     * @return Hash-code from primary-key.
     */
    public int hashCode() {
        int result = 17;
        if (getId() != null) {
            result = (31 * result) + getId().hashCode();
        }
        return result;
    }

    /**
     * @return The view string of all columns. (NotNull)
     */
    public String toString() {
        String delimiter = ",";
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter).append(getId());
        sb.append(delimiter).append(getWebConfigId());
        sb.append(delimiter).append(getRoleTypeId());
        if (sb.length() > 0) {
            sb.delete(0, delimiter.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * WEB_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} <br />
     * @return The value of the column 'WEB_CONFIG_ID'. (Nullable)
     */
    public Long getWebConfigId() {
        return _webConfigId;
    }

    /**
     * WEB_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} <br />
     * @param webConfigId The value of the column 'WEB_CONFIG_ID'. (Nullable)
     */
    public void setWebConfigId(Long webConfigId) {
        _modifiedProperties.addPropertyName("webConfigId");
        this._webConfigId = webConfigId;
    }

    /**
     * ROLE_TYPE_ID: {NotNull : BIGINT : FK to ROLE_TYPE} <br />
     * @return The value of the column 'ROLE_TYPE_ID'. (Nullable)
     */
    public Long getRoleTypeId() {
        return _roleTypeId;
    }

    /**
     * ROLE_TYPE_ID: {NotNull : BIGINT : FK to ROLE_TYPE} <br />
     * @param roleTypeId The value of the column 'ROLE_TYPE_ID'. (Nullable)
     */
    public void setRoleTypeId(Long roleTypeId) {
        _modifiedProperties.addPropertyName("roleTypeId");
        this._roleTypeId = roleTypeId;
    }
}
