/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of CRAWLING_SESSION_INFO.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsCrawlingSessionInfoCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsCrawlingSessionInfoCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    public String getTableSqlName() {
        return "CRAWLING_SESSION_INFO";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {PK : ID : NotNull : BIGINT}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        regId(CK_NE, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : BIGINT : FK to CRAWLING_SESSION}
     * @param crawlingSessionId The value of crawlingSessionId as equal.
     */
    public void setCrawlingSessionId_Equal(Long crawlingSessionId) {
        regCrawlingSessionId(CK_EQ, crawlingSessionId);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param crawlingSessionId The value of crawlingSessionId as notEqual.
     */
    public void setCrawlingSessionId_NotEqual(Long crawlingSessionId) {
        regCrawlingSessionId(CK_NE, crawlingSessionId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param crawlingSessionId The value of crawlingSessionId as greaterThan.
     */
    public void setCrawlingSessionId_GreaterThan(Long crawlingSessionId) {
        regCrawlingSessionId(CK_GT, crawlingSessionId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param crawlingSessionId The value of crawlingSessionId as lessThan.
     */
    public void setCrawlingSessionId_LessThan(Long crawlingSessionId) {
        regCrawlingSessionId(CK_LT, crawlingSessionId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param crawlingSessionId The value of crawlingSessionId as greaterEqual.
     */
    public void setCrawlingSessionId_GreaterEqual(Long crawlingSessionId) {
        regCrawlingSessionId(CK_GE, crawlingSessionId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param crawlingSessionId The value of crawlingSessionId as lessEqual.
     */
    public void setCrawlingSessionId_LessEqual(Long crawlingSessionId) {
        regCrawlingSessionId(CK_LE, crawlingSessionId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param crawlingSessionIdList The collection of crawlingSessionId as inScope.
     */
    public void setCrawlingSessionId_InScope(
            Collection<Long> crawlingSessionIdList) {
        regINS(CK_INS, cTL(crawlingSessionIdList),
                getCValueCrawlingSessionId(), "CRAWLING_SESSION_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param crawlingSessionIdList The collection of crawlingSessionId as notInScope.
     */
    public void setCrawlingSessionId_NotInScope(
            Collection<Long> crawlingSessionIdList) {
        regINS(CK_NINS, cTL(crawlingSessionIdList),
                getCValueCrawlingSessionId(), "CRAWLING_SESSION_ID");
    }

    public void inScopeCrawlingSession(SubQuery<CrawlingSessionCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionCB>", subQuery);
        CrawlingSessionCB cb = new CrawlingSessionCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepCrawlingSessionId_InScopeSubQuery_CrawlingSession(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "CRAWLING_SESSION_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepCrawlingSessionId_InScopeSubQuery_CrawlingSession(
            CrawlingSessionCQ subQuery);

    protected void regCrawlingSessionId(ConditionKey k, Object v) {
        regQ(k, v, getCValueCrawlingSessionId(), "CRAWLING_SESSION_ID");
    }

    abstract protected ConditionValue getCValueCrawlingSessionId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(20)}
     * @param key The value of key as equal.
     */
    public void setKey_Equal(String key) {
        regKey(CK_EQ, fRES(key));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param key The value of key as notEqual.
     */
    public void setKey_NotEqual(String key) {
        regKey(CK_NE, fRES(key));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param key The value of key as greaterThan.
     */
    public void setKey_GreaterThan(String key) {
        regKey(CK_GT, fRES(key));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param key The value of key as lessThan.
     */
    public void setKey_LessThan(String key) {
        regKey(CK_LT, fRES(key));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param key The value of key as greaterEqual.
     */
    public void setKey_GreaterEqual(String key) {
        regKey(CK_GE, fRES(key));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param key The value of key as lessEqual.
     */
    public void setKey_LessEqual(String key) {
        regKey(CK_LE, fRES(key));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param key The value of key as prefixSearch.
     */
    public void setKey_PrefixSearch(String key) {
        setKey_LikeSearch(key, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param keyList The collection of key as inScope.
     */
    public void setKey_InScope(Collection<String> keyList) {
        regINS(CK_INS, cTL(keyList), getCValueKey(), "KEY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param keyList The collection of key as notInScope.
     */
    public void setKey_NotInScope(Collection<String> keyList) {
        regINS(CK_NINS, cTL(keyList), getCValueKey(), "KEY");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param key The value of key as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setKey_LikeSearch(String key, LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(key), getCValueKey(), "KEY", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param key The value of key as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setKey_NotLikeSearch(String key,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(key), getCValueKey(), "KEY", likeSearchOption);
    }

    protected void regKey(ConditionKey k, Object v) {
        regQ(k, v, getCValueKey(), "KEY");
    }

    abstract protected ConditionValue getCValueKey();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(100)}
     * @param value The value of value as equal.
     */
    public void setValue_Equal(String value) {
        regValue(CK_EQ, fRES(value));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param value The value of value as notEqual.
     */
    public void setValue_NotEqual(String value) {
        regValue(CK_NE, fRES(value));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param value The value of value as greaterThan.
     */
    public void setValue_GreaterThan(String value) {
        regValue(CK_GT, fRES(value));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param value The value of value as lessThan.
     */
    public void setValue_LessThan(String value) {
        regValue(CK_LT, fRES(value));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param value The value of value as greaterEqual.
     */
    public void setValue_GreaterEqual(String value) {
        regValue(CK_GE, fRES(value));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param value The value of value as lessEqual.
     */
    public void setValue_LessEqual(String value) {
        regValue(CK_LE, fRES(value));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param value The value of value as prefixSearch.
     */
    public void setValue_PrefixSearch(String value) {
        setValue_LikeSearch(value, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param valueList The collection of value as inScope.
     */
    public void setValue_InScope(Collection<String> valueList) {
        regINS(CK_INS, cTL(valueList), getCValueValue(), "VALUE");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param valueList The collection of value as notInScope.
     */
    public void setValue_NotInScope(Collection<String> valueList) {
        regINS(CK_NINS, cTL(valueList), getCValueValue(), "VALUE");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param value The value of value as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setValue_LikeSearch(String value,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(value), getCValueValue(), "VALUE", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param value The value of value as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setValue_NotLikeSearch(String value,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(value), getCValueValue(), "VALUE", likeSearchOption);
    }

    protected void regValue(ConditionKey k, Object v) {
        regQ(k, v, getCValueValue(), "VALUE");
    }

    abstract protected ConditionValue getCValueValue();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param createdTime The value of createdTime as equal.
     */
    public void setCreatedTime_Equal(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_EQ, createdTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterThan.
     */
    public void setCreatedTime_GreaterThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GT, createdTime);
    }

    /**
     * LessThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessThan.
     */
    public void setCreatedTime_LessThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LT, createdTime);
    }

    /**
     * GreaterEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterEqual.
     */
    public void setCreatedTime_GreaterEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GE, createdTime);
    }

    /**
     * LessEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessEqual.
     */
    public void setCreatedTime_LessEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LE, createdTime);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt;= toDate). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setCreatedTime_FromTo(java.util.Date fromDate,
            java.util.Date toDate, FromToOption fromToOption) {
        regFTQ((fromDate != null ? new java.sql.Timestamp(fromDate.getTime())
                : null), (toDate != null ? new java.sql.Timestamp(toDate
                .getTime()) : null), getCValueCreatedTime(), "CREATED_TIME",
                fromToOption);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt; toDate + 1). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     */
    public void setCreatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setCreatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regCreatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedTime(), "CREATED_TIME");
    }

    abstract protected ConditionValue getCValueCreatedTime();

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public SSQFunction<CrawlingSessionInfoCB> scalar_Equal() {
        return xcreateSSQFunction("=");
    }

    public SSQFunction<CrawlingSessionInfoCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(">=");
    }

    public SSQFunction<CrawlingSessionInfoCB> scalar_GreaterThan() {
        return xcreateSSQFunction(">");
    }

    public SSQFunction<CrawlingSessionInfoCB> scalar_LessEqual() {
        return xcreateSSQFunction("<=");
    }

    public SSQFunction<CrawlingSessionInfoCB> scalar_LessThan() {
        return xcreateSSQFunction("<");
    }

    protected SSQFunction<CrawlingSessionInfoCB> xcreateSSQFunction(
            final String operand) {
        return new SSQFunction<CrawlingSessionInfoCB>(
                new SSQSetupper<CrawlingSessionInfoCB>() {
                    public void setup(String function,
                            SubQuery<CrawlingSessionInfoCB> subQuery) {
                        xscalarSubQuery(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarSubQuery(String function,
            SubQuery<CrawlingSessionInfoCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForScalarSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarSubQuery(cb.query()); // for saving query-value.
        registerScalarSubQuery(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarSubQuery(CrawlingSessionInfoCQ subQuery);

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    /**
     * Myself InScope SubQuery. {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<CrawlingSessionInfoCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeSubQuery(cb.query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeSubQuery(
            CrawlingSessionInfoCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return CrawlingSessionInfoCB.class.getName();
    }

    String xCQ() {
        return CrawlingSessionInfoCQ.class.getName();
    }

    String xLSO() {
        return LikeSearchOption.class.getName();
    }
}
