/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import jp.sf.fess.db.exentity.CrawlingConfig;

public class CrawlingConfigHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    protected static final Map<String, CrawlingConfig> CRAWLING_CONFIG_MAP = new HashMap<String, CrawlingConfig>();

    public void setCrawlingConfig(String sessionId,
            CrawlingConfig crawlingConfig) {
        if (crawlingConfig != null) {
            CRAWLING_CONFIG_MAP.put(sessionId, crawlingConfig);
        } else {
            CRAWLING_CONFIG_MAP.remove(sessionId);
        }
    }

    public CrawlingConfig getCrawlingConfig(String sessionId) {
        return CRAWLING_CONFIG_MAP.get(sessionId);
    }

    public void init() {
        CRAWLING_CONFIG_MAP.clear();
    }
}
