/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of DATA_CRAWLING_CONFIG. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class DataCrawlingConfigDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final DataCrawlingConfigDbm _instance = new DataCrawlingConfigDbm();

    private DataCrawlingConfigDbm() {
    }

    public static DataCrawlingConfigDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    public String getTablePropertyName() {
        return "dataCrawlingConfig";
    }

    public String getTableSqlName() {
        return "DATA_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected ColumnInfo _columnId = cci("ID", null, "id", Long.class, true,
            true, null, null);

    protected ColumnInfo _columnName = cci("NAME", null, "name", String.class,
            false, false, 200, 0);

    protected ColumnInfo _columnHandlerName = cci("HANDLER_NAME", null,
            "handlerName", String.class, false, false, 200, 0);

    protected ColumnInfo _columnHandlerParameter = cci("HANDLER_PARAMETER",
            null, "handlerParameter", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnHandlerScript = cci("HANDLER_SCRIPT", null,
            "handlerScript", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnBoost = cci("BOOST", null, "boost",
            java.math.BigDecimal.class, false, false, null, null);

    protected ColumnInfo _columnAvailable = cci("AVAILABLE", null, "available",
            String.class, false, false, 1, 0);

    protected ColumnInfo _columnSortOrder = cci("SORT_ORDER", null,
            "sortOrder", Integer.class, false, false, null, null);

    protected ColumnInfo _columnCreatedBy = cci("CREATED_BY", null,
            "createdBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnCreatedTime = cci("CREATED_TIME", null,
            "createdTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnUpdatedBy = cci("UPDATED_BY", null,
            "updatedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME", null,
            "updatedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnDeletedBy = cci("DELETED_BY", null,
            "deletedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnDeletedTime = cci("DELETED_TIME", null,
            "deletedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnVersionNo = cci("VERSION_NO", null,
            "versionNo", Integer.class, false, false, null, null,
            OptimisticLockType.VERSION_NO);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnName() {
        return _columnName;
    }

    public ColumnInfo columnHandlerName() {
        return _columnHandlerName;
    }

    public ColumnInfo columnHandlerParameter() {
        return _columnHandlerParameter;
    }

    public ColumnInfo columnHandlerScript() {
        return _columnHandlerScript;
    }

    public ColumnInfo columnBoost() {
        return _columnBoost;
    }

    public ColumnInfo columnAvailable() {
        return _columnAvailable;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------
    public ReferrerInfo referrerDataConfigToBrowserTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                DataConfigToBrowserTypeMappingDbm.getInstance()
                        .columnDataConfigId());
        return cri("dataConfigToBrowserTypeMappingList", this,
                DataConfigToBrowserTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerDataConfigToLabelTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                DataConfigToLabelTypeMappingDbm.getInstance()
                        .columnDataConfigId());
        return cri("dataConfigToLabelTypeMappingList", this,
                DataConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerDataConfigToRoleTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                DataConfigToRoleTypeMappingDbm.getInstance()
                        .columnDataConfigId());
        return cri("dataConfigToRoleTypeMappingList", this,
                DataConfigToRoleTypeMappingDbm.getInstance(), map, false);
    }

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.DataCrawlingConfig";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.DataCrawlingConfigCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.DataCrawlingConfigDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.DataCrawlingConfigBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<DataCrawlingConfig> getEntityType() {
        return DataCrawlingConfig.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public DataCrawlingConfig newMyEntity() {
        return new DataCrawlingConfig();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    // -----------------------------------------------------
    //                                                Accept
    //                                                ------
    public void acceptPrimaryKeyMap(Entity entity,
            Map<String, ? extends Object> primaryKeyMap) {
        doAcceptPrimaryKeyMap((DataCrawlingConfig) entity, primaryKeyMap,
                _epsMap);
    }

    public void acceptPrimaryKeyMapString(Entity entity,
            String primaryKeyMapString) {
        MapStringUtil.acceptPrimaryKeyMapString(primaryKeyMapString, entity);
    }

    public void acceptColumnValueMap(Entity entity,
            Map<String, ? extends Object> columnValueMap) {
        doAcceptColumnValueMap((DataCrawlingConfig) entity, columnValueMap,
                _epsMap);
    }

    public void acceptColumnValueMapString(Entity entity,
            String columnValueMapString) {
        MapStringUtil.acceptColumnValueMapString(columnValueMapString, entity);
    }

    // -----------------------------------------------------
    //                                               Extract
    //                                               -------
    public String extractPrimaryKeyMapString(Entity entity) {
        return MapStringUtil.extractPrimaryKeyMapString(entity);
    }

    public String extractPrimaryKeyMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractPrimaryKeyMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    public String extractColumnValueMapString(Entity entity) {
        return MapStringUtil.extractColumnValueMapString(entity);
    }

    public String extractColumnValueMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractColumnValueMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    // -----------------------------------------------------
    //                                               Convert
    //                                               -------
    public List<Object> convertToColumnValueList(Entity entity) {
        return newArrayList(convertToColumnValueMap(entity).values());
    }

    public Map<String, Object> convertToColumnValueMap(Entity entity) {
        return doConvertToColumnValueMap(entity);
    }

    public List<String> convertToColumnStringValueList(Entity entity) {
        return newArrayList(convertToColumnStringValueMap(entity).values());
    }

    public Map<String, String> convertToColumnStringValueMap(Entity entity) {
        return doConvertToColumnStringValueMap(entity);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<DataCrawlingConfig>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsName(), columnName());
        setupEps(_epsMap, new EpsHandlerName(), columnHandlerName());
        setupEps(_epsMap, new EpsHandlerParameter(), columnHandlerParameter());
        setupEps(_epsMap, new EpsHandlerScript(), columnHandlerScript());
        setupEps(_epsMap, new EpsBoost(), columnBoost());
        setupEps(_epsMap, new EpsAvailable(), columnAvailable());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName)
                .setup((DataCrawlingConfig) entity, value);
    }

    public static class EpsId implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setId((Long) v);
        }
    }

    public static class EpsName implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setName((String) v);
        }
    }

    public static class EpsHandlerName implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setHandlerName((String) v);
        }
    }

    public static class EpsHandlerParameter implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setHandlerParameter((String) v);
        }
    }

    public static class EpsHandlerScript implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setHandlerScript((String) v);
        }
    }

    public static class EpsBoost implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setBoost((java.math.BigDecimal) v);
        }
    }

    public static class EpsAvailable implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setAvailable((String) v);
        }
    }

    public static class EpsSortOrder implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setSortOrder((Integer) v);
        }
    }

    public static class EpsCreatedBy implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsVersionNo implements Eps<DataCrawlingConfig> {
        public void setup(DataCrawlingConfig e, Object v) {
            e.setVersionNo((Integer) v);
        }
    }
}
