/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.bs;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedInvokerAssistant;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.OrQuery;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.chelper.HpAbstractSpecification;
import org.seasar.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.chelper.HpColQyHandler;
import org.seasar.dbflute.cbean.chelper.HpColQyOperand;
import org.seasar.dbflute.cbean.chelper.HpSDRFunction;
import org.seasar.dbflute.cbean.chelper.HpSDRSetupper;
import org.seasar.dbflute.cbean.chelper.HpSpQyCall;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.twowaysql.factory.SqlAnalyzerFactory;

/**
 * The base condition-bean of ROLE_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class BsRoleTypeCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected RoleTypeCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        SqlClauseCreator creator = DBFluteConfig.getInstance()
                .getSqlClauseCreator();
        if (creator != null) {
            return creator.createSqlClause(this);
        }
        return new ImplementedSqlClauseCreator().createSqlClause(this); // as default
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return new DBMetaInstanceHandler(); // as default
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "ROLE_TYPE";
    }

    // ===================================================================================
    //                                                                 PrimaryKey Handling
    //                                                                 ===================
    public void acceptPrimaryKey(Long id) {
        assertObjectNotNull("id", id);
        BsRoleTypeCB cb = this;
        cb.query().setId_Equal(id);
    }

    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    /**
     * Prepare for various queries. <br />
     * Examples of main functions are following:
     * <pre>
     * <span style="color: #3F7E5E">// Basic Queries</span>
     * cb.query().setMemberId_Equal(value);        <span style="color: #3F7E5E">// =</span>
     * cb.query().setMemberId_NotEqual(value);     <span style="color: #3F7E5E">// !=</span>
     * cb.query().setMemberId_GreaterThan(value);  <span style="color: #3F7E5E">// &gt;</span>
     * cb.query().setMemberId_LessThan(value);     <span style="color: #3F7E5E">// &lt;</span>
     * cb.query().setMemberId_GreaterEqual(value); <span style="color: #3F7E5E">// &gt;=</span>
     * cb.query().setMemberId_LessEqual(value);    <span style="color: #3F7E5E">// &lt;=</span>
     * cb.query().setMemberName_InScope(valueList);    <span style="color: #3F7E5E">// in ('a', 'b')</span>
     * cb.query().setMemberName_NotInScope(valueList); <span style="color: #3F7E5E">// not in ('a', 'b')</span>
     * cb.query().setMemberName_PrefixSearch(value);   <span style="color: #3F7E5E">// like 'a%' escape '|'</span>
     * <span style="color: #3F7E5E">// LikeSearch with various options: (versatile)</span>
     * <span style="color: #3F7E5E">// {like ... [options]}</span>
     * cb.query().setMemberName_LikeSearch(value, option);
     * cb.query().setMemberName_NotLikeSearch(value, option); <span style="color: #3F7E5E">// not like ...</span>
     * <span style="color: #3F7E5E">// FromTo with various options: (versatile)</span>
     * <span style="color: #3F7E5E">// {(default) fromDatetime &lt;= BIRTHDATE &lt;= toDatetime}</span>
     * cb.query().setBirthdate_FromTo(fromDatetime, toDatetime, option);
     * <span style="color: #3F7E5E">// DateFromTo: (Date means yyyy/MM/dd)</span>
     * <span style="color: #3F7E5E">// {fromDate &lt;= BIRTHDATE &lt; toDate + 1 day}</span>
     * cb.query().setBirthdate_DateFromTo(fromDate, toDate);
     * cb.query().setBirthdate_IsNull();    <span style="color: #3F7E5E">// is null</span>
     * cb.query().setBirthdate_IsNotNull(); <span style="color: #3F7E5E">// is not null</span>
     * 
     * <span style="color: #3F7E5E">// ExistsReferrer: (co-related sub-query)</span>
     * <span style="color: #3F7E5E">// {where exists (select PURCHASE_ID from PURCHASE where ...)}</span>
     * cb.query().existsPurchaseList(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.query().setXxx... <span style="color: #3F7E5E">// referrer sub-query condition</span>
     *     }
     * });
     * cb.query().notExistsPurchaseList...
     * 
     * <span style="color: #3F7E5E">// InScopeRelation: (sub-query)</span>
     * <span style="color: #3F7E5E">// {where MEMBER_STATUS_CODE in (select MEMBER_STATUS_CODE from MEMBER_STATUS where ...)}</span>
     * cb.query().inScopeMemberStatus(new SubQuery&lt;MemberStatusCB&gt;() {
     *     public void query(MemberStatusCB subCB) {
     *         subCB.query().setXxx... <span style="color: #3F7E5E">// relation sub-query condition</span>
     *     }
     * });
     * cb.query().notInScopeMemberStatus...
     * 
     * <span style="color: #3F7E5E">// (Query)DerivedReferrer: (co-related sub-query)</span>
     * cb.query().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchasePrice(); <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setXxx... <span style="color: #3F7E5E">// referrer sub-query condition</span>
     *     }
     * }).greaterEqual(value);
     * 
     * <span style="color: #3F7E5E">// ScalarCondition: (self-table sub-query)</span>
     * cb.query().scalar_Equal().max(new SubQuery&lt;MemberCB&gt;() {
     *     public void query(MemberCB subCB) {
     *         subCB.specify().columnBirthdate(); <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setXxx... <span style="color: #3F7E5E">// scalar sub-query condition</span>
     *     }
     * });
     * 
     * <span style="color: #3F7E5E">// OrderBy</span>
     * cb.query().addOrderBy_MemberName_Asc();
     * cb.query().addOrderBy_MemberName_Desc().withManualOrder(valueList);
     * cb.query().addOrderBy_MemberName_Desc().withNullsFirst();
     * cb.query().addOrderBy_MemberName_Desc().withNullsLast();
     * cb.query().addSpecifiedDerivedOrderBy_Desc(aliasName);
     * 
     * <span style="color: #3F7E5E">// Query(Relation)</span>
     * cb.query().queryMemberStatus()...;
     * cb.query().queryMemberAddressAsValid(targetDate)...;
     * </pre>
     * @return The instance of condition-query for base-point table to set up query. (NotNull)
     */
    public RoleTypeCQ query() {
        return getConditionQuery();
    }

    public RoleTypeCQ getConditionQuery() { // public for parameter comment
        assertQueryPurpose();
        if (_conditionQuery == null) {
            _conditionQuery = createLocalCQ();
        }
        return _conditionQuery;
    }

    protected RoleTypeCQ createLocalCQ() {
        return xcreateCQ(null, getSqlClause(), getSqlClause()
                .getLocalTableAliasName(), 0);
    }

    protected RoleTypeCQ xcreateCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        return new RoleTypeCQ(childQuery, sqlClause, aliasName, nestLevel);
    }

    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union' for base-point table. <br />
     * You don't need to call SetupSelect in union-query,
     * because it inherits calls before. (Don't call SetupSelect after here)
     * <pre>
     * cb.query().<span style="color: #FD4747">union</span>(new UnionQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<RoleTypeCB> unionQuery) {
        final RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForUnion();
        xsyncUQ(cb);
        unionQuery.query(cb);
        final RoleTypeCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all' for base-point table. <br />
     * You don't need to call SetupSelect in union-query,
     * because it inherits calls before. (Don't call SetupSelect after here)
     * <pre>
     * cb.query().<span style="color: #FD4747">unionAll</span>(new UnionQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union all'. (NotNull)
     */
    public void unionAll(UnionQuery<RoleTypeCB> unionQuery) {
        final RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForUnion();
        xsyncUQ(cb);
        unionQuery.query(cb);
        final RoleTypeCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    // ===================================================================================
    //                                                                         SetupSelect
    //                                                                         ===========

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected HpSpecification _specification;

    /**
     * Prepare for SpecifyColumn, (Specify)DerivedReferrer. <br />
     * This method should be called after SetupSelect.
     * <pre>
     * cb.setupSelect_MemberStatus(); <span style="color: #3F7E5E">// should be called before specify()</span>
     * cb.specify().columnMemberName();
     * cb.specify().specifyMemberStatus().columnMemberStatusName();
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *         subCB.query().set...
     *     }
     * }, aliasName);
     * </pre>
     * @return The instance of specification. (NotNull)
     */
    public HpSpecification specify() {
        assertSpecifyPurpose();
        if (_specification == null) {
            _specification = new HpSpecification(this,
                    new HpSpQyCall<RoleTypeCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public RoleTypeCQ qy() {
                            return query();
                        }
                    }, _purpose, getDBMetaProvider());
        }
        return _specification;
    }

    protected boolean hasSpecifiedColumn() {
        return _specification != null
                && _specification.isAlreadySpecifiedRequiredColumn();
    }

    protected HpAbstractSpecification<? extends ConditionQuery> localSp() {
        return specify();
    }

    public static class HpSpecification extends
            HpAbstractSpecification<RoleTypeCQ> {
        public HpSpecification(ConditionBean baseCB,
                HpSpQyCall<RoleTypeCQ> qyCall, HpCBPurpose purpose,
                DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, purpose, dbmetaProvider);
        }

        /** ID: {PK, ID, NotNull, BIGINT(19)} */
        public void columnId() {
            doColumn("ID");
        }

        /** NAME: {NotNull, VARCHAR(100)} */
        public void columnName() {
            doColumn("NAME");
        }

        /** VALUE: {NotNull, VARCHAR(20)} */
        public void columnValue() {
            doColumn("VALUE");
        }

        /** SORT_ORDER: {NotNull, INTEGER(10)} */
        public void columnSortOrder() {
            doColumn("SORT_ORDER");
        }

        /** CREATED_BY: {NotNull, VARCHAR(255)} */
        public void columnCreatedBy() {
            doColumn("CREATED_BY");
        }

        /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
        public void columnCreatedTime() {
            doColumn("CREATED_TIME");
        }

        /** UPDATED_BY: {VARCHAR(255)} */
        public void columnUpdatedBy() {
            doColumn("UPDATED_BY");
        }

        /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
        public void columnUpdatedTime() {
            doColumn("UPDATED_TIME");
        }

        /** DELETED_BY: {VARCHAR(255)} */
        public void columnDeletedBy() {
            doColumn("DELETED_BY");
        }

        /** DELETED_TIME: {TIMESTAMP(23, 10)} */
        public void columnDeletedTime() {
            doColumn("DELETED_TIME");
        }

        /** VERSION_NO: {NotNull, INTEGER(10)} */
        public void columnVersionNo() {
            doColumn("VERSION_NO");
        }

        @Override
        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
        }

        @Override
        protected String getTableDbName() {
            return "ROLE_TYPE";
        }

        /**
         * Prepare for '(Specify)DerivedReferrer'. <br />
         * DATA_CONFIG_TO_ROLE_TYPE_MAPPING as 'dataConfigToRoleTypeMappingList'.
         * <pre>
         * cb.specify().<span style="color: #FD4747">derivedDataConfigToRoleTypeMappingList()</span>.max(new SubQuery&lt;DataConfigToRoleTypeMappingCB&gt;() {
         *     public void query(DataConfigToRoleTypeMappingCB subCB) {
         *         subCB.specify().<span style="color: #FD4747">columnFoo...</span> <span style="color: #3F7E5E">// derived column for function</span>
         *         subCB.query().setBar... <span style="color: #3F7E5E">// referrer condition</span>
         *     }
         * }, aliasName);
         * </pre>
         * @return The object to set up a function for referrer table. (NotNull)
         */
        public HpSDRFunction<DataConfigToRoleTypeMappingCB, RoleTypeCQ> derivedDataConfigToRoleTypeMappingList() {
            assertDerived("dataConfigToRoleTypeMappingList");
            return new HpSDRFunction<DataConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _qyCall.qy(),
                    new HpSDRSetupper<DataConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<DataConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveDataConfigToRoleTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        /**
         * Prepare for '(Specify)DerivedReferrer'. <br />
         * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
         * <pre>
         * cb.specify().<span style="color: #FD4747">derivedFileConfigToRoleTypeMappingList()</span>.max(new SubQuery&lt;FileConfigToRoleTypeMappingCB&gt;() {
         *     public void query(FileConfigToRoleTypeMappingCB subCB) {
         *         subCB.specify().<span style="color: #FD4747">columnFoo...</span> <span style="color: #3F7E5E">// derived column for function</span>
         *         subCB.query().setBar... <span style="color: #3F7E5E">// referrer condition</span>
         *     }
         * }, aliasName);
         * </pre>
         * @return The object to set up a function for referrer table. (NotNull)
         */
        public HpSDRFunction<FileConfigToRoleTypeMappingCB, RoleTypeCQ> derivedFileConfigToRoleTypeMappingList() {
            assertDerived("fileConfigToRoleTypeMappingList");
            return new HpSDRFunction<FileConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _qyCall.qy(),
                    new HpSDRSetupper<FileConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<FileConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveFileConfigToRoleTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        /**
         * Prepare for '(Specify)DerivedReferrer'. <br />
         * LABEL_TYPE_TO_ROLE_TYPE_MAPPING as 'labelTypeToRoleTypeMappingList'.
         * <pre>
         * cb.specify().<span style="color: #FD4747">derivedLabelTypeToRoleTypeMappingList()</span>.max(new SubQuery&lt;LabelTypeToRoleTypeMappingCB&gt;() {
         *     public void query(LabelTypeToRoleTypeMappingCB subCB) {
         *         subCB.specify().<span style="color: #FD4747">columnFoo...</span> <span style="color: #3F7E5E">// derived column for function</span>
         *         subCB.query().setBar... <span style="color: #3F7E5E">// referrer condition</span>
         *     }
         * }, aliasName);
         * </pre>
         * @return The object to set up a function for referrer table. (NotNull)
         */
        public HpSDRFunction<LabelTypeToRoleTypeMappingCB, RoleTypeCQ> derivedLabelTypeToRoleTypeMappingList() {
            assertDerived("labelTypeToRoleTypeMappingList");
            return new HpSDRFunction<LabelTypeToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _qyCall.qy(),
                    new HpSDRSetupper<LabelTypeToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<LabelTypeToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveLabelTypeToRoleTypeMappingList(function,
                                    subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        /**
         * Prepare for '(Specify)DerivedReferrer'. <br />
         * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
         * <pre>
         * cb.specify().<span style="color: #FD4747">derivedWebConfigToRoleTypeMappingList()</span>.max(new SubQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
         *     public void query(WebConfigToRoleTypeMappingCB subCB) {
         *         subCB.specify().<span style="color: #FD4747">columnFoo...</span> <span style="color: #3F7E5E">// derived column for function</span>
         *         subCB.query().setBar... <span style="color: #3F7E5E">// referrer condition</span>
         *     }
         * }, aliasName);
         * </pre>
         * @return The object to set up a function for referrer table. (NotNull)
         */
        public HpSDRFunction<WebConfigToRoleTypeMappingCB, RoleTypeCQ> derivedWebConfigToRoleTypeMappingList() {
            assertDerived("webConfigToRoleTypeMappingList");
            return new HpSDRFunction<WebConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _qyCall.qy(),
                    new HpSDRSetupper<WebConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<WebConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveWebConfigToRoleTypeMappingList(function,
                                    subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }
    }

    // [DBFlute-0.9.5.3]
    // ===================================================================================
    //                                                                         ColumnQuery
    //                                                                         ===========
    /**
     * Set up column-query. {column1 = column2}
     * <pre>
     * <span style="color: #3F7E5E">// where FOO &lt; BAR</span>
     * cb.<span style="color: #FD4747">columnQuery</span>(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFoo()</span>; <span style="color: #3F7E5E">// left column</span>
     *     }
     * }).lessThan(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnBar()</span>; <span style="color: #3F7E5E">// right column</span>
     *     }
     * }); <span style="color: #3F7E5E">// you can calculate for right column like '}).plus(3);'</span>
     * </pre>
     * @param leftSpecifyQuery The specify-query for left column. (NotNull)
     * @return The object for setting up operand and right column. (NotNull)
     */
    public HpColQyOperand<RoleTypeCB> columnQuery(
            final SpecifyQuery<RoleTypeCB> leftSpecifyQuery) {
        return new HpColQyOperand<RoleTypeCB>(new HpColQyHandler<RoleTypeCB>() {
            public HpCalculator handle(SpecifyQuery<RoleTypeCB> rightSp,
                    String operand) {
                return xcolqy(xcreateColumnQueryCB(), xcreateColumnQueryCB(),
                        leftSpecifyQuery, rightSp, operand);
            }
        });
    }

    protected RoleTypeCB xcreateColumnQueryCB() {
        RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForColumnQuery((RoleTypeCB) this);
        return cb;
    }

    // [DBFlute-0.9.6.3]
    // ===================================================================================
    //                                                                        OrScopeQuery
    //                                                                        ============
    /**
     * Set up the query for or-scope.
     * <pre>
     * <span style="color: #3F7E5E">// where (FOO = '...' or BAR = '...')</span>
     * cb.<span style="color: #FD4747">orScopeQuery</span>(new OrQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB orCB) {
     *         orCB.query().setFOO_Equal...
     *         orCB.query().setBAR_Equal...
     *     }
     * });
     * </pre>
     * @param orQuery The query for or-condition. (NotNull)
     */
    public void orScopeQuery(OrQuery<RoleTypeCB> orQuery) {
        xorSQ((RoleTypeCB) this, orQuery);
    }

    // ===================================================================================
    //                                                                          DisplaySQL
    //                                                                          ==========
    @Override
    protected SqlAnalyzerFactory getSqlAnalyzerFactory() {
        return new ImplementedInvokerAssistant().assistSqlAnalyzerFactory();
    }

    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                          Basic Status Determination
    //                                                          ==========================
    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                        Purpose Type
    //                                                                        ============
    public void xsetupForColumnQuery(final RoleTypeCB cb) {
        xchangePurposeSqlClause(HpCBPurpose.COLUMN_QUERY);

        // inherits a parent query to synchronize real name
        // (and also for suppressing query check) 
        specify().xswitchQyCall(new HpSpQyCall<RoleTypeCQ>() {
            public boolean has() {
                return true;
            }

            public RoleTypeCQ qy() {
                return cb.query();
            }
        });
    }

    public void xsetupForVaryingUpdate() {
        xchangePurposeSqlClause(HpCBPurpose.VARYING_UPDATE);

        // for suppressing query check
        final RoleTypeCB nonCheckCB = new RoleTypeCB();
        specify().xswitchQyCall(new HpSpQyCall<RoleTypeCQ>() {
            public boolean has() {
                return true;
            }

            public RoleTypeCQ qy() {
                return nonCheckCB.query();
            }
        });
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // very internal (for suppressing warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return RoleTypeCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return RoleTypeCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
