/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.FileAuthenticationCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.FileAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.chelper.HpSSQFunction;
import org.seasar.dbflute.cbean.chelper.HpSSQSetupper;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of FILE_AUTHENTICATION.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsFileAuthenticationCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsFileAuthenticationCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "FILE_AUTHENTICATION";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * ID: {PK, ID, NotNull, BIGINT(19)}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        doSetId_Equal(id);
    }

    protected void doSetId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        doSetId_NotEqual(id);
    }

    protected void doSetId_NotEqual(Long id) {
        regId(CK_NES, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        doSetId_InScope(idList);
    }

    protected void doSetId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        doSetId_NotInScope(idList);
    }

    protected void doSetId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * HOSTNAME: {VARCHAR(255)}
     * @param hostname The value of hostname as equal.
     */
    public void setHostname_Equal(String hostname) {
        doSetHostname_Equal(fRES(hostname));
    }

    protected void doSetHostname_Equal(String hostname) {
        regHostname(CK_EQ, hostname);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param hostname The value of hostname as notEqual.
     */
    public void setHostname_NotEqual(String hostname) {
        doSetHostname_NotEqual(fRES(hostname));
    }

    protected void doSetHostname_NotEqual(String hostname) {
        regHostname(CK_NES, hostname);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param hostname The value of hostname as greaterThan.
     */
    public void setHostname_GreaterThan(String hostname) {
        regHostname(CK_GT, fRES(hostname));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param hostname The value of hostname as lessThan.
     */
    public void setHostname_LessThan(String hostname) {
        regHostname(CK_LT, fRES(hostname));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param hostname The value of hostname as greaterEqual.
     */
    public void setHostname_GreaterEqual(String hostname) {
        regHostname(CK_GE, fRES(hostname));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param hostname The value of hostname as lessEqual.
     */
    public void setHostname_LessEqual(String hostname) {
        regHostname(CK_LE, fRES(hostname));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param hostnameList The collection of hostname as inScope.
     */
    public void setHostname_InScope(Collection<String> hostnameList) {
        doSetHostname_InScope(hostnameList);
    }

    public void doSetHostname_InScope(Collection<String> hostnameList) {
        regINS(CK_INS, cTL(hostnameList), getCValueHostname(), "HOSTNAME");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param hostnameList The collection of hostname as notInScope.
     */
    public void setHostname_NotInScope(Collection<String> hostnameList) {
        doSetHostname_NotInScope(hostnameList);
    }

    public void doSetHostname_NotInScope(Collection<String> hostnameList) {
        regINS(CK_NINS, cTL(hostnameList), getCValueHostname(), "HOSTNAME");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param hostname The value of hostname as prefixSearch.
     */
    public void setHostname_PrefixSearch(String hostname) {
        setHostname_LikeSearch(hostname, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param hostname The value of hostname as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setHostname_LikeSearch(String hostname,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(hostname), getCValueHostname(), "HOSTNAME",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param hostname The value of hostname as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setHostname_NotLikeSearch(String hostname,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(hostname), getCValueHostname(), "HOSTNAME",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setHostname_IsNull() {
        regHostname(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setHostname_IsNotNull() {
        regHostname(CK_ISNN, DOBJ);
    }

    protected void regHostname(ConditionKey k, Object v) {
        regQ(k, v, getCValueHostname(), "HOSTNAME");
    }

    abstract protected ConditionValue getCValueHostname();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * PORT: {NotNull, INTEGER(10)}
     * @param port The value of port as equal.
     */
    public void setPort_Equal(Integer port) {
        doSetPort_Equal(port);
    }

    protected void doSetPort_Equal(Integer port) {
        regPort(CK_EQ, port);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param port The value of port as notEqual.
     */
    public void setPort_NotEqual(Integer port) {
        doSetPort_NotEqual(port);
    }

    protected void doSetPort_NotEqual(Integer port) {
        regPort(CK_NES, port);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param port The value of port as greaterThan.
     */
    public void setPort_GreaterThan(Integer port) {
        regPort(CK_GT, port);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param port The value of port as lessThan.
     */
    public void setPort_LessThan(Integer port) {
        regPort(CK_LT, port);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param port The value of port as greaterEqual.
     */
    public void setPort_GreaterEqual(Integer port) {
        regPort(CK_GE, port);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param port The value of port as lessEqual.
     */
    public void setPort_LessEqual(Integer port) {
        regPort(CK_LE, port);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param portList The collection of port as inScope.
     */
    public void setPort_InScope(Collection<Integer> portList) {
        doSetPort_InScope(portList);
    }

    protected void doSetPort_InScope(Collection<Integer> portList) {
        regINS(CK_INS, cTL(portList), getCValuePort(), "PORT");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param portList The collection of port as notInScope.
     */
    public void setPort_NotInScope(Collection<Integer> portList) {
        doSetPort_NotInScope(portList);
    }

    protected void doSetPort_NotInScope(Collection<Integer> portList) {
        regINS(CK_NINS, cTL(portList), getCValuePort(), "PORT");
    }

    protected void regPort(ConditionKey k, Object v) {
        regQ(k, v, getCValuePort(), "PORT");
    }

    abstract protected ConditionValue getCValuePort();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * PROTOCOL_SCHEME: {VARCHAR(10)}
     * @param protocolScheme The value of protocolScheme as equal.
     */
    public void setProtocolScheme_Equal(String protocolScheme) {
        doSetProtocolScheme_Equal(fRES(protocolScheme));
    }

    protected void doSetProtocolScheme_Equal(String protocolScheme) {
        regProtocolScheme(CK_EQ, protocolScheme);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param protocolScheme The value of protocolScheme as notEqual.
     */
    public void setProtocolScheme_NotEqual(String protocolScheme) {
        doSetProtocolScheme_NotEqual(fRES(protocolScheme));
    }

    protected void doSetProtocolScheme_NotEqual(String protocolScheme) {
        regProtocolScheme(CK_NES, protocolScheme);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param protocolScheme The value of protocolScheme as greaterThan.
     */
    public void setProtocolScheme_GreaterThan(String protocolScheme) {
        regProtocolScheme(CK_GT, fRES(protocolScheme));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param protocolScheme The value of protocolScheme as lessThan.
     */
    public void setProtocolScheme_LessThan(String protocolScheme) {
        regProtocolScheme(CK_LT, fRES(protocolScheme));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param protocolScheme The value of protocolScheme as greaterEqual.
     */
    public void setProtocolScheme_GreaterEqual(String protocolScheme) {
        regProtocolScheme(CK_GE, fRES(protocolScheme));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param protocolScheme The value of protocolScheme as lessEqual.
     */
    public void setProtocolScheme_LessEqual(String protocolScheme) {
        regProtocolScheme(CK_LE, fRES(protocolScheme));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param protocolSchemeList The collection of protocolScheme as inScope.
     */
    public void setProtocolScheme_InScope(Collection<String> protocolSchemeList) {
        doSetProtocolScheme_InScope(protocolSchemeList);
    }

    public void doSetProtocolScheme_InScope(
            Collection<String> protocolSchemeList) {
        regINS(CK_INS, cTL(protocolSchemeList), getCValueProtocolScheme(),
                "PROTOCOL_SCHEME");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param protocolSchemeList The collection of protocolScheme as notInScope.
     */
    public void setProtocolScheme_NotInScope(
            Collection<String> protocolSchemeList) {
        doSetProtocolScheme_NotInScope(protocolSchemeList);
    }

    public void doSetProtocolScheme_NotInScope(
            Collection<String> protocolSchemeList) {
        regINS(CK_NINS, cTL(protocolSchemeList), getCValueProtocolScheme(),
                "PROTOCOL_SCHEME");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param protocolScheme The value of protocolScheme as prefixSearch.
     */
    public void setProtocolScheme_PrefixSearch(String protocolScheme) {
        setProtocolScheme_LikeSearch(protocolScheme, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param protocolScheme The value of protocolScheme as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setProtocolScheme_LikeSearch(String protocolScheme,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(protocolScheme), getCValueProtocolScheme(),
                "PROTOCOL_SCHEME", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param protocolScheme The value of protocolScheme as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setProtocolScheme_NotLikeSearch(String protocolScheme,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(protocolScheme), getCValueProtocolScheme(),
                "PROTOCOL_SCHEME", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setProtocolScheme_IsNull() {
        regProtocolScheme(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setProtocolScheme_IsNotNull() {
        regProtocolScheme(CK_ISNN, DOBJ);
    }

    protected void regProtocolScheme(ConditionKey k, Object v) {
        regQ(k, v, getCValueProtocolScheme(), "PROTOCOL_SCHEME");
    }

    abstract protected ConditionValue getCValueProtocolScheme();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * USERNAME: {NotNull, VARCHAR(100)}
     * @param username The value of username as equal.
     */
    public void setUsername_Equal(String username) {
        doSetUsername_Equal(fRES(username));
    }

    protected void doSetUsername_Equal(String username) {
        regUsername(CK_EQ, username);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param username The value of username as notEqual.
     */
    public void setUsername_NotEqual(String username) {
        doSetUsername_NotEqual(fRES(username));
    }

    protected void doSetUsername_NotEqual(String username) {
        regUsername(CK_NES, username);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param username The value of username as greaterThan.
     */
    public void setUsername_GreaterThan(String username) {
        regUsername(CK_GT, fRES(username));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param username The value of username as lessThan.
     */
    public void setUsername_LessThan(String username) {
        regUsername(CK_LT, fRES(username));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param username The value of username as greaterEqual.
     */
    public void setUsername_GreaterEqual(String username) {
        regUsername(CK_GE, fRES(username));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param username The value of username as lessEqual.
     */
    public void setUsername_LessEqual(String username) {
        regUsername(CK_LE, fRES(username));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param usernameList The collection of username as inScope.
     */
    public void setUsername_InScope(Collection<String> usernameList) {
        doSetUsername_InScope(usernameList);
    }

    public void doSetUsername_InScope(Collection<String> usernameList) {
        regINS(CK_INS, cTL(usernameList), getCValueUsername(), "USERNAME");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param usernameList The collection of username as notInScope.
     */
    public void setUsername_NotInScope(Collection<String> usernameList) {
        doSetUsername_NotInScope(usernameList);
    }

    public void doSetUsername_NotInScope(Collection<String> usernameList) {
        regINS(CK_NINS, cTL(usernameList), getCValueUsername(), "USERNAME");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param username The value of username as prefixSearch.
     */
    public void setUsername_PrefixSearch(String username) {
        setUsername_LikeSearch(username, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param username The value of username as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUsername_LikeSearch(String username,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(username), getCValueUsername(), "USERNAME",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param username The value of username as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUsername_NotLikeSearch(String username,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(username), getCValueUsername(), "USERNAME",
                likeSearchOption);
    }

    protected void regUsername(ConditionKey k, Object v) {
        regQ(k, v, getCValueUsername(), "USERNAME");
    }

    abstract protected ConditionValue getCValueUsername();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * PASSWORD: {VARCHAR(100)}
     * @param password The value of password as equal.
     */
    public void setPassword_Equal(String password) {
        doSetPassword_Equal(fRES(password));
    }

    protected void doSetPassword_Equal(String password) {
        regPassword(CK_EQ, password);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param password The value of password as notEqual.
     */
    public void setPassword_NotEqual(String password) {
        doSetPassword_NotEqual(fRES(password));
    }

    protected void doSetPassword_NotEqual(String password) {
        regPassword(CK_NES, password);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param password The value of password as greaterThan.
     */
    public void setPassword_GreaterThan(String password) {
        regPassword(CK_GT, fRES(password));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param password The value of password as lessThan.
     */
    public void setPassword_LessThan(String password) {
        regPassword(CK_LT, fRES(password));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param password The value of password as greaterEqual.
     */
    public void setPassword_GreaterEqual(String password) {
        regPassword(CK_GE, fRES(password));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param password The value of password as lessEqual.
     */
    public void setPassword_LessEqual(String password) {
        regPassword(CK_LE, fRES(password));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param passwordList The collection of password as inScope.
     */
    public void setPassword_InScope(Collection<String> passwordList) {
        doSetPassword_InScope(passwordList);
    }

    public void doSetPassword_InScope(Collection<String> passwordList) {
        regINS(CK_INS, cTL(passwordList), getCValuePassword(), "PASSWORD");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param passwordList The collection of password as notInScope.
     */
    public void setPassword_NotInScope(Collection<String> passwordList) {
        doSetPassword_NotInScope(passwordList);
    }

    public void doSetPassword_NotInScope(Collection<String> passwordList) {
        regINS(CK_NINS, cTL(passwordList), getCValuePassword(), "PASSWORD");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param password The value of password as prefixSearch.
     */
    public void setPassword_PrefixSearch(String password) {
        setPassword_LikeSearch(password, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param password The value of password as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setPassword_LikeSearch(String password,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(password), getCValuePassword(), "PASSWORD",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param password The value of password as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setPassword_NotLikeSearch(String password,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(password), getCValuePassword(), "PASSWORD",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setPassword_IsNull() {
        regPassword(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setPassword_IsNotNull() {
        regPassword(CK_ISNN, DOBJ);
    }

    protected void regPassword(ConditionKey k, Object v) {
        regQ(k, v, getCValuePassword(), "PASSWORD");
    }

    abstract protected ConditionValue getCValuePassword();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * PARAMETERS: {VARCHAR(1000)}
     * @param parameters The value of parameters as equal.
     */
    public void setParameters_Equal(String parameters) {
        doSetParameters_Equal(fRES(parameters));
    }

    protected void doSetParameters_Equal(String parameters) {
        regParameters(CK_EQ, parameters);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param parameters The value of parameters as notEqual.
     */
    public void setParameters_NotEqual(String parameters) {
        doSetParameters_NotEqual(fRES(parameters));
    }

    protected void doSetParameters_NotEqual(String parameters) {
        regParameters(CK_NES, parameters);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param parameters The value of parameters as greaterThan.
     */
    public void setParameters_GreaterThan(String parameters) {
        regParameters(CK_GT, fRES(parameters));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param parameters The value of parameters as lessThan.
     */
    public void setParameters_LessThan(String parameters) {
        regParameters(CK_LT, fRES(parameters));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param parameters The value of parameters as greaterEqual.
     */
    public void setParameters_GreaterEqual(String parameters) {
        regParameters(CK_GE, fRES(parameters));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param parameters The value of parameters as lessEqual.
     */
    public void setParameters_LessEqual(String parameters) {
        regParameters(CK_LE, fRES(parameters));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param parametersList The collection of parameters as inScope.
     */
    public void setParameters_InScope(Collection<String> parametersList) {
        doSetParameters_InScope(parametersList);
    }

    public void doSetParameters_InScope(Collection<String> parametersList) {
        regINS(CK_INS, cTL(parametersList), getCValueParameters(), "PARAMETERS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param parametersList The collection of parameters as notInScope.
     */
    public void setParameters_NotInScope(Collection<String> parametersList) {
        doSetParameters_NotInScope(parametersList);
    }

    public void doSetParameters_NotInScope(Collection<String> parametersList) {
        regINS(CK_NINS, cTL(parametersList), getCValueParameters(),
                "PARAMETERS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param parameters The value of parameters as prefixSearch.
     */
    public void setParameters_PrefixSearch(String parameters) {
        setParameters_LikeSearch(parameters, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param parameters The value of parameters as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setParameters_LikeSearch(String parameters,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(parameters), getCValueParameters(), "PARAMETERS",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param parameters The value of parameters as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setParameters_NotLikeSearch(String parameters,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(parameters), getCValueParameters(), "PARAMETERS",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setParameters_IsNull() {
        regParameters(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setParameters_IsNotNull() {
        regParameters(CK_ISNN, DOBJ);
    }

    protected void regParameters(ConditionKey k, Object v) {
        regQ(k, v, getCValueParameters(), "PARAMETERS");
    }

    abstract protected ConditionValue getCValueParameters();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * FILE_CRAWLING_CONFIG_ID: {IX, NotNull, BIGINT(19), FK to FILE_CRAWLING_CONFIG}
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as equal.
     */
    public void setFileCrawlingConfigId_Equal(Long fileCrawlingConfigId) {
        doSetFileCrawlingConfigId_Equal(fileCrawlingConfigId);
    }

    protected void doSetFileCrawlingConfigId_Equal(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_EQ, fileCrawlingConfigId);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as notEqual.
     */
    public void setFileCrawlingConfigId_NotEqual(Long fileCrawlingConfigId) {
        doSetFileCrawlingConfigId_NotEqual(fileCrawlingConfigId);
    }

    protected void doSetFileCrawlingConfigId_NotEqual(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_NES, fileCrawlingConfigId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as greaterThan.
     */
    public void setFileCrawlingConfigId_GreaterThan(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_GT, fileCrawlingConfigId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as lessThan.
     */
    public void setFileCrawlingConfigId_LessThan(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_LT, fileCrawlingConfigId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as greaterEqual.
     */
    public void setFileCrawlingConfigId_GreaterEqual(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_GE, fileCrawlingConfigId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param fileCrawlingConfigId The value of fileCrawlingConfigId as lessEqual.
     */
    public void setFileCrawlingConfigId_LessEqual(Long fileCrawlingConfigId) {
        regFileCrawlingConfigId(CK_LE, fileCrawlingConfigId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param fileCrawlingConfigIdList The collection of fileCrawlingConfigId as inScope.
     */
    public void setFileCrawlingConfigId_InScope(
            Collection<Long> fileCrawlingConfigIdList) {
        doSetFileCrawlingConfigId_InScope(fileCrawlingConfigIdList);
    }

    protected void doSetFileCrawlingConfigId_InScope(
            Collection<Long> fileCrawlingConfigIdList) {
        regINS(CK_INS, cTL(fileCrawlingConfigIdList),
                getCValueFileCrawlingConfigId(), "FILE_CRAWLING_CONFIG_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param fileCrawlingConfigIdList The collection of fileCrawlingConfigId as notInScope.
     */
    public void setFileCrawlingConfigId_NotInScope(
            Collection<Long> fileCrawlingConfigIdList) {
        doSetFileCrawlingConfigId_NotInScope(fileCrawlingConfigIdList);
    }

    protected void doSetFileCrawlingConfigId_NotInScope(
            Collection<Long> fileCrawlingConfigIdList) {
        regINS(CK_NINS, cTL(fileCrawlingConfigIdList),
                getCValueFileCrawlingConfigId(), "FILE_CRAWLING_CONFIG_ID");
    }

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select FILE_CRAWLING_CONFIG_ID from FILE_CRAWLING_CONFIG where ...)} <br />
     * FILE_CRAWLING_CONFIG as 'fileCrawlingConfig'.
     * @param subQuery The sub-query of FileCrawlingConfig for 'in-scope'. (NotNull)
     */
    public void inScopeFileCrawlingConfig(
            SubQuery<FileCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<FileCrawlingConfigCB>", subQuery);
        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepFileCrawlingConfigId_InScopeRelation_FileCrawlingConfig(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "FILE_CRAWLING_CONFIG_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepFileCrawlingConfigId_InScopeRelation_FileCrawlingConfig(
            FileCrawlingConfigCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select FILE_CRAWLING_CONFIG_ID from FILE_CRAWLING_CONFIG where ...)} <br />
     * FILE_CRAWLING_CONFIG as 'fileCrawlingConfig'.
     * @param subQuery The sub-query of FileCrawlingConfig for 'not in-scope'. (NotNull)
     */
    public void notInScopeFileCrawlingConfig(
            SubQuery<FileCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<FileCrawlingConfigCB>", subQuery);
        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepFileCrawlingConfigId_NotInScopeRelation_FileCrawlingConfig(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "FILE_CRAWLING_CONFIG_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepFileCrawlingConfigId_NotInScopeRelation_FileCrawlingConfig(
            FileCrawlingConfigCQ subQuery);

    protected void regFileCrawlingConfigId(ConditionKey k, Object v) {
        regQ(k, v, getCValueFileCrawlingConfigId(), "FILE_CRAWLING_CONFIG_ID");
    }

    abstract protected ConditionValue getCValueFileCrawlingConfigId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * CREATED_BY: {NotNull, VARCHAR(255)}
     * @param createdBy The value of createdBy as equal.
     */
    public void setCreatedBy_Equal(String createdBy) {
        doSetCreatedBy_Equal(fRES(createdBy));
    }

    protected void doSetCreatedBy_Equal(String createdBy) {
        regCreatedBy(CK_EQ, createdBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as notEqual.
     */
    public void setCreatedBy_NotEqual(String createdBy) {
        doSetCreatedBy_NotEqual(fRES(createdBy));
    }

    protected void doSetCreatedBy_NotEqual(String createdBy) {
        regCreatedBy(CK_NES, createdBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterThan.
     */
    public void setCreatedBy_GreaterThan(String createdBy) {
        regCreatedBy(CK_GT, fRES(createdBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessThan.
     */
    public void setCreatedBy_LessThan(String createdBy) {
        regCreatedBy(CK_LT, fRES(createdBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterEqual.
     */
    public void setCreatedBy_GreaterEqual(String createdBy) {
        regCreatedBy(CK_GE, fRES(createdBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessEqual.
     */
    public void setCreatedBy_LessEqual(String createdBy) {
        regCreatedBy(CK_LE, fRES(createdBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as inScope.
     */
    public void setCreatedBy_InScope(Collection<String> createdByList) {
        doSetCreatedBy_InScope(createdByList);
    }

    public void doSetCreatedBy_InScope(Collection<String> createdByList) {
        regINS(CK_INS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as notInScope.
     */
    public void setCreatedBy_NotInScope(Collection<String> createdByList) {
        doSetCreatedBy_NotInScope(createdByList);
    }

    public void doSetCreatedBy_NotInScope(Collection<String> createdByList) {
        regINS(CK_NINS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as prefixSearch.
     */
    public void setCreatedBy_PrefixSearch(String createdBy) {
        setCreatedBy_LikeSearch(createdBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setCreatedBy_LikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setCreatedBy_NotLikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    protected void regCreatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedBy(), "CREATED_BY");
    }

    abstract protected ConditionValue getCValueCreatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * CREATED_TIME: {NotNull, TIMESTAMP(23, 10)}
     * @param createdTime The value of createdTime as equal.
     */
    public void setCreatedTime_Equal(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_EQ, createdTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterThan.
     */
    public void setCreatedTime_GreaterThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GT, createdTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessThan.
     */
    public void setCreatedTime_LessThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LT, createdTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterEqual.
     */
    public void setCreatedTime_GreaterEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GE, createdTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessEqual.
     */
    public void setCreatedTime_LessEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LE, createdTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of createdTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of createdTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setCreatedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueCreatedTime(),
                "CREATED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of createdTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of createdTime. (Nullable)
     */
    public void setCreatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setCreatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regCreatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedTime(), "CREATED_TIME");
    }

    abstract protected ConditionValue getCValueCreatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * UPDATED_BY: {VARCHAR(255)}
     * @param updatedBy The value of updatedBy as equal.
     */
    public void setUpdatedBy_Equal(String updatedBy) {
        doSetUpdatedBy_Equal(fRES(updatedBy));
    }

    protected void doSetUpdatedBy_Equal(String updatedBy) {
        regUpdatedBy(CK_EQ, updatedBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as notEqual.
     */
    public void setUpdatedBy_NotEqual(String updatedBy) {
        doSetUpdatedBy_NotEqual(fRES(updatedBy));
    }

    protected void doSetUpdatedBy_NotEqual(String updatedBy) {
        regUpdatedBy(CK_NES, updatedBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterThan.
     */
    public void setUpdatedBy_GreaterThan(String updatedBy) {
        regUpdatedBy(CK_GT, fRES(updatedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessThan.
     */
    public void setUpdatedBy_LessThan(String updatedBy) {
        regUpdatedBy(CK_LT, fRES(updatedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterEqual.
     */
    public void setUpdatedBy_GreaterEqual(String updatedBy) {
        regUpdatedBy(CK_GE, fRES(updatedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessEqual.
     */
    public void setUpdatedBy_LessEqual(String updatedBy) {
        regUpdatedBy(CK_LE, fRES(updatedBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as inScope.
     */
    public void setUpdatedBy_InScope(Collection<String> updatedByList) {
        doSetUpdatedBy_InScope(updatedByList);
    }

    public void doSetUpdatedBy_InScope(Collection<String> updatedByList) {
        regINS(CK_INS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as notInScope.
     */
    public void setUpdatedBy_NotInScope(Collection<String> updatedByList) {
        doSetUpdatedBy_NotInScope(updatedByList);
    }

    public void doSetUpdatedBy_NotInScope(Collection<String> updatedByList) {
        regINS(CK_NINS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as prefixSearch.
     */
    public void setUpdatedBy_PrefixSearch(String updatedBy) {
        setUpdatedBy_LikeSearch(updatedBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUpdatedBy_LikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUpdatedBy_NotLikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNull() {
        regUpdatedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNotNull() {
        regUpdatedBy(CK_ISNN, DOBJ);
    }

    protected void regUpdatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedBy(), "UPDATED_BY");
    }

    abstract protected ConditionValue getCValueUpdatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * UPDATED_TIME: {TIMESTAMP(23, 10)}
     * @param updatedTime The value of updatedTime as equal.
     */
    public void setUpdatedTime_Equal(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_EQ, updatedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterThan.
     */
    public void setUpdatedTime_GreaterThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GT, updatedTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessThan.
     */
    public void setUpdatedTime_LessThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LT, updatedTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterEqual.
     */
    public void setUpdatedTime_GreaterEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GE, updatedTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessEqual.
     */
    public void setUpdatedTime_LessEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LE, updatedTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of updatedTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of updatedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setUpdatedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueUpdatedTime(),
                "UPDATED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of updatedTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of updatedTime. (Nullable)
     */
    public void setUpdatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setUpdatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNull() {
        regUpdatedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNotNull() {
        regUpdatedTime(CK_ISNN, DOBJ);
    }

    protected void regUpdatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedTime(), "UPDATED_TIME");
    }

    abstract protected ConditionValue getCValueUpdatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * DELETED_BY: {VARCHAR(255)}
     * @param deletedBy The value of deletedBy as equal.
     */
    public void setDeletedBy_Equal(String deletedBy) {
        doSetDeletedBy_Equal(fRES(deletedBy));
    }

    protected void doSetDeletedBy_Equal(String deletedBy) {
        regDeletedBy(CK_EQ, deletedBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as notEqual.
     */
    public void setDeletedBy_NotEqual(String deletedBy) {
        doSetDeletedBy_NotEqual(fRES(deletedBy));
    }

    protected void doSetDeletedBy_NotEqual(String deletedBy) {
        regDeletedBy(CK_NES, deletedBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterThan.
     */
    public void setDeletedBy_GreaterThan(String deletedBy) {
        regDeletedBy(CK_GT, fRES(deletedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessThan.
     */
    public void setDeletedBy_LessThan(String deletedBy) {
        regDeletedBy(CK_LT, fRES(deletedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterEqual.
     */
    public void setDeletedBy_GreaterEqual(String deletedBy) {
        regDeletedBy(CK_GE, fRES(deletedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessEqual.
     */
    public void setDeletedBy_LessEqual(String deletedBy) {
        regDeletedBy(CK_LE, fRES(deletedBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as inScope.
     */
    public void setDeletedBy_InScope(Collection<String> deletedByList) {
        doSetDeletedBy_InScope(deletedByList);
    }

    public void doSetDeletedBy_InScope(Collection<String> deletedByList) {
        regINS(CK_INS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as notInScope.
     */
    public void setDeletedBy_NotInScope(Collection<String> deletedByList) {
        doSetDeletedBy_NotInScope(deletedByList);
    }

    public void doSetDeletedBy_NotInScope(Collection<String> deletedByList) {
        regINS(CK_NINS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as prefixSearch.
     */
    public void setDeletedBy_PrefixSearch(String deletedBy) {
        setDeletedBy_LikeSearch(deletedBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setDeletedBy_LikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setDeletedBy_NotLikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNull() {
        regDeletedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNotNull() {
        regDeletedBy(CK_ISNN, DOBJ);
    }

    protected void regDeletedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedBy(), "DELETED_BY");
    }

    abstract protected ConditionValue getCValueDeletedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * DELETED_TIME: {TIMESTAMP(23, 10)}
     * @param deletedTime The value of deletedTime as equal.
     */
    public void setDeletedTime_Equal(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_EQ, deletedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterThan.
     */
    public void setDeletedTime_GreaterThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GT, deletedTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessThan.
     */
    public void setDeletedTime_LessThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LT, deletedTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterEqual.
     */
    public void setDeletedTime_GreaterEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GE, deletedTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessEqual.
     */
    public void setDeletedTime_LessEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LE, deletedTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of deletedTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of deletedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setDeletedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueDeletedTime(),
                "DELETED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of deletedTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of deletedTime. (Nullable)
     */
    public void setDeletedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setDeletedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNull() {
        regDeletedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNotNull() {
        regDeletedTime(CK_ISNN, DOBJ);
    }

    protected void regDeletedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedTime(), "DELETED_TIME");
    }

    abstract protected ConditionValue getCValueDeletedTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * VERSION_NO: {NotNull, INTEGER(10)}
     * @param versionNo The value of versionNo as equal.
     */
    public void setVersionNo_Equal(Integer versionNo) {
        doSetVersionNo_Equal(versionNo);
    }

    protected void doSetVersionNo_Equal(Integer versionNo) {
        regVersionNo(CK_EQ, versionNo);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as notEqual.
     */
    public void setVersionNo_NotEqual(Integer versionNo) {
        doSetVersionNo_NotEqual(versionNo);
    }

    protected void doSetVersionNo_NotEqual(Integer versionNo) {
        regVersionNo(CK_NES, versionNo);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterThan.
     */
    public void setVersionNo_GreaterThan(Integer versionNo) {
        regVersionNo(CK_GT, versionNo);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessThan.
     */
    public void setVersionNo_LessThan(Integer versionNo) {
        regVersionNo(CK_LT, versionNo);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterEqual.
     */
    public void setVersionNo_GreaterEqual(Integer versionNo) {
        regVersionNo(CK_GE, versionNo);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessEqual.
     */
    public void setVersionNo_LessEqual(Integer versionNo) {
        regVersionNo(CK_LE, versionNo);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as inScope.
     */
    public void setVersionNo_InScope(Collection<Integer> versionNoList) {
        doSetVersionNo_InScope(versionNoList);
    }

    protected void doSetVersionNo_InScope(Collection<Integer> versionNoList) {
        regINS(CK_INS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as notInScope.
     */
    public void setVersionNo_NotInScope(Collection<Integer> versionNoList) {
        doSetVersionNo_NotInScope(versionNoList);
    }

    protected void doSetVersionNo_NotInScope(Collection<Integer> versionNoList) {
        regINS(CK_NINS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    protected void regVersionNo(ConditionKey k, Object v) {
        regQ(k, v, getCValueVersionNo(), "VERSION_NO");
    }

    abstract protected ConditionValue getCValueVersionNo();

    // ===================================================================================
    //                                                                    Scalar Condition
    //                                                                    ================
    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO = (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_Equal()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setXxx... // derived column for function
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_Equal() {
        return xcreateSSQFunction(CK_EQ.getOperand());
    }

    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO &lt;&gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_NotEqual()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setXxx... // derived column for function
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_NotEqual() {
        return xcreateSSQFunction(CK_NES.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterThan. <br />
     * {where FOO &gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterThan()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_GreaterThan() {
        return xcreateSSQFunction(CK_GT.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessThan. <br />
     * {where FOO &lt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessThan()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_LessThan() {
        return xcreateSSQFunction(CK_LT.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterEqual. <br />
     * {where FOO &gt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterEqual()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(CK_GE.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessEqual. <br />
     * {where FOO &lt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessEqual()</span>.max(new SubQuery&lt;FileAuthenticationCB&gt;() {
     *     public void query(FileAuthenticationCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<FileAuthenticationCB> scalar_LessEqual() {
        return xcreateSSQFunction(CK_LE.getOperand());
    }

    protected HpSSQFunction<FileAuthenticationCB> xcreateSSQFunction(
            final String operand) {
        return new HpSSQFunction<FileAuthenticationCB>(
                new HpSSQSetupper<FileAuthenticationCB>() {
                    public void setup(String function,
                            SubQuery<FileAuthenticationCB> subQuery) {
                        xscalarCondition(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarCondition(String function,
            SubQuery<FileAuthenticationCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<FileAuthenticationCB>", subQuery);
        FileAuthenticationCB cb = new FileAuthenticationCB();
        cb.xsetupForScalarCondition();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarCondition(cb.query()); // for saving query-value.
        registerScalarCondition(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarCondition(FileAuthenticationCQ subQuery);

    // ===================================================================================
    //                                                                      Myself InScope
    //                                                                      ==============
    /**
     * Myself InScope (SubQuery). {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<FileAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<FileAuthenticationCB>", subQuery);
        FileAuthenticationCB cb = new FileAuthenticationCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeRelation(cb.query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeRelation(
            FileAuthenticationCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xabCB() {
        return FileAuthenticationCB.class.getName();
    }

    protected String xabCQ() {
        return FileAuthenticationCQ.class.getName();
    }

    protected String xabLSO() {
        return LikeSearchOption.class.getName();
    }

    protected String xabSSQS() {
        return HpSSQSetupper.class.getName();
    }
}
