/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebCrawlingConfigDbm;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FailureUrlBhv;
import jp.sf.fess.db.exbhv.RequestHeaderBhv;
import jp.sf.fess.db.exbhv.WebAuthenticationBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of WEB_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, URLS, INCLUDED_URLS, EXCLUDED_URLS, INCLUDED_DOC_URLS, EXCLUDED_DOC_URLS, DEPTH, MAX_ACCESS_COUNT, USER_AGENT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, REQUEST_HEADER, WEB_AUTHENTICATION, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, requestHeaderList, webAuthenticationList, webConfigToBrowserTypeMappingList, webConfigToLabelTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebCrawlingConfigBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebCrawlingConfigDbm getMyDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebCrawlingConfig newMyEntity() {
        return new WebCrawlingConfig();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebCrawlingConfigCB newMyConditionBean() {
        return new WebCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * int count = webCrawlingConfigBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebCrawlingConfigCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(WebCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebCrawlingConfig&gt;() {
     *     public void handle(WebCrawlingConfig entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of WebCrawlingConfig. (NotNull)
     */
    public void selectCursor(WebCrawlingConfigCB cb,
            EntityRowHandler<WebCrawlingConfig> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> void doSelectCursor(
            WebCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebCrawlingConfig>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * WebCrawlingConfig webCrawlingConfig = webCrawlingConfigBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webCrawlingConfig != null) {
     *     ... = webCrawlingConfig.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectEntity(WebCrawlingConfigCB cb) {
        return doSelectEntity(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectEntity(
            final WebCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * WebCrawlingConfig webCrawlingConfig = webCrawlingConfigBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webCrawlingConfig.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectEntityWithDeletedCheck(WebCrawlingConfigCB cb) {
        return doSelectEntityWithDeletedCheck(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectEntityWithDeletedCheck(
            final WebCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebCrawlingConfigCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebCrawlingConfig&gt; webCrawlingConfigList = webCrawlingConfigBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebCrawlingConfig> selectList(WebCrawlingConfigCB cb) {
        return doSelectList(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ListResultBean<ENTITY> doSelectList(
            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebCrawlingConfig&gt; page = webCrawlingConfigBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebCrawlingConfig webCrawlingConfig : page) {
     *     ... = webCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebCrawlingConfig> selectPage(WebCrawlingConfigCB cb) {
        return doSelectPage(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> PagingResultBean<ENTITY> doSelectPage(
            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, WebCrawlingConfigCB>() {
                    public int callbackSelectCount(WebCrawlingConfigCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebCrawlingConfigCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadFailureUrlList(xnewLRLs(webCrawlingConfig), conditionBeanSetupper);
    }

    /**
     * Load referrer of failureUrlList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadFailureUrlList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;FailureUrlCB&gt;() {
     *     public void setup(FailureUrlCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getFailureUrlList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadFailureUrlList(webCrawlingConfigList,
                new LoadReferrerOption<FailureUrlCB, FailureUrl>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadFailureUrlList(xnewLRLs(webCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final FailureUrlBhv referrerBhv = xgetBSFLR().select(
                FailureUrlBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, FailureUrlCB, FailureUrl>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e, List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }

                    public FailureUrlCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FailureUrlCB cb, List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FailureUrlCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<FailureUrl> selRfLs(FailureUrlCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FailureUrl e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(FailureUrl re, WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of requestHeaderList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadRequestHeaderList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;RequestHeaderCB&gt;() {
     *     public void setup(RequestHeaderCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getRequestHeaderList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadRequestHeaderList(webCrawlingConfigList,
                new LoadReferrerOption<RequestHeaderCB, RequestHeader>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final RequestHeaderBhv referrerBhv = xgetBSFLR().select(
                RequestHeaderBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, RequestHeaderCB, RequestHeader>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<RequestHeader> ls) {
                        e.setRequestHeaderList(ls);
                    }

                    public RequestHeaderCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(RequestHeaderCB cb, List<Long> ls) {
                        cb.query().setWebCrawlingConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(RequestHeaderCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public List<RequestHeader> selRfLs(RequestHeaderCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(RequestHeader e) {
                        return e.getWebCrawlingConfigId();
                    }

                    public void setlcEt(RequestHeader re, WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webAuthenticationList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebAuthenticationList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebAuthenticationCB&gt;() {
     *     public void setup(WebAuthenticationCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebAuthenticationList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebAuthenticationList(webCrawlingConfigList,
                new LoadReferrerOption<WebAuthenticationCB, WebAuthentication>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebAuthenticationBhv referrerBhv = xgetBSFLR().select(
                WebAuthenticationBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebAuthenticationCB, WebAuthentication>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebAuthentication> ls) {
                        e.setWebAuthenticationList(ls);
                    }

                    public WebAuthenticationCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebAuthenticationCB cb, List<Long> ls) {
                        cb.query().setWebCrawlingConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebAuthenticationCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public List<WebAuthentication> selRfLs(
                            WebAuthenticationCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebAuthentication e) {
                        return e.getWebCrawlingConfigId();
                    }

                    public void setlcEt(WebAuthentication re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToBrowserTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }

                    public WebConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToBrowserTypeMapping> selRfLs(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToBrowserTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToBrowserTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToLabelTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(WebConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }

                    public WebConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToLabelTypeMapping> selRfLs(
                            WebConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToLabelTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToLabelTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToRoleTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(WebConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }

                    public WebConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToRoleTypeMapping> selRfLs(
                            WebConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToRoleTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToRoleTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webCrawlingConfig.setFoo...(value);
     * webCrawlingConfig.setBar...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">insert</span>(webCrawlingConfig);
     * ... = webCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebCrawlingConfig webCrawlingConfig) {
        assertEntityNotNull(webCrawlingConfig);
        delegateInsert(webCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webCrawlingConfigBhv.<span style="color: #FD4747">update</span>(webCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final WebCrawlingConfig webCrawlingConfig) {
        helpUpdateInternally(webCrawlingConfig,
                new InternalUpdateCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdate(WebCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">updateNonstrict</span>(webCrawlingConfig);
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final WebCrawlingConfig webCrawlingConfig) {
        helpUpdateNonstrictInternally(webCrawlingConfig,
                new InternalUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final WebCrawlingConfig webCrawlingConfig) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateCallback<WebCrawlingConfig, WebCrawlingConfigCB>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(WebCrawlingConfig entity) {
                        update(entity);
                    }

                    public WebCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(WebCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(WebCrawlingConfig webCrawlingConfig) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(WebCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webCrawlingConfigBhv.<span style="color: #FD4747">delete</span>(webCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteInternally(webCrawlingConfig,
                new InternalDeleteCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDelete(WebCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrict</span>(webCrawlingConfig);
     * </pre>
     * @param webCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteNonstrictInternally(webCrawlingConfig,
                new InternalDeleteNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(webCrawlingConfig);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param webCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                webCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateInsertList(webCrawlingConfigList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateUpdateList(webCrawlingConfigList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateUpdateListNonstrict(webCrawlingConfigList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateDeleteList(webCrawlingConfigList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateDeleteListNonstrict(webCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setPK...(value);</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">queryUpdate</span>(webCrawlingConfig, cb);
     * </pre>
     * @param webCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb) {
        return delegateQueryUpdate(webCrawlingConfig, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">queryDelete</span>(webCrawlingConfig, cb);
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebCrawlingConfigCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *         public void specify(WebCrawlingConfigCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdate</span>(webCrawlingConfig, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(WebCrawlingConfig webCrawlingConfig,
            final UpdateOption<WebCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(webCrawlingConfig,
                new InternalUpdateCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdate(WebCrawlingConfig entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void specify(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(webCrawlingConfig, option);
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(WebCrawlingConfig webCrawlingConfig,
            final UpdateOption<WebCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(webCrawlingConfig,
                new InternalUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setPK...(value);</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void specify(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webCrawlingConfig, cb, option);
     * </pre>
     * @param webCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb,
            final UpdateOption<WebCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(webCrawlingConfig, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends WebCrawlingConfig> void delegateSelectCursor(
            WebCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends WebCrawlingConfig> List<ENTITY> delegateSelectList(
            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(WebCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(WebCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(WebCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(WebCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(WebCrawlingConfig e,
            WebCrawlingConfigCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(WebCrawlingConfigCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(WebCrawlingConfig e,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(WebCrawlingConfig e,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(WebCrawlingConfig e,
            WebCrawlingConfigCB cb, UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebCrawlingConfig downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, WebCrawlingConfig.class);
    }

    protected WebCrawlingConfigCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebCrawlingConfigCB.class);
    }
}
