/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.ciq;

import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.FailureUrlCQ;
import jp.sf.fess.db.cbean.cq.FileAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.bs.AbstractBsFileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.bs.BsFileCrawlingConfigCQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The condition-query for in-line of FILE_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public class FileCrawlingConfigCIQ extends AbstractBsFileCrawlingConfigCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected BsFileCrawlingConfigCQ _myCQ;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public FileCrawlingConfigCIQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel,
            BsFileCrawlingConfigCQ myCQ) {
        super(childQuery, sqlClause, aliasName, nestLevel);
        _myCQ = myCQ;
        _foreignPropertyName = _myCQ.xgetForeignPropertyName(); // accept foreign property name
        _relationPath = _myCQ.xgetRelationPath(); // accept relation path
        _inline = true;
    }

    // ===================================================================================
    //                                                             Override about Register
    //                                                             =======================
    @Override
    protected void reflectRelationOnUnionQuery(ConditionQuery bq,
            ConditionQuery uq) {
        String msg = "InlineView must not need UNION method: " + bq + " : "
                + uq;
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col) {
        regIQ(k, v, cv, col);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col, ConditionOption op) {
        regIQ(k, v, cv, col, op);
    }

    @Override
    protected void registerWhereClause(String wc) {
        registerInlineWhereClause(wc);
    }

    @Override
    protected boolean isInScopeRelationSuppressLocalAliasName() {
        if (_onClause) {
            throw new IllegalConditionBeanOperationException(
                    "InScopeRelation on OnClause is unsupported.");
        }
        return true;
    }

    // ===================================================================================
    //                                                                Override about Query
    //                                                                ====================
    protected ConditionValue getCValueId() {
        return _myCQ.getId();
    }

    public String keepId_ExistsReferrer_FailureUrlList(FailureUrlCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_ExistsReferrer_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_ExistsReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_ExistsReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_ExistsReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_FailureUrlList(FailureUrlCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_InScopeRelation_FailureUrlList(FailureUrlCQ sq) {
        return _myCQ.keepId_InScopeRelation_FailureUrlList(sq);
    }

    public String keepId_InScopeRelation_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        return _myCQ.keepId_InScopeRelation_FileAuthenticationList(sq);
    }

    public String keepId_InScopeRelation_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        return _myCQ
                .keepId_InScopeRelation_FileConfigToBrowserTypeMappingList(sq);
    }

    public String keepId_InScopeRelation_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        return _myCQ
                .keepId_InScopeRelation_FileConfigToLabelTypeMappingList(sq);
    }

    public String keepId_InScopeRelation_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        return _myCQ.keepId_InScopeRelation_FileConfigToRoleTypeMappingList(sq);
    }

    public String keepId_NotInScopeRelation_FailureUrlList(FailureUrlCQ sq) {
        return _myCQ.keepId_NotInScopeRelation_FailureUrlList(sq);
    }

    public String keepId_NotInScopeRelation_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        return _myCQ.keepId_NotInScopeRelation_FileAuthenticationList(sq);
    }

    public String keepId_NotInScopeRelation_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        return _myCQ
                .keepId_NotInScopeRelation_FileConfigToBrowserTypeMappingList(sq);
    }

    public String keepId_NotInScopeRelation_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        return _myCQ
                .keepId_NotInScopeRelation_FileConfigToLabelTypeMappingList(sq);
    }

    public String keepId_NotInScopeRelation_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        return _myCQ
                .keepId_NotInScopeRelation_FileConfigToRoleTypeMappingList(sq);
    }

    public String keepId_SpecifyDerivedReferrer_FailureUrlList(FailureUrlCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_SpecifyDerivedReferrer_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FailureUrlList(FailureUrlCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FailureUrlListParameter(Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileAuthenticationList(
            FileAuthenticationCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileAuthenticationListParameter(
            Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameter(
            Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameter(
            Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter(
            Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    protected ConditionValue getCValueName() {
        return _myCQ.getName();
    }

    protected ConditionValue getCValuePaths() {
        return _myCQ.getPaths();
    }

    protected ConditionValue getCValueIncludedPaths() {
        return _myCQ.getIncludedPaths();
    }

    protected ConditionValue getCValueExcludedPaths() {
        return _myCQ.getExcludedPaths();
    }

    protected ConditionValue getCValueIncludedDocPaths() {
        return _myCQ.getIncludedDocPaths();
    }

    protected ConditionValue getCValueExcludedDocPaths() {
        return _myCQ.getExcludedDocPaths();
    }

    protected ConditionValue getCValueDepth() {
        return _myCQ.getDepth();
    }

    protected ConditionValue getCValueMaxAccessCount() {
        return _myCQ.getMaxAccessCount();
    }

    protected ConditionValue getCValueNumOfThread() {
        return _myCQ.getNumOfThread();
    }

    protected ConditionValue getCValueIntervalTime() {
        return _myCQ.getIntervalTime();
    }

    protected ConditionValue getCValueBoost() {
        return _myCQ.getBoost();
    }

    protected ConditionValue getCValueAvailable() {
        return _myCQ.getAvailable();
    }

    protected ConditionValue getCValueSortOrder() {
        return _myCQ.getSortOrder();
    }

    protected ConditionValue getCValueCreatedBy() {
        return _myCQ.getCreatedBy();
    }

    protected ConditionValue getCValueCreatedTime() {
        return _myCQ.getCreatedTime();
    }

    protected ConditionValue getCValueUpdatedBy() {
        return _myCQ.getUpdatedBy();
    }

    protected ConditionValue getCValueUpdatedTime() {
        return _myCQ.getUpdatedTime();
    }

    protected ConditionValue getCValueDeletedBy() {
        return _myCQ.getDeletedBy();
    }

    protected ConditionValue getCValueDeletedTime() {
        return _myCQ.getDeletedTime();
    }

    protected ConditionValue getCValueVersionNo() {
        return _myCQ.getVersionNo();
    }

    public String keepScalarCondition(FileCrawlingConfigCQ subQuery) {
        throwIICBOE("ScalarCondition");
        return null;
    }

    public String keepMyselfInScopeRelation(FileCrawlingConfigCQ subQuery) {
        throwIICBOE("MyselfInScopeRelation");
        return null;
    }

    protected void throwIICBOE(String name) { // throwInlineIllegalConditionBeanOperationException()
        throw new IllegalConditionBeanOperationException(name
                + " at InlineView is unsupported.");
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xinCB() {
        return FileCrawlingConfigCB.class.getName();
    }

    protected String xinCQ() {
        return FileCrawlingConfigCQ.class.getName();
    }
}
