/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.dialog;

import filebookmark.Activator;
import filebookmark.dialog.Messages;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDialog
extends Dialog {
    private boolean single = false;
    private Map<String, String> fileInfo;
    private Text txtName = null;
    private Tree tree = null;
    private final int CREATE_ID = 100;
    private Category rootCategory;
    private boolean url = false;

    public AddDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Point getInitialSize() {
        return new Point(300, 300);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AddDialog.dialog_title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("AddDialog.dialog_name"));
        this.txtName = new Text(composite, 2052);
        this.txtName.setLayoutData((Object)new GridData(768));
        if (this.single) {
            String name = this.fileInfo.keySet().iterator().next();
            this.txtName.setText(name);
        }
        this.txtName.setEnabled(this.single);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(Messages.getString("AddDialog.dialog_making"));
        this.tree = new Tree(composite, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        TreeItem parentItem = new TreeItem(this.tree, 0);
        this.rootCategory = FileBookmarkUtil.readXml();
        parentItem.setText(this.rootCategory.getName());
        parentItem.setImage(Activator.getImage("icons/book_close_w.gif"));
        parentItem.setData((Object)this.rootCategory);
        this.tree.setSelection(parentItem);
        this.setTreeItem(parentItem, this.rootCategory);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, Messages.getString("AddDialog.dialog_new_category"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.createNewBookmark();
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 100) {
            this.createNewCategory();
        }
        super.buttonPressed(buttonId);
    }

    protected void createNewBookmark() {
        TreeItem selectItem = this.tree.getSelection()[0];
        Category category = (Category)selectItem.getData();
        for (String name : this.fileInfo.keySet()) {
            String inputName = null;
            if (this.fileInfo.size() == 1) {
                inputName = this.txtName.getText();
                if (inputName == null || "".equals(inputName)) {
                    inputName = name;
                }
            } else {
                inputName = name;
            }
            String fileType = "";
            if (this.url) {
                fileType = "URL";
            }
            Bookmark bookmark = new Bookmark(inputName, this.fileInfo.get(name), fileType);
            category.addChild(bookmark);
        }
        FileBookmarkUtil.writeXml();
    }

    protected void createNewCategory() {
        InputDialog newDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.getString("AddDialog.dialog_new_category"), Messages.getString("AddDialog.dialog_name"), "New Category", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return Messages.getString("AddDialog.dialog_not_input_name");
                }
                if (!FileBookmarkUtil.getRootCategory().exist(newText)) {
                    return Messages.getString("AddDialog.dialog_repetition_category");
                }
                return null;
            }
        }){

            protected Point getInitialSize() {
                return new Point(270, 160);
            }
        };
        if (newDialog.open() == 0) {
            TreeItem item = this.tree.getSelection()[0];
            TreeItem newItem = new TreeItem(item, 0);
            newItem.setText(newDialog.getValue());
            newItem.setImage(Activator.getImage("icons/book_close_w.gif"));
            Category category = new Category(newDialog.getValue());
            newItem.setData((Object)category);
            Category selectCategory = (Category)item.getData();
            selectCategory.addChild(category);
            this.tree.setSelection(newItem);
        }
    }

    private void setTreeItem(TreeItem parentTree, Category category) {
        if (!category.hasChildren()) {
            return;
        }
        Bookmark[] bookmarkArray = category.getChildren();
        int n = 0;
        int n2 = bookmarkArray.length;
        while (n < n2) {
            Bookmark childCategory = bookmarkArray[n];
            if (childCategory.getType() == ElementType.CATEGORY) {
                TreeItem childTree = new TreeItem(parentTree, 0);
                childTree.setData((Object)childCategory);
                childTree.setText(childCategory.getName());
                childTree.setImage(Activator.getImage("icons/book_close_w.gif"));
                this.setTreeItem(childTree, (Category)childCategory);
            }
            ++n;
        }
    }

    public void setFileInfo(Map<String, String> fileInfo) {
        this.fileInfo = fileInfo;
        this.single = fileInfo.size() == 1;
    }

    public void setUrl(boolean url) {
        this.url = url;
    }
}

