package filebookmark.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.util.FileBookmarkUtil;

public class DelAction implements IObjectActionDelegate, IViewActionDelegate {

	private ISelection selection;
	
	/**
	 * Constructor for Action1.
	 */
	public DelAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		
		Object[] list = ((IStructuredSelection)selection).toArray();

		for(Object obj : list){

			if(obj instanceof Bookmark){

				Category parent = ((Bookmark)obj).getParentCategory();
				
				if("Bookmark".equals(((Bookmark)obj).getName())){ //$NON-NLS-1$
					((Category)obj).clearChildren();
					break;
				}else if(parent != null){
					parent.removeChild((Bookmark)obj);
					obj = null;
					
				}
				
				
			}
			
		}
		
		FileBookmarkUtil.writeXml();
		FileBookmarkUtil.refreshView();
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	public void init(IViewPart view) {	
	}

}
