package filebookmark.model;

import java.util.ArrayList;
import java.util.List;

import filebookmark.util.ElementType;

public class Category extends Bookmark{

	private ArrayList<Bookmark> children;

	/**
	 * RXgN^
	 * @param name O 
	 */
	public Category(String name){
		super(name, null);
		type =  ElementType.CATEGORY;
		children = new ArrayList<Bookmark>();
	}

	/**
	 * qvfǉB
	 * @param child
	 */
	public void addChild(Bookmark child) {
		children.add(child);
		child.setParentCategory(this);
	}

	/**
	 * qvf폜B
	 * @param child
	 */
	public void removeChild(Bookmark child) {
		children.remove(child);
		child.setParentCategory(null);
	}

	public void clearChildren(){
		children.clear();
	}
	/**
	 * qvfԋpB
	 * @return qvf
	 */
	public Bookmark[] getChildren() {
		return (Bookmark[]) children.toArray(new Bookmark[children.size()]);
	}

	public List<Bookmark> getChildrenList(){
		return children;
	}
	/**
	 * qvf邩ǂ
	 * @return true:qvf
	 */
	public boolean hasChildren() {
		return children.size() > 0;
	}

	/**
	 * dJeS邩B
	 * @param checkName 閼O
	 * @return true dȂ
	 */
	public boolean exist(String checkName){
		
		if(getName().equals(checkName)){
			return false;
		}
		
		if(hasChildren()){
			for(Bookmark category : children){
				if(category.getType() == ElementType.CATEGORY
						&& !((Category)category).exist(checkName)){
					return false;
				}
			}
		}

		return true;
	}
}
