package filebookmark.util;

import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import filebookmark.Activator;
import filebookmark.model.Category;
import filebookmark.view.BookmarkView;

public class FileBookmarkUtil {
		
	/**
	 * t@CEubN}[Nr[XVB
	 *
	 */
	public static void refreshView() {
		IWorkbench workbench = Activator.getDefault().getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		
		IViewReference[] references = page.getViewReferences();
		
		for(IViewReference r : references){
			if(r.getId().equals("BookmarkView")){ //$NON-NLS-1$
				BookmarkView view = (BookmarkView)r.getView(false);
				view.refresh();
				break;
			}
		}
	}

	/**
	 * XMLǂݍ݁A[gJeSԋpB
	 * @return [gJeS
	 */
	public static Category readXml(){
		return XmlAccessor.getInstance().readXml();
	}
	
	/**
	 * XMLɏށB
	 */
	public static void writeXml(){
		XmlAccessor.getInstance().writeXml();
	}
	
	/**
	 * [gJeSԋpB
	 * @return [gJeS
	 */
	public static Category getRootCategory(){
		return XmlAccessor.getInstance().getRootCategory();
	}
}
