﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Partial Class Archive

        Public Structure EntryInfo

            Public Class EntryPathComparer
                Implements Collections.Generic.IComparer(Of EntryInfo)
                Public Function Compare(ByVal x As EntryInfo, ByVal y As EntryInfo) As Integer Implements System.Collections.Generic.IComparer(Of EntryInfo).Compare
                    Return Logic.FileSystem.PathBase.Compare(x.EntryPath, y.EntryPath)
                End Function
            End Class

            Public CompressedSize As Nullable(Of Integer)
            Public CompressionRatio As Nullable(Of Double)
            Public Crc32 As Nullable(Of UInt32)
            Public EntryPath As String
            Public ExtractSize As Nullable(Of Integer)
            Public ModifiedTime As Nullable(Of DateTime)

            Public Function CrcHex8() As String
                If Crc32 Is Nothing Then Return Nothing
                Return Crc32.Value.ToString("X8")
            End Function

            Public Overrides Function ToString() As String
                Return EntryPath
            End Function

        End Structure

        Public Enum RarCompressionLv As Integer
            None = 0
            BestSpeed = 1
            Speed = 2
            Normal = 3
            Compress = 4
            BestCompress = 5
        End Enum

        Public Enum ZipCompressionLv As Integer
            None = Ionic.Zlib.CompressionLevel.None
            Normal = Ionic.Zlib.CompressionLevel.Default
            BestSpeed = Ionic.Zlib.CompressionLevel.BestSpeed
            BestCompress = Ionic.Zlib.CompressionLevel.BestCompression
            Level0 = Ionic.Zlib.CompressionLevel.Level0
            Level1 = Ionic.Zlib.CompressionLevel.Level1
            Level2 = Ionic.Zlib.CompressionLevel.Level2
            Level3 = Ionic.Zlib.CompressionLevel.Level3
            Level4 = Ionic.Zlib.CompressionLevel.Level4
            Level5 = Ionic.Zlib.CompressionLevel.Level5
            Level6 = Ionic.Zlib.CompressionLevel.Level6
            Level7 = Ionic.Zlib.CompressionLevel.Level7
            Level8 = Ionic.Zlib.CompressionLevel.Level8
            Level9 = Ionic.Zlib.CompressionLevel.Level9
        End Enum

    End Class ' Archive

    <Serializable()> _
    Public Class ArchiveOptionConfigCollection

        Public Sub New()
            SelectedType = ENUM_ARCHIVETYPE.ZIP
            _Ext = New Collections.Generic.SortedList(Of ENUM_ARCHIVETYPE, ArchiveOptionConfig)
            For Each e As ENUM_ARCHIVETYPE In [Enum].GetValues(GetType(ENUM_ARCHIVETYPE))
                _Ext.Add(e, ArchiveOptionConfig(e))
            Next
        End Sub

        Public Sub New(ByVal src As ArchiveOptionConfigCollection)
            MyClass.New()
            If src Is Nothing Then Return
            SelectedType = src.SelectedType
            For Each key As ENUM_ARCHIVETYPE In src._Ext.Keys
                _Ext(key) = src._Ext(key).Clone
            Next
        End Sub

        ' public properties /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        Default Public ReadOnly Property Item(ByVal e As ENUM_ARCHIVETYPE) As ArchiveOptionConfig
            Get
                If _Ext.ContainsKey(e) Then Return _Ext(e)
                Return Nothing
            End Get
        End Property
        Default Public ReadOnly Property Item(ByVal path_ext As Logic.FileSystem.Extention) As ArchiveOptionConfig
            Get
                If path_ext IsNot Nothing AndAlso path_ext.IsNullOrWhiteSpace = False Then
                    For Each e As ArchiveOptionConfig In _Ext.Values
                        If path_ext.Equals(e.Extention) Then Return e
                    Next
                End If
                Return Nothing
            End Get
        End Property
        Default Public ReadOnly Property Item(ByVal path_ext As String) As ArchiveOptionConfig
            Get
                Dim ext As String = Logic.FileSystem.GetPathExtention(path_ext)
                If String.IsNullOrWhiteSpace(ext) Then ext = path_ext
                Return Item(New Logic.FileSystem.Extention(ext))
            End Get
        End Property

        Public ReadOnly Property SelectedExt As ArchiveOptionConfig
            Get
                Return _Ext(SelectedType)
            End Get
        End Property

        Public Property SelectedType As ENUM_ARCHIVETYPE

        Public Property Rar As Archive.RarOptionConfig
            Get
                Return _Ext(ENUM_ARCHIVETYPE.RAR)
            End Get
            Set(ByVal value As Archive.RarOptionConfig)
                _Ext(ENUM_ARCHIVETYPE.RAR) = value
            End Set
        End Property

        Public Property Zip As Archive.ZipOptionConfig
            Get
                Return _Ext(ENUM_ARCHIVETYPE.ZIP)
            End Get
            Set(ByVal value As Archive.ZipOptionConfig)
                _Ext(ENUM_ARCHIVETYPE.ZIP) = value
            End Set
        End Property

        ' public methods ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        Public Shared Function ArchiveOptionConfig(ByVal t As ENUM_ARCHIVETYPE) As ArchiveOptionConfig
            Return ArchiveOptionType.FromType(t).InvokeMember(Nothing, Reflection.BindingFlags.CreateInstance, Nothing, Nothing, Nothing)
        End Function

        Public Shared Function ArchiveOptionConfig(ByVal path_ext As Logic.FileSystem.Extention) As ArchiveOptionConfig
            If path_ext Is Nothing OrElse ArchiveOptionType.FromExtention.ContainsKey(path_ext) = False Then Return Nothing
            Return ArchiveOptionConfig(ArchiveOptionType.FromExtention(path_ext))
        End Function

        Public Shared Function ArchiveOptionConfig(ByVal path_ext As String) As ArchiveOptionConfig
            Dim ext As String = Logic.FileSystem.GetPathExtention(path_ext)
            If String.IsNullOrWhiteSpace(ext) Then ext = path_ext
            Return ArchiveOptionConfig(New Logic.FileSystem.Extention(ext))
        End Function

        Public Shared Function Contains(ByVal path_ext As Logic.FileSystem.Extention) As Boolean
            Return ArchiveOptionType.FromExtention.ContainsKey(path_ext)
        End Function

        Public Shared Function Contains(ByVal path_ext As String) As Boolean
            Dim ext As String = Logic.FileSystem.GetPathExtention(path_ext)
            If String.IsNullOrWhiteSpace(ext) Then ext = path_ext
            Return ArchiveOptionType.FromExtention.ContainsKey(New Logic.FileSystem.Extention(ext))
        End Function

        Public Shared Function ExtentionNames() As Logic.FileSystem.Extention()
            Dim ret(ArchiveOptionType.FromExtention.Keys.Count - 1) As Logic.FileSystem.Extention
            ArchiveOptionType.FromExtention.Keys.CopyTo(ret, 0)
            Return ret
        End Function

        Public Sub NothingComplementDefault()
            For Each key As ENUM_ARCHIVETYPE In [Enum].GetValues(GetType(ENUM_ARCHIVETYPE))
#If DEBUG Then
                Debug.Assert(_Ext.ContainsKey(key))
#End If
                If _Ext(key) Is Nothing Then
                    _Ext.Item(key) = ArchiveOptionConfig(key)
                End If
            Next
        End Sub

        Private Class ArchiveOptionType
            Public Shared ReadOnly FromType As New Collections.Generic.SortedDictionary(Of ENUM_ARCHIVETYPE, Type) From {
                {ENUM_ARCHIVETYPE.ZIP, GetType(Archive.ZipOptionConfig)},
                {ENUM_ARCHIVETYPE.RAR, GetType(Archive.RarOptionConfig)}
            }
            Public Shared ReadOnly FromExtention As New Collections.Generic.SortedDictionary(Of Logic.FileSystem.Extention, ENUM_ARCHIVETYPE) From {
                {Archive.ZipOptionConfig.EXT, ENUM_ARCHIVETYPE.ZIP},
                {Archive.RarOptionConfig.EXT, ENUM_ARCHIVETYPE.RAR}
            }
        End Class

        Private _Ext As Collections.Generic.SortedList(Of ENUM_ARCHIVETYPE, ArchiveOptionConfig)

    End Class ' ArchiveOptionConfigCollection

End Class ' AppBase
