﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    <Serializable()> _
    Public MustInherit Class ArchiveOptionConfig
        Implements ICloneable

        Protected Shared Function ExtJoin(ByRef strExtentions() As String, ByRef strSign As String, ByRef strSep As String) As String
            If Not strExtentions Is Nothing AndAlso 0 < strExtentions.Length Then
                For idx As Integer = 0 To strExtentions.Length - 1
                    strExtentions(idx) = strSign & strExtentions(idx)
                Next
                Return String.Join(strSep, strExtentions)
            End If
            Return Nothing
        End Function

        Public Overridable Function CrcCheck(ByVal Path As String) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public MustOverride Function Extention() As Logic.FileSystem.Extention
        Public MustOverride Function TextInformation() As String
        Public MustOverride Function Clone() As Object Implements System.ICloneable.Clone
        Public MustOverride Function CreateProcess(Optional ByVal AppBase As AppBase = Nothing, Optional ByVal IsStopReq As Logic.Threading.SignalHandler = Nothing) As ArchiveProcess

    End Class

End Class

