﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive
        Partial Public Class Threading

            Public Class CrcCheckTask
                Implements IAppBase
                Implements Logic.Threading.TaskQueueingThread.ITask
                Public Property AppBase As AppBase Implements IAppBase.AppBase
                Public PathCollection() As String

                Public Sub New(ByVal AppBase As AppBase, ByVal PathCollection As Collections.ObjectModel.ReadOnlyCollection(Of String))
                    Me.AppBase = AppBase
                    ReDim Me.PathCollection(PathCollection.Count - 1)
                    PathCollection.CopyTo(Me.PathCollection, 0)
                End Sub

                Public Sub Task(ByVal SenderIsStopRequested As Logic.Threading.SignalHandler) Implements Logic.Threading.TaskQueueingThread.ITask.Task

                    If (AppBase Is Nothing Or PathCollection Is Nothing) OrElse PathCollection.Length <= 0 Then Return

                    AppBase.Echoing.TaskStartEcho("CrcCheck")

                    Dim ctAnyErr As UInt32 = 0
                    For idx As Integer = 0 To PathCollection.Length - 1

                        If String.IsNullOrWhiteSpace(PathCollection(idx)) Then Continue For
                        Dim EachPath As Logic.FileSystem.Path = PathCollection(idx)

                        AppBase.Echoing.Log.EchoProgressOutline(EachPath)

                        Dim ret As RESULT = RESULT.USER_CANCEL
                        If SenderIsStopRequested IsNot Nothing AndAlso SenderIsStopRequested() Then

                            ret = RESULT.USER_CANCEL

                        ElseIf EachPath.FileExists = False Then

                            ret = RESULT.NO_FILE

                        Else

                            ret = RESULT.INVALID_FILE_EXT

                            ' // get process object //
                            Dim ArchiveOption As ArchiveOptionConfig = AppBase.DefaultCompressSetting(EachPath.Extention)
                            If ArchiveOption IsNot Nothing Then
                                ' // crc check process //
                                Dim ArchiveProcess As ArchiveProcess = ArchiveOption.CreateProcess(AppBase, SenderIsStopRequested)
                                If ArchiveProcess IsNot Nothing Then ret = ArchiveProcess.CrcCheck(EachPath.ToString)
                            End If

                        End If

                        If ret <> RESULT.OK Then
                            AppBase.Echoing.Log.Echo(String.Format("{0} {1}", ResultMessage(ret), EachPath.ToString))
                            ctAnyErr += 1
                        End If

                        AppBase.Echoing.Progress.Echo(idx, PathCollection.Length - 1)

                    Next

                    If 0 < ctAnyErr Then
                        Dim msg As String = String.Format("crc check error ({0} files error)", ctAnyErr)
                        AppBase.Echoing.Log.Echo(msg)
                        MsgBox(msg)
                    Else
                        AppBase.Echoing.Log.Echo(String.Format("crc check complete ({0} files)", PathCollection.Length))
                        AppBase.Echoing.TaskCompletedEcho()
                    End If

                End Sub

            End Class

        End Class
    End Class
End Class

