﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class AppendLogArgs

        Public Enum LogType
            Log
            Status
            StatusDescription
            ConsoleOut
            ProgressOutline
        End Enum

        Public Class LogTypeDictionary(Of T)
            Inherits Logic.SerializableCollections.ProtectedSerializable(Of  _
                Logic.SerializableCollections.Dictionary(Of LogType, T))
            Default Public Property Item(ByVal key As LogType) As T
                Get
                    If Not Payload Is Nothing AndAlso Payload.ContainsKey(key) Then Return Payload(key)
                    Return Nothing
                End Get
                Set(ByVal value As T)
                    If Payload Is Nothing Then Payload = New Logic.SerializableCollections.Dictionary(Of LogType, T)
                    Payload(key) = value
                End Set
            End Property
        End Class

        Public Log As String
        Public t As LogType
        Public Class Echoes
            Inherits Logic.Echoes(Of AppendLogArgs)
            Public Shadows Sub Echo(ByVal log As String, Optional ByVal t As LogType = LogType.Log)
                Dim e As New AppendLogArgs
                e.Log = New String(log)
                e.t = t
                MyBase.Echo(e)
            End Sub
            Public Sub EchoProgressOutline(ByVal Path As Logic.FileSystem.Path)
                Echo(Path.Name.ToString, AppendLogArgs.LogType.ProgressOutline)
                Echo(Path.ToString, AppendLogArgs.LogType.Status)
            End Sub
        End Class
    End Class

End Class