﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Public Class ArchiveTaskOptionConfig

        Public Class LoadOptionConfig
            Public IsLocalCopy As Boolean = True
            Public IsCrcCheck As Boolean = True
            Public CopyRetryCount As Byte = 2
        End Class

        Public Class CreateOptionConfig
            Public Enum OverwriteMode
                NeverWrite
                ModifiedNewerThanCreatedWrite
                EverWrite
            End Enum
            Public Overwrite As OverwriteMode = OverwriteMode.ModifiedNewerThanCreatedWrite
            Public IsOriginalArcProtection As Boolean = True
            Public IsCreateDirectory As Boolean = True
            Public IsCrcCheck As Boolean = True
        End Class

        Public Class FilterOptionConfig
            Public HiddenFile As Boolean = True
            Public HiddenDirectory As Boolean = True
            Public DeleteMirroring As Boolean = True
        End Class

        Public Sub New()
            LoadOption = Nothing
            CreateOption = Nothing
            FilterOption = Nothing
        End Sub

        Private m_LoadingOption As LoadOptionConfig
        Public Property LoadOption As LoadOptionConfig
            Get
                Return m_LoadingOption
            End Get
            Set(ByVal value As LoadOptionConfig)
                If value Is Nothing Then value = New LoadOptionConfig
                m_LoadingOption = value
            End Set
        End Property

        Private m_MirrorCreation As CreateOptionConfig
        Public Property CreateOption As CreateOptionConfig
            Get
                Return m_MirrorCreation
            End Get
            Set(ByVal value As CreateOptionConfig)
                If value Is Nothing Then value = New CreateOptionConfig
                m_MirrorCreation = value
            End Set
        End Property

        Private m_Filtering As FilterOptionConfig
        Public Property FilterOption As FilterOptionConfig
            Get
                Return m_Filtering
            End Get
            Set(ByVal value As FilterOptionConfig)
                If value Is Nothing Then value = New FilterOptionConfig
                m_Filtering = value
            End Set
        End Property

    End Class

End Class