﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Configuration

        Public Class Exportable
            Inherits Logic.SerializableCollections.ProtectedSerializable(Of ExportableConfigurations)

            Public Class ExportableConfigurations

                Private m_ArchiveTaskConfig As New ArchiveTaskOptionConfig
                Public Property ArchiveTaskConfig As ArchiveTaskOptionConfig
                    Get
                        Return m_ArchiveTaskConfig
                    End Get
                    Set(ByVal value As ArchiveTaskOptionConfig)
                        If value Is Nothing Then value = New ArchiveTaskOptionConfig
                        m_ArchiveTaskConfig = value
                    End Set
                End Property

                Private m_ArchiveTaskPresets As New ArchiveTaskPreset.Collection
                Public Property ArchiveTaskPresets As ArchiveTaskPreset.Collection
                    Get
                        Return m_ArchiveTaskPresets
                    End Get
                    Set(ByVal value As ArchiveTaskPreset.Collection)
                        If value Is Nothing Then value = New ArchiveTaskPreset.Collection
                        m_ArchiveTaskPresets = value
                    End Set
                End Property

                Private m_DefaultCompressSetting As New ArchiveOptionConfigCollection
                Public Property DefaultCompressSetting As ArchiveOptionConfigCollection
                    Get
                        Return m_DefaultCompressSetting
                    End Get
                    Set(ByVal value As ArchiveOptionConfigCollection)
                        If value Is Nothing Then value = New ArchiveOptionConfigCollection
                        m_DefaultCompressSetting = value
                    End Set
                End Property

                Private m_EntryTaskPresets As New EntryTaskPreset.Collection
                Public Property EntryTaskPresets As EntryTaskPreset.Collection
                    Get
                        Return m_EntryTaskPresets
                    End Get
                    Set(ByVal value As EntryTaskPreset.Collection)
                        If value Is Nothing Then value = New EntryTaskPreset.Collection
                        m_EntryTaskPresets = value
                    End Set
                End Property

                Private m_ImagingOption As New ImagingOptionConfig
                Public Property ImagingOption As ImagingOptionConfig
                    Get
                        Return m_ImagingOption
                    End Get
                    Set(ByVal value As ImagingOptionConfig)
                        If value Is Nothing Then value = New ImagingOptionConfig
                        m_ImagingOption = value
                    End Set
                End Property

                Public IsDropFolderRecursiveLoad As Boolean = True

                Private m_LastExportedPath As Logic.FileSystem.Path = String.Empty
                Public Property LastExportedPath As Logic.FileSystem.Path
                    Get
                        Return m_LastExportedPath
                    End Get
                    Set(ByVal value As Logic.FileSystem.Path)
                        If value Is Nothing Then value = String.Empty
                        m_LastExportedPath = value.ToString
                    End Set
                End Property

                Private m_LastImportedPath As Logic.FileSystem.Path = String.Empty
                Public Property LastImportedPath As Logic.FileSystem.Path
                    Get
                        Return m_LastImportedPath
                    End Get
                    Set(ByVal value As Logic.FileSystem.Path)
                        If value Is Nothing Then value = String.Empty
                        m_LastImportedPath = value.ToString
                    End Set
                End Property

                Public Property RarPath As String
                    Get
                        Return AppBase.Archive.RarOptionConfig.RarPath
                    End Get
                    Set(ByVal value As String)
                        AppBase.Archive.RarOptionConfig.RarPath = value
                    End Set
                End Property

            End Class

            Public Sub New()
                Payload = New ExportableConfigurations
            End Sub

            ' public properties ////////////////////////////////////////////////////////////////////////////////////////////////

            Public ReadOnly Property ArchiveTaskConfig As ArchiveTaskOptionConfig
                Get
                    Return Payload.ArchiveTaskConfig
                End Get
            End Property

            Public ReadOnly Property ArchiveTaskPresets As ArchiveTaskPreset.Collection
                Get
                    Return Payload.ArchiveTaskPresets
                End Get
            End Property

            Public Property DefaultCompressSetting As ArchiveOptionConfigCollection
                Get
                    Return Payload.DefaultCompressSetting
                End Get
                Set(ByVal value As ArchiveOptionConfigCollection)
                    Payload.DefaultCompressSetting = value
                End Set
            End Property

            Public ReadOnly Property EntryTaskPresets As EntryTaskPreset.Collection
                Get
                    Return Payload.EntryTaskPresets
                End Get
            End Property

            Public ReadOnly Property ImagingOption As ImagingOptionConfig
                Get
                    Return Payload.ImagingOption
                End Get
            End Property

            Public Property IsDropFolderRecursiveLoad As Boolean
                Get
                    Return Payload.IsDropFolderRecursiveLoad
                End Get
                Set(ByVal value As Boolean)
                    Payload.IsDropFolderRecursiveLoad = value
                End Set
            End Property

            Public ReadOnly Property LastExportedPath As Logic.FileSystem.Path
                Get
                    Return Payload.LastExportedPath.ToString
                End Get
            End Property

            Public ReadOnly Property LastImportedPath As Logic.FileSystem.Path
                Get
                    Return Payload.LastImportedPath.ToString
                End Get
            End Property

            ' public methods ///////////////////////////////////////////////////////////////////////////////////////////////////
            Public Shadows Function ExportToXml(Optional ByVal Path As Logic.FileSystem.Path = Nothing) As Boolean

                If Path Is Nothing OrElse Path.IsNullOrWhiteSpace Then Path = Payload.LastExportedPath

                ExportToXml = False
                Try
                    MyBase.ExportToXml(Path)
                    Payload.LastExportedPath = Path.ToString
                    ExportToXml = True
                Catch ex As SerializeException
#If DEBUG Then
                    Throw
#End If
                Catch
                End Try

            End Function

            Public Shadows Function ImportFromXml(Optional ByVal Path As Logic.FileSystem.Path = Nothing) As Boolean

                If Path Is Nothing OrElse Path.IsNullOrWhiteSpace Then Path = Payload.LastImportedPath
                If Path.FileExists = False Then Return False

                ImportFromXml = False
                Try
                    MyBase.ImportFromXml(Path)
                    Payload.LastImportedPath = Path.ToString
                    ImportFromXml = True
                Catch ex As SerializeException
#If DEBUG Then
                    Throw
#End If
                Catch
                End Try
                If ImportFromXml = False And Payload Is Nothing Then Payload = New ExportableConfigurations

            End Function

        End Class

    End Class
End Class
