﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class ConfigArchiveTaskPanel
    Implements IAppBase
    Implements IReadOnly

    Public Sub New()
        InitializeComponent()
        MirrorOverwriteEverWrite.Tag = AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.EverWrite
        MirrorOverwriteModifiedNewerThanCreatedWrite.Tag = AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.ModifiedNewerThanCreatedWrite
        MirrorOverwriteNeverWrite.Tag = AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.NeverWrite
    End Sub

    ' public properties //////////////////////////////////////////////////////////////////////////////

    Private m_AppBase As AppBase
    Public Property AppBase As AppBase Implements IAppBase.AppBase
        Get
            Return m_AppBase
        End Get
        Set(ByVal value As AppBase)

            m_AppBase = value

            If IsDisposed Or Disposing Then Return

            If value Is Nothing Then

                IsLocalCopy.Checked = False
                IsCrcCheck.Checked = False
                CtCopyRetry.Value = CtCopyRetry.Minimum
                GenArcSafe.Checked = False
                GenArcSpeed.Checked = False

                RenamePolicyIsCreateDirectory.Checked = False
                IsOriginalArcProtection.Checked = False
                MirrorOverwriteEverWrite.Checked = False
                MirrorOverwriteModifiedNewerThanCreatedWrite.Checked = False
                MirrorOverwriteNeverWrite.Checked = False
                IsFilterHiddenFile.Checked = False
                IsFilterHiddenDirectory.Checked = False
                IsFilteredMirrorDelete.Checked = False

                Return

            End If

            Dim Config As AppBase.ArchiveTaskOptionConfig = value.ArchiveTaskConfig

            IsLocalCopy.Checked = Config.LoadOption.IsLocalCopy
            IsCrcCheck.Checked = Config.LoadOption.IsCrcCheck
            CtCopyRetry.Value = Config.LoadOption.CopyRetryCount
            If Config.CreateOption.IsCrcCheck Then
                GenArcSafe.Checked = True
            Else
                GenArcSpeed.Checked = True
            End If

            RenamePolicyIsCreateDirectory.Checked = Config.CreateOption.IsCreateDirectory
            IsOriginalArcProtection.Checked = Config.CreateOption.IsOriginalArcProtection

            Select Case Config.CreateOption.Overwrite
                Case AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.EverWrite
                    MirrorOverwriteEverWrite.Checked = True
                Case AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.ModifiedNewerThanCreatedWrite
                    MirrorOverwriteModifiedNewerThanCreatedWrite.Checked = True
                Case AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode.NeverWrite
                    MirrorOverwriteNeverWrite.Checked = True
            End Select

            IsFilterHiddenFile.Checked = Config.FilterOption.HiddenFile
            IsFilterHiddenDirectory.Checked = Config.FilterOption.HiddenDirectory
            IsFilteredMirrorDelete.Checked = Config.FilterOption.DeleteMirroring

        End Set
    End Property

    Private m_ReadOnly As Boolean = False
    <System.ComponentModel.DefaultValue(False)> _
    Public Property [ReadOnly] As Boolean Implements IReadOnly.ReadOnly
        Get
            Return m_ReadOnly
        End Get
        Set(ByVal value As Boolean)

            m_ReadOnly = value

            IsLocalCopy.Enabled = Not m_ReadOnly
            IsCrcCheck.Enabled = Not m_ReadOnly
            CtCopyRetry.ReadOnly = m_ReadOnly
            GenArcSafe.Enabled = Not m_ReadOnly
            GenArcSpeed.Enabled = Not m_ReadOnly

            OverwriteConfigPanel.Enabled = m_ReadOnly

            IsFilterHiddenFile.Enabled = m_ReadOnly
            IsFilterHiddenDirectory.Enabled = m_ReadOnly
            IsFilteredMirrorDelete.Enabled = m_ReadOnly

        End Set
    End Property

    ' private implements ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private ReadOnly InsertContext As New CustomContextMenu.InsertTextInRenamePolicyContextMenu

    Protected Overrides Sub OnVisibleChanged(ByVal e As System.EventArgs)
        MyBase.OnVisibleChanged(e)
        If Visible = False Then AppBase = Nothing
    End Sub

    Private Sub IsLocalCopy_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsLocalCopy.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.LoadOption.IsLocalCopy = IsLocalCopy.Checked
    End Sub

    Private Sub IsCrcCheck_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsCrcCheck.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.LoadOption.IsCrcCheck = IsCrcCheck.Checked
    End Sub

    Private Sub CtCopyRetry_ValueValidated(ByVal sender As Object, ByVal e As System.EventArgs) Handles CtCopyRetry.ValueValidated
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.LoadOption.CopyRetryCount = CtCopyRetry.Value
    End Sub

    Private Sub rdGenArcSpeed_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GenArcSpeed.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.CreateOption.IsCrcCheck = Not GenArcSpeed.Checked
    End Sub

    Private Sub RenamePolicyIsCreateDirectory_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RenamePolicyIsCreateDirectory.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.CreateOption.IsCreateDirectory = RenamePolicyIsCreateDirectory.Checked
    End Sub

    Private Sub IsOriginalArcProtection_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsOriginalArcProtection.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.CreateOption.IsOriginalArcProtection = IsOriginalArcProtection.Checked
    End Sub

    Private Sub MirrorOverwrite_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MirrorOverwriteEverWrite.CheckedChanged,
                                                        MirrorOverwriteModifiedNewerThanCreatedWrite.CheckedChanged, MirrorOverwriteNeverWrite.CheckedChanged
        Dim Control As RadioButton = TryCast(sender, RadioButton)
        If AppBase Is Nothing OrElse Control Is Nothing OrElse Control.Checked = False Then Return
        If TypeOf Control.Tag Is AppBase.ArchiveTaskOptionConfig.CreateOptionConfig.OverwriteMode Then
            AppBase.ArchiveTaskConfig.CreateOption.Overwrite = Control.Tag
        End If
    End Sub

    Private Sub IsFilterHiddenFile_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsFilterHiddenFile.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.FilterOption.HiddenFile = IsFilterHiddenFile.Checked
    End Sub

    Private Sub IsFilterHiddenDirectory_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsFilterHiddenDirectory.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.FilterOption.HiddenDirectory = IsFilterHiddenDirectory.Checked
    End Sub

    Private Sub IsFilteredMirrorDelete_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsFilteredMirrorDelete.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ArchiveTaskConfig.FilterOption.DeleteMirroring = IsFilteredMirrorDelete.Checked
    End Sub

End Class
