﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class ConfigImagingPanel
    Implements IAppBase
    Implements IReadOnly

    Public Sub New()
        InitializeComponent()
        PermitPercent.Minimum = AppBase.ImagingOptionConfig.PermitPercentMin
        PermitPercent.Maximum = AppBase.ImagingOptionConfig.PermitPercentMax
    End Sub

    ' public peoprties ///////////////////////////////////////////////////////////////////////////////////////////////////

    Private m_AppBase As AppBase
    Public Property AppBase As AppBase Implements IAppBase.AppBase
        Get
            Return m_AppBase
        End Get
        Set(ByVal value As AppBase)
            m_AppBase = Nothing ' change apply mode = off
            If IsDisposed = False And Disposing = False Then
                If value Is Nothing Then
                    SamplingCount.Value = SamplingCount.Minimum
                    PermitPercent.Value = PermitPercent.Minimum
                    IsPermitWideOnNarrow.Checked = False
                    IsDisplayProgress.Checked = False
                Else
                    SamplingCount.Value = value.ImagingConfig.SamplingCount
                    PermitPercent.Value = value.ImagingConfig.PermitPercent
                    IsPermitWideOnNarrow.Checked = value.ImagingConfig.IsPermitWideOnNarrow
                    IsDisplayProgress.Checked = value.ImagingConfig.IsDisplayProgress
                End If
            End If
            m_AppBase = value
        End Set
    End Property

    Private m_ReadOnly As Boolean = False
    <System.ComponentModel.DefaultValue(False)> _
    Public Property [ReadOnly] As Boolean Implements IReadOnly.ReadOnly
        Get
            Return m_ReadOnly
        End Get
        Set(ByVal value As Boolean)
            m_ReadOnly = value
            SamplingCount.ReadOnly = m_ReadOnly
            PermitPercent.ReadOnly = m_ReadOnly
            IsPermitWideOnNarrow.Enabled = Not m_ReadOnly
            IsDisplayProgress.Enabled = Not m_ReadOnly
        End Set
    End Property

    ' private implements ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Protected Overrides Sub OnVisibleChanged(ByVal e As System.EventArgs)
        MyBase.OnVisibleChanged(e)
        If Visible = False Then AppBase = Nothing
    End Sub

    Private Sub SamplingCount_ValueValidated(ByVal sender As Object, ByVal e As System.EventArgs) Handles SamplingCount.ValueValidated
        If AppBase Is Nothing Then Return
        AppBase.ImagingConfig.SamplingCount = SamplingCount.Value
    End Sub

    Private Sub PermitPercent_ValueValidated(ByVal sender As Object, ByVal e As System.EventArgs) Handles PermitPercent.ValueValidated
        If AppBase Is Nothing Then Return
        AppBase.ImagingConfig.PermitPercent = PermitPercent.Value
    End Sub

    Private Sub IsPermitWideOnNarrow_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsPermitWideOnNarrow.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ImagingConfig.IsPermitWideOnNarrow = IsPermitWideOnNarrow.Checked
    End Sub

    Private Sub IsDisplayProgress_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsDisplayProgress.CheckedChanged
        If AppBase Is Nothing Then Return
        AppBase.ImagingConfig.IsDisplayProgress = IsDisplayProgress.Checked
    End Sub
End Class
