﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class PresetArchiveTaskPanelControl
    Implements IAppBase
    Implements IReadOnly

    ' public properties //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Public Property AppBase As AppBase Implements IAppBase.AppBase

    Private m_ReadOnly As Boolean = False
    <System.ComponentModel.DefaultValue(False)> _
    Public Property [ReadOnly] As Boolean Implements IReadOnly.ReadOnly
        Get
            Return m_ReadOnly
        End Get
        Set(ByVal value As Boolean)
            m_ReadOnly = value
            ScanCmdInsertContextButton.Enabled = Not m_ReadOnly
            ScanCmd.ReadOnly = m_ReadOnly
            IsExtract.Enabled = Not m_ReadOnly
            UserCmdInsertContextButton.Enabled = Not m_ReadOnly
            UserCmd.ReadOnly = m_ReadOnly
            IsCompress.Enabled = Not m_ReadOnly
            CompressSettingClr.Enabled = Not m_ReadOnly
            CompressSettingButton.Enabled = Not m_ReadOnly
            RenamePolicyText.ReadOnly = m_ReadOnly
            RenamePolicyInsWord.Enabled = m_ReadOnly
            IsFilteredDelete.Enabled = m_ReadOnly
        End Set
    End Property

    Private m_CurrentPreset As AppBase.ArchiveTaskPreset
    Public Property CurrentPreset As AppBase.ArchiveTaskPreset
        Get
            Return m_CurrentPreset
        End Get
        Set(ByVal value As AppBase.ArchiveTaskPreset)

            CompressSettingClr.Enabled = False
            CompressSetting.Text = Nothing

            m_CurrentPreset = value

            If value Is Nothing Then
                IsExtZip.Checked = False
                IsExtRar.Checked = False
                UserCmd.Text = Nothing
                ScanCmd.Text = Nothing
                IsExtract.Checked = False
                IsCompress.Checked = False
                RenamePolicyText.Text = Nothing
                IsFilteredDelete.Checked = False
                If AppBase IsNot Nothing AndAlso AppBase.DefaultCompressSetting.SelectedExt IsNot Nothing Then
                    CompressSetting.Text = "デフォルト設定 " & AppBase.DefaultCompressSetting.SelectedExt.TextInformation
                End If
                Return
            End If

            IsExtZip.Checked = CurrentPreset.ArchiveExtentionList.Contains("zip")
            IsExtRar.Checked = CurrentPreset.ArchiveExtentionList.Contains("rar")
            UserCmd.Text = CurrentPreset.UserCmd
            ScanCmd.Text = CurrentPreset.ScanCmd
            IsExtract.Checked = CurrentPreset.IsExtract
            IsCompress.Checked = CurrentPreset.IsCompress
            RenamePolicyText.Text = CurrentPreset.RenamePolicy
            IsFilteredDelete.Checked = CurrentPreset.IsFilteredDelete

            ' set CompressSetting.Text ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            If CurrentPreset.CompressSetting IsNot Nothing AndAlso CurrentPreset.CompressSetting.SelectedExt IsNot Nothing Then
                CompressSettingClr.Enabled = True
                CompressSetting.Text = CurrentPreset.CompressSetting.SelectedExt.TextInformation
            ElseIf AppBase IsNot Nothing AndAlso AppBase.DefaultCompressSetting.SelectedExt IsNot Nothing Then
                CompressSetting.Text = "デフォルト設定 " & AppBase.DefaultCompressSetting.SelectedExt.TextInformation
            End If

        End Set
    End Property

    ' private implements /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private ReadOnly InsertScanCmdContext As New CustomContextMenu.InsertTextInScanCmdContextMenu
    Private ReadOnly InsertCmdContext As New CustomContextMenu.InsertTextInCmdContextMenu
    Private ReadOnly InsertRenContext As New CustomContextMenu.InsertTextInRenamePolicyContextMenu
    Private ReadOnly SplitterMovedHandler As New Logic.UniqueEvents(Of SplitterEventArgs)

    Protected Overrides Sub OnVisibleChanged(ByVal e As System.EventArgs)
        MyBase.OnVisibleChanged(e)
        If Visible Then
            If AppBase IsNot Nothing AndAlso (ParentForm.WindowState = FormWindowState.Normal Or ParentForm.WindowState = FormWindowState.Maximized) Then
                If 0 < AppBase.Config.WindowSize(Me.ParentForm.WindowState).ArchiveTaskPresetSplitDistance Then
                    Split.SplitterDistance = AppBase.Config.WindowSize(Me.ParentForm.WindowState).ArchiveTaskPresetSplitDistance
                End If
            End If
        Else
            CurrentPreset = Nothing
            SizeEventEnable = False
        End If
    End Sub

    Private m_SizeEventEnable As Boolean = False
    Public Property SizeEventEnable As Boolean
        Get
            SizeEventEnable = m_SizeEventEnable
        End Get
        Set(ByVal value As Boolean)
            If value Then
                If m_SizeEventEnable = False Then
                    m_SizeEventEnable = True
                    If AppBase IsNot Nothing AndAlso (ParentForm.WindowState = FormWindowState.Normal Or ParentForm.WindowState = FormWindowState.Maximized) Then
                        If 0 < AppBase.Config.WindowSize(Me.ParentForm.WindowState).ArchiveTaskPresetSplitDistance Then
                            Split.SplitterDistance = AppBase.Config.WindowSize(Me.ParentForm.WindowState).ArchiveTaskPresetSplitDistance
                        End If
                    End If
                    SplitterMovedHandler.Add(New EventHandler(Of Windows.Forms.SplitterEventArgs)(AddressOf Split_SplitterMovedImpl))
                End If
            Else
                m_SizeEventEnable = False
                SplitterMovedHandler.Clear()
            End If
        End Set
    End Property

    Private Sub Split_SplitterMovedImpl(ByVal sender As System.Object, ByVal e As System.Windows.Forms.SplitterEventArgs)
        If AppBase IsNot Nothing And (ParentForm.WindowState = FormWindowState.Normal Or ParentForm.WindowState = FormWindowState.Maximized) Then
            AppBase.Config.WindowSize(ParentForm.WindowState).ArchiveTaskPresetSplitDistance = Split.SplitterDistance
        End If
    End Sub

    Private Sub Split_SplitterMoved(ByVal sender As System.Object, ByVal e As System.Windows.Forms.SplitterEventArgs) Handles Split.SplitterMoved
        SplitterMovedHandler.Invoke(sender, e)
    End Sub

    Private Sub PresetArchiveTaskPanelControl_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        SplitterMovedHandler.Clear()
    End Sub

    Private Sub IsExtract_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsExtract.CheckedChanged
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.IsExtract = IsExtract.Checked
    End Sub

    Private Sub IsCompress_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsCompress.CheckedChanged
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.IsCompress = IsCompress.Checked
    End Sub

    Private Sub ScanCmd_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles ScanCmd.Validated
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.ScanCmd = ScanCmd.Text
    End Sub

    Private Sub UserCmd_Validated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UserCmd.Validated
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.UserCmd = UserCmd.Text
    End Sub

    Private Sub CompressSettingClr_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompressSettingClr.Click
        CurrentPreset.CompressSetting = Nothing
        CompressSettingClr.Enabled = False
        CompressSetting.Text = Nothing
        If AppBase IsNot Nothing Then CompressSetting.Text = "デフォルト設定 " & AppBase.DefaultCompressSetting.SelectedExt.TextInformation
    End Sub

    Private Sub CompressSettingButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompressSettingButton.Click
        If CurrentPreset Is Nothing Then Return
        Dim dlg As New ExtConfigDialog
        dlg.Text = "Compress Settings"
        dlg.CompressSetting = New AppBase.ArchiveOptionConfigCollection(IIf(CurrentPreset.CompressSetting Is Nothing, AppBase.DefaultCompressSetting, CurrentPreset.CompressSetting))
        If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
            CurrentPreset.CompressSetting = dlg.CompressSetting
            CompressSettingClr.Enabled = True
            CompressSetting.Text = CurrentPreset.CompressSetting.SelectedExt.TextInformation
        End If
    End Sub

    Private Sub ScanCmdInsertContextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ScanCmdInsertContextButton.Click
        InsertScanCmdContext.Show(ScanCmdInsertContextButton, ScanCmd, AddressOf ScanCmd_Validated)
    End Sub

    Private Sub UserCmdInsertContextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UserCmdInsertContextButton.Click
        InsertCmdContext.Show(UserCmdInsertContextButton, UserCmd, AddressOf UserCmd_Validated)
    End Sub

    Private Sub IsExt_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsExtZip.CheckedChanged, IsExtRar.CheckedChanged
        Dim Checker As Windows.Forms.CheckBox = TryCast(sender, Windows.Forms.CheckBox)
        If CurrentPreset IsNot Nothing And Checker IsNot Nothing AndAlso Checker.Tag IsNot Nothing Then
            If sender.checked Then
                CurrentPreset.ArchiveExtentionList.Add(Checker.Tag.ToString)
            Else
                CurrentPreset.ArchiveExtentionList.Remove(Checker.Tag.ToString)
            End If
        End If
    End Sub

    Private Sub RenamePolicyText_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles RenamePolicyText.Validated
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.RenamePolicy = RenamePolicyText.Text
    End Sub

    Private Sub RenamePolicyInsWord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RenamePolicyInsWord.Click
        InsertRenContext.Show(RenamePolicyInsWord, RenamePolicyText, AddressOf RenamePolicyText_Validated)
    End Sub

    Private Sub IsFilterDelete_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsFilteredDelete.CheckedChanged
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.IsFilteredDelete = IsFilteredDelete.Checked
    End Sub
End Class
