﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class PresetEntryTaskPanelControl
    Implements IAppBase
    Implements IReadOnly

    ' public properties //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Public Property AppBase As AppBase Implements IAppBase.AppBase

    Private m_ReadOnly As Boolean = False
    <System.ComponentModel.DefaultValue(False)> _
    Public Property [ReadOnly] As Boolean Implements IReadOnly.ReadOnly
        Get
            Return m_ReadOnly
        End Get
        Set(ByVal value As Boolean)
            m_ReadOnly = value
            EntryCmdPositiveExtFilter.ReadOnly = m_ReadOnly
            EntryCmdNegativeExtFilter.ReadOnly = m_ReadOnly
            IsMultiSelect.Enabled = Not m_ReadOnly
            IsPipeToStdIn.Enabled = Not m_ReadOnly
            EntryCmdInsertContextButton.Enabled = Not m_ReadOnly
            EntryCmd.ReadOnly = m_ReadOnly
        End Set
    End Property

    Private m_CurrentPreset As AppBase.EntryTaskPreset
    Public Property CurrentPreset As AppBase.EntryTaskPreset
        Get
            Return m_CurrentPreset
        End Get
        Set(ByVal value As AppBase.EntryTaskPreset)

            m_CurrentPreset = Nothing
            If value Is Nothing Then Return

            EntryCmdPositiveExtFilter.Text = Nothing
            If value.PositiveExtentionList IsNot Nothing Then EntryCmdPositiveExtFilter.Text = value.PositiveExtentionList.ToString

            EntryCmdNegativeExtFilter.Text = Nothing
            If value.NegativeExtentionList IsNot Nothing Then EntryCmdNegativeExtFilter.Text = value.NegativeExtentionList.ToString

            IsMultiSelect.Checked = value.IsMultiSelect
            IsPipeToStdIn.Checked = value.IsPipeToStdIn
            CheckedChanged(Nothing, Nothing)

            EntryCmd.Text = value.EntryTaskCommand

            m_CurrentPreset = value

        End Set
    End Property

    ' private implements /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private ReadOnly InsertContext As New CustomContextMenu.InsertTextInEntryCmdContextMenu

    Protected Overrides Sub OnVisibleChanged(ByVal e As System.EventArgs)
        MyBase.OnVisibleChanged(e)
        If Not (Visible And ParentForm IsNot Nothing) Then CurrentPreset = Nothing
    End Sub

    Private Sub EntryCmdInsertContextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles EntryCmdInsertContextButton.Click
        InsertContext.Show(EntryCmdInsertContextButton, EntryCmd, AddressOf EntryCmd_Validated)
    End Sub

    Private Sub CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IsMultiSelect.CheckedChanged, IsPipeToStdIn.CheckedChanged
        If IsPipeToStdIn.Checked = False Then
            PipeItem.Text = "なし"
        Else
            PipeItem.Text = IIf(IsMultiSelect.Checked, "エントリーパスリスト(改行区切り)", "展開されたエントリー")
        End If
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.IsMultiSelect = IsMultiSelect.Checked
        CurrentPreset.IsPipeToStdIn = IsPipeToStdIn.Checked
    End Sub

    Private Sub EntryCmd_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles EntryCmd.Validated
        EntryCmd.Text = EntryCmd.Text.Replace(vbCrLf, " ")
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.EntryTaskCommand = EntryCmd.Text
    End Sub

    Private Sub EntryCmdPositiveExtFilter_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles EntryCmdPositiveExtFilter.Validated
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.PositiveExtentionList = EntryCmdPositiveExtFilter.Text
        EntryCmdPositiveExtFilter.Text = CurrentPreset.PositiveExtentionList.ToString
    End Sub

    Private Sub EntryCmdNegativeExtFilter_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles EntryCmdNegativeExtFilter.Validated
        If CurrentPreset Is Nothing Then Return
        CurrentPreset.NegativeExtentionList = EntryCmdNegativeExtFilter.Text
        EntryCmdNegativeExtFilter.Text = CurrentPreset.NegativeExtentionList.ToString
    End Sub

End Class
