﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class DataGridViewUtility

        Public Shared Sub ScrollTo(ByVal Column As DataGridViewColumn)

            If Column Is Nothing OrElse (Column.Index < 0 Or Column.Frozen) Then Return

            Dim View As System.Windows.Forms.DataGridView = Column.DataGridView
            If View Is Nothing OrElse View.FirstDisplayedScrollingColumnIndex < 0 Then Return

            While View.GetColumnDisplayRectangle(Column.Index, True).Width < Column.Width
                Dim FirstDisplayedColumn As DataGridViewColumn = View.Columns(View.FirstDisplayedScrollingColumnIndex)
                If Column.DisplayIndex = FirstDisplayedColumn.DisplayIndex Then
                    Exit While
                ElseIf Column.DisplayIndex < FirstDisplayedColumn.DisplayIndex Then
                    ' left scroll
                    View.FirstDisplayedScrollingColumnIndex = Column.Index
                    Exit While
                Else
                    ' right scroll
                    Dim NextCol As DataGridViewColumn = View.Columns.GetNextColumn(FirstDisplayedColumn,
                        DataGridViewElementStates.Visible, DataGridViewElementStates.Frozen)
                    If NextCol Is Nothing Then Exit While
                    View.FirstDisplayedScrollingColumnIndex = NextCol.Index
                End If
            End While

        End Sub

        Public Shared Sub ScrollTo(ByVal Row As DataGridViewRow)

            If Row Is Nothing OrElse (Row.Index < 0 Or Row.Frozen) Then Return

            Dim View As System.Windows.Forms.DataGridView = Row.DataGridView
            If View Is Nothing OrElse View.FirstDisplayedScrollingRowIndex < 0 Then Return

            While View.GetRowDisplayRectangle(Row.Index, True).Height < Row.Height
                Dim FirstDisplayedRow As DataGridViewRow = View.Rows(View.FirstDisplayedScrollingRowIndex)
                If Row.Index = FirstDisplayedRow.Index Then
                    Exit While
                ElseIf Row.Index < FirstDisplayedRow.Index Then
                    ' left scroll
                    View.FirstDisplayedScrollingRowIndex = Row.Index
                    Exit While
                Else
                    ' right scroll
                    Dim NextRowIndex As Integer = View.Rows.GetNextRow(FirstDisplayedRow.Index,
                        DataGridViewElementStates.Visible, DataGridViewElementStates.Frozen)
                    If NextRowIndex < 0 Then Exit While
                    View.FirstDisplayedScrollingRowIndex = NextRowIndex
                End If
            End While

        End Sub

        Public Shared Sub ScrollTo(ByVal Cell As DataGridViewCell)
            If Cell Is Nothing OrElse (Cell.ColumnIndex < 0 Or Cell.RowIndex < 0 Or Cell.Frozen = True) Then Return
            ScrollTo(Cell.OwningColumn)
            ScrollTo(Cell.OwningRow)
        End Sub

        Public Shared Function IsPositionOnHeader(ByVal Src As System.Windows.Forms.DataGridView, ByVal DisplayPosition As Point) As Boolean
            If Not Src Is Nothing AndAlso Src.Parent.RectangleToScreen(Src.Bounds).Contains(DisplayPosition) Then
                Dim TopLeftCell As DataGridViewCell = Src.FirstDisplayedCell
                If Not TopLeftCell Is Nothing AndAlso (0 <= TopLeftCell.ColumnIndex And 0 <= TopLeftCell.RowIndex) Then
                    Dim rcTopLeftCell As Rectangle = Src.Parent.RectangleToScreen(Src.GetCellDisplayRectangle(TopLeftCell.ColumnIndex, TopLeftCell.RowIndex, True))
                    Return Not (rcTopLeftCell.X <= DisplayPosition.X And rcTopLeftCell.Y <= DisplayPosition.Y)
                End If
            End If
            Return False
        End Function

    End Class
End Class
