﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Private Class SystemIconLoader
            Implements System.Collections.IEnumerable
            Private Shared ReadOnly instance As New SystemIconLoader
            Public Shared Function SingletonInstance() As SystemIconLoader
                Return instance
            End Function

            Private ary As System.Collections.Generic.SortedDictionary(Of FileSystem.Extention, Drawing.Bitmap)
            Protected Sub New()
                ary = New System.Collections.Generic.SortedDictionary(Of FileSystem.Extention, Drawing.Bitmap) From
                {{String.Empty, Shell.GetIconImageFromDLL(Nothing, 4, True).ToBitmap}}
            End Sub

            Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
                Return ary.GetEnumerator()
            End Function

            Default Public ReadOnly Property Item(ByVal ext As String) As Drawing.Bitmap
                Get
                    If Not ext Is Nothing Then ext = ext.Trim
                    Dim e As Extention = FileSystem.Path.GetExtention(ext)
                    If ary.ContainsKey(e) = False Then ary.Add(e, Shell.ExtractAssociatedIcon("." & e.ToString, 0, True, True))
                    Return ary(e)
                End Get
            End Property

        End Class ' Icon

    End Class
End Class

