﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class Graphics

        Public Shared GDIPlusExtentions As New System.Collections.ObjectModel.ReadOnlyCollection(Of String)(New String() _
            {"bmp", "gif", "jpg", "jpeg", "png", "tif", "tiff"})

        Public Class StreamedImage
            Implements IDisposable

            Private m_buf As IO.Stream
            Private m_img As Drawing.Image

            Public Sub New(Optional ByVal buf As IO.Stream = Nothing)
                Try
                    m_buf = buf
                    m_img = Nothing
                    If buf IsNot Nothing Then m_img = Drawing.Image.FromStream(buf)
                Catch ex As Exception
                    m_buf = Nothing
                    m_img = Nothing
#If DEBUG Then
                    Throw
#End If
                End Try
            End Sub

            Public Shared Function TryInstance(ByVal buf As IO.Stream) As StreamedImage
                TryInstance = Nothing
                Try
                    If buf IsNot Nothing Then TryInstance = New StreamedImage(buf)
                Catch ex As Exception
                    TryInstance = Nothing
#If DEBUG Then
                    Throw
#End If
                End Try
            End Function

            Public ReadOnly Property Image As Drawing.Image
                Get
                    Return m_img
                End Get
            End Property

#Region "IDisposable Support"
            Private disposedValue As Boolean ' 重複する呼び出しを検出するには

            ' IDisposable
            Protected Overridable Sub Dispose(ByVal disposing As Boolean)
                If Not Me.disposedValue Then
                    If disposing Then
                        ' TODO: マネージ状態を破棄します (マネージ オブジェクト)。
                    End If

                    ' TODO: アンマネージ リソース (アンマネージ オブジェクト) を解放し、下の Finalize() をオーバーライドします。
                    ' TODO: 大きなフィールドを null に設定します。
                    If Not m_img Is Nothing Then
                        m_img.Dispose()
                        m_img = Nothing
                    End If

                    If Not m_buf Is Nothing Then
                        m_buf.Close()
                        m_buf = Nothing
                    End If

                End If
                Me.disposedValue = True
            End Sub

            ' TODO: 上の Dispose(ByVal disposing As Boolean) にアンマネージ リソースを解放するコードがある場合にのみ、Finalize() をオーバーライドします。
            Protected Overrides Sub Finalize()
                ' このコードを変更しないでください。クリーンアップ コードを上の Dispose(ByVal disposing As Boolean) に記述します。
                Dispose(False)
                MyBase.Finalize()
            End Sub

            ' このコードは、破棄可能なパターンを正しく実装できるように Visual Basic によって追加されました。
            Public Sub Dispose() Implements IDisposable.Dispose
                ' このコードを変更しないでください。クリーンアップ コードを上の Dispose(ByVal disposing As Boolean) に記述します。
                Dispose(True)
                GC.SuppressFinalize(Me)
            End Sub
#End Region

        End Class

    End Class ' AppBase.Graphics
End Class ' AppBase