﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class Logic

    Public Interface INamed
        Property Name As String
    End Interface

    Public Shared Sub CopyTo(ByVal Dest() As String, ByVal Src As System.Collections.IEnumerable)
        Dim idx As Integer = 0
        For Each item As Object In Src
            Dest(idx) = item.ToString
            idx += 1
        Next
    End Sub

    ' Location of some.exe/dll which has written Logic
    Public Shared ReadOnly ExecutingLocation As New Logic.LocalLocation(Reflection.Assembly.GetExecutingAssembly, , False)

    Public Shared Function GetAttributes(Of TAttr As Attribute)(ByVal Assembly As System.Reflection.Assembly) As System.Collections.Generic.List(Of TAttr)
        GetAttributes = New System.Collections.Generic.List(Of TAttr)
        If Assembly IsNot Nothing Then
            Dim Attributes() As Object = Assembly.GetCustomAttributes(True)
            For Each EachObj As Object In Attributes
                Dim Attr As TAttr = TryCast(EachObj, TAttr)
                If Attr IsNot Nothing Then GetAttributes.Add(Attr)
            Next
        End If
    End Function

End Class
