------------------------------------------------------------------------------
--  Copyright (C) 2011, Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------
-- Entity:      upycc
-- File:        upycc.vhd
-- Author:      Kenichi Kurimoto 
-- Description: upsample + YCbCr-RGB translation
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library grlib;
use grlib.amba.all;
use grlib.stdlib.all;
use grlib.devices.all;

library techmap;
use techmap.gencomp.all;

library kuri;
use kuri.mjpeg.all;

entity upycc is
   generic (
      memtech : integer := DEFMEMTECH;
--      fifo_depth : integer := 32;
      shindex : integer := 0;
      haddr  : integer := 0;
      hmask  : integer := 16#fff#;
      hirq   : integer := 0;      
      pindex : integer := 0;
      paddr  : integer := 0;
      pmask  : integer := 16#fff#;
      mhindex : integer := 0;
      chprot : integer := 3);      

   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      ahbmi : in ahb_mst_in_type;
      ahbmo : out ahb_mst_out_type;
      ahbsi : in ahb_slv_in_type;
      ahbso : out ahb_slv_out_type;
      apbi  : in apb_slv_in_type;
      apbo  : out apb_slv_out_type
   );
end;

architecture rtl of upycc is

signal kready1, kready2, kstrobe1, kstrobe2 : std_logic;
signal kdata1 : std_logic_vector(7 downto 0);
signal kdata2 : std_logic_vector(23 downto 0);
signal samp_fact, error : std_logic;
signal xmcumax : std_logic_vector(5 downto 0);
signal ymcumax : std_logic_vector(4 downto 0);
signal incaddy : std_logic_vector(15 downto 0);
signal incaddmcux : std_logic_vector(15 downto 0);
signal incaddmcuy : std_logic_vector(10 downto 0);
signal fbstartadd : std_logic_vector(31 downto 0);
signal startgen : std_logic;

begin
   amif : yccambaif 
   generic map(memtech => memtech,shindex => shindex , haddr => haddr, hmask => hmask,
               hirq => hirq, pindex => pindex, paddr => paddr, pmask => pmask)
   port map(rst => rst, clk => clk, ahbsi => ahbsi, ahbso => ahbso, apbi => apbi, apbo => apbo,
             kready => kready1, kstrobe => kstrobe1, kdata => kdata1, samp_fact => samp_fact, 
             error => error, xmcumax => xmcumax, ymcumax => ymcumax, incaddy => incaddy,
             incaddmcux => incaddmcux, incaddmcuy => incaddmcuy, fbstartadd => fbstartadd,
             startgen => startgen);
   
   yccmem : yccmemcont
   generic map(memtech => memtech)
   port map(rst => rst, clk => clk, kready1 => kready1, kstrobe1 => kstrobe1, kdata1 => kdata1,
            kready2 => kready2, kstrobe2 => kstrobe2, kdata2 => kdata2, samp_fact => samp_fact,
            error => error);
   
   ycb : yccrgb
   generic map(memtech => memtech, hirq => hirq, mhindex => mhindex,
               chprot => chprot)
   port map(rst => rst, clk => clk, ahbmi => ahbmi, ahbmo => ahbmo, kready => kready2,
            kstrobe => kstrobe2, kdata => kdata2, xmcumax => xmcumax, ymcumax => ymcumax,
            incaddy => incaddy, incaddmcux => incaddmcux, incaddmcuy => incaddmcuy,
            fbstartadd => fbstartadd, startgen => startgen);
   
end;
   
