----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:50 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_acf
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_acf.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_acf.v,v $
-- Revision 1.10  2005/04/08 13:03:07  igorm
-- In "Extended mode" when dual filter was used and standard frame received,
-- upper nibble of the data was not filtered ok.
--
-- Revision 1.9  2004/05/31 14:46:11  igorm
-- Bit acceptance_filter_mode was inverted.
--
-- Revision 1.8  2004/02/08 14:16:44  mohor
-- Header changed.
--
-- Revision 1.7  2003/07/16 13:41:34  mohor
-- Fixed according to the linter.
--
-- Revision 1.6  2003/02/10 16:02:11  mohor
-- CAN is working according to the specification. WB interface and more
-- registers (status, IRQ, ...) needs to be added.
--
-- Revision 1.5  2003/02/09 18:40:29  mohor
-- Overload fixed. Hard synchronization also enabled at the last bit of
-- interframe.
--
-- Revision 1.4  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.3  2003/01/31 01:13:37  mohor
-- backup.
--
-- Revision 1.2  2003/01/14 12:19:35  mohor
-- rx_fifo is now working.
--
-- Revision 1.1  2003/01/08 02:13:15  mohor
-- Acceptance filter added.
--
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_acf IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      id                      : IN std_logic_vector(28 DOWNTO 0);
      reset_mode              : IN std_logic;
      acceptance_filter_mode  : IN std_logic;
      extended_mode           : IN std_logic;
      acceptance_code_0       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_code_1       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_code_2       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_code_3       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_0       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_1       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_2       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_3       : IN std_logic_vector(7 DOWNTO 0);
      go_rx_crc_lim           : IN std_logic;
      go_rx_inter             : IN std_logic;
      go_error_frame          : IN std_logic;
      data0                   : IN std_logic_vector(7 DOWNTO 0);
      data1                   : IN std_logic_vector(7 DOWNTO 0);
      rtr1                    : IN std_logic;
      rtr2                    : IN std_logic;
      ide                     : IN std_logic;
      no_byte0                : IN std_logic;
      no_byte1                : IN std_logic;
      id_ok                   : OUT std_logic);
END ENTITY can_acf;

ARCHITECTURE RTL OF can_acf IS


   SIGNAL match                    :  std_logic;
   SIGNAL match_sf_std             :  std_logic;
   SIGNAL match_sf_ext             :  std_logic;
   SIGNAL match_df_std             :  std_logic;
   SIGNAL match_df_ext             :  std_logic;
   SIGNAL id_ok_xhdl1              :  std_logic;

BEGIN
   id_ok <= id_ok_xhdl1;
   -- Working in basic mode. ID match for standard format (11-bit ID).
   match <= (((((((CONV_STD_LOGIC(id(3) = acceptance_code_0(0)) OR acceptance_mask_0(0)) AND (CONV_STD_LOGIC(id(4) = acceptance_code_0(1)) OR acceptance_mask_0(1))) AND (CONV_STD_LOGIC(id(5) = acceptance_code_0(2)) OR acceptance_mask_0(2))) AND (CONV_STD_LOGIC(id(6) = acceptance_code_0(3)) OR acceptance_mask_0(3))) AND (CONV_STD_LOGIC(id(7) = acceptance_code_0(4)) OR acceptance_mask_0(4))) AND (CONV_STD_LOGIC(id(8) = acceptance_code_0(5)) OR acceptance_mask_0(5))) AND (CONV_STD_LOGIC(id(9) = acceptance_code_0(6)) OR acceptance_mask_0(6))) AND (CONV_STD_LOGIC(id(10) = acceptance_code_0(7)) OR acceptance_mask_0(7)) ;
   -- Working in extended mode. ID match for standard format (11-bit ID). Using single filter.
   match_sf_std <= (((((((((((((((((((((((((((CONV_STD_LOGIC(id(3) = acceptance_code_0(0)) OR acceptance_mask_0(0)) AND (CONV_STD_LOGIC(id(4) = acceptance_code_0(1))
	OR acceptance_mask_0(1))) AND (CONV_STD_LOGIC(id(5) = acceptance_code_0(2)) OR acceptance_mask_0(2))) AND (CONV_STD_LOGIC(id(6) = acceptance_code_0(3))
	OR acceptance_mask_0(3))) AND (CONV_STD_LOGIC(id(7) = acceptance_code_0(4)) OR acceptance_mask_0(4))) AND (CONV_STD_LOGIC(id(8) = acceptance_code_0(5))
	OR acceptance_mask_0(5))) AND (CONV_STD_LOGIC(id(9) = acceptance_code_0(6)) OR acceptance_mask_0(6))) AND (CONV_STD_LOGIC(id(10) = acceptance_code_0(7))
	OR acceptance_mask_0(7))) AND (CONV_STD_LOGIC(rtr1 = acceptance_code_1(4)) OR acceptance_mask_1(4))) AND (CONV_STD_LOGIC(id(0) = acceptance_code_1(5))
	OR acceptance_mask_1(5))) AND (CONV_STD_LOGIC(id(1) = acceptance_code_1(6)) OR acceptance_mask_1(6))) AND (CONV_STD_LOGIC(id(2) = acceptance_code_1(7))
	OR acceptance_mask_1(7))) AND (CONV_STD_LOGIC(data0(0) = acceptance_code_2(0)) OR acceptance_mask_2(0) OR no_byte0)) AND (CONV_STD_LOGIC(data0(1) = acceptance_code_2(1))
	OR acceptance_mask_2(1) OR no_byte0)) AND (CONV_STD_LOGIC(data0(2) = acceptance_code_2(2)) OR acceptance_mask_2(2)
	OR no_byte0)) AND (CONV_STD_LOGIC(data0(3) = acceptance_code_2(3)) OR acceptance_mask_2(3) OR no_byte0)) AND (CONV_STD_LOGIC(data0(4) = acceptance_code_2(4))
	OR acceptance_mask_2(4) OR no_byte0)) AND (CONV_STD_LOGIC(data0(5) = acceptance_code_2(5)) OR acceptance_mask_2(5) OR no_byte0)) AND (CONV_STD_LOGIC(data0(6) = acceptance_code_2(6))
	OR acceptance_mask_2(6) OR no_byte0)) AND (CONV_STD_LOGIC(data0(7) = acceptance_code_2(7)) OR acceptance_mask_2(7) OR no_byte0)) AND (CONV_STD_LOGIC(data1(0) = acceptance_code_3(0))
	OR acceptance_mask_3(0) OR no_byte1)) AND (CONV_STD_LOGIC(data1(1) = acceptance_code_3(1)) OR acceptance_mask_3(1) OR no_byte1)) AND (CONV_STD_LOGIC(data1(2) = acceptance_code_3(2))
	OR acceptance_mask_3(2) OR no_byte1)) AND (CONV_STD_LOGIC(data1(3) = acceptance_code_3(3)) OR acceptance_mask_3(3) OR no_byte1)) AND (CONV_STD_LOGIC(data1(4) = acceptance_code_3(4))
	OR acceptance_mask_3(4) OR no_byte1)) AND (CONV_STD_LOGIC(data1(5) = acceptance_code_3(5)) OR acceptance_mask_3(5) OR no_byte1)) AND (CONV_STD_LOGIC(data1(6) = acceptance_code_3(6))
	OR acceptance_mask_3(6) OR no_byte1)) AND (CONV_STD_LOGIC(data1(7) = acceptance_code_3(7)) OR acceptance_mask_3(7) OR no_byte1) ;
   -- Working in extended mode. ID match for extended format (29-bit ID). Using single filter.
   match_sf_ext <= (((((((((((((((((((((((((((((CONV_STD_LOGIC(id(21) = acceptance_code_0(0)) OR acceptance_mask_0(0)) AND (CONV_STD_LOGIC(id(22) = acceptance_code_0(1))
	OR acceptance_mask_0(1))) AND (CONV_STD_LOGIC(id(23) = acceptance_code_0(2)) OR acceptance_mask_0(2))) AND (CONV_STD_LOGIC(id(24) = acceptance_code_0(3))
	OR acceptance_mask_0(3))) AND (CONV_STD_LOGIC(id(25) = acceptance_code_0(4)) OR acceptance_mask_0(4))) AND (CONV_STD_LOGIC(id(26) = acceptance_code_0(5))
	OR acceptance_mask_0(5))) AND (CONV_STD_LOGIC(id(27) = acceptance_code_0(6)) OR acceptance_mask_0(6))) AND (CONV_STD_LOGIC(id(28) = acceptance_code_0(7))
	OR acceptance_mask_0(7))) AND (CONV_STD_LOGIC(id(13) = acceptance_code_1(0)) OR acceptance_mask_1(0))) AND (CONV_STD_LOGIC(id(14) = acceptance_code_1(1))
	OR acceptance_mask_1(1))) AND (CONV_STD_LOGIC(id(15) = acceptance_code_1(2)) OR acceptance_mask_1(2))) AND (CONV_STD_LOGIC(id(16) = acceptance_code_1(3))
	OR acceptance_mask_1(3))) AND (CONV_STD_LOGIC(id(17) = acceptance_code_1(4)) OR acceptance_mask_1(4))) AND (CONV_STD_LOGIC(id(18) = acceptance_code_1(5))
	OR acceptance_mask_1(5))) AND (CONV_STD_LOGIC(id(19) = acceptance_code_1(6)) OR acceptance_mask_1(6))) AND (CONV_STD_LOGIC(id(20) = acceptance_code_1(7))
	OR acceptance_mask_1(7))) AND (CONV_STD_LOGIC(id(5) = acceptance_code_2(0)) OR acceptance_mask_2(0))) AND (CONV_STD_LOGIC(id(6) = acceptance_code_2(1))
	OR acceptance_mask_2(1))) AND (CONV_STD_LOGIC(id(7) = acceptance_code_2(2)) OR acceptance_mask_2(2))) AND (CONV_STD_LOGIC(id(8) = acceptance_code_2(3))
	OR acceptance_mask_2(3))) AND (CONV_STD_LOGIC(id(9) = acceptance_code_2(4)) OR acceptance_mask_2(4))) AND (CONV_STD_LOGIC(id(10) = acceptance_code_2(5))
	OR acceptance_mask_2(5))) AND (CONV_STD_LOGIC(id(11) = acceptance_code_2(6)) OR acceptance_mask_2(6))) AND (CONV_STD_LOGIC(id(12) = acceptance_code_2(7))
	OR acceptance_mask_2(7))) AND (CONV_STD_LOGIC(rtr2 = acceptance_code_3(2)) OR acceptance_mask_3(2))) AND (CONV_STD_LOGIC(id(0) = acceptance_code_3(3))
	 OR acceptance_mask_3(3))) AND (CONV_STD_LOGIC(id(1) = acceptance_code_3(4)) OR acceptance_mask_3(4))) AND (CONV_STD_LOGIC(id(2) = acceptance_code_3(5))
	OR acceptance_mask_3(5))) AND (CONV_STD_LOGIC(id(3) = acceptance_code_3(6)) OR acceptance_mask_3(6))) AND (CONV_STD_LOGIC(id(4) = acceptance_code_3(7))
	OR acceptance_mask_3(7)) ;
   -- Working in extended mode. ID match for standard format (11-bit ID). Using double filter.
   match_df_std <= ((((((((((((((((((((CONV_STD_LOGIC(id(3) = acceptance_code_0(0)) OR acceptance_mask_0(0)) AND (CONV_STD_LOGIC(id(4) = acceptance_code_0(1))
	OR acceptance_mask_0(1))) AND (CONV_STD_LOGIC(id(5) = acceptance_code_0(2)) OR acceptance_mask_0(2))) AND (CONV_STD_LOGIC(id(6) = acceptance_code_0(3))
	OR acceptance_mask_0(3))) AND (CONV_STD_LOGIC(id(7) = acceptance_code_0(4)) OR acceptance_mask_0(4))) AND (CONV_STD_LOGIC(id(8) = acceptance_code_0(5))
	OR acceptance_mask_0(5))) AND (CONV_STD_LOGIC(id(9) = acceptance_code_0(6)) OR acceptance_mask_0(6))) AND (CONV_STD_LOGIC(id(10) = acceptance_code_0(7))
	OR acceptance_mask_0(7))) AND (CONV_STD_LOGIC(rtr1 = acceptance_code_1(4)) OR acceptance_mask_1(4))) AND (CONV_STD_LOGIC(id(0) = acceptance_code_1(5))
	OR acceptance_mask_1(5))) AND (CONV_STD_LOGIC(id(1) = acceptance_code_1(6)) OR acceptance_mask_1(6))) AND (CONV_STD_LOGIC(id(2) = acceptance_code_1(7))

	OR acceptance_mask_1(7))) AND (CONV_STD_LOGIC(data0(0) = acceptance_code_3(0)) OR acceptance_mask_3(0)
	OR no_byte0)) AND (CONV_STD_LOGIC(data0(1) = acceptance_code_3(1)) OR acceptance_mask_3(1) OR no_byte0)) AND (CONV_STD_LOGIC(data0(2) = acceptance_code_3(2))
	OR acceptance_mask_3(2) OR no_byte0)) AND (CONV_STD_LOGIC(data0(3) = acceptance_code_3(3)) OR acceptance_mask_3(3)
	OR no_byte0)) AND (CONV_STD_LOGIC(data0(4) = acceptance_code_1(0)) OR acceptance_mask_1(0) OR no_byte0)) AND (CONV_STD_LOGIC(data0(5) = acceptance_code_1(1))
	OR acceptance_mask_1(1) OR no_byte0)) AND (CONV_STD_LOGIC(data0(6) = acceptance_code_1(2))
	OR acceptance_mask_1(2) OR no_byte0)) AND (CONV_STD_LOGIC(data0(7) = acceptance_code_1(3)) OR acceptance_mask_1(3) OR no_byte0))

	OR ((((((((((((CONV_STD_LOGIC(id(3) = acceptance_code_2(0)) OR acceptance_mask_2(0)) AND (CONV_STD_LOGIC(id(4) = acceptance_code_2(1))
	OR acceptance_mask_2(1))) AND (CONV_STD_LOGIC(id(5) = acceptance_code_2(2)) OR acceptance_mask_2(2))) AND (CONV_STD_LOGIC(id(6) = acceptance_code_2(3))
	OR acceptance_mask_2(3))) AND (CONV_STD_LOGIC(id(7) = acceptance_code_2(4)) OR acceptance_mask_2(4))) AND (CONV_STD_LOGIC(id(8) = acceptance_code_2(5))
	OR acceptance_mask_2(5))) AND (CONV_STD_LOGIC(id(9) = acceptance_code_2(6)) OR acceptance_mask_2(6))) AND (CONV_STD_LOGIC(id(10) = acceptance_code_2(7))
	OR acceptance_mask_2(7))) AND (CONV_STD_LOGIC(rtr1 = acceptance_code_3(4)) OR acceptance_mask_3(4))) AND (CONV_STD_LOGIC(id(0) = acceptance_code_3(5))
	OR acceptance_mask_3(5))) AND (CONV_STD_LOGIC(id(1) = acceptance_code_3(6)) OR acceptance_mask_3(6))) AND (CONV_STD_LOGIC(id(2) = acceptance_code_3(7))
	OR acceptance_mask_3(7))) ;
   -- Working in extended mode. ID match for extended format (29-bit ID). Using double filter.
   match_df_ext <= ((((((((((((((((CONV_STD_LOGIC(id(21) = acceptance_code_0(0)) OR acceptance_mask_0(0)) AND (CONV_STD_LOGIC(id(22) = acceptance_code_0(1))
	OR acceptance_mask_0(1))) AND (CONV_STD_LOGIC(id(23) = acceptance_code_0(2)) OR acceptance_mask_0(2))) AND (CONV_STD_LOGIC(id(24) = acceptance_code_0(3))
	OR acceptance_mask_0(3))) AND (CONV_STD_LOGIC(id(25) = acceptance_code_0(4)) OR acceptance_mask_0(4))) AND (CONV_STD_LOGIC(id(26) = acceptance_code_0(5))
	OR acceptance_mask_0(5))) AND (CONV_STD_LOGIC(id(27) = acceptance_code_0(6)) OR acceptance_mask_0(6))) AND (CONV_STD_LOGIC(id(28) = acceptance_code_0(7))
	OR acceptance_mask_0(7))) AND (CONV_STD_LOGIC(id(13) = acceptance_code_1(0)) OR acceptance_mask_1(0))) AND (CONV_STD_LOGIC(id(14) = acceptance_code_1(1))
	OR acceptance_mask_1(1))) AND (CONV_STD_LOGIC(id(15) = acceptance_code_1(2)) OR acceptance_mask_1(2))) AND (CONV_STD_LOGIC(id(16) = acceptance_code_1(3))
	OR acceptance_mask_1(3))) AND (CONV_STD_LOGIC(id(17) = acceptance_code_1(4)) OR acceptance_mask_1(4))) AND (CONV_STD_LOGIC(id(18) = acceptance_code_1(5))
	OR acceptance_mask_1(5))) AND (CONV_STD_LOGIC(id(19) = acceptance_code_1(6)) OR acceptance_mask_1(6))) AND (CONV_STD_LOGIC(id(20) = acceptance_code_1(7))
	OR acceptance_mask_1(7))) OR ((((((((((((((((CONV_STD_LOGIC(id(21) = acceptance_code_2(0)) OR acceptance_mask_2(0)) AND (CONV_STD_LOGIC(id(22) = acceptance_code_2(1))
	OR acceptance_mask_2(1))) AND (CONV_STD_LOGIC(id(23) = acceptance_code_2(2)) OR acceptance_mask_2(2))) AND (CONV_STD_LOGIC(id(24) = acceptance_code_2(3))
	OR acceptance_mask_2(3))) AND (CONV_STD_LOGIC(id(25) = acceptance_code_2(4)) OR acceptance_mask_2(4))) AND (CONV_STD_LOGIC(id(26) = acceptance_code_2(5))
	OR acceptance_mask_2(5))) AND (CONV_STD_LOGIC(id(27) = acceptance_code_2(6)) OR acceptance_mask_2(6))) AND (CONV_STD_LOGIC(id(28) = acceptance_code_2(7))
	OR acceptance_mask_2(7))) AND (CONV_STD_LOGIC(id(13) = acceptance_code_3(0)) OR acceptance_mask_3(0))) AND (CONV_STD_LOGIC(id(14) = acceptance_code_3(1))
	OR acceptance_mask_3(1))) AND (CONV_STD_LOGIC(id(15) = acceptance_code_3(2)) OR acceptance_mask_3(2))) AND (CONV_STD_LOGIC(id(16) = acceptance_code_3(3))
	OR acceptance_mask_3(3))) AND (CONV_STD_LOGIC(id(17) = acceptance_code_3(4)) OR acceptance_mask_3(4))) AND (CONV_STD_LOGIC(id(18) = acceptance_code_3(5))
	OR acceptance_mask_3(5))) AND (CONV_STD_LOGIC(id(19) = acceptance_code_3(6)) OR acceptance_mask_3(6))) AND (CONV_STD_LOGIC(id(20) = acceptance_code_3(7))
	OR acceptance_mask_3(7))) ;

   -- ID ok signal generation

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         id_ok_xhdl1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_rx_crc_lim = '1') THEN
            -- sample_point is already included in go_rx_crc_lim

            IF (extended_mode = '1') THEN
               IF (NOT acceptance_filter_mode = '1') THEN
                  -- dual filter

                  IF (ide = '1') THEN
                     -- extended frame message

                     id_ok_xhdl1 <= match_df_ext ;
                  ELSE
                     -- standard frame message

                     id_ok_xhdl1 <= match_df_std ;
                  END IF;
               ELSE
                  -- single filter

                  IF (ide = '1') THEN
                     -- extended frame message

                     id_ok_xhdl1 <= match_sf_ext ;
                  ELSE
                     -- standard frame message

                     id_ok_xhdl1 <= match_sf_std ;
                  END IF;
               END IF;
            ELSE
               id_ok_xhdl1 <= match ;
            END IF;
         ELSE
            IF ((reset_mode OR go_rx_inter OR go_error_frame) = '1') THEN
               -- sample_point is already included in go_rx_inter

               id_ok_xhdl1 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_btl
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_btl.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_btl.v,v $
-- Revision 1.30  2004/10/27 18:51:37  igorm
-- Fixed synchronization problem in real hardware when 0xf is used for TSEG1.
--
-- Revision 1.29  2004/05/12 15:58:41  igorm
-- Core improved to pass all tests with the Bosch VHDL Reference system.
--
-- Revision 1.28  2004/02/08 14:25:26  mohor
-- Header changed.
--
-- Revision 1.27  2003/09/30 00:55:13  mohor
-- Error counters fixed to be compatible with Bosch VHDL reference model.
-- Small synchronization changes.
--
-- Revision 1.26  2003/09/25 18:55:49  mohor
-- Synchronization changed, error counters fixed.
--
-- Revision 1.25  2003/07/16 13:40:35  mohor
-- Fixed according to the linter.
--
-- Revision 1.24  2003/07/10 15:32:28  mohor
-- Unused signal removed.
--
-- Revision 1.23  2003/07/10 01:59:04  tadejm
-- Synchronization fixed. In some strange cases it didn't work according to
-- the VHDL reference model.
--
-- Revision 1.22  2003/07/07 11:21:37  mohor
-- Little fixes (to fix warnings).
--
-- Revision 1.21  2003/07/03 09:32:20  mohor
-- Synchronization changed.
--
-- Revision 1.20  2003/06/20 14:51:11  mohor
-- Previous change removed. When resynchronization occurs we go to seg1
-- stage. sync stage does not cause another start of seg1 stage.
--
-- Revision 1.19  2003/06/20 14:28:20  mohor
-- When hard_sync or resync occure we need to go to seg1 segment. Going to
-- sync segment is in that case blocked.
--
-- Revision 1.18  2003/06/17 15:53:33  mohor
-- clk_cnt reduced from [8:0] to [6:0].
--
-- Revision 1.17  2003/06/17 14:32:17  mohor
-- Removed few signals.
--
-- Revision 1.16  2003/06/16 13:57:58  mohor
-- tx_point generated one clk earlier. rx_i registered. Data corrected when
-- using extended mode.
--
-- Revision 1.15  2003/06/13 15:02:24  mohor
-- Synchronization is also needed when transmitting a message.
--
-- Revision 1.14  2003/06/13 14:55:11  mohor
-- Counters width changed.
--
-- Revision 1.13  2003/06/11 14:21:35  mohor
-- When switching to tx, sync stage is overjumped.
--
-- Revision 1.12  2003/02/14 20:17:01  mohor
-- Several registers added. Not finished, yet.
--
-- Revision 1.11  2003/02/09 18:40:29  mohor
-- Overload fixed. Hard synchronization also enabled at the last bit of
-- interframe.
--
-- Revision 1.10  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.9  2003/01/31 01:13:38  mohor
-- backup.
--
-- Revision 1.8  2003/01/10 17:51:34  mohor
-- Temporary version (backup).
--
-- Revision 1.7  2003/01/08 02:10:53  mohor
-- Acceptance filter added.
--
-- Revision 1.6  2002/12/28 04:13:23  mohor
-- Backup version.
--
-- Revision 1.5  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.4  2002/12/26 01:33:05  mohor
-- Tripple sampling supported.
--
-- Revision 1.3  2002/12/25 23:44:16  mohor
-- Commented lines removed.
--
-- Revision 1.2  2002/12/25 14:17:00  mohor
-- Synchronization working.
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_btl IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      rx                      : IN std_logic;
      tx                      : IN std_logic;
      -- Bus Timing 0 register
      baud_r_presc            : IN std_logic_vector(5 DOWNTO 0);
      sync_jump_width         : IN std_logic_vector(1 DOWNTO 0);
      -- Bus Timing 1 register
      time_segment1           : IN std_logic_vector(3 DOWNTO 0);
      time_segment2           : IN std_logic_vector(2 DOWNTO 0);
      triple_sampling         : IN std_logic;
      -- Output signals from this module
      sample_point            : OUT std_logic;
      sampled_bit             : OUT std_logic;
      sampled_bit_q           : OUT std_logic;
      tx_point                : OUT std_logic;
      hard_sync               : OUT std_logic;
      -- Output from can_bsp module
      rx_idle                 : IN std_logic;
      rx_inter                : IN std_logic;
      transmitting            : IN std_logic;
      transmitter             : IN std_logic;
      go_rx_inter             : IN std_logic;
      tx_next                 : IN std_logic;
      go_overload_frame       : IN std_logic;
      go_error_frame          : IN std_logic;
      go_tx                   : IN std_logic;
      send_ack                : IN std_logic;
      node_error_passive      : IN std_logic);
END ENTITY can_btl;

ARCHITECTURE RTL OF can_btl IS

   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL clk_cnt                  :  std_logic_vector(6 DOWNTO 0);
   SIGNAL clk_en                   :  std_logic;
   SIGNAL clk_en_q                 :  std_logic;
   SIGNAL sync_blocked             :  std_logic;
   SIGNAL hard_sync_blocked        :  std_logic;
   SIGNAL quant_cnt                :  std_logic_vector(4 DOWNTO 0);
   SIGNAL delay                    :  std_logic_vector(3 DOWNTO 0);
   SIGNAL sync                     :  std_logic;
   SIGNAL seg1                     :  std_logic;
   SIGNAL seg2                     :  std_logic;
   SIGNAL resync_latched           :  std_logic;
   SIGNAL sample                   :  std_logic_vector(1 DOWNTO 0);
   SIGNAL tx_next_sp               :  std_logic;
   SIGNAL go_sync                  :  std_logic;
   SIGNAL go_seg1                  :  std_logic;
   SIGNAL go_seg2                  :  std_logic;
   SIGNAL preset_cnt               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL sync_window              :  std_logic;
   SIGNAL resync                   :  std_logic;
   -- when transmitting 0 with positive error delay is set to 0
   SIGNAL temp_xhdl6               :  std_logic_vector(4 DOWNTO 0);
   SIGNAL sample_point_xhdl1       :  std_logic;
   SIGNAL sampled_bit_xhdl2        :  std_logic;
   SIGNAL sampled_bit_q_xhdl3      :  std_logic;
   SIGNAL tx_point_xhdl4           :  std_logic;
   SIGNAL hard_sync_xhdl5          :  std_logic;

   signal time_segment1_ext, delay_ext, add_ext: std_logic_vector(4 DOWNTO 0); --##

BEGIN
   sample_point <= sample_point_xhdl1;
   sampled_bit <= sampled_bit_xhdl2;
   sampled_bit_q <= sampled_bit_q_xhdl3;
   tx_point <= tx_point_xhdl4;
   hard_sync <= hard_sync_xhdl5;
   preset_cnt <=  (('0' & baud_r_presc) + 1) & "0" ;
   hard_sync_xhdl5 <= (((rx_idle OR rx_inter) AND (NOT rx)) AND sampled_bit_xhdl2) AND (NOT hard_sync_blocked) ;
   resync <= ((((NOT rx_idle) AND (NOT rx_inter)) AND (NOT rx)) AND sampled_bit_xhdl2) AND (NOT sync_blocked) ;

   -- Generating general enable signal that defines baud rate.
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         clk_cnt <= "0000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (('0' & clk_cnt) >= (preset_cnt - "00000001")) THEN
            clk_cnt <= "0000000" ;
         ELSE
            clk_cnt <= clk_cnt + "0000001" ;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         clk_en <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (('0' & clk_cnt) = (preset_cnt - "00000001")) THEN
            clk_en <= '1' ;
         ELSE
            clk_en <= '0' ;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         clk_en_q <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         clk_en_q <= clk_en ;
      END IF;
   END PROCESS;
   -- Changing states
   go_sync <= (((clk_en_q AND seg2) AND CONV_STD_LOGIC(quant_cnt(2 DOWNTO 0) = time_segment2)) AND (NOT hard_sync_xhdl5)) AND (NOT resync) ;
   go_seg1 <= clk_en_q AND (sync OR hard_sync_xhdl5 OR ((resync AND seg2) AND sync_window) OR (resync_latched AND sync_window)) ;
--##   go_seg2 <= clk_en_q AND ((seg1 AND (NOT hard_sync_xhdl5)) AND CONV_STD_LOGIC(quant_cnt = ( '0' & (time_segment1 + delay)))) ;

   go_seg2 <= clk_en_q AND ((seg1 AND (NOT hard_sync_xhdl5)) AND CONV_STD_LOGIC(quant_cnt = add_ext)) ;--##
   time_segment1_ext <=  '0' & time_segment1;   --## fix comparison for max values
   delay_ext <=  '0' & delay;                   --##
   add_ext <= time_segment1_ext + delay_ext;    --##

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_point_xhdl4 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         tx_point_xhdl4 <= (NOT tx_point_xhdl4 AND seg2) AND ((clk_en AND CONV_STD_LOGIC(quant_cnt(2 DOWNTO 0) = time_segment2)) OR ((clk_en OR clk_en_q) AND (resync OR hard_sync_xhdl5))) ;    --  When transmitter we should transmit as soon as possible.
      END IF;
   END PROCESS;

   -- When early edge is detected outside of the SJW field, synchronization request is latched and performed when
   --  When early edge is detected outside of the SJW field, synchronization request is latched and performed when
   --    SJW is reached

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         resync_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (((resync AND seg2) AND (NOT sync_window)) = '1') THEN
            resync_latched <= '1' ;
         ELSE
            IF (go_seg1 = '1') THEN
               resync_latched <= '0';
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Synchronization stage/segment
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         sync <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (clk_en_q = '1') THEN
            sync <= go_sync ;
         END IF;
      END IF;
   END PROCESS;

   -- Seg1 stage/segment (together with propagation segment which is 1 quant long)
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         seg1 <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_seg1 = '1') THEN
            seg1 <= '1' ;
         ELSE
            IF (go_seg2 = '1') THEN
               seg1 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Seg2 stage/segment
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         seg2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_seg2 = '1') THEN
            seg2 <= '1' ;
         ELSE
            IF ((go_sync OR go_seg1) = '1') THEN
               seg2 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Quant counter
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         quant_cnt <= "00000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((go_sync OR go_seg1 OR go_seg2) = '1') THEN
            quant_cnt <= "00000" ;
         ELSE
            IF (clk_en_q = '1') THEN
               quant_cnt <= quant_cnt + "00001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
--##   temp_xhdl6 <= ("0" & ("00" & sync_jump_width + "0001")) WHEN (quant_cnt > "000" & sync_jump_width) ELSE (quant_cnt + "00001");
   temp_xhdl6 <= ("0" & (("00" & sync_jump_width) + "0001")) WHEN (quant_cnt > ("000" & sync_jump_width)) ELSE (quant_cnt + "00001");

   -- When late edge is detected (in seg1 stage), stage seg1 is prolonged.
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         delay <= "0000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (((resync AND seg1) AND (NOT transmitting OR (transmitting AND (tx_next_sp OR (tx AND (NOT rx)))))) = '1') THEN
            delay <= temp_xhdl6(3 DOWNTO 0) ;
         ELSE
            IF ((go_sync OR go_seg1) = '1') THEN
               delay <= "0000" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   -- If early edge appears within this window (in seg2 stage), phase error is fully compensated
--##   sync_window <= CONV_STD_LOGIC((time_segment2 - quant_cnt(2 DOWNTO 0)) < ('0' & (sync_jump_width + "01"))) ;
   sync_window <= '1' when (time_segment2 - quant_cnt(2 DOWNTO 0)) < (('0' & sync_jump_width) + "01") else '0';

   -- Sampling data (memorizing two samples all the time).

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         sample <= "11";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (clk_en_q = '1') THEN
            sample <= sample(0) & rx;
         END IF;
      END IF;
   END PROCESS;

   -- When enabled, tripple sampling is done here.

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         sampled_bit_xhdl2 <= '1';
         sampled_bit_q_xhdl3 <= '1';
         sample_point_xhdl1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_error_frame = '1') THEN
            sampled_bit_q_xhdl3 <= sampled_bit_xhdl2 ;
            sample_point_xhdl1 <= '0' ;
         ELSE
            IF ((clk_en_q AND (NOT hard_sync_xhdl5)) = '1') THEN
--##               IF ((seg1 AND CONV_STD_LOGIC(quant_cnt = ('0' & (time_segment1 + delay)))) = '1') then
               IF ((seg1 AND CONV_STD_LOGIC(quant_cnt = add_ext )) = '1') then --##
                  sample_point_xhdl1 <= '1' ;
                  sampled_bit_q_xhdl3 <= sampled_bit_xhdl2 ;
                  IF (triple_sampling = '1') THEN
                     sampled_bit_xhdl2 <= (sample(0) AND sample(1)) OR (sample(0) AND rx) OR (sample(1) AND rx) ;
                  ELSE
                     sampled_bit_xhdl2 <= rx ;
                  END IF;
-- kc fix
               ELSE
                 sample_point_xhdl1 <= '0' ;
--
               END IF;
            ELSE
               sample_point_xhdl1 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- tx_next_sp shows next value that will be driven on the TX. When driving 1 and receiving 0 we
   -- need to synchronize (even when we are a transmitter)

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_next_sp <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((go_overload_frame OR (go_error_frame AND (NOT node_error_passive)) OR go_tx OR send_ack) = '1') THEN
            tx_next_sp <= '0' ;
         ELSE
            IF ((go_error_frame AND node_error_passive) = '1') THEN
               tx_next_sp <= '1' ;
            ELSE
               IF (sample_point_xhdl1 = '1') THEN
                  tx_next_sp <= tx_next ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Blocking synchronization (can occur only once in a bit time)
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         sync_blocked <= '1' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (clk_en_q = '1') THEN
            IF (resync = '1') THEN
               sync_blocked <= '1' ;
            ELSE
               IF (go_seg2 = '1') THEN
                  sync_blocked <= '0' ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Blocking hard synchronization when occurs once or when we are transmitting a msg
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         hard_sync_blocked <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (((hard_sync_xhdl5 AND clk_en_q) OR ((((transmitting AND transmitter) OR go_tx) AND tx_point_xhdl4) AND (NOT tx_next))) = '1') THEN
            hard_sync_blocked <= '1' ;
         ELSE
            IF ((go_rx_inter OR (((rx_idle OR rx_inter) AND sample_point_xhdl1) AND sampled_bit_xhdl2)) = '1') THEN
               -- When a glitch performed synchronization

               hard_sync_blocked <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_fifo
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_fifo.v                                                  ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- Rev 1.28 rd_info_pointer fix from opencores merged. /Kristoffer
--
-- $Log: can_fifo.v,v $
-- Revision 1.27  2004/11/18 12:39:34  igorm
-- Fixes for compatibility after the SW reset.
--
-- Revision 1.26  2004/02/08 14:30:57  mohor
-- Header changed.
--
-- Revision 1.25  2003/10/23 16:52:17  mohor
-- Active high/low problem when Altera devices are used. Bug fixed by
-- Rojhalat Ibrahim.
--
-- Revision 1.24  2003/10/17 05:55:20  markom
-- mbist signals updated according to newest convention
--
-- Revision 1.23  2003/09/05 12:46:41  mohor
-- ALTERA_RAM supported.
--
-- Revision 1.22  2003/08/20 09:59:16  mohor
-- Artisan RAM fixed (when not using BIST).
--
-- Revision 1.21  2003/08/14 16:04:52  simons
-- Artisan ram instances added.
--
-- Revision 1.20  2003/07/16 14:00:45  mohor
-- Fixed according to the linter.
--
-- Revision 1.19  2003/07/03 09:30:44  mohor
-- PCI_BIST replaced with CAN_BIST.
--
-- Revision 1.18  2003/06/27 22:14:23  simons
-- Overrun fifo implemented with FFs, because it is not possible to create such a memory.
--
-- Revision 1.17  2003/06/27 20:56:15  simons
-- Virtual silicon ram instances added.
--
-- Revision 1.16  2003/06/18 23:03:44  mohor
-- Typo fixed.
--
-- Revision 1.15  2003/06/11 09:37:05  mohor
-- overrun and length_info fifos are initialized at the end of reset.
--
-- Revision 1.14  2003/03/05 15:02:30  mohor
-- Xilinx RAM added.
--
-- Revision 1.13  2003/03/01 22:53:33  mohor
-- Actel APA ram supported.
--
-- Revision 1.12  2003/02/19 14:44:03  mohor
-- CAN core finished. Host interface added. Registers finished.
-- Synchronization to the wishbone finished.
--
-- Revision 1.11  2003/02/14 20:17:01  mohor
-- Several registers added. Not finished, yet.
--
-- Revision 1.10  2003/02/11 00:56:06  mohor
-- Wishbone interface added.
--
-- Revision 1.9  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.8  2003/01/31 01:13:38  mohor
-- backup.
--
-- Revision 1.7  2003/01/17 17:44:31  mohor
-- Fifo corrected to be synthesizable.
--
-- Revision 1.6  2003/01/15 13:16:47  mohor
-- When a frame with "remote request" is received, no data is stored
-- to fifo, just the frame information (identifier, ...). Data length
-- that is stored is the received data length and not the actual data
-- length that is stored to fifo.
--
-- Revision 1.5  2003/01/14 17:25:09  mohor
-- Addresses corrected to decimal values (previously hex).
--
-- Revision 1.4  2003/01/14 12:19:35  mohor
-- rx_fifo is now working.
--
-- Revision 1.3  2003/01/09 21:54:45  mohor
-- rx fifo added. Not 100 % verified, yet.
--
-- Revision 1.2  2003/01/09 14:46:58  mohor
-- Temporary files (backup).
--
-- Revision 1.1  2003/01/08 02:10:55  mohor
-- Acceptance filter added.
--
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_fifo IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      wr                      : IN std_logic;
      data_in                 : IN std_logic_vector(7 DOWNTO 0);
      addr                    : IN std_logic_vector(5 DOWNTO 0);
      data_out                : OUT std_logic_vector(7 DOWNTO 0);
      fifo_selected           : IN std_logic;
      reset_mode              : IN std_logic;
      release_buffer          : IN std_logic;
      extended_mode           : IN std_logic;
      overrun                 : OUT std_logic;
      info_empty              : OUT std_logic;
      info_cnt                : OUT std_logic_vector(6 DOWNTO 0);
      --------------------------------------------------
-- port connections for Ram
--64x8

      q_dp_64x8               : IN std_logic_vector(7 DOWNTO 0);
      data_64x8               : OUT std_logic_vector(7 DOWNTO 0);
      wren_64x8               : OUT std_logic;
      rden_64x8               : OUT std_logic;
      wraddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      --64x4

      q_dp_64x4               : IN std_logic_vector(3 DOWNTO 0);
      data_64x4               : OUT std_logic_vector(3 DOWNTO 0);
      wren_64x4x1             : OUT std_logic;
      wraddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      --64x1

      q_dp_64x1               : IN std_logic;
      data_64x1               : OUT std_logic);
END ENTITY can_fifo;

ARCHITECTURE RTL OF can_fifo IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   --------------------------------------------------
   SIGNAL fifo                     :  xhdl_15;
   SIGNAL length_fifo              :  xhdl_16;
   SIGNAL overrun_info             :  xhdl_17;
   SIGNAL rd_pointer               :  std_logic_vector(5 DOWNTO 0);
   SIGNAL wr_pointer               :  std_logic_vector(5 DOWNTO 0);
   SIGNAL read_address             :  std_logic_vector(5 DOWNTO 0);
   SIGNAL wr_info_pointer          :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rd_info_pointer          :  std_logic_vector(5 DOWNTO 0);
   SIGNAL wr_q                     :  std_logic;
   SIGNAL len_cnt                  :  std_logic_vector(3 DOWNTO 0);
   SIGNAL fifo_cnt                 :  std_logic_vector(6 DOWNTO 0);
   SIGNAL latch_overrun            :  std_logic;
   SIGNAL initialize_memories      :  std_logic;
   SIGNAL length_info              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL write_length_info        :  std_logic;
   SIGNAL fifo_empty               :  std_logic;
   SIGNAL fifo_full                :  std_logic;
   SIGNAL info_full                :  std_logic;
   SIGNAL data_out_xhdl1           :  std_logic_vector(7 DOWNTO 0);
   SIGNAL overrun_xhdl2            :  std_logic;
   SIGNAL info_empty_xhdl3         :  std_logic;
   SIGNAL info_cnt_xhdl4           :  std_logic_vector(6 DOWNTO 0);
   SIGNAL data_64x8_xhdl5          :  std_logic_vector(7 DOWNTO 0);
   SIGNAL wren_64x8_xhdl6          :  std_logic;
   SIGNAL rden_64x8_xhdl7          :  std_logic;
   SIGNAL wraddress_64x8_xhdl8     :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x8_xhdl9     :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x4_xhdl10         :  std_logic_vector(3 DOWNTO 0);
   SIGNAL wren_64x4x1_xhdl11       :  std_logic;
   SIGNAL wraddress_64x4x1_xhdl12  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x4x1_xhdl13  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x1_xhdl14         :  std_logic;

BEGIN
   data_out <= data_out_xhdl1;
   overrun <= overrun_xhdl2;
   info_empty <= info_empty_xhdl3;
   info_cnt <= info_cnt_xhdl4;
   data_64x8 <= data_64x8_xhdl5;
   wren_64x8 <= wren_64x8_xhdl6;
   rden_64x8 <= rden_64x8_xhdl7;
   wraddress_64x8 <= wraddress_64x8_xhdl8;
   rdaddress_64x8 <= rdaddress_64x8_xhdl9;
   data_64x4 <= data_64x4_xhdl10;
   wren_64x4x1 <= wren_64x4x1_xhdl11;
   wraddress_64x4x1 <= wraddress_64x4x1_xhdl12;
   rdaddress_64x4x1 <= rdaddress_64x4x1_xhdl13;
   data_64x1 <= data_64x1_xhdl14;
   write_length_info <= (NOT wr) AND wr_q ;

   -- Delayed write signal

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         wr_q <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            wr_q <= '0' ;
         ELSE
            wr_q <= wr ;
         END IF;
      END IF;
   END PROCESS;

   -- length counter

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         len_cnt <= "0000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR write_length_info) = '1') THEN
            len_cnt <= "0000" ;
         ELSE
            IF ((wr AND (NOT fifo_full)) = '1') THEN
               len_cnt <= len_cnt + "0001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- wr_info_pointer

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         wr_info_pointer <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (((write_length_info AND (NOT info_full)) OR initialize_memories) = '1') THEN
            wr_info_pointer <= wr_info_pointer + "000001" ;
         ELSE
            IF (reset_mode = '1') THEN
               wr_info_pointer <= rd_info_pointer ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- rd_info_pointer

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rd_info_pointer <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
        IF ((release_buffer AND (NOT info_empty_xhdl3)) = '1') THEN
--      Fix from opencores rev 1.28
--      IF ((release_buffer AND (NOT fifo_empty)) = '1') THEN
            rd_info_pointer <= rd_info_pointer + "000001" ;
         END IF;
      END IF;
   END PROCESS;

   -- rd_pointer

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rd_pointer <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((release_buffer AND (NOT fifo_empty)) = '1') THEN
            rd_pointer <= rd_pointer + ("00" & length_info) ;
         END IF;
      END IF;
   END PROCESS;

   -- wr_pointer

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         wr_pointer <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            wr_pointer <= rd_pointer ;
         ELSE
            IF ((wr AND (NOT fifo_full)) = '1') THEN
               wr_pointer <= wr_pointer + "000001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- latch_overrun

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         latch_overrun <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR write_length_info) = '1') THEN
            latch_overrun <= '0' ;
         ELSE
            IF ((wr AND fifo_full) = '1') THEN
               latch_overrun <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Counting data in fifo

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         fifo_cnt <= "0000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            fifo_cnt <= "0000000" ;
         ELSE
            IF (((wr AND (NOT release_buffer)) AND (NOT fifo_full)) = '1') THEN
               fifo_cnt <= fifo_cnt + "0000001" ;
            ELSE
               IF ((((NOT wr) AND release_buffer) AND (NOT fifo_empty)) = '1') THEN
                  fifo_cnt <= fifo_cnt - ("000" & length_info) ;
               ELSE
                  IF ((((wr AND release_buffer) AND (NOT fifo_full)) AND (NOT fifo_empty)) = '1') THEN
                     fifo_cnt <= fifo_cnt - ("000" & length_info) + "0000001" ;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   fifo_full <= CONV_STD_LOGIC(fifo_cnt = "1000000") ;
   fifo_empty <= CONV_STD_LOGIC(fifo_cnt = "0000000") ;

   -- Counting data in length_fifo and overrun_info fifo

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         info_cnt_xhdl4 <= "0000000" ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            info_cnt_xhdl4 <= "0000000" ;
         ELSE
            IF ((write_length_info XOR release_buffer) = '1') THEN
               IF ((release_buffer AND (NOT info_empty_xhdl3)) = '1') THEN
                  info_cnt_xhdl4 <= info_cnt_xhdl4 - "0000001" ;
               ELSE
                  IF ((write_length_info AND (NOT info_full)) = '1') THEN
                     info_cnt_xhdl4 <= info_cnt_xhdl4 + "0000001" ;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   info_full <= CONV_STD_LOGIC(info_cnt_xhdl4 = "1000000") ;
   info_empty_xhdl3 <= CONV_STD_LOGIC(info_cnt_xhdl4 = "0000000") ;

   -- Selecting which address will be used for reading data from rx fifo

   PROCESS (extended_mode, rd_pointer, addr)
      VARIABLE read_address_xhdl18  : std_logic_vector(5 DOWNTO 0);
   BEGIN
      IF (extended_mode = '1') THEN
         -- extended mode

         read_address_xhdl18 := rd_pointer + (addr - "010000");
      ELSE
         -- normal mode

         read_address_xhdl18 := rd_pointer + (addr - "010100");
      END IF;
      read_address <= read_address_xhdl18;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         initialize_memories <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (andv(wr_info_pointer) = '1') THEN
            initialize_memories <= '0' ;
         END IF;
      END IF;
   END PROCESS;
   -- port connections for Ram
   --64x8
   data_out_xhdl1 <= q_dp_64x8 ;
   data_64x8_xhdl5 <= data_in ;
   wren_64x8_xhdl6 <= wr AND (NOT fifo_full) ;
   rden_64x8_xhdl7 <= fifo_selected ;
   wraddress_64x8_xhdl8 <= wr_pointer ;
   rdaddress_64x8_xhdl9 <= read_address ;
   --64x4
   length_info <= q_dp_64x4 ;
   data_64x4_xhdl10 <= len_cnt AND NOT initialize_memories & NOT initialize_memories & NOT initialize_memories & NOT initialize_memories ;
   wren_64x4x1_xhdl11 <= (write_length_info AND (NOT info_full)) OR initialize_memories ;
   wraddress_64x4x1_xhdl12 <= wr_info_pointer ;
   rdaddress_64x4x1_xhdl13 <= rd_info_pointer ;
   --64x1
   overrun_xhdl2 <= q_dp_64x1 ;
   data_64x1_xhdl14 <= (latch_overrun OR (wr AND fifo_full)) AND (NOT initialize_memories) ;
   -- `ifdef ALTERA_RAM
   -- //  altera_ram_64x8_sync fifo
   --   lpm_ram_dp fifo
   --   (
   --     .q         (data_out),
   --     .rdclock   (clk),
   --     .wrclock   (clk),
   --     .data      (data_in),
   --     .wren      (wr & (~fifo_full)),
   --     .rden      (fifo_selected),
   --     .wraddress (wr_pointer),
   --     .rdaddress (read_address)
   --   );
   --   defparam fifo.lpm_width = 8;
   --   defparam fifo.lpm_widthad = 6;
   --   defparam fifo.lpm_numwords = 64;
   --
   --
   -- //  altera_ram_64x4_sync info_fifo
   --   lpm_ram_dp info_fifo
   --   (
   --     .q         (length_info),
   --     .rdclock   (clk),
   --     .wrclock   (clk),
   --     .data      (len_cnt & {4{~initialize_memories}}),
   --     .wren      (write_length_info & (~info_full) | initialize_memories),
   --     .wraddress (wr_info_pointer),
   --     .rdaddress (rd_info_pointer)
   --   );
   --   defparam info_fifo.lpm_width = 4;
   --   defparam info_fifo.lpm_widthad = 6;
   --   defparam info_fifo.lpm_numwords = 64;
   --
   --
   -- //  altera_ram_64x1_sync overrun_fifo
   --   lpm_ram_dp overrun_fifo
   --   (
   --     .q         (overrun),
   --     .rdclock   (clk),
   --     .wrclock   (clk),
   --     .data      ((latch_overrun | (wr & fifo_full)) & (~initialize_memories)),
   --     .wren      (write_length_info & (~info_full) | initialize_memories),
   --     .wraddress (wr_info_pointer),
   --     .rdaddress (rd_info_pointer)
   --   );
   --   defparam overrun_fifo.lpm_width = 1;
   --   defparam overrun_fifo.lpm_widthad = 6;
   --   defparam overrun_fifo.lpm_numwords = 64;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_crc
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_crc.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_crc.v,v $
-- Revision 1.5  2004/02/08 14:25:57  mohor
-- Header changed.
--
-- Revision 1.4  2003/07/16 13:16:51  mohor
-- Fixed according to the linter.
--
-- Revision 1.3  2003/02/10 16:02:11  mohor
-- CAN is working according to the specification. WB interface and more
-- registers (status, IRQ, ...) needs to be added.
--
-- Revision 1.2  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.1  2003/01/08 02:10:54  mohor
-- Acceptance filter added.
--
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_crc IS
   PORT (
      clk                     : IN std_logic;
      data                    : IN std_logic;
      enable                  : IN std_logic;
      initialize              : IN std_logic;
      crc                     : OUT std_logic_vector(14 DOWNTO 0));
END ENTITY can_crc;

ARCHITECTURE RTL OF can_crc IS

   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL crc_next                 :  std_logic;
   SIGNAL crc_tmp                  :  std_logic_vector(14 DOWNTO 0);
   SIGNAL crc_xhdl1                :  std_logic_vector(14 DOWNTO 0);

BEGIN
   crc <= crc_xhdl1;
   crc_next <= data XOR crc_xhdl1(14) ;
   crc_tmp <= crc_xhdl1(13 DOWNTO 0) & '0' ;

   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         IF (initialize = '1') THEN
            crc_xhdl1 <= "000000000000000";
         ELSE
            IF (enable = '1') THEN
               IF (crc_next = '1') THEN
                  crc_xhdl1 <= crc_tmp XOR "100010110011001";
               ELSE
                  crc_xhdl1 <= crc_tmp ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_ibo
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_ibo.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_ibo.v,v $
-- Revision 1.3  2004/02/08 14:31:44  mohor
-- Header changed.
--
-- Revision 1.2  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.1  2003/02/04 14:34:52  mohor
-- *** empty log message ***
--
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on
-- This module only inverts bit order
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY can_ibo IS
   PORT (
      di                      : IN std_logic_vector(7 DOWNTO 0);
      do                      : OUT std_logic_vector(7 DOWNTO 0));
END ENTITY can_ibo;

ARCHITECTURE RTL OF can_ibo IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL do_xhdl1                 :  std_logic_vector(7 DOWNTO 0);

BEGIN
   do <= do_xhdl1;
   do_xhdl1(0) <= di(7) ;
   do_xhdl1(1) <= di(6) ;
   do_xhdl1(2) <= di(5) ;
   do_xhdl1(3) <= di(4) ;
   do_xhdl1(4) <= di(3) ;
   do_xhdl1(5) <= di(2) ;
   do_xhdl1(6) <= di(1) ;
   do_xhdl1(7) <= di(0) ;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_bsp
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_bsp.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_bsp.v,v $
-- Revision 1.52  2004/11/18 12:39:21  igorm
-- Fixes for compatibility after the SW reset.
--
-- Revision 1.51  2004/11/15 18:23:21  igorm
-- When CAN was reset by setting the reset_mode signal in mode register, it
-- was possible that CAN was blocked for a short period of time. Problem
-- occured very rarly.
--
-- Revision 1.50  2004/10/27 18:51:36  igorm
-- Fixed synchronization problem in real hardware when 0xf is used for TSEG1.
--
-- Revision 1.49  2004/10/25 06:37:51  igorm
-- Arbitration bug fixed.
--
-- Revision 1.48  2004/05/12 15:58:41  igorm
-- Core improved to pass all tests with the Bosch VHDL Reference system.
--
-- Revision 1.47  2004/02/08 14:24:10  mohor
-- Error counters changed.
--
-- Revision 1.46  2003/10/17 05:55:20  markom
-- mbist signals updated according to newest convention
--
-- Revision 1.45  2003/09/30 21:14:33  mohor
-- Error counters changed.
--
-- Revision 1.44  2003/09/30 00:55:12  mohor
-- Error counters fixed to be compatible with Bosch VHDL reference model.
-- Small synchronization changes.
--
-- Revision 1.43  2003/09/25 18:55:49  mohor
-- Synchronization changed, error counters fixed.
--
-- Revision 1.42  2003/08/29 07:01:14  mohor
-- When detecting bus-free, signal bus_free_cnt_en was cleared to zero
-- although the last sampled bit was zero instead of one.
--
-- Revision 1.41  2003/07/18 15:23:31  tadejm
-- Tx and rx length are limited to 8 bytes regardless to the DLC value.
--
-- Revision 1.40  2003/07/16 15:10:17  mohor
-- Fixed according to the linter.
--
-- Revision 1.39  2003/07/16 13:12:46  mohor
-- Fixed according to the linter.
--
-- Revision 1.38  2003/07/10 01:59:04  tadejm
-- Synchronization fixed. In some strange cases it didn't work according to
-- the VHDL reference model.
--
-- Revision 1.37  2003/07/07 11:21:37  mohor
-- Little fixes (to fix warnings).
--
-- Revision 1.36  2003/07/03 09:32:20  mohor
-- Synchronization changed.
--
-- Revision 1.35  2003/06/27 20:56:12  simons
-- Virtual silicon ram instances added.
--
-- Revision 1.34  2003/06/22 09:43:03  mohor
-- synthesi full_case parallel_case fixed.
--
-- Revision 1.33  2003/06/21 12:16:30  mohor
-- paralel_case and full_case compiler directives added to case statements.
--
-- Revision 1.32  2003/06/17 14:28:32  mohor
-- Form error was detected when stuff bit occured at the end of crc.
--
-- Revision 1.31  2003/06/16 14:31:29  tadejm
-- Bit stuffing corrected when stuffing comes at the end of the crc.
--
-- Revision 1.30  2003/06/16 13:57:58  mohor
-- tx_point generated one clk earlier. rx_i registered. Data corrected when
-- using extended mode.
--
-- Revision 1.29  2003/06/11 14:21:35  mohor
-- When switching to tx, sync stage is overjumped.
--
-- Revision 1.28  2003/03/01 22:53:33  mohor
-- Actel APA ram supported.
--
-- Revision 1.27  2003/02/20 00:26:02  mohor
-- When a dominant bit was detected at the third bit of the intermission and
-- node had a message to transmit, bit_stuff error could occur. Fixed.
--
-- Revision 1.26  2003/02/19 23:21:54  mohor
-- When bit error occured while active error flag was transmitted, counter was
-- not incremented.
--
-- Revision 1.25  2003/02/19 14:44:03  mohor
-- CAN core finished. Host interface added. Registers finished.
-- Synchronization to the wishbone finished.
--
-- Revision 1.24  2003/02/18 00:10:15  mohor
-- Most of the registers added. Registers "arbitration lost capture", "error code
-- capture" + few more still need to be added.
--
-- Revision 1.23  2003/02/14 20:17:01  mohor
-- Several registers added. Not finished, yet.
--
-- Revision 1.22  2003/02/12 14:23:59  mohor
-- abort_tx added. Bit destuff fixed.
--
-- Revision 1.21  2003/02/11 00:56:06  mohor
-- Wishbone interface added.
--
-- Revision 1.20  2003/02/10 16:02:11  mohor
-- CAN is working according to the specification. WB interface and more
-- registers (status, IRQ, ...) needs to be added.
--
-- Revision 1.19  2003/02/09 18:40:29  mohor
-- Overload fixed. Hard synchronization also enabled at the last bit of
-- interframe.
--
-- Revision 1.18  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.17  2003/02/04 17:24:41  mohor
-- Backup.
--
-- Revision 1.16  2003/02/04 14:34:52  mohor
-- *** empty log message ***
--
-- Revision 1.15  2003/01/31 01:13:37  mohor
-- backup.
--
-- Revision 1.14  2003/01/16 13:36:19  mohor
-- Form error supported. When receiving messages, last bit of the end-of-frame
-- does not generate form error. Receiver goes to the idle mode one bit sooner.
-- (CAN specification ver 2.0, part B, page 57).
--
-- Revision 1.13  2003/01/15 21:59:45  mohor
-- Data is stored to fifo at the end of ack stage.
--
-- Revision 1.12  2003/01/15 21:05:11  mohor
-- CRC checking fixed (when bitstuff occurs at the end of a CRC sequence).
--
-- Revision 1.11  2003/01/15 14:40:23  mohor
-- RX state machine fixed to receive "remote request" frames correctly.
-- No data bytes are written to fifo when such frames are received.
--
-- Revision 1.10  2003/01/15 13:16:47  mohor
-- When a frame with "remote request" is received, no data is stored to
-- fifo, just the frame information (identifier, ...). Data length that
-- is stored is the received data length and not the actual data length
-- that is stored to fifo.
--
-- Revision 1.9  2003/01/14 12:19:35  mohor
-- rx_fifo is now working.
--
-- Revision 1.8  2003/01/10 17:51:33  mohor
-- Temporary version (backup).
--
-- Revision 1.7  2003/01/09 21:54:45  mohor
-- rx fifo added. Not 100 % verified, yet.
--
-- Revision 1.6  2003/01/09 14:46:58  mohor
-- Temporary files (backup).
--
-- Revision 1.5  2003/01/08 13:30:31  mohor
-- Temp version.
--
-- Revision 1.4  2003/01/08 02:10:53  mohor
-- Acceptance filter added.
--
-- Revision 1.3  2002/12/28 04:13:23  mohor
-- Backup version.
--
-- Revision 1.2  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_bsp IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      sample_point            : IN std_logic;
      sampled_bit             : IN std_logic;
      sampled_bit_q           : IN std_logic;
      tx_point                : IN std_logic;
      hard_sync               : IN std_logic;
      addr                    : IN std_logic_vector(7 DOWNTO 0);
      data_in                 : IN std_logic_vector(7 DOWNTO 0);
      data_out                : OUT std_logic_vector(7 DOWNTO 0);
      fifo_selected           : IN std_logic;
      reset_mode              : IN std_logic;
      listen_only_mode        : IN std_logic;
      acceptance_filter_mode  : IN std_logic;
      self_test_mode          : IN std_logic;
      -- Command register
      release_buffer          : IN std_logic;
      tx_request              : IN std_logic;
      abort_tx                : IN std_logic;
      self_rx_request         : IN std_logic;
      single_shot_transmission: IN std_logic;
      tx_state                : OUT std_logic;
      tx_state_q              : OUT std_logic;
      overload_request        : IN std_logic;   --  When receiver is busy, it needs to send overload frame. Only 2 overload frames are allowed to
      overload_frame          : OUT std_logic;   --  be send in a row. This is not implemented, yet,  because host can not send an overload request.
      -- Arbitration Lost Capture Register
      read_arbitration_lost_capture_reg: IN std_logic;
      -- Error Code Capture Register
      read_error_code_capture_reg: IN std_logic;
      error_capture_code      : OUT std_logic_vector(7 DOWNTO 0);
      -- Error Warning Limit register
      error_warning_limit     : IN std_logic_vector(7 DOWNTO 0);
      -- Rx Error Counter register
      we_rx_err_cnt           : IN std_logic;
      -- Tx Error Counter register
      we_tx_err_cnt           : IN std_logic;
      extended_mode           : IN std_logic;
      rx_idle                 : OUT std_logic;
      transmitting            : OUT std_logic;
      transmitter             : OUT std_logic;
      go_rx_inter             : OUT std_logic;
      not_first_bit_of_inter  : OUT std_logic;
      rx_inter                : OUT std_logic;
      set_reset_mode          : OUT std_logic;
      node_bus_off            : OUT std_logic;
      error_status            : OUT std_logic;
      rx_err_cnt              : OUT std_logic_vector(8 DOWNTO 0);
      tx_err_cnt              : OUT std_logic_vector(8 DOWNTO 0);
      transmit_status         : OUT std_logic;
      receive_status          : OUT std_logic;
      tx_successful           : OUT std_logic;
      need_to_tx              : OUT std_logic;
      overrun                 : OUT std_logic;
      info_empty              : OUT std_logic;
      set_bus_error_irq       : OUT std_logic;
      set_arbitration_lost_irq: OUT std_logic;
      arbitration_lost_capture: OUT std_logic_vector(4 DOWNTO 0);
      node_error_passive      : OUT std_logic;
      node_error_active       : OUT std_logic;
      rx_message_counter      : OUT std_logic_vector(6 DOWNTO 0);
      -- This section is for BASIC and EXTENDED mode -- Acceptance code register
      acceptance_code_0       : IN std_logic_vector(7 DOWNTO 0);
      -- Acceptance mask register
      acceptance_mask_0       : IN std_logic_vector(7 DOWNTO 0);
      -- End: This section is for BASIC and EXTENDED mode -- This section is for EXTENDED mode -- Acceptance code register
      acceptance_code_1       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_code_2       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_code_3       : IN std_logic_vector(7 DOWNTO 0);
      -- Acceptance mask register
      acceptance_mask_1       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_2       : IN std_logic_vector(7 DOWNTO 0);
      acceptance_mask_3       : IN std_logic_vector(7 DOWNTO 0);
      -- End: This section is for EXTENDED mode -- Tx data registers. Holding identifier (basic mode), tx frame information (extended mode) and data
      tx_data_0               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_1               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_2               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_3               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_4               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_5               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_6               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_7               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_8               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_9               : IN std_logic_vector(7 DOWNTO 0);
      tx_data_10              : IN std_logic_vector(7 DOWNTO 0);
      tx_data_11              : IN std_logic_vector(7 DOWNTO 0);
      tx_data_12              : IN std_logic_vector(7 DOWNTO 0);
      -- End: Tx data registers -- Tx signal
      tx                      : OUT std_logic;
      tx_next                 : OUT std_logic;
      bus_off_on              : OUT std_logic;
      go_overload_frame       : OUT std_logic;
      go_error_frame          : OUT std_logic;
      go_tx                   : OUT std_logic;
      send_ack                : OUT std_logic;
      -- Bist -- port connections for Ram
--64x8

      q_dp_64x8               : IN std_logic_vector(7 DOWNTO 0);
      data_64x8               : OUT std_logic_vector(7 DOWNTO 0);
      wren_64x8               : OUT std_logic;
      rden_64x8               : OUT std_logic;
      wraddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      --64x4

      q_dp_64x4               : IN std_logic_vector(3 DOWNTO 0);
      data_64x4               : OUT std_logic_vector(3 DOWNTO 0);
      wren_64x4x1             : OUT std_logic;
      wraddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      --64x1

      q_dp_64x1               : IN std_logic;
      data_64x1               : OUT std_logic);
END ENTITY can_bsp;

ARCHITECTURE RTL OF can_bsp IS

   COMPONENT can_acf
      PORT (
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         id                      : IN  std_logic_vector(28 DOWNTO 0);
         reset_mode              : IN  std_logic;
         acceptance_filter_mode  : IN  std_logic;
         extended_mode           : IN  std_logic;
         acceptance_code_0       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_1       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_2       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_3       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_0       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_1       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_2       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_3       : IN  std_logic_vector(7 DOWNTO 0);
         go_rx_crc_lim           : IN  std_logic;
         go_rx_inter             : IN  std_logic;
         go_error_frame          : IN  std_logic;
         data0                   : IN  std_logic_vector(7 DOWNTO 0);
         data1                   : IN  std_logic_vector(7 DOWNTO 0);
         rtr1                    : IN  std_logic;
         rtr2                    : IN  std_logic;
         ide                     : IN  std_logic;
         no_byte0                : IN  std_logic;
         no_byte1                : IN  std_logic;
         id_ok                   : OUT std_logic);
   END COMPONENT;

   COMPONENT can_crc
      PORT (
         clk                     : IN  std_logic;
         data                    : IN  std_logic;
         enable                  : IN  std_logic;
         initialize              : IN  std_logic;
         crc                     : OUT std_logic_vector(14 DOWNTO 0));
   END COMPONENT;

   COMPONENT can_fifo
      PORT (
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         wr                      : IN  std_logic;
         data_in                 : IN  std_logic_vector(7 DOWNTO 0);
         addr                    : IN  std_logic_vector(5 DOWNTO 0);
         data_out                : OUT std_logic_vector(7 DOWNTO 0);
         fifo_selected           : IN  std_logic;
         reset_mode              : IN  std_logic;
         release_buffer          : IN  std_logic;
         extended_mode           : IN  std_logic;
         overrun                 : OUT std_logic;
         info_empty              : OUT std_logic;
         info_cnt                : OUT std_logic_vector(6 DOWNTO 0);
         q_dp_64x8               : IN  std_logic_vector(7 DOWNTO 0);
         data_64x8               : OUT std_logic_vector(7 DOWNTO 0);
         wren_64x8               : OUT std_logic;
         rden_64x8               : OUT std_logic;
         wraddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
         rdaddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
         q_dp_64x4               : IN  std_logic_vector(3 DOWNTO 0);
         data_64x4               : OUT std_logic_vector(3 DOWNTO 0);
         wren_64x4x1             : OUT std_logic;
         wraddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
         rdaddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
         q_dp_64x1               : IN  std_logic;
         data_64x1               : OUT std_logic);
   END COMPONENT;

   COMPONENT can_ibo
      PORT (
         di                      : IN  std_logic_vector(7 DOWNTO 0);
         do                      : OUT std_logic_vector(7 DOWNTO 0));
   END COMPONENT;

   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   ------------------------------
   SIGNAL reset_mode_q             :  std_logic;
   SIGNAL bit_cnt                  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_len                 :  std_logic_vector(3 DOWNTO 0);
   SIGNAL id                       :  std_logic_vector(28 DOWNTO 0);
   SIGNAL bit_stuff_cnt            :  std_logic_vector(2 DOWNTO 0);
   SIGNAL bit_stuff_cnt_tx         :  std_logic_vector(2 DOWNTO 0);
   SIGNAL tx_point_q               :  std_logic;
   SIGNAL rx_id1                   :  std_logic;
   SIGNAL rx_rtr1                  :  std_logic;
   SIGNAL rx_ide                   :  std_logic;
   SIGNAL rx_id2                   :  std_logic;
   SIGNAL rx_rtr2                  :  std_logic;
   SIGNAL rx_r1                    :  std_logic;
   SIGNAL rx_r0                    :  std_logic;
   SIGNAL rx_dlc                   :  std_logic;
   SIGNAL rx_data                  :  std_logic;
   SIGNAL rx_crc                   :  std_logic;
   SIGNAL rx_crc_lim               :  std_logic;
   SIGNAL rx_ack                   :  std_logic;
   SIGNAL rx_ack_lim               :  std_logic;
   SIGNAL rx_eof                   :  std_logic;
   SIGNAL go_early_tx_latched      :  std_logic;
   SIGNAL rtr1                     :  std_logic;
   SIGNAL ide                      :  std_logic;
   SIGNAL rtr2                     :  std_logic;
   SIGNAL crc_in                   :  std_logic_vector(14 DOWNTO 0);
   SIGNAL tmp_data                 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tmp_fifo                 :  xhdl_46;
   SIGNAL write_data_to_tmp_fifo   :  std_logic;
   SIGNAL byte_cnt                 :  std_logic_vector(2 DOWNTO 0);
   SIGNAL bit_stuff_cnt_en         :  std_logic;
   SIGNAL crc_enable               :  std_logic;
   SIGNAL eof_cnt                  :  std_logic_vector(2 DOWNTO 0);
   SIGNAL passive_cnt              :  std_logic_vector(2 DOWNTO 0);
   SIGNAL error_frame              :  std_logic;
   SIGNAL enable_error_cnt2        :  std_logic;
   SIGNAL error_cnt1               :  std_logic_vector(2 DOWNTO 0);
   SIGNAL error_cnt2               :  std_logic_vector(2 DOWNTO 0);
   SIGNAL delayed_dominant_cnt     :  std_logic_vector(2 DOWNTO 0);
   SIGNAL enable_overload_cnt2     :  std_logic;
   SIGNAL overload_frame_blocked   :  std_logic;
   SIGNAL overload_request_cnt     :  std_logic_vector(1 DOWNTO 0);
   SIGNAL overload_cnt1            :  std_logic_vector(2 DOWNTO 0);
   SIGNAL overload_cnt2            :  std_logic_vector(2 DOWNTO 0);
   SIGNAL crc_err                  :  std_logic;
   SIGNAL arbitration_lost         :  std_logic;
   SIGNAL arbitration_lost_q       :  std_logic;
   SIGNAL read_arbitration_lost_capture_reg_q:  std_logic;
   signal read_error_code_capture_reg_q : std_logic;
   signal reset_error_code_capture_reg : std_logic;
   SIGNAL arbitration_cnt_en       :  std_logic;
   SIGNAL arbitration_blocked      :  std_logic;
   SIGNAL tx_q                     :  std_logic;
   SIGNAL data_cnt                 :  std_logic_vector(3 DOWNTO 0);   --  Counting the data bytes that are written to FIFO
   SIGNAL header_cnt               :  std_logic_vector(2 DOWNTO 0);   --  Counting header length
   SIGNAL wr_fifo                  :  std_logic;   --  Write data and header to 64-byte fifo
   SIGNAL data_for_fifo            :  std_logic_vector(7 DOWNTO 0);   --  Multiplexed data that is stored to 64-byte fifo
   SIGNAL tx_pointer               :  std_logic_vector(5 DOWNTO 0);
   SIGNAL tx_bit                   :  std_logic;
   SIGNAL finish_msg               :  std_logic;
   SIGNAL bus_free_cnt             :  std_logic_vector(3 DOWNTO 0);
   SIGNAL bus_free_cnt_en          :  std_logic;
   SIGNAL bus_free                 :  std_logic;
   SIGNAL waiting_for_bus_free     :  std_logic;
   SIGNAL node_bus_off_q           :  std_logic;
   SIGNAL ack_err_latched          :  std_logic;
   SIGNAL bit_err_latched          :  std_logic;
   SIGNAL stuff_err_latched        :  std_logic;
   SIGNAL form_err_latched         :  std_logic;
   SIGNAL rule3_exc1_1             :  std_logic;
   SIGNAL rule3_exc1_2             :  std_logic;
   SIGNAL suspend                  :  std_logic;
   SIGNAL susp_cnt_en              :  std_logic;
   SIGNAL susp_cnt                 :  std_logic_vector(2 DOWNTO 0);
   SIGNAL error_flag_over_latched  :  std_logic;
   SIGNAL error_capture_code_type  :  std_logic_vector(7 DOWNTO 6);
   SIGNAL error_capture_code_blocked      :  std_logic;
   SIGNAL first_compare_bit        :  std_logic;
   SIGNAL error_capture_code_segment      :  std_logic_vector(4 DOWNTO 0);
   SIGNAL error_capture_code_direction    :  std_logic;
   SIGNAL bit_de_stuff             :  std_logic;
   SIGNAL bit_de_stuff_tx          :  std_logic;
   SIGNAL rule5                    :  std_logic;
   -- Rx state machine
   SIGNAL go_rx_idle               :  std_logic;
   SIGNAL go_rx_id1                :  std_logic;
   SIGNAL go_rx_rtr1               :  std_logic;
   SIGNAL go_rx_ide                :  std_logic;
   SIGNAL go_rx_id2                :  std_logic;
   SIGNAL go_rx_rtr2               :  std_logic;
   SIGNAL go_rx_r1                 :  std_logic;
   SIGNAL go_rx_r0                 :  std_logic;
   SIGNAL go_rx_dlc                :  std_logic;
   SIGNAL go_rx_data               :  std_logic;
   SIGNAL go_rx_crc                :  std_logic;
   SIGNAL go_rx_crc_lim            :  std_logic;
   SIGNAL go_rx_ack                :  std_logic;
   SIGNAL go_rx_ack_lim            :  std_logic;
   SIGNAL go_rx_eof                :  std_logic;
   SIGNAL last_bit_of_inter        :  std_logic;
   SIGNAL go_crc_enable            :  std_logic;
   SIGNAL rst_crc_enable           :  std_logic;
   SIGNAL bit_de_stuff_set         :  std_logic;
   SIGNAL bit_de_stuff_reset       :  std_logic;
   SIGNAL go_early_tx              :  std_logic;
   SIGNAL calculated_crc           :  std_logic_vector(14 DOWNTO 0);
   SIGNAL r_calculated_crc         :  std_logic_vector(15 DOWNTO 0);
   SIGNAL remote_rq                :  std_logic;
   SIGNAL limited_data_len         :  std_logic_vector(3 DOWNTO 0);
   SIGNAL form_err                 :  std_logic;
   SIGNAL error_frame_ended        :  std_logic;
   SIGNAL overload_frame_ended     :  std_logic;
   SIGNAL bit_err                  :  std_logic;
   SIGNAL ack_err                  :  std_logic;
   SIGNAL stuff_err                :  std_logic;
   SIGNAL id_ok                    :  std_logic;   --  If received ID matches ID set in registers
   SIGNAL no_byte0                 :  std_logic;   --  There is no byte 0 (RTR bit set to 1 or DLC field equal to 0). Signal used for acceptance filter.
   SIGNAL no_byte1                 :  std_logic;   --  There is no byte 1 (RTR bit set to 1 or DLC field equal to 1). Signal used for acceptance filter.
   SIGNAL header_len               :  std_logic_vector(2 DOWNTO 0);
   SIGNAL storing_header           :  std_logic;
   SIGNAL limited_data_len_minus1  :  std_logic_vector(3 DOWNTO 0);
   SIGNAL reset_wr_fifo            :  std_logic;
   SIGNAL err                      :  std_logic;
   SIGNAL arbitration_field        :  std_logic;
   SIGNAL basic_chain              :  std_logic_vector(18 DOWNTO 0);
   SIGNAL basic_chain_data         :  std_logic_vector(63 DOWNTO 0);
   SIGNAL extended_chain_std       :  std_logic_vector(18 DOWNTO 0);
   SIGNAL extended_chain_ext       :  std_logic_vector(38 DOWNTO 0);
   SIGNAL extended_chain_data_std  :  std_logic_vector(63 DOWNTO 0);
   SIGNAL extended_chain_data_ext  :  std_logic_vector(63 DOWNTO 0);
   SIGNAL rst_tx_pointer           :  std_logic;
   SIGNAL r_tx_data_0              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_1              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_2              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_3              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_4              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_5              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_6              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_7              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_8              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_9              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_10             :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_11             :  std_logic_vector(7 DOWNTO 0);
   SIGNAL r_tx_data_12             :  std_logic_vector(7 DOWNTO 0);
   SIGNAL bit_err_exc1             :  std_logic;
   SIGNAL bit_err_exc2             :  std_logic;
   SIGNAL bit_err_exc3             :  std_logic;
   SIGNAL bit_err_exc4             :  std_logic;
   SIGNAL bit_err_exc5             :  std_logic;
   SIGNAL bit_err_exc6             :  std_logic;
   SIGNAL error_flag_over          :  std_logic;
   SIGNAL overload_flag_over       :  std_logic;
   SIGNAL limited_tx_cnt_ext       :  std_logic_vector(5 DOWNTO 0);
   SIGNAL limited_tx_cnt_std       :  std_logic_vector(5 DOWNTO 0);
   -- port connections for Ram
   --64x8
   SIGNAL w_q_dp_64x8              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL w_data_64x8              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL w_wren_64x8              :  std_logic;
   SIGNAL w_rden_64x8              :  std_logic;
   SIGNAL w_wraddress_64x8         :  std_logic_vector(5 DOWNTO 0);
   SIGNAL w_rdaddress_64x8         :  std_logic_vector(5 DOWNTO 0);
   --64x4
   SIGNAL w_q_dp_64x4              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL w_data_64x4              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL w_wren_64x4x1            :  std_logic;
   SIGNAL w_wraddress_64x4x1       :  std_logic_vector(5 DOWNTO 0);
   SIGNAL w_rdaddress_64x4x1       :  std_logic_vector(5 DOWNTO 0);
   --64x1
   SIGNAL w_q_dp_64x1              :  std_logic;
   SIGNAL w_data_64x1              :  std_logic;
   SIGNAL temp_xhdl47              :  std_logic_vector(3 DOWNTO 0);
   -- Instantiation of the RX CRC module
   SIGNAL xhdl_49                  :  std_logic;
   -- Mode register
   -- Clock Divider register
   -- This section is for BASIC and EXTENDED mode
   -- Acceptance code register
   -- Acceptance mask register
   -- End: This section is for BASIC and EXTENDED mode
   -- This section is for EXTENDED mode
   -- Acceptance code register
   -- Acceptance mask register
   -- End: This section is for EXTENDED mode
   SIGNAL port_xhdl73              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL port_xhdl74              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL temp_xhdl75              :  std_logic_vector(2 DOWNTO 0);
   SIGNAL temp_xhdl76              :  std_logic_vector(2 DOWNTO 0);
   SIGNAL temp_xhdl77              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL temp_xhdl78              :  std_logic_vector(3 DOWNTO 0);   --  - 1 because counter counts from 0
   SIGNAL xhdl_106                 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL temp_xhdl108             :  std_logic_vector(5 DOWNTO 0);
   SIGNAL temp_xhdl109             :  std_logic_vector(5 DOWNTO 0);
   SIGNAL temp_xhdl110             :  boolean;
   SIGNAL temp_xhdl111             :  std_logic;
   SIGNAL data_out_xhdl1           :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_state_xhdl2           :  std_logic;
   SIGNAL tx_state_q_xhdl3         :  std_logic;
   SIGNAL overload_frame_xhdl4     :  std_logic;
   SIGNAL error_capture_code_xhdl5 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL rx_idle_xhdl6            :  std_logic;
   SIGNAL transmitting_xhdl7       :  std_logic;
   SIGNAL transmitter_xhdl8        :  std_logic;
   SIGNAL go_rx_inter_xhdl9        :  std_logic;
   SIGNAL not_first_bit_of_inter_xhdl10   :  std_logic;
   SIGNAL rx_inter_xhdl11          :  std_logic;
   SIGNAL set_reset_mode_xhdl12    :  std_logic;
   SIGNAL node_bus_off_xhdl13      :  std_logic;
   SIGNAL error_status_xhdl14      :  std_logic;
   SIGNAL rx_err_cnt_xhdl15        :  std_logic_vector(8 DOWNTO 0);
   SIGNAL tx_err_cnt_xhdl16        :  std_logic_vector(8 DOWNTO 0);
   SIGNAL transmit_status_xhdl17   :  std_logic;
   SIGNAL receive_status_xhdl18    :  std_logic;
   SIGNAL tx_successful_xhdl19     :  std_logic;
   SIGNAL need_to_tx_xhdl20        :  std_logic;
   SIGNAL overrun_xhdl21           :  std_logic;
   SIGNAL info_empty_xhdl22        :  std_logic;
   SIGNAL set_bus_error_irq_xhdl23 :  std_logic;
   SIGNAL set_arbitration_lost_irq_xhdl24 :  std_logic;
   SIGNAL arbitration_lost_capture_xhdl25 :  std_logic_vector(4 DOWNTO 0);
   SIGNAL node_error_passive_xhdl26:  std_logic;
   SIGNAL node_error_active_xhdl27 :  std_logic;
   SIGNAL rx_message_counter_xhdl28:  std_logic_vector(6 DOWNTO 0);
   SIGNAL tx_xhdl29                :  std_logic;
   SIGNAL tx_next_xhdl30           :  std_logic;
   SIGNAL bus_off_on_xhdl31        :  std_logic;
   SIGNAL go_overload_frame_xhdl32 :  std_logic;
   SIGNAL go_error_frame_xhdl33    :  std_logic;
   SIGNAL go_tx_xhdl34             :  std_logic;
   SIGNAL send_ack_xhdl35          :  std_logic;
   SIGNAL data_64x8_xhdl36         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL wren_64x8_xhdl37         :  std_logic;
   SIGNAL rden_64x8_xhdl38         :  std_logic;
   SIGNAL wraddress_64x8_xhdl39    :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x8_xhdl40    :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x4_xhdl41         :  std_logic_vector(3 DOWNTO 0);
   SIGNAL wren_64x4x1_xhdl42       :  std_logic;
   SIGNAL wraddress_64x4x1_xhdl43  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x4x1_xhdl44  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x1_xhdl45         :  std_logic;

BEGIN
   data_out <= data_out_xhdl1;
   tx_state <= tx_state_xhdl2;
   tx_state_q <= tx_state_q_xhdl3;
   overload_frame <= overload_frame_xhdl4;
   error_capture_code <= error_capture_code_xhdl5;
   rx_idle <= rx_idle_xhdl6;
   transmitting <= transmitting_xhdl7;
   transmitter <= transmitter_xhdl8;
   go_rx_inter <= go_rx_inter_xhdl9;
   not_first_bit_of_inter <= not_first_bit_of_inter_xhdl10;
   rx_inter <= rx_inter_xhdl11;
   set_reset_mode <= set_reset_mode_xhdl12;
   node_bus_off <= node_bus_off_xhdl13;
   error_status <= error_status_xhdl14;
   rx_err_cnt <= rx_err_cnt_xhdl15;
   tx_err_cnt <= tx_err_cnt_xhdl16;
   transmit_status <= transmit_status_xhdl17;
   receive_status <= receive_status_xhdl18;
   tx_successful <= tx_successful_xhdl19;
   need_to_tx <= need_to_tx_xhdl20;
   overrun <= overrun_xhdl21;
   info_empty <= info_empty_xhdl22;
   set_bus_error_irq <= set_bus_error_irq_xhdl23;
   set_arbitration_lost_irq <= set_arbitration_lost_irq_xhdl24;
   arbitration_lost_capture <= arbitration_lost_capture_xhdl25;
   node_error_passive <= node_error_passive_xhdl26;
   node_error_active <= node_error_active_xhdl27;
   rx_message_counter <= rx_message_counter_xhdl28;
   tx <= tx_xhdl29;
   tx_next <= tx_next_xhdl30;
   bus_off_on <= bus_off_on_xhdl31;
   go_overload_frame <= go_overload_frame_xhdl32;
   go_error_frame <= go_error_frame_xhdl33;
   go_tx <= go_tx_xhdl34;
   send_ack <= send_ack_xhdl35;
   data_64x8 <= data_64x8_xhdl36;
   wren_64x8 <= wren_64x8_xhdl37;
   rden_64x8 <= rden_64x8_xhdl38;
   wraddress_64x8 <= wraddress_64x8_xhdl39;
   rdaddress_64x8 <= rdaddress_64x8_xhdl40;
   data_64x4 <= data_64x4_xhdl41;
   wren_64x4x1 <= wren_64x4x1_xhdl42;
   wraddress_64x4x1 <= wraddress_64x4x1_xhdl43;
   rdaddress_64x4x1 <= rdaddress_64x4x1_xhdl44;
   data_64x1 <= data_64x1_xhdl45;
   -- port connections for Ram
   --64x8
   w_q_dp_64x8 <= q_dp_64x8 ;
   data_64x8_xhdl36 <= w_data_64x8 ;
   wren_64x8_xhdl37 <= w_wren_64x8 ;
   rden_64x8_xhdl38 <= w_rden_64x8 ;
   wraddress_64x8_xhdl39 <= w_wraddress_64x8 ;
   rdaddress_64x8_xhdl40 <= w_rdaddress_64x8 ;
   --64x4
   w_q_dp_64x4 <= q_dp_64x4 ;
   data_64x4_xhdl41 <= w_data_64x4 ;
   wren_64x4x1_xhdl42 <= w_wren_64x4x1 ;
   wraddress_64x4x1_xhdl43 <= w_wraddress_64x4x1 ;
   rdaddress_64x4x1_xhdl44 <= w_rdaddress_64x4x1 ;
   --64x1
   w_q_dp_64x1 <= q_dp_64x1 ;
   data_64x1_xhdl45 <= w_data_64x1 ;
   -- ----------------------
   go_rx_idle <= ((sample_point AND sampled_bit) AND last_bit_of_inter) OR (bus_free AND (NOT node_bus_off_xhdl13)) ;
   go_rx_id1 <= (sample_point AND (NOT sampled_bit)) AND (rx_idle_xhdl6 OR last_bit_of_inter) ;
   go_rx_rtr1 <= (((NOT bit_de_stuff) AND sample_point) AND rx_id1) AND CONV_STD_LOGIC(bit_cnt(3 DOWNTO 0) = "1010") ;
   go_rx_ide <= ((NOT bit_de_stuff) AND sample_point) AND rx_rtr1 ;
   go_rx_id2 <= (((NOT bit_de_stuff) AND sample_point) AND rx_ide) AND sampled_bit ;
   go_rx_rtr2 <= (((NOT bit_de_stuff) AND sample_point) AND rx_id2) AND CONV_STD_LOGIC(bit_cnt(4 DOWNTO 0) = "10001") ;
   go_rx_r1 <= ((NOT bit_de_stuff) AND sample_point) AND rx_rtr2 ;
   go_rx_r0 <= ((NOT bit_de_stuff) AND sample_point) AND ((rx_ide AND (NOT sampled_bit)) OR rx_r1) ;
   go_rx_dlc <= ((NOT bit_de_stuff) AND sample_point) AND rx_r0 ;
   go_rx_data <= (((((NOT bit_de_stuff) AND sample_point) AND rx_dlc) AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) = "11")) AND (sampled_bit OR (orv(data_len(2 DOWNTO 0))))) AND (NOT remote_rq) ;
--##   go_rx_crc <= ((NOT bit_de_stuff) AND sample_point) AND (((rx_dlc AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) = "11")) AND (((NOT sampled_bit) AND (NOT (orv(data_len(2 DOWNTO 0))))) OR remote_rq)) OR (rx_data AND CONV_STD_LOGIC('0' & bit_cnt(5 DOWNTO 0) = ((limited_data_len & "000") - 1)))) ;
   go_rx_crc <= ((NOT bit_de_stuff) AND sample_point) AND (((rx_dlc AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) = "11")) AND (((NOT sampled_bit) AND (NOT (orv(data_len(2 DOWNTO 0))))) OR remote_rq)) OR (rx_data AND CONV_STD_LOGIC(('0' & bit_cnt(5 DOWNTO 0)) = ((limited_data_len & "000") - 1)))) ;
   go_rx_crc_lim <= (((NOT bit_de_stuff) AND sample_point) AND rx_crc) AND CONV_STD_LOGIC(bit_cnt(3 DOWNTO 0) = "1110") ;
   go_rx_ack <= ((NOT bit_de_stuff) AND sample_point) AND rx_crc_lim ;
   go_rx_ack_lim <= sample_point AND rx_ack ;
   go_rx_eof <= sample_point AND rx_ack_lim ;
   go_rx_inter_xhdl9 <= (((sample_point AND rx_eof) AND CONV_STD_LOGIC(eof_cnt = "110")) OR error_frame_ended OR overload_frame_ended) AND (NOT overload_request) ;
   go_error_frame_xhdl33 <= form_err OR stuff_err OR bit_err OR ack_err OR (crc_err AND go_rx_eof) ;
   error_frame_ended <= CONV_STD_LOGIC(error_cnt2 = "111") AND tx_point ;
   overload_frame_ended <= CONV_STD_LOGIC(overload_cnt2 = "111") AND tx_point ;
   go_overload_frame_xhdl32 <= (((sample_point AND ((NOT sampled_bit) OR overload_request)) AND (((rx_eof AND (NOT transmitter_xhdl8)) AND CONV_STD_LOGIC(eof_cnt = "110")) OR error_frame_ended OR overload_frame_ended)) OR (((sample_point AND (NOT sampled_bit)) AND rx_inter_xhdl11) AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) < "10")) OR ((sample_point AND (NOT sampled_bit)) AND CONV_STD_LOGIC((error_cnt2 = "111") OR (overload_cnt2 = "111")))) AND (NOT overload_frame_blocked) ;
   go_crc_enable <= hard_sync OR go_tx_xhdl34 ;
   rst_crc_enable <= go_rx_crc ;
   bit_de_stuff_set <= go_rx_id1 AND (NOT go_error_frame_xhdl33) ;
   bit_de_stuff_reset <= go_rx_ack OR reset_mode OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32 ;
   remote_rq <= ((NOT ide) AND rtr1) OR (ide AND rtr2) ;
   temp_xhdl47 <= data_len WHEN (data_len < "1000") ELSE "1000";
   limited_data_len <= temp_xhdl47 ;
   ack_err <= (((rx_ack AND sample_point) AND sampled_bit) AND tx_state_xhdl2) AND (NOT self_test_mode) ;
   bit_err <= ((((((((tx_state_xhdl2 OR error_frame OR overload_frame_xhdl4 OR rx_ack) AND sample_point) AND CONV_STD_LOGIC(tx_xhdl29 /= sampled_bit)) AND (NOT bit_err_exc1)) AND (NOT bit_err_exc2)) AND (NOT bit_err_exc3)) AND (NOT bit_err_exc4)) AND (NOT bit_err_exc5)) AND (NOT bit_err_exc6) ;
   bit_err_exc1 <= (tx_state_xhdl2 AND arbitration_field) AND tx_xhdl29 ;
   bit_err_exc2 <= rx_ack AND tx_xhdl29 ;
   bit_err_exc3 <= (error_frame AND node_error_passive_xhdl26) AND CONV_STD_LOGIC(error_cnt1 < "111") ;
   bit_err_exc4 <= ((error_frame AND CONV_STD_LOGIC(error_cnt1 = "111")) AND (NOT enable_error_cnt2)) OR ((overload_frame_xhdl4 AND CONV_STD_LOGIC(overload_cnt1 = "111")) AND (NOT enable_overload_cnt2)) ;
   bit_err_exc5 <= (error_frame AND CONV_STD_LOGIC(error_cnt2 = "111")) OR (overload_frame_xhdl4 AND CONV_STD_LOGIC(overload_cnt2 = "111")) ;
   bit_err_exc6 <= (CONV_STD_LOGIC(eof_cnt = "110") AND rx_eof) AND (NOT transmitter_xhdl8) ;
   arbitration_field <= rx_id1 OR rx_rtr1 OR rx_ide OR rx_id2 OR rx_rtr2 ;
   last_bit_of_inter <= rx_inter_xhdl11 AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) = "10") ;
   not_first_bit_of_inter_xhdl10 <= rx_inter_xhdl11 AND CONV_STD_LOGIC(bit_cnt(1 DOWNTO 0) /= "00") ;

   -- Rx idle state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_idle_xhdl6 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_id1 OR go_error_frame_xhdl33) = '1') THEN
            rx_idle_xhdl6 <= '0' ;
         ELSE
            IF (go_rx_idle = '1') THEN
               rx_idle_xhdl6 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx id1 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_id1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_rtr1 OR go_error_frame_xhdl33) = '1') THEN
            rx_id1 <= '0' ;
         ELSE
            IF (go_rx_id1 = '1') THEN
               rx_id1 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx rtr1 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_rtr1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_ide OR go_error_frame_xhdl33) = '1') THEN
            rx_rtr1 <= '0' ;
         ELSE
            IF (go_rx_rtr1 = '1') THEN
               rx_rtr1 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx ide state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_ide <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_r0 OR go_rx_id2 OR go_error_frame_xhdl33) = '1') THEN
            rx_ide <= '0' ;
         ELSE
            IF (go_rx_ide = '1') THEN
               rx_ide <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx id2 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_id2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_rtr2 OR go_error_frame_xhdl33) = '1') THEN
            rx_id2 <= '0' ;
         ELSE
            IF (go_rx_id2 = '1') THEN
               rx_id2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx rtr2 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_rtr2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_r1 OR go_error_frame_xhdl33) = '1') THEN
            rx_rtr2 <= '0' ;
         ELSE
            IF (go_rx_rtr2 = '1') THEN
               rx_rtr2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx r0 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_r1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_r0 OR go_error_frame_xhdl33) = '1') THEN
            rx_r1 <= '0' ;
         ELSE
            IF (go_rx_r1 = '1') THEN
               rx_r1 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx r0 state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_r0 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_dlc OR go_error_frame_xhdl33) = '1') THEN
            rx_r0 <= '0' ;
         ELSE
            IF (go_rx_r0 = '1') THEN
               rx_r0 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx dlc state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_dlc <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_data OR go_rx_crc OR go_error_frame_xhdl33) = '1') THEN
            rx_dlc <= '0' ;
         ELSE
            IF (go_rx_dlc = '1') THEN
               rx_dlc <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx data state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_data <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_crc OR go_error_frame_xhdl33) = '1') THEN
            rx_data <= '0' ;
         ELSE
            IF (go_rx_data = '1') THEN
               rx_data <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx crc state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_crc <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_crc_lim OR go_error_frame_xhdl33) = '1') THEN
            rx_crc <= '0' ;
         ELSE
            IF (go_rx_crc = '1') THEN
               rx_crc <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx crc delimiter state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_crc_lim <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_ack OR go_error_frame_xhdl33) = '1') THEN
            rx_crc_lim <= '0' ;
         ELSE
            IF (go_rx_crc_lim = '1') THEN
               rx_crc_lim <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx ack state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_ack <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_ack_lim OR go_error_frame_xhdl33) = '1') THEN
            rx_ack <= '0' ;
         ELSE
            IF (go_rx_ack = '1') THEN
               rx_ack <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx ack delimiter state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_ack_lim <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_eof OR go_error_frame_xhdl33) = '1') THEN
            rx_ack_lim <= '0' ;
         ELSE
            IF (go_rx_ack_lim = '1') THEN
               rx_ack_lim <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rx eof state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_eof <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_inter_xhdl9 OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            rx_eof <= '0' ;
         ELSE
            IF (go_rx_eof = '1') THEN
               rx_eof <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Interframe space

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_inter_xhdl11 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_idle OR go_rx_id1 OR go_overload_frame_xhdl32 OR go_error_frame_xhdl33) = '1') THEN
            rx_inter_xhdl11 <= '0' ;
         ELSE
            IF (go_rx_inter_xhdl9 = '1') THEN
               rx_inter_xhdl11 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- ID register

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         id <= "00000000000000000000000000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            id <= "00000000000000000000000000000";
         ELSE
            IF (((sample_point AND (rx_id1 OR rx_id2)) AND (NOT bit_de_stuff)) = '1') THEN
               id <= id(27 DOWNTO 0) & sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- rtr1 bit

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rtr1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            rtr1 <= '0';
         ELSE
            IF (((sample_point AND rx_rtr1) AND (NOT bit_de_stuff)) = '1') THEN
               rtr1 <= sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- rtr2 bit

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rtr2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            rtr2 <= '0';
         ELSE
            IF (((sample_point AND rx_rtr2) AND (NOT bit_de_stuff)) = '1') THEN
               rtr2 <= sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- ide bit

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         ide <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            ide <= '0';
         ELSE
            IF (((sample_point AND rx_ide) AND (NOT bit_de_stuff)) = '1') THEN
               ide <= sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Data length

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         data_len <= "0000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            data_len <= "0000";
         ELSE
            IF (((sample_point AND rx_dlc) AND (NOT bit_de_stuff)) = '1') THEN
               data_len <= data_len(2 DOWNTO 0) & sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Data

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tmp_data <= "00000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            tmp_data <= "00000000";
         ELSE
            IF (((sample_point AND rx_data) AND (NOT bit_de_stuff)) = '1') THEN
               tmp_data <= tmp_data(6 DOWNTO 0) & sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         write_data_to_tmp_fifo <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            write_data_to_tmp_fifo <= '0';
         ELSE
            IF ((((sample_point AND rx_data) AND (NOT bit_de_stuff)) AND (andv(bit_cnt(2 DOWNTO 0)))) = '1') THEN
               write_data_to_tmp_fifo <= '1' ;
            ELSE
               write_data_to_tmp_fifo <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         byte_cnt <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            byte_cnt <= "000";
         ELSE
            IF (write_data_to_tmp_fifo = '1') THEN
               byte_cnt <= byte_cnt + "001" ;
            ELSE
--##               IF ((sample_point AND go_rx_crc_lim) = '1') THEN
               IF (((sample_point AND go_rx_crc_lim) or rx_dlc) = '1') then --## OpenCores: byte count when recovering from error frame
                  byte_cnt <= "000" ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         IF (write_data_to_tmp_fifo = '1') THEN
            tmp_fifo(conv_integer(byte_cnt)) <= tmp_data ;
         END IF;
      END IF;
   END PROCESS;

   -- CRC

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         crc_in <= "000000000000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            crc_in <= "000000000000000";
         ELSE
            IF (((sample_point AND rx_crc) AND (NOT bit_de_stuff)) = '1') THEN
               crc_in <= crc_in(13 DOWNTO 0) & sampled_bit ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- bit_cnt

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bit_cnt <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bit_cnt <= "000000";
         ELSE
            IF ((go_rx_id1 OR go_rx_id2 OR go_rx_dlc OR go_rx_data OR go_rx_crc OR go_rx_ack OR go_rx_eof OR go_rx_inter_xhdl9 OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
               bit_cnt <= "000000" ;
            ELSE
               IF ((sample_point AND (NOT bit_de_stuff)) = '1') THEN
                  bit_cnt <= bit_cnt + "000001" ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- eof_cnt

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         eof_cnt <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            eof_cnt <= "000";
         ELSE
            IF (sample_point = '1') THEN
               IF ((go_rx_inter_xhdl9 OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
                  eof_cnt <= "000" ;
               ELSE
                  IF (rx_eof = '1') THEN
                     eof_cnt <= eof_cnt + "001" ;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Enabling bit de-stuffing

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bit_stuff_cnt_en <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bit_stuff_cnt_en <= '0';
         ELSE
            IF (bit_de_stuff_set = '1') THEN
               bit_stuff_cnt_en <= '1' ;
            ELSE
               IF (bit_de_stuff_reset = '1') THEN
                  bit_stuff_cnt_en <= '0' ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- bit_stuff_cnt

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bit_stuff_cnt <= "001";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bit_stuff_cnt <= "001";
         ELSE
            IF (bit_de_stuff_reset = '1') THEN
               bit_stuff_cnt <= "001" ;
            ELSE
               IF ((sample_point AND bit_stuff_cnt_en) = '1') THEN
                  IF (bit_stuff_cnt = "101") THEN
                     bit_stuff_cnt <= "001" ;
                  ELSE
                     IF (sampled_bit = sampled_bit_q) THEN
                        bit_stuff_cnt <= bit_stuff_cnt + "001" ;
                     ELSE
                        bit_stuff_cnt <= "001" ;
                     END IF;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- bit_stuff_cnt_tx

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bit_stuff_cnt_tx <= "001";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bit_stuff_cnt_tx <= "001";
         ELSE
            IF (bit_de_stuff_reset = '1') THEN
               bit_stuff_cnt_tx <= "001" ;
            ELSE
               IF ((tx_point_q AND bit_stuff_cnt_en) = '1') THEN
                  IF (bit_stuff_cnt_tx = "101") THEN
                     bit_stuff_cnt_tx <= "001" ;
                  ELSE
                     IF (tx_xhdl29 = tx_q) THEN
                        bit_stuff_cnt_tx <= bit_stuff_cnt_tx + "001" ;
                     ELSE
                        bit_stuff_cnt_tx <= "001" ;
                     END IF;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   bit_de_stuff <= CONV_STD_LOGIC(bit_stuff_cnt = "101") ;
   bit_de_stuff_tx <= CONV_STD_LOGIC(bit_stuff_cnt_tx = "101") ;
   -- stuff_err
   stuff_err <= ((sample_point AND bit_stuff_cnt_en) AND bit_de_stuff) AND CONV_STD_LOGIC(sampled_bit = sampled_bit_q) ;

   -- Generating delayed signals

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         reset_mode_q <= '0' ;
         node_bus_off_q <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         reset_mode_q <= reset_mode ;
         node_bus_off_q <= node_bus_off_xhdl13 ;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         crc_enable <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR rst_crc_enable) = '1') THEN
            crc_enable <= '0' ;
         ELSE
            IF (go_crc_enable = '1') THEN
               crc_enable <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- CRC error generation

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         crc_err <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended) = '1') THEN
            crc_err <= '0' ;
         ELSE
            IF (go_rx_ack = '1') THEN
               crc_err <= CONV_STD_LOGIC(crc_in /= calculated_crc) ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   -- Conditions for form error
   form_err <= sample_point AND ((((NOT bit_de_stuff) AND rx_crc_lim) AND (NOT sampled_bit)) OR (rx_ack_lim AND (NOT sampled_bit)) OR (((CONV_STD_LOGIC(eof_cnt < "110") AND rx_eof) AND (NOT sampled_bit)) AND (NOT transmitter_xhdl8)) OR (((rx_eof) AND (NOT sampled_bit)) AND transmitter_xhdl8)) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         ack_err_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_overload_frame_xhdl32) = '1') THEN
            ack_err_latched <= '0' ;
         ELSE
            IF (ack_err = '1') THEN
               ack_err_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bit_err_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_overload_frame_xhdl32) = '1') THEN
            bit_err_latched <= '0' ;
         ELSE
            IF (bit_err = '1') THEN
               bit_err_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   -- Rule 5 (Fault confinement).
   rule5 <= bit_err AND ((((NOT node_error_passive_xhdl26) AND error_frame) AND CONV_STD_LOGIC(error_cnt1 < "111")) OR (overload_frame_xhdl4 AND CONV_STD_LOGIC(overload_cnt1 < "111"))) ;

   -- Rule 3 exception 1 - first part (Fault confinement).

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rule3_exc1_1 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_flag_over OR rule3_exc1_2) = '1') THEN
            rule3_exc1_1 <= '0' ;
         ELSE
            IF (((transmitter_xhdl8 AND node_error_passive_xhdl26) AND ack_err) = '1') THEN
               rule3_exc1_1 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Rule 3 exception 1 - second part (Fault confinement).

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rule3_exc1_2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_error_frame_xhdl33 OR rule3_exc1_2) = '1') THEN
            rule3_exc1_2 <= '0' ;
         ELSE
            IF ((((rule3_exc1_1 AND CONV_STD_LOGIC(error_cnt1 < "111")) AND sample_point) AND (NOT sampled_bit)) = '1') THEN
               rule3_exc1_2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         stuff_err_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_overload_frame_xhdl32) = '1') THEN
            stuff_err_latched <= '0' ;
         ELSE
            IF (stuff_err = '1') THEN
               stuff_err_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         form_err_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_overload_frame_xhdl32) = '1') THEN
            form_err_latched <= '0' ;
         ELSE
            IF (form_err = '1') THEN
               form_err_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   xhdl_49 <= ((crc_enable AND sample_point) AND (NOT bit_de_stuff));
   i_can_crc_rx : can_crc
      PORT MAP (
         clk => clk,
         data => sampled_bit,
         enable => xhdl_49,
         initialize => go_crc_enable,
         crc => calculated_crc);

   no_byte0 <= rtr1 OR CONV_STD_LOGIC(data_len < "0001") ;
   no_byte1 <= rtr1 OR CONV_STD_LOGIC(data_len < "0010") ;
   port_xhdl73 <= tmp_fifo(0);
   port_xhdl74 <= tmp_fifo(1);
   i_can_acf : can_acf
      PORT MAP (
         clk => clk,
         rst => rst,
         id => id,
         reset_mode => reset_mode,
         acceptance_filter_mode => acceptance_filter_mode,
         extended_mode => extended_mode,
         acceptance_code_0 => acceptance_code_0,
         acceptance_mask_0 => acceptance_mask_0,
         acceptance_code_1 => acceptance_code_1,
         acceptance_code_2 => acceptance_code_2,
         acceptance_code_3 => acceptance_code_3,
         acceptance_mask_1 => acceptance_mask_1,
         acceptance_mask_2 => acceptance_mask_2,
         acceptance_mask_3 => acceptance_mask_3,
         go_rx_crc_lim => go_rx_crc_lim,
         go_rx_inter => go_rx_inter_xhdl9,
         go_error_frame => go_error_frame_xhdl33,
         data0 => port_xhdl73,
         data1 => port_xhdl74,
         rtr1 => rtr1,
         rtr2 => rtr2,
         ide => ide,
         no_byte0 => no_byte0,
         no_byte1 => no_byte1,
         id_ok => id_ok);

   temp_xhdl75 <= "101" WHEN ide = '1' ELSE "011";
   temp_xhdl76 <= (temp_xhdl75) WHEN extended_mode = '1' ELSE "010";
   header_len(2 DOWNTO 0) <= temp_xhdl76 ;
   storing_header <= CONV_STD_LOGIC(header_cnt < header_len) ;
   temp_xhdl77 <= (data_len - "0001") WHEN (data_len < "1000") ELSE "0111";
   temp_xhdl78 <= "1111" WHEN remote_rq = '1' ELSE (temp_xhdl77);
   limited_data_len_minus1(3 DOWNTO 0) <= temp_xhdl78 ;
   reset_wr_fifo <= CONV_STD_LOGIC(data_cnt = (limited_data_len_minus1 + ('0' & header_len))) OR reset_mode ;
   err <= form_err OR stuff_err OR bit_err OR ack_err OR form_err_latched OR stuff_err_latched OR bit_err_latched OR ack_err_latched OR crc_err ;

   -- Write enable signal for 64-byte rx fifo

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         wr_fifo <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_wr_fifo = '1') THEN
            wr_fifo <= '0' ;
         ELSE
            IF ((((go_rx_inter_xhdl9 AND id_ok) AND (NOT error_frame_ended)) AND ((NOT tx_state_xhdl2) OR self_rx_request)) = '1') THEN
               wr_fifo <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Header counter. Header length depends on the mode of operation and frame format.

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         header_cnt <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_wr_fifo = '1') THEN
            header_cnt <= "000" ;
         ELSE
            IF ((wr_fifo AND storing_header) = '1') THEN
               header_cnt <= header_cnt + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Data counter. Length of the data is limited to 8 bytes.

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         data_cnt <= "0000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_wr_fifo = '1') THEN
            data_cnt <= "0000" ;
         ELSE
            IF (wr_fifo = '1') THEN
               data_cnt <= data_cnt + "0001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Multiplexing data that is stored to 64-byte fifo depends on the mode of operation and frame format

   PROCESS (extended_mode, ide, data_cnt, header_cnt, header_len, storing_header, id, rtr1, rtr2, data_len, tmp_fifo)
      VARIABLE data_for_fifo_xhdl79  : std_logic_vector(7 DOWNTO 0);
      VARIABLE temp_xhdl80  : std_logic_vector(5 DOWNTO 0);
   BEGIN
      temp_xhdl80 := storing_header & extended_mode & ide & header_cnt;
      IF (std_match(temp_xhdl80, "111000")) THEN
               data_for_fifo_xhdl79 := '1' & rtr2 & "00" & data_len;    --  extended mode, extended format header
      ELSIF (std_match(temp_xhdl80, "111001")) THEN
               data_for_fifo_xhdl79 := id(28 DOWNTO 21);    --  extended mode, extended format header
      ELSIF (std_match(temp_xhdl80, "111010")) THEN
               data_for_fifo_xhdl79 := id(20 DOWNTO 13);    --  extended mode, extended format header
      ELSIF (std_match(temp_xhdl80, "111011")) THEN
               data_for_fifo_xhdl79 := id(12 DOWNTO 5);    --  extended mode, extended format header
      ELSIF (std_match(temp_xhdl80, "111100")) THEN
               data_for_fifo_xhdl79 := id(4 DOWNTO 0) & rtr2 & "00";    --  extended mode, extended format header
      ELSIF (std_match(temp_xhdl80, "110000")) THEN
               data_for_fifo_xhdl79 := '0' & rtr1 & "00" & data_len;    --  extended mode, standard format header
      ELSIF (std_match(temp_xhdl80, "110001")) THEN
               data_for_fifo_xhdl79 := id(10 DOWNTO 3);    --  extended mode, standard format header
      ELSIF (std_match(temp_xhdl80, "110010")) THEN
               data_for_fifo_xhdl79 := id(2 DOWNTO 0) & rtr1 & "0000";    --  extended mode, standard format header
      ELSIF (std_match(temp_xhdl80, "10-000")) THEN
               data_for_fifo_xhdl79 := id(10 DOWNTO 3);    --  normal mode                    header
      ELSIF (std_match(temp_xhdl80, "10-001")) THEN
               data_for_fifo_xhdl79 := id(2 DOWNTO 0) & rtr1 & data_len;    --  normal mode                    header
      ELSE
               data_for_fifo_xhdl79 := tmp_fifo(conv_integer(data_cnt - ('0' & header_len)) mod 8);    --  data

      END IF;
      data_for_fifo <= data_for_fifo_xhdl79;
   END PROCESS;

   -- Instantiation of the RX fifo module
   -- port connections for Ram
   --64x8
   --64x4
   --64x1
   i_can_fifo : can_fifo
      PORT MAP (
         clk => clk,
         rst => rst,
         wr => wr_fifo,
         data_in => data_for_fifo,
         addr => addr(5 DOWNTO 0),
         data_out => data_out_xhdl1,
         fifo_selected => fifo_selected,
         reset_mode => reset_mode,
         release_buffer => release_buffer,
         extended_mode => extended_mode,
         overrun => overrun_xhdl21,
         info_empty => info_empty_xhdl22,
         info_cnt => rx_message_counter_xhdl28,
         q_dp_64x8 => w_q_dp_64x8,
         data_64x8 => w_data_64x8,
         wren_64x8 => w_wren_64x8,
         rden_64x8 => w_rden_64x8,
         wraddress_64x8 => w_wraddress_64x8,
         rdaddress_64x8 => w_rdaddress_64x8,
         q_dp_64x4 => w_q_dp_64x4,
         data_64x4 => w_data_64x4,
         wren_64x4x1 => w_wren_64x4x1,
         wraddress_64x4x1 => w_wraddress_64x4x1,
         rdaddress_64x4x1 => w_rdaddress_64x4x1,
         q_dp_64x1 => w_q_dp_64x1,
         data_64x1 => w_data_64x1);


   -- Transmitting error frame.

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_frame <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_overload_frame_xhdl32) = '1') THEN
            error_frame <= '0' ;
         ELSE
            IF (go_error_frame_xhdl33 = '1') THEN
               error_frame <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_cnt1 <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            error_cnt1 <= "000" ;
         ELSE
            IF (((error_frame AND tx_point) AND CONV_STD_LOGIC(error_cnt1 < "111")) = '1') THEN
               error_cnt1 <= error_cnt1 + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   error_flag_over <= ((((NOT node_error_passive_xhdl26) AND sample_point) AND CONV_STD_LOGIC(error_cnt1 = "111")) OR ((node_error_passive_xhdl26 AND sample_point) AND CONV_STD_LOGIC(passive_cnt = "110"))) AND (NOT enable_error_cnt2) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_flag_over_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            error_flag_over_latched <= '0' ;
         ELSE
            IF (error_flag_over = '1') THEN
               error_flag_over_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         enable_error_cnt2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            enable_error_cnt2 <= '0' ;
         ELSE
            IF ((error_frame AND (error_flag_over AND sampled_bit)) = '1') THEN
               enable_error_cnt2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_cnt2 <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            error_cnt2 <= "000" ;
         ELSE
            IF ((enable_error_cnt2 AND tx_point) = '1') THEN
               error_cnt2 <= error_cnt2 + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         delayed_dominant_cnt <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR enable_error_cnt2 OR go_error_frame_xhdl33 OR enable_overload_cnt2 OR go_overload_frame_xhdl32) = '1') THEN
            delayed_dominant_cnt <= "000" ;
         ELSE
            IF (((sample_point AND (NOT sampled_bit)) AND CONV_STD_LOGIC((error_cnt1 = "111") OR (overload_cnt1 = "111"))) = '1') THEN
               delayed_dominant_cnt <= delayed_dominant_cnt + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- passive_cnt

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         passive_cnt <= "001";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR error_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32 OR first_compare_bit) = '1') THEN
            passive_cnt <= "001" ;
         ELSE
            IF ((sample_point AND CONV_STD_LOGIC(passive_cnt < "110")) = '1') THEN
               IF (((error_frame AND (NOT enable_error_cnt2)) AND CONV_STD_LOGIC(sampled_bit = sampled_bit_q)) = '1') THEN
                  passive_cnt <= passive_cnt + "001" ;
               ELSE
                  passive_cnt <= "001" ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- When comparing 6 equal bits, first is always equal

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         first_compare_bit <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_error_frame_xhdl33 = '1') THEN
            first_compare_bit <= '1' ;
         ELSE
            IF (sample_point = '1') THEN
               first_compare_bit <= '0';
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Transmitting overload frame.

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         overload_frame_xhdl4 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR overload_frame_ended OR go_error_frame_xhdl33) = '1') THEN
            overload_frame_xhdl4 <= '0' ;
         ELSE
            IF (go_overload_frame_xhdl32 = '1') THEN
               overload_frame_xhdl4 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         overload_cnt1 <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR overload_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            overload_cnt1 <= "000" ;
         ELSE
            IF (((overload_frame_xhdl4 AND tx_point) AND CONV_STD_LOGIC(overload_cnt1 < "111")) = '1') THEN
               overload_cnt1 <= overload_cnt1 + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   overload_flag_over <= (sample_point AND CONV_STD_LOGIC(overload_cnt1 = "111")) AND (NOT enable_overload_cnt2) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         enable_overload_cnt2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR overload_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            enable_overload_cnt2 <= '0' ;
         ELSE
            IF ((overload_frame_xhdl4 AND (overload_flag_over AND sampled_bit)) = '1') THEN
               enable_overload_cnt2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         overload_cnt2 <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR overload_frame_ended OR go_error_frame_xhdl33 OR go_overload_frame_xhdl32) = '1') THEN
            overload_cnt2 <= "000" ;
         ELSE
            IF ((enable_overload_cnt2 AND tx_point) = '1') THEN
               overload_cnt2 <= overload_cnt2 + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         overload_request_cnt <= "00";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_error_frame_xhdl33 OR go_rx_id1) = '1') THEN
            overload_request_cnt <= "00" ;
         ELSE
            IF ((overload_request AND overload_frame_xhdl4) = '1') THEN
               overload_request_cnt <= overload_request_cnt + "01" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         overload_frame_blocked <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_error_frame_xhdl33 OR go_rx_id1) = '1') THEN
            overload_frame_blocked <= '0' ;
         ELSE
            IF (((overload_request AND overload_frame_xhdl4) AND CONV_STD_LOGIC(overload_request_cnt = "10")) = '1') THEN
               -- This is a second sequential overload_request

               overload_frame_blocked <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   send_ack_xhdl35 <= (((NOT tx_state_xhdl2) AND rx_ack) AND (NOT err)) AND (NOT listen_only_mode) ;

   PROCESS (reset_mode, node_bus_off_xhdl13, tx_state_xhdl2, go_tx_xhdl34, bit_de_stuff_tx, tx_bit, tx_q, send_ack_xhdl35, go_overload_frame_xhdl32, overload_frame_xhdl4, overload_cnt1, go_error_frame_xhdl33, error_frame, error_cnt1, node_error_passive_xhdl26)
      VARIABLE tx_next_xhdl30_xhdl105  : std_logic;
   BEGIN
      IF ((reset_mode OR node_bus_off_xhdl13) = '1') THEN
         -- Reset or node_bus_off

         tx_next_xhdl30_xhdl105 := '1';
      ELSE
         IF ((go_error_frame_xhdl33 OR error_frame) = '1') THEN
            -- Transmitting error frame

            IF (error_cnt1 < "110") THEN
               IF (node_error_passive_xhdl26 = '1') THEN
                  tx_next_xhdl30_xhdl105 := '1';
               ELSE
                  tx_next_xhdl30_xhdl105 := '0';
               END IF;
            ELSE
               tx_next_xhdl30_xhdl105 := '1';
            END IF;
         ELSE
            IF ((go_overload_frame_xhdl32 OR overload_frame_xhdl4) = '1') THEN
               -- Transmitting overload frame

               IF (overload_cnt1 < "110") THEN
                  tx_next_xhdl30_xhdl105 := '0';
               ELSE
                  tx_next_xhdl30_xhdl105 := '1';
               END IF;
            ELSE
               IF ((go_tx_xhdl34 OR tx_state_xhdl2) = '1') THEN
                  -- Transmitting message

                  tx_next_xhdl30_xhdl105 := ((NOT bit_de_stuff_tx) AND tx_bit) OR (bit_de_stuff_tx AND (NOT tx_q));
               ELSE
                  IF (send_ack_xhdl35 = '1') THEN
                     -- Acknowledge

                     tx_next_xhdl30_xhdl105 := '0';
                  ELSE
                     tx_next_xhdl30_xhdl105 := '1';
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
      tx_next_xhdl30 <= tx_next_xhdl30_xhdl105;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_xhdl29 <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            tx_xhdl29 <= '1';
         ELSE
            IF (tx_point = '1') THEN
               tx_xhdl29 <= tx_next_xhdl30 ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_q <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            tx_q <= '0' ;
         ELSE
            IF (tx_point = '1') THEN
               tx_q <= tx_xhdl29 AND (NOT go_early_tx_latched) ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Delayed tx point
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_point_q <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            tx_point_q <= '0' ;
         ELSE
            tx_point_q <= tx_point ;
         END IF;
      END IF;
   END PROCESS;

   -- Changing bit order from [7:0] to [0:7]
   i_ibo_tx_data_0 : can_ibo
      PORT MAP (
         di => tx_data_0,
         do => r_tx_data_0);

   i_ibo_tx_data_1 : can_ibo
      PORT MAP (
         di => tx_data_1,
         do => r_tx_data_1);

   i_ibo_tx_data_2 : can_ibo
      PORT MAP (
         di => tx_data_2,
         do => r_tx_data_2);

   i_ibo_tx_data_3 : can_ibo
      PORT MAP (
         di => tx_data_3,
         do => r_tx_data_3);

   i_ibo_tx_data_4 : can_ibo
      PORT MAP (
         di => tx_data_4,
         do => r_tx_data_4);

   i_ibo_tx_data_5 : can_ibo
      PORT MAP (
         di => tx_data_5,
         do => r_tx_data_5);

   i_ibo_tx_data_6 : can_ibo
      PORT MAP (
         di => tx_data_6,
         do => r_tx_data_6);

   i_ibo_tx_data_7 : can_ibo
      PORT MAP (
         di => tx_data_7,
         do => r_tx_data_7);

   i_ibo_tx_data_8 : can_ibo
      PORT MAP (
         di => tx_data_8,
         do => r_tx_data_8);

   i_ibo_tx_data_9 : can_ibo
      PORT MAP (
         di => tx_data_9,
         do => r_tx_data_9);

   i_ibo_tx_data_10 : can_ibo
      PORT MAP (
         di => tx_data_10,
         do => r_tx_data_10);

   i_ibo_tx_data_11 : can_ibo
      PORT MAP (
         di => tx_data_11,
         do => r_tx_data_11);

   i_ibo_tx_data_12 : can_ibo
      PORT MAP (
         di => tx_data_12,
         do => r_tx_data_12);


   -- Changing bit order from [14:0] to [0:14]
   i_calculated_crc0 : can_ibo
      PORT MAP (
         di => calculated_crc(14 DOWNTO 7),
         do => r_calculated_crc(7 DOWNTO 0));

   xhdl_106 <= calculated_crc(6 DOWNTO 0) & '0';
   i_calculated_crc1 : can_ibo
      PORT MAP (
         di => xhdl_106,
         do => r_calculated_crc(15 DOWNTO 8));

   basic_chain <= r_tx_data_1(7 DOWNTO 4) & "00" & r_tx_data_1(3 DOWNTO 0) & r_tx_data_0(7 DOWNTO 0) & '0' ;
   basic_chain_data <= r_tx_data_9 & r_tx_data_8 & r_tx_data_7 & r_tx_data_6 & r_tx_data_5 & r_tx_data_4 & r_tx_data_3 & r_tx_data_2 ;
   extended_chain_std <= r_tx_data_0(7 DOWNTO 4) & "00" & r_tx_data_0(1) & r_tx_data_2(2 DOWNTO 0) & r_tx_data_1(7 DOWNTO 0) & '0' ;
   extended_chain_ext <= r_tx_data_0(7 DOWNTO 4) & "00" & r_tx_data_0(1) & r_tx_data_4(4 DOWNTO 0) & r_tx_data_3(7 DOWNTO 0) & r_tx_data_2(7 DOWNTO 3) & '1' & '1' & r_tx_data_2(2 DOWNTO 0) & r_tx_data_1(7 DOWNTO 0) & '0' ;
   extended_chain_data_std <= r_tx_data_10 & r_tx_data_9 & r_tx_data_8 & r_tx_data_7 & r_tx_data_6 & r_tx_data_5 & r_tx_data_4 & r_tx_data_3 ;
   extended_chain_data_ext <= r_tx_data_12 & r_tx_data_11 & r_tx_data_10 & r_tx_data_9 & r_tx_data_8 & r_tx_data_7 & r_tx_data_6 & r_tx_data_5 ;

   PROCESS (extended_mode, rx_data, tx_pointer, extended_chain_data_std, extended_chain_data_ext, rx_crc, r_calculated_crc, r_tx_data_0, extended_chain_ext, extended_chain_std, basic_chain_data, basic_chain, finish_msg)
      VARIABLE tx_bit_xhdl107  : std_logic;
   BEGIN
      IF (extended_mode = '1') THEN
         IF (rx_data = '1') THEN
            -- data stage

            IF (r_tx_data_0(0) = '1') THEN
               -- Extended frame

               tx_bit_xhdl107 := extended_chain_data_ext(conv_integer(tx_pointer));
            ELSE
               tx_bit_xhdl107 := extended_chain_data_std(conv_integer(tx_pointer));
            END IF;
         ELSE
            IF (rx_crc = '1') THEN
               tx_bit_xhdl107 := r_calculated_crc(conv_integer(tx_pointer(3 downto 0)));
            ELSE
               IF (finish_msg = '1') THEN
                  tx_bit_xhdl107 := '1';
               ELSE
                  IF (r_tx_data_0(0) = '1') THEN
                     -- Extended frame

                     tx_bit_xhdl107 := extended_chain_ext(conv_integer(tx_pointer));
                  ELSE
                     tx_bit_xhdl107 := extended_chain_std(conv_integer(tx_pointer));
                  END IF;
               END IF;
            END IF;
         END IF;
      ELSE
         -- Basic mode

         IF (rx_data = '1') THEN
            -- data stage

            tx_bit_xhdl107 := basic_chain_data(conv_integer(tx_pointer));
         ELSE
            IF (rx_crc = '1') THEN
               tx_bit_xhdl107 := r_calculated_crc(conv_integer(tx_pointer));
            ELSE
               IF (finish_msg = '1') THEN
                  tx_bit_xhdl107 := '1';
               ELSE
                  tx_bit_xhdl107 := basic_chain(conv_integer(tx_pointer));
               END IF;
            END IF;
         END IF;
      END IF;
      tx_bit <= tx_bit_xhdl107;
   END PROCESS;
   temp_xhdl108 <= "111111" WHEN tx_data_0(3) = '1' ELSE ((tx_data_0(2 DOWNTO 0) & "000") - 1);
   limited_tx_cnt_ext <= temp_xhdl108 ;
   temp_xhdl109 <= "111111" WHEN tx_data_1(3) = '1' ELSE ((tx_data_1(2 DOWNTO 0) & "000") - 1);
   limited_tx_cnt_std <= temp_xhdl109 ;
   -- arbitration + control for extended format
   -- arbitration + control for extended format
   -- arbitration + control for standard format
   -- data       (overflow is OK here)
   -- data       (overflow is OK here)
   -- crc
   -- at the end
   rst_tx_pointer <= ((((((NOT bit_de_stuff_tx) AND tx_point) AND (NOT rx_data)) AND extended_mode) AND r_tx_data_0(0)) AND CONV_STD_LOGIC(tx_pointer = "100110")) OR ((((((NOT bit_de_stuff_tx) AND tx_point) AND (NOT rx_data)) AND extended_mode) AND (NOT r_tx_data_0(0))) AND CONV_STD_LOGIC(tx_pointer = "010010")) OR (((((NOT bit_de_stuff_tx) AND tx_point) AND (NOT rx_data)) AND (NOT extended_mode)) AND CONV_STD_LOGIC(tx_pointer = "010010")) OR (((((NOT bit_de_stuff_tx) AND tx_point) AND rx_data) AND extended_mode) AND CONV_STD_LOGIC(tx_pointer = limited_tx_cnt_ext)) OR (((((NOT bit_de_stuff_tx) AND tx_point) AND rx_data) AND (NOT extended_mode)) AND CONV_STD_LOGIC(tx_pointer = limited_tx_cnt_std)) OR (tx_point AND rx_crc_lim) OR (go_rx_idle) OR (reset_mode) OR (overload_frame_xhdl4) OR (error_frame) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_pointer <= "000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (rst_tx_pointer = '1') THEN
            tx_pointer <= "000000" ;
         ELSE
            IF ((go_early_tx OR ((tx_point AND (tx_state_xhdl2 OR go_tx_xhdl34)) AND (NOT bit_de_stuff_tx))) = '1') THEN
               tx_pointer <= tx_pointer + "000001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   tx_successful_xhdl19 <= ((((transmitter_xhdl8 AND go_rx_inter_xhdl9) AND (NOT go_error_frame_xhdl33)) AND (NOT error_frame_ended)) AND (NOT overload_frame_ended)) AND (NOT arbitration_lost) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         need_to_tx_xhdl20 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((tx_successful_xhdl19 OR reset_mode OR (abort_tx AND (NOT transmitting_xhdl7)) OR (((NOT tx_state_xhdl2) AND tx_state_q_xhdl3) AND single_shot_transmission)) = '1') THEN
            need_to_tx_xhdl20 <= '0' ;
         ELSE
            IF ((tx_request AND sample_point) = '1') THEN
               need_to_tx_xhdl20 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   go_early_tx <= ((((((NOT listen_only_mode) AND need_to_tx_xhdl20) AND (NOT tx_state_xhdl2)) AND (NOT suspend OR CONV_STD_LOGIC(susp_cnt = "111"))) AND sample_point) AND (NOT sampled_bit)) AND (rx_idle_xhdl6 OR last_bit_of_inter) ;
   go_tx_xhdl34 <= ((((NOT listen_only_mode) AND need_to_tx_xhdl20) AND (NOT tx_state_xhdl2)) AND (NOT suspend OR (sample_point AND CONV_STD_LOGIC(susp_cnt = "111")))) AND (go_early_tx OR rx_idle_xhdl6) ;

   -- go_early_tx latched (for proper bit_de_stuff generation)

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         go_early_tx_latched <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR tx_point) = '1') THEN
            go_early_tx_latched <= '0' ;
         ELSE
            IF (go_early_tx = '1') THEN
               go_early_tx_latched <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Tx state

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_state_xhdl2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR go_rx_inter_xhdl9 OR error_frame OR arbitration_lost) = '1') THEN
            tx_state_xhdl2 <= '0' ;
         ELSE
            IF (go_tx_xhdl34 = '1') THEN
               tx_state_xhdl2 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_state_q_xhdl3 <= '0' ;
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            tx_state_q_xhdl3 <= '0' ;
         ELSE
            tx_state_q_xhdl3 <= tx_state_xhdl2 ;
         END IF;
      END IF;
   END PROCESS;

   -- Node is a transmitter

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         transmitter_xhdl8 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (go_tx_xhdl34 = '1') THEN
            transmitter_xhdl8 <= '1' ;
         ELSE
            IF ((reset_mode OR go_rx_idle OR (suspend AND go_rx_id1)) = '1') THEN
               transmitter_xhdl8 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   -- Signal "transmitting" signals that the core is a transmitting (message, error frame or overload frame). No synchronization is done meanwhile.
   -- Node might be both transmitter or receiver (sending error or overload frame)

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         transmitting_xhdl7 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((go_error_frame_xhdl33 OR go_overload_frame_xhdl32 OR go_tx_xhdl34 OR send_ack_xhdl35) = '1') THEN
            transmitting_xhdl7 <= '1' ;
         ELSE
            IF ((reset_mode OR go_rx_idle OR (go_rx_id1 AND (NOT tx_state_xhdl2)) OR (arbitration_lost AND tx_state_xhdl2)) = '1') THEN
               transmitting_xhdl7 <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         suspend <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR (sample_point AND CONV_STD_LOGIC(susp_cnt = "111"))) = '1') THEN
            suspend <= '0' ;
         ELSE
            IF (((not_first_bit_of_inter_xhdl10 AND transmitter_xhdl8) AND node_error_passive_xhdl26) = '1') THEN
               suspend <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         susp_cnt_en <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR (sample_point AND CONV_STD_LOGIC(susp_cnt = "111"))) = '1') THEN
            susp_cnt_en <= '0' ;
         ELSE
            IF (((suspend AND sample_point) AND last_bit_of_inter) = '1') THEN
               susp_cnt_en <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         susp_cnt <= "000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR (sample_point AND CONV_STD_LOGIC(susp_cnt = "111"))) = '1') THEN
            susp_cnt <= "000" ;
         ELSE
            IF ((susp_cnt_en AND sample_point) = '1') THEN
               susp_cnt <= susp_cnt + "001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         finish_msg <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((go_rx_idle OR go_rx_id1 OR error_frame OR reset_mode) = '1') THEN
            finish_msg <= '0' ;
         ELSE
            IF (go_rx_crc_lim = '1') THEN
               finish_msg <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         arbitration_lost <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((go_rx_idle OR error_frame_ended OR reset_mode) = '1') THEN
            arbitration_lost <= '0' ;
         ELSE
            IF (((((transmitter_xhdl8 AND sample_point) AND tx_xhdl29) AND arbitration_field) AND NOT sampled_bit) = '1') THEN
               arbitration_lost <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         arbitration_lost_q <= '0' ;
         read_arbitration_lost_capture_reg_q <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            arbitration_lost_q <= '0';
            read_arbitration_lost_capture_reg_q <= '0';
         ELSE
            arbitration_lost_q <= arbitration_lost;
            read_arbitration_lost_capture_reg_q <= read_arbitration_lost_capture_reg ;
         END IF;
      END IF;
   END PROCESS;
   set_arbitration_lost_irq_xhdl24 <= (arbitration_lost AND (NOT arbitration_lost_q)) AND (NOT arbitration_blocked) ;

   PROCESS (clk, rst)
   BEGIN
     IF (rst = '1') THEN
       read_error_code_capture_reg_q <= '0';
     ELSIF (clk'EVENT AND clk = '1') THEN
       read_error_code_capture_reg_q <= read_error_code_capture_reg;
     END IF;
   END PROCESS;

   reset_error_code_capture_reg <= read_error_code_capture_reg_q and not read_error_code_capture_reg;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         arbitration_cnt_en <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR arbitration_blocked) = '1') THEN
            arbitration_cnt_en <= '0' ;
         ELSE
            IF (((rx_id1 AND sample_point) AND (NOT arbitration_blocked)) = '1') THEN
               arbitration_cnt_en <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         arbitration_blocked <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((reset_mode OR read_arbitration_lost_capture_reg) = '1') THEN
            arbitration_blocked <= '0' ;
         ELSE
            IF (set_arbitration_lost_irq_xhdl24 = '1') THEN
               arbitration_blocked <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         arbitration_lost_capture_xhdl25 <= "00000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (read_arbitration_lost_capture_reg_q = '1') THEN
            arbitration_lost_capture_xhdl25 <= "00000" ;
         ELSE
            IF ((((sample_point AND (NOT arbitration_blocked)) AND arbitration_cnt_en) AND (NOT bit_de_stuff)) = '1') THEN
               arbitration_lost_capture_xhdl25 <= arbitration_lost_capture_xhdl25 + "00001" ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_err_cnt_xhdl15 <= "000000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((we_rx_err_cnt AND (NOT node_bus_off_xhdl13)) = '1') THEN
            rx_err_cnt_xhdl15 <= '0' & data_in ;
         ELSE
            IF (set_reset_mode_xhdl12 = '1') THEN
               rx_err_cnt_xhdl15 <= "000000000" ;
            ELSE
               IF (((NOT listen_only_mode) AND (NOT transmitter_xhdl8 OR arbitration_lost)) = '1') THEN
                  IF ((((go_rx_ack_lim AND (NOT go_error_frame_xhdl33)) AND (NOT crc_err)) AND CONV_STD_LOGIC(rx_err_cnt_xhdl15 > "000000000")) = '1') THEN
                     IF (rx_err_cnt_xhdl15 > "001111111") THEN
                        rx_err_cnt_xhdl15 <= "001111111" ;
                     ELSE
                        rx_err_cnt_xhdl15 <= rx_err_cnt_xhdl15 - "000000001" ;
                     END IF;
                  ELSE
                     IF (rx_err_cnt_xhdl15 < "010000000") THEN
                        IF ((go_error_frame_xhdl33 AND (NOT rule5)) = '1') THEN
                           -- 1  (rule 5 is just the opposite then rule 1 exception

                           rx_err_cnt_xhdl15 <= rx_err_cnt_xhdl15 + "000000001" ;
                        ELSE
                           IF ((((((error_flag_over AND (NOT error_flag_over_latched)) AND sample_point) AND (NOT sampled_bit)) AND CONV_STD_LOGIC(error_cnt1 = "111")) OR (go_error_frame_xhdl33 AND rule5) OR ((sample_point AND (NOT sampled_bit)) AND CONV_STD_LOGIC(delayed_dominant_cnt = "111"))) = '1') THEN
                              -- 2
                              -- 5
                              -- 6

                              rx_err_cnt_xhdl15 <= rx_err_cnt_xhdl15 + "000001000" ;
                           END IF;
                        END IF;
                     END IF;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         tx_err_cnt_xhdl16 <= "000000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (we_tx_err_cnt = '1') THEN
            tx_err_cnt_xhdl16 <= '0' & data_in ;
         ELSE
            IF (set_reset_mode_xhdl12 = '1') THEN
               tx_err_cnt_xhdl16 <= "010000000" ;
            ELSE
               IF ((CONV_STD_LOGIC(tx_err_cnt_xhdl16 > "000000000") AND (tx_successful_xhdl19 OR bus_free)) = '1') THEN
                  tx_err_cnt_xhdl16 <= tx_err_cnt_xhdl16 - "000000001" ;
               ELSE
                  IF ((transmitter_xhdl8 AND (NOT arbitration_lost)) = '1') THEN
                     IF ((((sample_point AND (NOT sampled_bit)) AND CONV_STD_LOGIC(delayed_dominant_cnt = "111")) OR (go_error_frame_xhdl33 AND rule5) OR ((go_error_frame_xhdl33 AND (NOT ((transmitter_xhdl8 AND node_error_passive_xhdl26) AND ack_err))) AND (NOT (((((transmitter_xhdl8 AND stuff_err) AND arbitration_field) AND sample_point) AND tx_xhdl29) AND (NOT sampled_bit)))) OR (error_frame AND rule3_exc1_2)) = '1') THEN
                        -- 6
                        -- 4  (rule 5 is the same as rule 4)
                        -- 3
                        -- 3

                        tx_err_cnt_xhdl16 <= tx_err_cnt_xhdl16 + "000001000" ;
                     END IF;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         node_error_passive_xhdl26 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((rx_err_cnt_xhdl15 < "010000000") AND (tx_err_cnt_xhdl16 < "010000000")) THEN
            node_error_passive_xhdl26 <= '0' ;
         ELSE
            IF (((CONV_STD_LOGIC((rx_err_cnt_xhdl15 >= "010000000") OR (tx_err_cnt_xhdl16 >= "010000000")) AND (error_frame_ended OR go_error_frame_xhdl33 OR ((NOT reset_mode) AND reset_mode_q))) AND (NOT node_bus_off_xhdl13)) = '1') THEN
               node_error_passive_xhdl26 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   node_error_active_xhdl27 <= NOT (node_error_passive_xhdl26 OR node_bus_off_xhdl13) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         node_bus_off_xhdl13 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (((CONV_STD_LOGIC((rx_err_cnt_xhdl15 = "000000000") AND (tx_err_cnt_xhdl16 = "000000000")) AND (NOT reset_mode)) OR (we_tx_err_cnt AND CONV_STD_LOGIC(data_in < "11111111"))) = '1') THEN
            node_bus_off_xhdl13 <= '0' ;
         ELSE
            IF ((CONV_STD_LOGIC(tx_err_cnt_xhdl16 >= "100000000") OR (we_tx_err_cnt AND CONV_STD_LOGIC(data_in = "11111111"))) = '1') THEN
               node_bus_off_xhdl13 <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bus_free_cnt <= "0000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bus_free_cnt <= "0000" ;
         ELSE
            IF (sample_point = '1') THEN
               IF (((sampled_bit AND bus_free_cnt_en) AND CONV_STD_LOGIC(bus_free_cnt < "1010")) = '1') THEN
                  bus_free_cnt <= bus_free_cnt + "0001" ;
               ELSE
                  bus_free_cnt <= "0000" ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bus_free_cnt_en <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((((NOT reset_mode) AND reset_mode_q) OR (node_bus_off_q AND (NOT reset_mode))) = '1') THEN
            bus_free_cnt_en <= '1' ;
         ELSE
            IF ((((sample_point AND sampled_bit) AND CONV_STD_LOGIC(bus_free_cnt = "1010")) AND (NOT node_bus_off_xhdl13)) = '1') THEN
               bus_free_cnt_en <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         bus_free <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            bus_free <= '0';
         ELSE
            IF (((sample_point AND sampled_bit) AND CONV_STD_LOGIC(bus_free_cnt = "1010")) = '1') THEN
               bus_free <= '1' ;
            ELSE
               bus_free <= '0' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         waiting_for_bus_free <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_mode = '1') THEN
            waiting_for_bus_free <= '1';
         ELSE
            IF ((bus_free AND (NOT node_bus_off_xhdl13)) = '1') THEN
               waiting_for_bus_free <= '0' ;
            ELSE
               IF ((((NOT reset_mode) AND reset_mode_q) OR (node_bus_off_q AND (NOT reset_mode))) = '1') THEN
                  waiting_for_bus_free <= '1' ;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   bus_off_on_xhdl31 <= NOT node_bus_off_xhdl13 ;
   set_reset_mode_xhdl12 <= node_bus_off_xhdl13 AND (NOT node_bus_off_q) ;
--##   temp_xhdl110 <= ((rx_err_cnt_xhdl15 >= ('0' & error_warning_limit)) OR (tx_err_cnt_xhdl16 >= ('0' & error_warning_limit))) WHEN extended_mode = '1' ELSE ((rx_err_cnt_xhdl15 >= "001100000") OR (tx_err_cnt_xhdl16 >= "001100000"));
   temp_xhdl110 <= ((rx_err_cnt_xhdl15 >= ('0' & error_warning_limit)) OR (tx_err_cnt_xhdl16 >= ('0' & error_warning_limit)) or (node_bus_off_xhdl13='1')) WHEN extended_mode = '1' ELSE ((rx_err_cnt_xhdl15 >= "001100000") OR (tx_err_cnt_xhdl16 >= "001100000") or (node_bus_off_xhdl13='1')); --## OpenCores: Error in recovery from BUSOFF

   error_status_xhdl14 <= CONV_STD_LOGIC(temp_xhdl110) ;
   transmit_status_xhdl17 <= transmitting_xhdl7 OR (extended_mode AND waiting_for_bus_free) ;
   temp_xhdl111 <= (waiting_for_bus_free OR ((NOT rx_idle_xhdl6) AND (NOT transmitting_xhdl7))) WHEN extended_mode = '1' ELSE (((NOT waiting_for_bus_free) AND (NOT rx_idle_xhdl6)) AND (NOT transmitting_xhdl7));
   receive_status_xhdl18 <= temp_xhdl111 ;

   -- Error code capture register
   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_capture_code_xhdl5 <= "00000000";
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (reset_error_code_capture_reg = '1') THEN
            error_capture_code_xhdl5 <= "00000000" ;
         ELSE
            IF (set_bus_error_irq_xhdl23 = '1') THEN
               error_capture_code_xhdl5 <= error_capture_code_type(7 DOWNTO 6) & error_capture_code_direction & error_capture_code_segment(4 DOWNTO 0) ;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   error_capture_code_segment(0) <= rx_idle_xhdl6 OR rx_ide OR (rx_id2 AND CONV_STD_LOGIC(bit_cnt < "001101")) OR rx_r1 OR rx_r0 OR rx_dlc OR rx_ack OR rx_ack_lim OR (error_frame AND node_error_active_xhdl27) ;
   error_capture_code_segment(1) <= rx_idle_xhdl6 OR rx_id1 OR rx_id2 OR rx_dlc OR rx_data OR rx_ack_lim OR rx_eof OR rx_inter_xhdl11 OR (error_frame AND node_error_passive_xhdl26) ;
   error_capture_code_segment(2) <= (rx_id1 AND CONV_STD_LOGIC(bit_cnt > "000111")) OR rx_rtr1 OR rx_ide OR rx_id2 OR rx_rtr2 OR rx_r1 OR (error_frame AND node_error_passive_xhdl26) OR overload_frame_xhdl4 ;
   error_capture_code_segment(3) <= (rx_id2 AND CONV_STD_LOGIC(bit_cnt > "000100")) OR rx_rtr2 OR rx_r1 OR rx_r0 OR rx_dlc OR rx_data OR rx_crc OR rx_crc_lim OR rx_ack OR rx_ack_lim OR rx_eof OR overload_frame_xhdl4 ;
   error_capture_code_segment(4) <= rx_crc_lim OR rx_ack OR rx_ack_lim OR rx_eof OR rx_inter_xhdl11 OR error_frame OR overload_frame_xhdl4 ;
   error_capture_code_direction <= NOT transmitting_xhdl7 ;

   PROCESS (bit_err, form_err, stuff_err)
      VARIABLE error_capture_code_type_xhdl112  : std_logic_vector(7 DOWNTO 6);
   BEGIN
      IF (bit_err = '1') THEN
         error_capture_code_type_xhdl112(7 DOWNTO 6) := "00";
      ELSE
         IF (form_err = '1') THEN
            error_capture_code_type_xhdl112(7 DOWNTO 6) := "01";
         ELSE
            IF (stuff_err = '1') THEN
               error_capture_code_type_xhdl112(7 DOWNTO 6) := "10";
            ELSE
               error_capture_code_type_xhdl112(7 DOWNTO 6) := "11";
            END IF;
         END IF;
      END IF;
      error_capture_code_type <= error_capture_code_type_xhdl112;
   END PROCESS;
   set_bus_error_irq_xhdl23 <= go_error_frame_xhdl33 AND (NOT error_capture_code_blocked) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         error_capture_code_blocked <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (read_error_code_capture_reg = '1') THEN
            error_capture_code_blocked <= '0' ;
         ELSE
            IF (set_bus_error_irq_xhdl23 = '1') THEN
               error_capture_code_blocked <= '1' ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_register
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_register.v                                              ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_register.v,v $
-- Revision 1.7  2004/02/08 14:32:31  mohor
-- Header changed.
--
-- Revision 1.6  2003/03/20 16:58:50  mohor
-- unix.
--
-- Revision 1.4  2003/03/11 16:32:34  mohor
-- timescale.v is used for simulation only.
--
-- Revision 1.3  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.2  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY can_register IS
   GENERIC (
      WIDTH                          :  integer := 8);    --  default parameter of the register width
   PORT (
      data_in                 : IN std_logic_vector(WIDTH - 1 DOWNTO 0);
      data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
      we                      : IN std_logic;
      clk                     : IN std_logic);
END ENTITY can_register;

ARCHITECTURE RTL OF can_register IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL data_out_xhdl1           :  std_logic_vector(WIDTH - 1 DOWNTO 0);

BEGIN
   data_out <= data_out_xhdl1;

   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         IF (we = '1') THEN
            -- write

            data_out_xhdl1 <= data_in;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:51 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_register_asyn
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_register_asyn.v                                         ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_register_asyn.v,v $
-- Revision 1.7  2004/02/08 14:33:19  mohor
-- Header changed.
--
-- Revision 1.6  2003/03/20 16:58:50  mohor
-- unix.
--
-- Revision 1.4  2003/03/11 16:32:34  mohor
-- timescale.v is used for simulation only.
--
-- Revision 1.3  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.2  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;


ENTITY can_register_asyn IS
   GENERIC (
      WIDTH                          :  integer := 8;    --  default parameter of the register width
      RESET_VALUE                    :  integer := 0);
   PORT (
      data_in                 : IN std_logic_vector(WIDTH - 1 DOWNTO 0);
      data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
      we                      : IN std_logic;
      clk                     : IN std_logic;
      rst                     : IN std_logic);
END ENTITY can_register_asyn;

ARCHITECTURE RTL OF can_register_asyn IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL data_out_xhdl1           :  std_logic_vector(WIDTH - 1 DOWNTO 0);

BEGIN
   data_out <= data_out_xhdl1;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         -- asynchronous reset

         data_out_xhdl1 <= CONV_STD_LOGIC_VECTOR(RESET_VALUE, WIDTH);
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (we = '1') THEN
            -- write

            data_out_xhdl1 <= data_in ;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:52 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_register_asyn_syn
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_register_asyn_syn.v                                     ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_register_asyn_syn.v,v $
-- Revision 1.7  2004/02/08 14:33:59  mohor
-- Header changed.
--
-- Revision 1.6  2003/03/20 16:52:43  mohor
-- unix.
--
-- Revision 1.4  2003/03/11 16:32:34  mohor
-- timescale.v is used for simulation only.
--
-- Revision 1.3  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.2  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_register_asyn_syn IS
   GENERIC (
      WIDTH                          :  integer := 8;    --  default parameter of the register width
      RESET_VALUE                    :  integer := 0);
   PORT (
      data_in                 : IN std_logic_vector(WIDTH - 1 DOWNTO 0);
      data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
      we                      : IN std_logic;
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      rst_sync                : IN std_logic);
END ENTITY can_register_asyn_syn;

ARCHITECTURE RTL OF can_register_asyn_syn IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL data_out_xhdl1           :  std_logic_vector(WIDTH - 1 DOWNTO 0);

BEGIN
   data_out <= data_out_xhdl1;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         data_out_xhdl1 <= CONV_STD_LOGIC_VECTOR(RESET_VALUE, WIDTH);
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF (rst_sync = '1') THEN
            -- synchronous reset

            data_out_xhdl1 <= CONV_STD_LOGIC_VECTOR(RESET_VALUE, WIDTH);
         ELSE
            IF (we = '1') THEN
               -- write

               data_out_xhdl1 <= data_in ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:52 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_register_syn
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_register_syn.v                                          ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_register_syn.v,v $
-- Revision 1.5  2004/02/08 14:34:40  mohor
-- Header changed.
--
-- Revision 1.4  2003/03/11 16:31:58  mohor
-- timescale.v is used for simulation only.
--
-- Revision 1.3  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.2  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_register_syn IS
   GENERIC (
      WIDTH                          :  integer := 8;    --  default parameter of the register width
      RESET_VALUE                    :  integer := 0);
   PORT (
      data_in                 : IN std_logic_vector(WIDTH - 1 DOWNTO 0);
      data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
      we                      : IN std_logic;
      clk                     : IN std_logic;
      rst_sync                : IN std_logic);
END ENTITY can_register_syn;

ARCHITECTURE RTL OF can_register_syn IS

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   SIGNAL data_out_xhdl1           :  std_logic_vector(WIDTH - 1 DOWNTO 0);

BEGIN
   data_out <= data_out_xhdl1;

   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         IF (rst_sync = '1') THEN
            -- synchronous reset

            data_out_xhdl1 <= CONV_STD_LOGIC_VECTOR(RESET_VALUE, 8);
         ELSE
            IF (we = '1') THEN
               -- write

               data_out_xhdl1 <= data_in ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:52 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_registers
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_registers.v                                             ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003 Authors                             ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History

-- Revision 1.36  2005/03/18 15:04:05  igorm
-- Wake-up interrupt was generated in some cases.
--
-- Revision 1.35  2004/11/30 15:08:26  igorm
-- irq is cleared after the release_buffer command. This bug was entered with
-- changes for the edge triggered interrupts.
--
-- Revision 1.34  2004/11/18 12:39:43  igorm
-- Fixes for compatibility after the SW reset.
--
-- Revision 1.33  2004/10/25 11:44:38  igorm
-- Interrupt is always cleared for one clock after the irq register is read.
-- This fixes problems when CPU is using IRQs that are edge triggered.
--
-- Revision 1.32  2004/05/12 15:58:41  igorm
-- Core improved to pass all tests with the Bosch VHDL Reference system.
--
-- Revision 1.31  2003/09/25 18:55:49  mohor
-- Synchronization changed, error counters fixed.
--
-- Revision 1.30  2003/07/16 15:19:34  mohor
-- Fixed according to the linter.
-- Case statement for data_out joined.
--
-- Revision 1.29  2003/07/10 01:59:04  tadejm
-- Synchronization fixed. In some strange cases it didn't work according to
-- the VHDL reference model.
--
-- Revision 1.28  2003/07/07 11:21:37  mohor
-- Little fixes (to fix warnings).
--
-- Revision 1.27  2003/06/22 09:43:03  mohor
-- synthesi full_case parallel_case fixed.
--
-- Revision 1.26  2003/06/22 01:33:14  mohor
-- clkout is clk/2 after the reset.
--
-- Revision 1.25  2003/06/21 12:16:30  mohor
-- paralel_case and full_case compiler directives added to case statements.
--
-- Revision 1.24  2003/06/09 11:22:54  mohor
-- data_out is already registered in the can_top.v file.
--
-- Revision 1.23  2003/04/15 15:31:24  mohor
-- Some features are supported in extended mode only (listen_only_mode...).
--
-- Revision 1.22  2003/03/20 16:58:50  mohor
-- unix.
--
-- Revision 1.20  2003/03/11 16:31:05  mohor
-- Mux used for clkout to avoid "gated clocks warning".
--
-- Revision 1.19  2003/03/10 17:34:25  mohor
-- Doubled declarations removed.
--
-- Revision 1.18  2003/03/01 22:52:11  mohor
-- Data is latched on read.
--
-- Revision 1.17  2003/02/19 15:09:02  mohor
-- Incomplete sensitivity list fixed.
--
-- Revision 1.16  2003/02/19 14:44:03  mohor
-- CAN core finished. Host interface added. Registers finished.
-- Synchronization to the wishbone finished.
--
-- Revision 1.15  2003/02/18 00:10:15  mohor
-- Most of the registers added. Registers "arbitration lost capture", "error code
-- capture" + few more still need to be added.
--
-- Revision 1.14  2003/02/14 20:17:01  mohor
-- Several registers added. Not finished, yet.
--
-- Revision 1.13  2003/02/12 14:25:30  mohor
-- abort_tx added.
--
-- Revision 1.12  2003/02/11 00:56:06  mohor
-- Wishbone interface added.
--
-- Revision 1.11  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.10  2003/01/31 01:13:38  mohor
-- backup.
--
-- Revision 1.9  2003/01/15 13:16:48  mohor
-- When a frame with "remote request" is received, no data is stored
-- to fifo, just the frame information (identifier, ...). Data length
-- that is stored is the received data length and not the actual data
-- length that is stored to fifo.
--
-- Revision 1.8  2003/01/14 17:25:09  mohor
-- Addresses corrected to decimal values (previously hex).
--
-- Revision 1.7  2003/01/14 12:19:35  mohor
-- rx_fifo is now working.
--
-- Revision 1.6  2003/01/10 17:51:34  mohor
-- Temporary version (backup).
--
-- Revision 1.5  2003/01/09 14:46:58  mohor
-- Temporary files (backup).
--
-- Revision 1.4  2003/01/08 02:10:55  mohor
-- Acceptance filter added.
--
-- Revision 1.3  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.2  2002/12/26 16:00:34  mohor
-- Testbench define file added. Clock divider register added.
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_registers IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      cs                      : IN std_logic;
      we                      : IN std_logic;
      addr                    : IN std_logic_vector(7 DOWNTO 0);
      data_in                 : IN std_logic_vector(7 DOWNTO 0);
      data_out                : OUT std_logic_vector(7 DOWNTO 0);
      irq_n                   : OUT std_logic;
      sample_point            : IN std_logic;
      transmitting            : IN std_logic;
      set_reset_mode          : IN std_logic;
      node_bus_off            : IN std_logic;
      error_status            : IN std_logic;
      rx_err_cnt              : IN std_logic_vector(7 DOWNTO 0);
      tx_err_cnt              : IN std_logic_vector(7 DOWNTO 0);
      transmit_status         : IN std_logic;
      receive_status          : IN std_logic;
      tx_successful           : IN std_logic;
      need_to_tx              : IN std_logic;
      overrun                 : IN std_logic;
      info_empty              : IN std_logic;
      set_bus_error_irq       : IN std_logic;
      set_arbitration_lost_irq: IN std_logic;
      arbitration_lost_capture: IN std_logic_vector(4 DOWNTO 0);
      node_error_passive      : IN std_logic;
      node_error_active       : IN std_logic;
      rx_message_counter      : IN std_logic_vector(6 DOWNTO 0);
      -- Mode register
      reset_mode              : OUT std_logic;
      listen_only_mode        : OUT std_logic;
      acceptance_filter_mode  : OUT std_logic;
      self_test_mode          : OUT std_logic;
      -- Command register
      clear_data_overrun      : OUT std_logic;
      release_buffer          : OUT std_logic;
      abort_tx                : OUT std_logic;
      tx_request              : OUT std_logic;
      self_rx_request         : OUT std_logic;
      single_shot_transmission: OUT std_logic;
      tx_state                : IN std_logic;
      tx_state_q              : IN std_logic;
      overload_request        : OUT std_logic;
      overload_frame          : IN std_logic;
      -- Arbitration Lost Capture Register
      read_arbitration_lost_capture_reg: OUT std_logic;
      -- Error Code Capture Register
      read_error_code_capture_reg: OUT std_logic;
      error_capture_code      : IN std_logic_vector(7 DOWNTO 0);
      -- Bus Timing 0 register
      baud_r_presc            : OUT std_logic_vector(5 DOWNTO 0);
      sync_jump_width         : OUT std_logic_vector(1 DOWNTO 0);
      -- Bus Timing 1 register
      time_segment1           : OUT std_logic_vector(3 DOWNTO 0);
      time_segment2           : OUT std_logic_vector(2 DOWNTO 0);
      triple_sampling         : OUT std_logic;
      -- Error Warning Limit register
      error_warning_limit     : OUT std_logic_vector(7 DOWNTO 0);
      -- Rx Error Counter register
      we_rx_err_cnt           : OUT std_logic;
      -- Tx Error Counter register
      we_tx_err_cnt           : OUT std_logic;
      -- Clock Divider register
      extended_mode           : OUT std_logic;
      clkout                  : OUT std_logic;
      -- This section is for BASIC and EXTENDED mode -- Acceptance code register
      acceptance_code_0       : OUT std_logic_vector(7 DOWNTO 0);
      -- Acceptance mask register
      acceptance_mask_0       : OUT std_logic_vector(7 DOWNTO 0);
      -- End: This section is for BASIC and EXTENDED mode -- This section is for EXTENDED mode -- Acceptance code register
      acceptance_code_1       : OUT std_logic_vector(7 DOWNTO 0);
      acceptance_code_2       : OUT std_logic_vector(7 DOWNTO 0);
      acceptance_code_3       : OUT std_logic_vector(7 DOWNTO 0);
      -- Acceptance mask register
      acceptance_mask_1       : OUT std_logic_vector(7 DOWNTO 0);
      acceptance_mask_2       : OUT std_logic_vector(7 DOWNTO 0);
      acceptance_mask_3       : OUT std_logic_vector(7 DOWNTO 0);
      -- End: This section is for EXTENDED mode -- Tx data registers. Holding identifier (basic mode), tx frame information (extended mode) and data
      tx_data_0               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_1               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_2               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_3               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_4               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_5               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_6               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_7               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_8               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_9               : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_10              : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_11              : OUT std_logic_vector(7 DOWNTO 0);
      tx_data_12              : OUT std_logic_vector(7 DOWNTO 0));
END ENTITY can_registers;

ARCHITECTURE RTL OF can_registers IS

   CONSTANT xhdl_timescale         : time := 1 ns;

   COMPONENT can_register
      GENERIC (
          WIDTH                          :  integer := 8);    --  default parameter of the register width
      PORT (
         data_in                 : IN  std_logic_vector(WIDTH - 1 DOWNTO 0);
         data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
         we                      : IN  std_logic;
         clk                     : IN  std_logic);
   END COMPONENT;

   COMPONENT can_register_asyn
      GENERIC (
          WIDTH                          :  integer := 8;    --  default parameter of the register width
          RESET_VALUE                    :  integer := 0);
      PORT (
         data_in                 : IN  std_logic_vector(WIDTH - 1 DOWNTO 0);
         data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
         we                      : IN  std_logic;
         clk                     : IN  std_logic;
         rst                     : IN  std_logic);
   END COMPONENT;

   COMPONENT can_register_asyn_syn
      GENERIC (
          WIDTH                          :  integer := 8;    --  default parameter of the register width
          RESET_VALUE                    :  integer := 0);
      PORT (
         data_in                 : IN  std_logic_vector(WIDTH - 1 DOWNTO 0);
         data_out                : OUT std_logic_vector(WIDTH - 1 DOWNTO 0);
         we                      : IN  std_logic;
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         rst_sync                : IN  std_logic);
   END COMPONENT;

   TYPE xhdl_15 IS ARRAY (0 TO 63) OF std_logic_vector(7 DOWNTO 0);
   TYPE xhdl_16 IS ARRAY (0 TO 63) OF std_logic_vector(3 DOWNTO 0);
   TYPE xhdl_17 IS ARRAY (0 TO 63) OF std_logic;
   TYPE xhdl_46 IS ARRAY (0 TO 7) OF std_logic_vector(7 DOWNTO 0);

   -- End: Tx data registers
   signal read_irq_reg_q           :  std_logic;
   signal reset_irq_reg            :  std_logic;
   SIGNAL tx_successful_q          :  std_logic;
   SIGNAL overrun_q                :  std_logic;
   SIGNAL overrun_status           :  std_logic;
   SIGNAL transmission_complete    :  std_logic;
   SIGNAL transmit_buffer_status_q :  std_logic;
   SIGNAL receive_buffer_status    :  std_logic;
   SIGNAL error_status_q           :  std_logic;
   SIGNAL node_bus_off_q           :  std_logic;
   SIGNAL node_error_passive_q     :  std_logic;
   SIGNAL transmit_buffer_status   :  std_logic;
   -- Some interrupts exist in basic mode and in extended mode. Since they are in different registers they need to be multiplexed.
   SIGNAL data_overrun_irq_en      :  std_logic;
   SIGNAL error_warning_irq_en     :  std_logic;
   SIGNAL transmit_irq_en          :  std_logic;
   SIGNAL receive_irq_en           :  std_logic;
   SIGNAL irq_reg                  :  std_logic_vector(7 DOWNTO 0);
   SIGNAL irq                      :  std_logic;
   SIGNAL we_mode                  :  std_logic;
   SIGNAL we_command               :  std_logic;
   SIGNAL we_bus_timing_0          :  std_logic;
   SIGNAL we_bus_timing_1          :  std_logic;
   SIGNAL we_clock_divider_low     :  std_logic;
   SIGNAL we_clock_divider_hi      :  std_logic;
   SIGNAL read                     :  std_logic;
   SIGNAL read_irq_reg             :  std_logic;
   -- This section is for BASIC and EXTENDED mode
   SIGNAL we_acceptance_code_0     :  std_logic;
   SIGNAL we_acceptance_mask_0     :  std_logic;
   SIGNAL we_tx_data_0             :  std_logic;
   SIGNAL we_tx_data_1             :  std_logic;
   SIGNAL we_tx_data_2             :  std_logic;
   SIGNAL we_tx_data_3             :  std_logic;
   SIGNAL we_tx_data_4             :  std_logic;
   SIGNAL we_tx_data_5             :  std_logic;
   SIGNAL we_tx_data_6             :  std_logic;
   SIGNAL we_tx_data_7             :  std_logic;
   SIGNAL we_tx_data_8             :  std_logic;
   SIGNAL we_tx_data_9             :  std_logic;
   SIGNAL we_tx_data_10            :  std_logic;
   SIGNAL we_tx_data_11            :  std_logic;
   SIGNAL we_tx_data_12            :  std_logic;
   -- End: This section is for BASIC and EXTENDED mode
   -- This section is for EXTENDED mode
   SIGNAL we_interrupt_enable      :  std_logic;
   SIGNAL we_error_warning_limit   :  std_logic;
   SIGNAL we_acceptance_code_1     :  std_logic;
   SIGNAL we_acceptance_code_2     :  std_logic;
   SIGNAL we_acceptance_code_3     :  std_logic;
   SIGNAL we_acceptance_mask_1     :  std_logic;
   SIGNAL we_acceptance_mask_2     :  std_logic;
   SIGNAL we_acceptance_mask_3     :  std_logic;
   -- Mode register
   SIGNAL mode                     :  std_logic;
   SIGNAL mode_basic               :  std_logic_vector(4 DOWNTO 1);
   SIGNAL mode_ext                 :  std_logic_vector(3 DOWNTO 1);
   SIGNAL receive_irq_en_basic     :  std_logic;
   SIGNAL transmit_irq_en_basic    :  std_logic;
   SIGNAL error_irq_en_basic       :  std_logic;
   SIGNAL overrun_irq_en_basic     :  std_logic;
   SIGNAL port_xhdl52              :  std_logic;
   SIGNAL xhdl_61                  :  std_logic;
   -- End Mode register
   -- Command register
   SIGNAL command                  :  std_logic_vector(4 DOWNTO 0);
   SIGNAL xhdl_69                  :  std_logic;
   SIGNAL port_xhdl70              :  std_logic;
   SIGNAL port_xhdl71              :  std_logic;
   SIGNAL xhdl_77                  :  std_logic;
   SIGNAL port_xhdl78              :  std_logic;
   SIGNAL port_xhdl79              :  std_logic;
   SIGNAL xhdl_85                  :  std_logic;
   SIGNAL xhdl_91                  :  std_logic;
   SIGNAL port_xhdl92              :  std_logic;
   SIGNAL port_xhdl93              :  std_logic;
   -- End Command register
   -- Status register
   SIGNAL status                   :  std_logic_vector(7 DOWNTO 0);
   -- End Status register
   -- Interrupt Enable register (extended mode)
   SIGNAL irq_en_ext               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL bus_error_irq_en         :  std_logic;
   SIGNAL arbitration_lost_irq_en  :  std_logic;
   SIGNAL error_passive_irq_en     :  std_logic;
   SIGNAL data_overrun_irq_en_ext  :  std_logic;
   SIGNAL error_warning_irq_en_ext :  std_logic;
   SIGNAL transmit_irq_en_ext      :  std_logic;
   SIGNAL receive_irq_en_ext       :  std_logic;
   -- End Bus Timing 0 register
   -- Bus Timing 0 register
   SIGNAL bus_timing_0             :  std_logic_vector(7 DOWNTO 0);
   -- End Bus Timing 0 register
   -- Bus Timing 1 register
   SIGNAL bus_timing_1             :  std_logic_vector(7 DOWNTO 0);
   -- End Error Warning Limit register
   -- Clock Divider register
   SIGNAL clock_divider            :  std_logic_vector(7 DOWNTO 0);
   SIGNAL clock_off                :  std_logic;
   SIGNAL cd                       :  std_logic_vector(2 DOWNTO 0);
   SIGNAL clkout_div               :  std_logic_vector(2 DOWNTO 0);
   SIGNAL clkout_cnt               :  std_logic_vector(2 DOWNTO 0);
   SIGNAL clkout_tmp               :  std_logic;
   SIGNAL port_xhdl116             :  std_logic;
   SIGNAL port_xhdl117             :  std_logic;
   SIGNAL port_xhdl123             :  std_logic;
   SIGNAL port_xhdl124             :  std_logic;
   SIGNAL temp_xhdl131             :  std_logic;
   SIGNAL temp_xhdl132             :  std_logic;
   SIGNAL temp_xhdl218             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl219             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl220             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl221             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl222             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl223             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl224             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl225             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl226             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl227             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl228             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl229             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl230             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   SIGNAL temp_xhdl231             :  std_logic_vector(7 DOWNTO 0);   --  basic mode
   -- Some interrupts exist in basic mode and in extended mode. Since they are in different registers they need to be multiplexed.
   SIGNAL temp_xhdl233             :  std_logic;
   SIGNAL temp_xhdl234             :  std_logic;
   SIGNAL temp_xhdl235             :  std_logic;
   SIGNAL temp_xhdl236             :  std_logic;
   SIGNAL data_overrun_irq         :  std_logic;
   SIGNAL transmit_irq             :  std_logic;
   SIGNAL receive_irq              :  std_logic;
   SIGNAL error_irq                :  std_logic;
   SIGNAL bus_error_irq            :  std_logic;
   SIGNAL arbitration_lost_irq     :  std_logic;
   SIGNAL error_passive_irq        :  std_logic;
   SIGNAL data_out_xhdl1           :  std_logic_vector(7 DOWNTO 0);
   SIGNAL irq_n_xhdl2              :  std_logic;
   SIGNAL reset_mode_xhdl3         :  std_logic;
   SIGNAL listen_only_mode_xhdl4   :  std_logic;
   SIGNAL acceptance_filter_mode_xhdl5    :  std_logic;
   SIGNAL self_test_mode_xhdl6     :  std_logic;
   SIGNAL clear_data_overrun_xhdl7 :  std_logic;
   SIGNAL release_buffer_xhdl8     :  std_logic;
   SIGNAL abort_tx_xhdl9           :  std_logic;
   SIGNAL tx_request_xhdl10        :  std_logic;
   SIGNAL self_rx_request_xhdl11   :  std_logic;
   SIGNAL single_shot_transmission_xhdl12 :  std_logic;
   SIGNAL overload_request_xhdl13  :  std_logic;
   SIGNAL read_arbitration_lost_capture_reg_xhdl14:  std_logic;
   SIGNAL read_error_code_capture_reg_xhdl15:  std_logic;
   SIGNAL baud_r_presc_xhdl16      :  std_logic_vector(5 DOWNTO 0);
   SIGNAL sync_jump_width_xhdl17   :  std_logic_vector(1 DOWNTO 0);
   SIGNAL time_segment1_xhdl18     :  std_logic_vector(3 DOWNTO 0);
   SIGNAL time_segment2_xhdl19     :  std_logic_vector(2 DOWNTO 0);
   SIGNAL triple_sampling_xhdl20   :  std_logic;
   SIGNAL error_warning_limit_xhdl21      :  std_logic_vector(7 DOWNTO 0);
   SIGNAL we_rx_err_cnt_xhdl22     :  std_logic;
   SIGNAL we_tx_err_cnt_xhdl23     :  std_logic;
   SIGNAL extended_mode_xhdl24     :  std_logic;
   SIGNAL clkout_xhdl25            :  std_logic;
   SIGNAL acceptance_code_0_xhdl26 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_0_xhdl27 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_code_1_xhdl28 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_code_2_xhdl29 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_code_3_xhdl30 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_1_xhdl31 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_2_xhdl32 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_3_xhdl33 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_0_xhdl34         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_1_xhdl35         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_2_xhdl36         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_3_xhdl37         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_4_xhdl38         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_5_xhdl39         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_6_xhdl40         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_7_xhdl41         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_8_xhdl42         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_9_xhdl43         :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_10_xhdl44        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_11_xhdl45        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_12_xhdl46        :  std_logic_vector(7 DOWNTO 0);

BEGIN
   data_out <= data_out_xhdl1;
   irq_n <= irq_n_xhdl2;
   reset_mode <= reset_mode_xhdl3;
   listen_only_mode <= listen_only_mode_xhdl4;
   acceptance_filter_mode <= acceptance_filter_mode_xhdl5;
   self_test_mode <= self_test_mode_xhdl6;
   clear_data_overrun <= clear_data_overrun_xhdl7;
   release_buffer <= release_buffer_xhdl8;
   abort_tx <= abort_tx_xhdl9;
   tx_request <= tx_request_xhdl10;
   self_rx_request <= self_rx_request_xhdl11;
   single_shot_transmission <= single_shot_transmission_xhdl12;
   overload_request <= overload_request_xhdl13;
   read_arbitration_lost_capture_reg <= read_arbitration_lost_capture_reg_xhdl14;
   read_error_code_capture_reg <= read_error_code_capture_reg_xhdl15;
   baud_r_presc <= baud_r_presc_xhdl16;
   sync_jump_width <= sync_jump_width_xhdl17;
   time_segment1 <= time_segment1_xhdl18;
   time_segment2 <= time_segment2_xhdl19;
   triple_sampling <= triple_sampling_xhdl20;
   error_warning_limit <= error_warning_limit_xhdl21;
   we_rx_err_cnt <= we_rx_err_cnt_xhdl22;
   we_tx_err_cnt <= we_tx_err_cnt_xhdl23;
   extended_mode <= extended_mode_xhdl24;
   clkout <= clkout_xhdl25;
   acceptance_code_0 <= acceptance_code_0_xhdl26;
   acceptance_mask_0 <= acceptance_mask_0_xhdl27;
   acceptance_code_1 <= acceptance_code_1_xhdl28;
   acceptance_code_2 <= acceptance_code_2_xhdl29;
   acceptance_code_3 <= acceptance_code_3_xhdl30;
   acceptance_mask_1 <= acceptance_mask_1_xhdl31;
   acceptance_mask_2 <= acceptance_mask_2_xhdl32;
   acceptance_mask_3 <= acceptance_mask_3_xhdl33;
   tx_data_0 <= tx_data_0_xhdl34;
   tx_data_1 <= tx_data_1_xhdl35;
   tx_data_2 <= tx_data_2_xhdl36;
   tx_data_3 <= tx_data_3_xhdl37;
   tx_data_4 <= tx_data_4_xhdl38;
   tx_data_5 <= tx_data_5_xhdl39;
   tx_data_6 <= tx_data_6_xhdl40;
   tx_data_7 <= tx_data_7_xhdl41;
   tx_data_8 <= tx_data_8_xhdl42;
   tx_data_9 <= tx_data_9_xhdl43;
   tx_data_10 <= tx_data_10_xhdl44;
   tx_data_11 <= tx_data_11_xhdl45;
   tx_data_12 <= tx_data_12_xhdl46;
   we_mode <= (cs AND we) AND CONV_STD_LOGIC(addr = "00000000") ;
   we_command <= (cs AND we) AND CONV_STD_LOGIC(addr = "00000001") ;
   we_bus_timing_0 <= ((cs AND we) AND CONV_STD_LOGIC(addr = "00000110")) AND reset_mode_xhdl3 ;
   we_bus_timing_1 <= ((cs AND we) AND CONV_STD_LOGIC(addr = "00000111")) AND reset_mode_xhdl3 ;
   we_clock_divider_low <= (cs AND we) AND CONV_STD_LOGIC(addr = "00011111") ;
   we_clock_divider_hi <= we_clock_divider_low AND reset_mode_xhdl3 ;
   read <= cs AND (NOT we) ;
   read_irq_reg <= read AND CONV_STD_LOGIC(addr = "00000011") ;

   reset_irq_reg <= read_irq_reg_q and not read_irq_reg;

   read_arbitration_lost_capture_reg_xhdl14 <= (read AND extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001011") ;
   read_error_code_capture_reg_xhdl15 <= (read AND extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001100") ;
   we_acceptance_code_0 <= ((cs AND we) AND reset_mode_xhdl3) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00000100")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010000"))) ;
   we_acceptance_mask_0 <= ((cs AND we) AND reset_mode_xhdl3) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00000101")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010100"))) ;
   we_tx_data_0 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001010")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010000")))) AND transmit_buffer_status ;
   we_tx_data_1 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001011")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010001")))) AND transmit_buffer_status ;
   we_tx_data_2 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001100")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010010")))) AND transmit_buffer_status ;
   we_tx_data_3 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001101")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010011")))) AND transmit_buffer_status ;
   we_tx_data_4 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001110")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010100")))) AND transmit_buffer_status ;
   we_tx_data_5 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00001111")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010101")))) AND transmit_buffer_status ;
   we_tx_data_6 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00010000")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010110")))) AND transmit_buffer_status ;
   we_tx_data_7 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00010001")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00010111")))) AND transmit_buffer_status ;
   we_tx_data_8 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00010010")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00011000")))) AND transmit_buffer_status ;
   we_tx_data_9 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (((NOT extended_mode_xhdl24) AND CONV_STD_LOGIC(addr = "00010011")) OR (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00011001")))) AND transmit_buffer_status ;
   we_tx_data_10 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00011010"))) AND transmit_buffer_status ;
   we_tx_data_11 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00011011"))) AND transmit_buffer_status ;
   we_tx_data_12 <= (((cs AND we) AND (NOT reset_mode_xhdl3)) AND (extended_mode_xhdl24 AND CONV_STD_LOGIC(addr = "00011100"))) AND transmit_buffer_status ;
   we_interrupt_enable <= ((cs AND we) AND CONV_STD_LOGIC(addr = "00000100")) AND extended_mode_xhdl24 ;
   we_error_warning_limit <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00001101")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_rx_err_cnt_xhdl22 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00001110")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_tx_err_cnt_xhdl23 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00001111")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_code_1 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010001")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_code_2 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010010")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_code_3 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010011")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_mask_1 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010101")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_mask_2 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010110")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;
   we_acceptance_mask_3 <= (((cs AND we) AND CONV_STD_LOGIC(addr = "00010111")) AND reset_mode_xhdl3) AND extended_mode_xhdl24 ;

   -- End: This section is for EXTENDED mode
   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         read_irq_reg_q <= read_irq_reg;
         tx_successful_q <= tx_successful ;
         overrun_q <= overrun ;
         transmit_buffer_status_q <= transmit_buffer_status ;
         error_status_q <= error_status ;
         node_bus_off_q <= node_bus_off ;
         node_error_passive_q <= node_error_passive ;
      END IF;
   END PROCESS;
   port_xhdl52 <= data_in(0);
   MODE_REG0 : can_register_asyn_syn
      GENERIC MAP (1, 1)
         PORT MAP (
            data_in(0) => port_xhdl52,
            data_out(0) => mode,
            we => we_mode,
            clk => clk,
            rst => rst,
            rst_sync => set_reset_mode);

      MODE_REG_BASIC : can_register_asyn
         GENERIC MAP (4, 0)
            PORT MAP (
               data_in => data_in(4 DOWNTO 1),
               data_out => mode_basic(4 DOWNTO 1),
               we => we_mode,
               clk => clk,
               rst => rst);

         xhdl_61 <= (we_mode AND reset_mode_xhdl3);
         MODE_REG_EXT : can_register_asyn
            GENERIC MAP (3, 0)
               PORT MAP (
                  data_in => data_in(3 DOWNTO 1),
                  data_out => mode_ext(3 DOWNTO 1),
                  we => xhdl_61,
                  clk => clk,
                  rst => rst);

            reset_mode_xhdl3 <= mode ;
            listen_only_mode_xhdl4 <= extended_mode_xhdl24 AND mode_ext(1) ;
            self_test_mode_xhdl6 <= extended_mode_xhdl24 AND mode_ext(2) ;
            acceptance_filter_mode_xhdl5 <= extended_mode_xhdl24 AND mode_ext(3) ;
            receive_irq_en_basic <= mode_basic(1) ;
            transmit_irq_en_basic <= mode_basic(2) ;
            error_irq_en_basic <= mode_basic(3) ;
            overrun_irq_en_basic <= mode_basic(4) ;
            xhdl_69 <= (command(0) AND sample_point) OR reset_mode_xhdl3;
            port_xhdl70 <= data_in(0);
            command(0) <= port_xhdl71;
            COMMAND_REG0 : can_register_asyn_syn
               GENERIC MAP (1, 0)
                  PORT MAP (
                     data_in(0) => port_xhdl70,
                     data_out(0) => port_xhdl71,
                     we => we_command,
                     clk => clk,
                     rst => rst,
                     rst_sync => xhdl_69);

               xhdl_77 <= (sample_point AND (tx_request_xhdl10 OR (abort_tx_xhdl9 AND NOT transmitting))) OR reset_mode_xhdl3;
               port_xhdl78 <= data_in(1);
               command(1) <= port_xhdl79;
               COMMAND_REG1 : can_register_asyn_syn
                  GENERIC MAP (1, 0)
                     PORT MAP (
                        data_in(0) => port_xhdl78,
                        data_out(0) => port_xhdl79,
                        we => we_command,
                        clk => clk,
                        rst => rst,
                        rst_sync => xhdl_77);

                  xhdl_85 <= orv(command(3 DOWNTO 2)) OR reset_mode_xhdl3;
                  COMMAND_REG : can_register_asyn_syn
                     GENERIC MAP (2, 0)
                        PORT MAP (
                           data_in => data_in(3 DOWNTO 2),
                           data_out => command(3 DOWNTO 2),
                           we => we_command,
                           clk => clk,
                           rst => rst,
                           rst_sync => xhdl_85);

                     xhdl_91 <= (command(4) AND sample_point) OR reset_mode_xhdl3;
                     port_xhdl92 <= data_in(4);
                     command(4) <= port_xhdl93;
                     COMMAND_REG4 : can_register_asyn_syn
                        GENERIC MAP (1, 0)
                           PORT MAP (
                              data_in(0) => port_xhdl92,
                              data_out(0) => port_xhdl93,
                              we => we_command,
                              clk => clk,
                              rst => rst,
                              rst_sync => xhdl_91);


                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              self_rx_request_xhdl11 <= '0';
                           ELSif clk'event and clk = '1' then
                              IF ((command(4) AND (NOT command(0))) = '1') THEN
                                 self_rx_request_xhdl11 <= '1' ;
                              ELSE
                                 IF (((NOT tx_state) AND tx_state_q) = '1') THEN
                                    self_rx_request_xhdl11 <= '0' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;
                        clear_data_overrun_xhdl7 <= command(3) ;
                        release_buffer_xhdl8 <= command(2) ;
                        tx_request_xhdl10 <= command(0) OR command(4) ;
                        abort_tx_xhdl9 <= command(1) AND (NOT tx_request_xhdl10) ;

                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              single_shot_transmission_xhdl12 <= '0';
                           ELSif clk'event and clk = '1' then
                              IF (((tx_request_xhdl10 AND command(1)) AND sample_point) = '1') THEN
                                 single_shot_transmission_xhdl12 <= '1' ;
                              ELSE
                                 IF (((NOT tx_state) AND tx_state_q) = '1') THEN
                                    single_shot_transmission_xhdl12 <= '0' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;
                        --
                        -- can_register_asyn_syn #(1, 1'h0) COMMAND_REG_OVERLOAD  // Uncomment this to enable overload requests !!!
                        -- ( .data_in(data_in[5]),
                        --   .data_out(overload_request),
                        --   .we(we_command),
                        --   .clk(clk),
                        --   .rst(rst),
                        --   .rst_sync(overload_frame & ~overload_frame_q)
                        -- );
                        -- reg           overload_frame_q;
                        -- always @ (posedge clk or posedge rst)
                        -- begin
                        --   if (rst)
                        --     overload_frame_q <= 1'b0;
                        --   else
                        --     overload_frame_q <=#Tp overload_frame;
                        -- end
                        --
                        overload_request_xhdl13 <= '0' ;
                        status(7) <= node_bus_off ;
                        status(6) <= error_status ;
                        status(5) <= transmit_status ;
                        status(4) <= receive_status ;
                        status(3) <= transmission_complete ;
                        status(2) <= transmit_buffer_status ;
                        status(1) <= overrun_status ;
                        status(0) <= receive_buffer_status ;

                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              transmission_complete <= '1';
                           ELSif clk'event and clk = '1' then
                              IF ((tx_successful AND ((NOT tx_successful_q) OR abort_tx_xhdl9)) = '1') THEN
--                              transmission_complete was always set when abort_tx=1
--                              Original code:
--                              IF (((tx_successful AND (NOT tx_successful_q)) OR abort_tx_xhdl9) = '1') THEN
                                 transmission_complete <= '1' ;
                              ELSE
                                 IF (tx_request_xhdl10 = '1') THEN
                                    transmission_complete <= '0' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;

                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              transmit_buffer_status <= '1';
                           ELSif clk'event and clk = '1' then
                              IF (tx_request_xhdl10 = '1') THEN
                                 transmit_buffer_status <= '0' ;
                              ELSE
                                 IF ((reset_mode_xhdl3 OR NOT need_to_tx) = '1') THEN
                                    transmit_buffer_status <= '1' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;

                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              overrun_status <= '0';
                           ELSif clk'event and clk = '1' then
                              IF ((overrun AND (NOT overrun_q)) = '1') THEN
                                 overrun_status <= '1' ;
                              ELSE
                                 IF ((reset_mode_xhdl3 OR clear_data_overrun_xhdl7) = '1') THEN
                                    overrun_status <= '0' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;

                        PROCESS (clk, rst)
                        BEGIN
                           IF (rst = '1') THEN
                              receive_buffer_status <= '0';
                           ELSif clk'event and clk = '1' then
                              IF ((reset_mode_xhdl3 OR release_buffer_xhdl8) = '1') THEN
                                 receive_buffer_status <= '0' ;
                              ELSE
                                 IF (NOT info_empty = '1') THEN
                                    receive_buffer_status <= '1' ;
                                 END IF;
                              END IF;
                           END IF;
                        END PROCESS;
                        IRQ_EN_REG : can_register
                           GENERIC MAP (8)
                              PORT MAP (
                                 data_in => data_in,
                                 data_out => irq_en_ext,
                                 we => we_interrupt_enable,
                                 clk => clk);

                           bus_error_irq_en <= irq_en_ext(7) ;
                           arbitration_lost_irq_en <= irq_en_ext(6) ;
                           error_passive_irq_en <= irq_en_ext(5) ;
                           data_overrun_irq_en_ext <= irq_en_ext(3) ;
                           error_warning_irq_en_ext <= irq_en_ext(2) ;
                           transmit_irq_en_ext <= irq_en_ext(1) ;
                           receive_irq_en_ext <= irq_en_ext(0) ;
                           BUS_TIMING_0_REG : can_register
                              GENERIC MAP (8)
                                 PORT MAP (
                                    data_in => data_in,
                                    data_out => bus_timing_0,
                                    we => we_bus_timing_0,
                                    clk => clk);

                              baud_r_presc_xhdl16 <= bus_timing_0(5 DOWNTO 0) ;
                              sync_jump_width_xhdl17 <= bus_timing_0(7 DOWNTO 6) ;
                              BUS_TIMING_1_REG : can_register
                                 GENERIC MAP (8)
                                    PORT MAP (
                                       data_in => data_in,
                                       data_out => bus_timing_1,
                                       we => we_bus_timing_1,
                                       clk => clk);

                                 time_segment1_xhdl18 <= bus_timing_1(3 DOWNTO 0) ;
                                 time_segment2_xhdl19 <= bus_timing_1(6 DOWNTO 4) ;
                                 triple_sampling_xhdl20 <= bus_timing_1(7) ;

                                 -- End Bus Timing 1 register -- Error Warning Limit register
                                 ERROR_WARNING_REG : can_register_asyn
                                    GENERIC MAP (8, 96)
                                       PORT MAP (
                                          data_in => data_in,
                                          data_out => error_warning_limit_xhdl21,
                                          we => we_error_warning_limit,
                                          clk => clk,
                                          rst => rst);

                                    port_xhdl116 <= data_in(7);
                                    clock_divider(7) <= port_xhdl117;
                                    CLOCK_DIVIDER_REG_7 : can_register_asyn
                                       GENERIC MAP (1, 0)
                                          PORT MAP (
                                             data_in(0) => port_xhdl116,
                                             data_out(0) => port_xhdl117,
                                             we => we_clock_divider_hi,
                                             clk => clk,
                                             rst => rst);

                                       clock_divider(6 DOWNTO 4) <= "000" ;
                                       port_xhdl123 <= data_in(3);
                                       clock_divider(3) <= port_xhdl124;
                                       CLOCK_DIVIDER_REG_3 : can_register_asyn
                                          GENERIC MAP (1, 0)
                                             PORT MAP (
                                                data_in(0) => port_xhdl123,
                                                data_out(0) => port_xhdl124,
                                                we => we_clock_divider_hi,
                                                clk => clk,
                                                rst => rst);

                                          CLOCK_DIVIDER_REG_LOW : can_register_asyn
                                             GENERIC MAP (3, 0)
                                                PORT MAP (
                                                   data_in => data_in(2 DOWNTO 0),
                                                   data_out => clock_divider(2 DOWNTO 0),
                                                   we => we_clock_divider_low,
                                                   clk => clk,
                                                   rst => rst);

                                             extended_mode_xhdl24 <= clock_divider(7) ;
                                             clock_off <= clock_divider(3) ;
                                             cd(2 DOWNTO 0) <= clock_divider(2 DOWNTO 0) ;

                                             PROCESS (cd)
                                                VARIABLE clkout_div_xhdl130  : std_logic_vector(2 DOWNTO 0);
                                             BEGIN
                                                CASE cd IS
                                                   -- synthesis full_case parallel_case
                                                   WHEN "000" =>
                                                            clkout_div_xhdl130 := "000";
                                                   WHEN "001" =>
                                                            clkout_div_xhdl130 := "001";
                                                   WHEN "010" =>
                                                            clkout_div_xhdl130 := "010";
                                                   WHEN "011" =>
                                                            clkout_div_xhdl130 := "011";
                                                   WHEN "100" =>
                                                            clkout_div_xhdl130 := "100";
                                                   WHEN "101" =>
                                                            clkout_div_xhdl130 := "101";
                                                   WHEN "110" =>
                                                            clkout_div_xhdl130 := "110";
                                                   WHEN "111" =>
                                                            clkout_div_xhdl130 := "000";
                                                   WHEN OTHERS =>
                                                            NULL;

                                                END CASE;
                                                clkout_div <= clkout_div_xhdl130;
                                             END PROCESS;

                                             PROCESS (clk, rst)
                                             BEGIN
                                                IF (rst = '1') THEN
                                                   clkout_cnt <= "000";
                                                ELSif clk'event and clk = '1' then
                                                   IF (clkout_cnt = clkout_div) THEN
                                                      clkout_cnt <= "000" ;
                                                   ELSE
                                                      clkout_cnt <= clkout_cnt + "001";
                                                   END IF;
                                                END IF;
                                             END PROCESS;

                                             PROCESS (clk, rst)
                                             BEGIN
                                                IF (rst = '1') THEN
                                                   clkout_tmp <= '0';
                                                ELSif clk'event and clk = '1' then
                                                   IF (clkout_cnt = clkout_div) THEN
                                                      clkout_tmp <= NOT clkout_tmp ;
                                                   END IF;
                                                END IF;
                                             END PROCESS;
                                             temp_xhdl131 <= clk WHEN (andv(cd)) = '1' ELSE clkout_tmp;
                                             temp_xhdl132 <= '1' WHEN clock_off = '1' ELSE (temp_xhdl131);
                                             clkout_xhdl25 <= temp_xhdl132 ;

                                             -- End Clock Divider register -- This section is for BASIC and EXTENDED mode -- Acceptance code register
                                             ACCEPTANCE_CODE_REG0 : can_register
                                                GENERIC MAP (8)
                                                   PORT MAP (
                                                      data_in => data_in,
                                                      data_out => acceptance_code_0_xhdl26,
                                                      we => we_acceptance_code_0,
                                                      clk => clk);


                                                -- End: Acceptance code register -- Acceptance mask register
                                                ACCEPTANCE_MASK_REG0 : can_register
                                                   GENERIC MAP (8)
                                                      PORT MAP (
                                                         data_in => data_in,
                                                         data_out => acceptance_mask_0_xhdl27,
                                                         we => we_acceptance_mask_0,
                                                         clk => clk);


                                                   -- End: Acceptance mask register -- End: This section is for BASIC and EXTENDED mode -- Tx data 0 register.
                                                   TX_DATA_REG0 : can_register
                                                      GENERIC MAP (8)
                                                         PORT MAP (
                                                            data_in => data_in,
                                                            data_out => tx_data_0_xhdl34,
                                                            we => we_tx_data_0,
                                                            clk => clk);


                                                      -- End: Tx data 0 register. -- Tx data 1 register.
                                                      TX_DATA_REG1 : can_register
                                                         GENERIC MAP (8)
                                                            PORT MAP (
                                                               data_in => data_in,
                                                               data_out => tx_data_1_xhdl35,
                                                               we => we_tx_data_1,
                                                               clk => clk);


                                                         -- End: Tx data 1 register. -- Tx data 2 register.
                                                         TX_DATA_REG2 : can_register
                                                            GENERIC MAP (8)
                                                               PORT MAP (
                                                                  data_in => data_in,
                                                                  data_out => tx_data_2_xhdl36,
                                                                  we => we_tx_data_2,
                                                                  clk => clk);


                                                            -- End: Tx data 2 register. -- Tx data 3 register.
                                                            TX_DATA_REG3 : can_register
                                                               GENERIC MAP (8)
                                                                  PORT MAP (
                                                                     data_in => data_in,
                                                                     data_out => tx_data_3_xhdl37,
                                                                     we => we_tx_data_3,
                                                                     clk => clk);


                                                               -- End: Tx data 3 register. -- Tx data 4 register.
                                                               TX_DATA_REG4 : can_register
                                                                  GENERIC MAP (8)
                                                                     PORT MAP (
                                                                        data_in => data_in,
                                                                        data_out => tx_data_4_xhdl38,
                                                                        we => we_tx_data_4,
                                                                        clk => clk);


                                                                  -- End: Tx data 4 register. -- Tx data 5 register.
                                                                  TX_DATA_REG5 : can_register
                                                                     GENERIC MAP (8)
                                                                        PORT MAP (
                                                                           data_in => data_in,
                                                                           data_out => tx_data_5_xhdl39,
                                                                           we => we_tx_data_5,
                                                                           clk => clk);


                                                                     -- End: Tx data 5 register. -- Tx data 6 register.
                                                                     TX_DATA_REG6 : can_register
                                                                        GENERIC MAP (8)
                                                                           PORT MAP (
                                                                              data_in => data_in,
                                                                              data_out => tx_data_6_xhdl40,
                                                                              we => we_tx_data_6,
                                                                              clk => clk);


                                                                        -- End: Tx data 6 register. -- Tx data 7 register.
                                                                        TX_DATA_REG7 : can_register
                                                                           GENERIC MAP (8)
                                                                              PORT MAP (
                                                                                 data_in => data_in,
                                                                                 data_out => tx_data_7_xhdl41,
                                                                                 we => we_tx_data_7,
                                                                                 clk => clk);


                                                                           -- End: Tx data 7 register. -- Tx data 8 register.
                                                                           TX_DATA_REG8 : can_register
                                                                              GENERIC MAP (8)
                                                                                 PORT MAP (
                                                                                    data_in => data_in,
                                                                                    data_out => tx_data_8_xhdl42,
                                                                                    we => we_tx_data_8,
                                                                                    clk => clk);


                                                                              -- End: Tx data 8 register. -- Tx data 9 register.
                                                                              TX_DATA_REG9 : can_register
                                                                                 GENERIC MAP (8)
                                                                                    PORT MAP (
                                                                                       data_in => data_in,
                                                                                       data_out => tx_data_9_xhdl43,
                                                                                       we => we_tx_data_9,
                                                                                       clk => clk);


                                                                                 -- End: Tx data 9 register. -- Tx data 10 register.
                                                                                 TX_DATA_REG10 : can_register
                                                                                    GENERIC MAP (8)
                                                                                       PORT MAP (
                                                                                          data_in => data_in,
                                                                                          data_out => tx_data_10_xhdl44,
                                                                                          we => we_tx_data_10,
                                                                                          clk => clk);


                                                                                    -- End: Tx data 10 register. -- Tx data 11 register.
                                                                                    TX_DATA_REG11 : can_register
                                                                                       GENERIC MAP (8)
                                                                                          PORT MAP (
                                                                                             data_in => data_in,
                                                                                             data_out => tx_data_11_xhdl45,
                                                                                             we => we_tx_data_11,
                                                                                             clk => clk);


                                                                                       -- End: Tx data 11 register. -- Tx data 12 register.
                                                                                       TX_DATA_REG12 : can_register
                                                                                          GENERIC MAP (8)
                                                                                             PORT MAP (
                                                                                                data_in => data_in,
                                                                                                data_out => tx_data_12_xhdl46,
                                                                                                we => we_tx_data_12,
                                                                                                clk => clk);


                                                                                          -- End: Tx data 12 register. -- This section is for EXTENDED mode -- Acceptance code register 1
                                                                                          ACCEPTANCE_CODE_REG1 : can_register
                                                                                             GENERIC MAP (8)
                                                                                                PORT MAP (
                                                                                                   data_in => data_in,
                                                                                                   data_out => acceptance_code_1_xhdl28,
                                                                                                   we => we_acceptance_code_1,
                                                                                                   clk => clk);


                                                                                             -- End: Acceptance code register -- Acceptance code register 2
                                                                                             ACCEPTANCE_CODE_REG2 : can_register
                                                                                                GENERIC MAP (8)
                                                                                                   PORT MAP (
                                                                                                      data_in => data_in,
                                                                                                      data_out => acceptance_code_2_xhdl29,
                                                                                                      we => we_acceptance_code_2,
                                                                                                      clk => clk);


                                                                                                -- End: Acceptance code register -- Acceptance code register 3
                                                                                                ACCEPTANCE_CODE_REG3 : can_register
                                                                                                   GENERIC MAP (8)
                                                                                                      PORT MAP (
                                                                                                         data_in => data_in,
                                                                                                         data_out => acceptance_code_3_xhdl30,
                                                                                                         we => we_acceptance_code_3,
                                                                                                         clk => clk);


                                                                                                   -- End: Acceptance code register -- Acceptance mask register 1
                                                                                                   ACCEPTANCE_MASK_REG1 : can_register
                                                                                                      GENERIC MAP (8)
                                                                                                         PORT MAP (
                                                                                                            data_in => data_in,
                                                                                                            data_out => acceptance_mask_1_xhdl31,
                                                                                                            we => we_acceptance_mask_1,
                                                                                                            clk => clk);


                                                                                                      -- End: Acceptance code register -- Acceptance mask register 2
                                                                                                      ACCEPTANCE_MASK_REG2 : can_register
                                                                                                         GENERIC MAP (8)
                                                                                                            PORT MAP (
                                                                                                               data_in => data_in,
                                                                                                               data_out => acceptance_mask_2_xhdl32,
                                                                                                               we => we_acceptance_mask_2,
                                                                                                               clk => clk);


                                                                                                         -- End: Acceptance code register -- Acceptance mask register 3
                                                                                                         ACCEPTANCE_MASK_REG3 : can_register
                                                                                                            GENERIC MAP (8)
                                                                                                               PORT MAP (
                                                                                                                  data_in => data_in,
                                                                                                                  data_out => acceptance_mask_3_xhdl33,
                                                                                                                  we => we_acceptance_mask_3,
                                                                                                                  clk => clk);

                                                                                                            temp_xhdl218 <= acceptance_code_0_xhdl26 WHEN reset_mode_xhdl3 = '1' ELSE "11111111";
                                                                                                            temp_xhdl219 <= acceptance_mask_0_xhdl27 WHEN reset_mode_xhdl3 = '1' ELSE "11111111";
                                                                                                            temp_xhdl220 <= bus_timing_0 WHEN reset_mode_xhdl3 = '1' ELSE "11111111";
                                                                                                            temp_xhdl221 <= bus_timing_1 WHEN reset_mode_xhdl3 = '1' ELSE "11111111";
                                                                                                            temp_xhdl222 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_0_xhdl34;
                                                                                                            temp_xhdl223 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_1_xhdl35;
                                                                                                            temp_xhdl224 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_2_xhdl36;
                                                                                                            temp_xhdl225 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_3_xhdl37;
                                                                                                            temp_xhdl226 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_4_xhdl38;
                                                                                                            temp_xhdl227 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_5_xhdl39;
                                                                                                            temp_xhdl228 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_6_xhdl40;
                                                                                                            temp_xhdl229 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_7_xhdl41;
                                                                                                            temp_xhdl230 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_8_xhdl42;
                                                                                                            temp_xhdl231 <= "11111111" WHEN reset_mode_xhdl3 = '1' ELSE tx_data_9_xhdl43;

                                                                                                            -- End: Acceptance code register -- End: This section is for EXTENDED mode -- Reading data from registers

                                                                                                            PROCESS (addr, extended_mode_xhdl24, mode, bus_timing_0, bus_timing_1, clock_divider,
															acceptance_code_0_xhdl26, acceptance_code_1_xhdl28, acceptance_code_2_xhdl29,
															acceptance_code_3_xhdl30, acceptance_mask_0_xhdl27, acceptance_mask_1_xhdl31,
															acceptance_mask_2_xhdl32, acceptance_mask_3_xhdl33, status,
															error_warning_limit_xhdl21, rx_err_cnt, tx_err_cnt, irq_en_ext, irq_reg, mode_ext,
															arbitration_lost_capture, rx_message_counter, mode_basic, error_capture_code,
															temp_xhdl218, temp_xhdl219, temp_xhdl220, temp_xhdl221, temp_xhdl222, temp_xhdl223,
															temp_xhdl224, temp_xhdl225, temp_xhdl226, temp_xhdl227, temp_xhdl228, temp_xhdl229,
															temp_xhdl230, temp_xhdl231
														       )
                                                                                                               VARIABLE data_out_xhdl1_xhdl217  : std_logic_vector(7 DOWNTO 0);
                                                                                                               VARIABLE temp_xhdl232  : std_logic_vector(5 DOWNTO 0);
                                                                                                            BEGIN
                                                                                                               temp_xhdl232 := extended_mode_xhdl24 & addr(4 DOWNTO 0);
                                                                                                               CASE temp_xhdl232 IS
                                                                                                                  WHEN "100000" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "0000" & mode_ext(3 DOWNTO 1) & mode;    --  extended mode
                                                                                                                  WHEN "100001" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "100010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := status;    --  extended mode
                                                                                                                  WHEN "100011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := irq_reg;    --  extended mode
                                                                                                                  WHEN "100100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := irq_en_ext;    --  extended mode
                                                                                                                  WHEN "100110" =>
                                                                                                                           data_out_xhdl1_xhdl217 := bus_timing_0;    --  extended mode
                                                                                                                  WHEN "100111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := bus_timing_1;    --  extended mode
                                                                                                                  WHEN "101011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "000" & arbitration_lost_capture(4 DOWNTO 0);    --  extended mode
                                                                                                                  WHEN "101100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := error_capture_code;    --  extended mode
                                                                                                                  WHEN "101101" =>
                                                                                                                           data_out_xhdl1_xhdl217 := error_warning_limit_xhdl21;    --  extended mode
                                                                                                                  WHEN "101110" =>
                                                                                                                           data_out_xhdl1_xhdl217 := rx_err_cnt;    --  extended mode
                                                                                                                  WHEN "101111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := tx_err_cnt;    --  extended mode
                                                                                                                  WHEN "110000" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_code_0_xhdl26;    --  extended mode
                                                                                                                  WHEN "110001" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_code_1_xhdl28;    --  extended mode
                                                                                                                  WHEN "110010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_code_2_xhdl29;    --  extended mode
                                                                                                                  WHEN "110011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_code_3_xhdl30;    --  extended mode
                                                                                                                  WHEN "110100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_mask_0_xhdl27;    --  extended mode
                                                                                                                  WHEN "110101" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_mask_1_xhdl31;    --  extended mode
                                                                                                                  WHEN "110110" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_mask_2_xhdl32;    --  extended mode
                                                                                                                  WHEN "110111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := acceptance_mask_3_xhdl33;    --  extended mode
                                                                                                                  WHEN "111000" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "111001" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "111010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "111011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "111100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  extended mode
                                                                                                                  WHEN "111101" =>
                                                                                                                           data_out_xhdl1_xhdl217 := '0' & rx_message_counter;    --  extended mode
                                                                                                                  WHEN "111111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := clock_divider;    --  extended mode
                                                                                                                  WHEN "000000" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "001" & mode_basic(4 DOWNTO 1) & mode;    --  basic mode
                                                                                                                  WHEN "000001" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "11111111";    --  basic mode
                                                                                                                  WHEN "000010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := status;    --  basic mode
                                                                                                                  WHEN "000011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := "1110" & irq_reg(3 DOWNTO 0);    --  basic mode
                                                                                                                  WHEN "000100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl218;
                                                                                                                  WHEN "000101" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl219;
                                                                                                                  WHEN "000110" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl220;
                                                                                                                  WHEN "000111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl221;
                                                                                                                  WHEN "001010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl222;
                                                                                                                  WHEN "001011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl223;
                                                                                                                  WHEN "001100" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl224;
                                                                                                                  WHEN "001101" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl225;
                                                                                                                  WHEN "001110" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl226;
                                                                                                                  WHEN "001111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl227;
                                                                                                                  WHEN "010000" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl228;
                                                                                                                  WHEN "010001" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl229;
                                                                                                                  WHEN "010010" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl230;
                                                                                                                  WHEN "010011" =>
                                                                                                                           data_out_xhdl1_xhdl217 := temp_xhdl231;
                                                                                                                  WHEN "011111" =>
                                                                                                                           data_out_xhdl1_xhdl217 := clock_divider;    --  basic mode
                                                                                                                  WHEN OTHERS  =>
                                                                                                                           data_out_xhdl1_xhdl217 := "00000000";    --  the rest is read as 0

                                                                                                               END CASE;
                                                                                                               data_out_xhdl1 <= data_out_xhdl1_xhdl217;
                                                                                                            END PROCESS;
                                                                                                            temp_xhdl233 <= data_overrun_irq_en_ext WHEN extended_mode_xhdl24 = '1' ELSE overrun_irq_en_basic;
                                                                                                            data_overrun_irq_en <= temp_xhdl233 ;
                                                                                                            temp_xhdl234 <= error_warning_irq_en_ext WHEN extended_mode_xhdl24 = '1' ELSE error_irq_en_basic;
                                                                                                            error_warning_irq_en <= temp_xhdl234 ;
                                                                                                            temp_xhdl235 <= transmit_irq_en_ext WHEN extended_mode_xhdl24 = '1' ELSE transmit_irq_en_basic;
                                                                                                            transmit_irq_en <= temp_xhdl235 ;
                                                                                                            temp_xhdl236 <= receive_irq_en_ext WHEN extended_mode_xhdl24 = '1' ELSE receive_irq_en_basic;
                                                                                                            receive_irq_en <= temp_xhdl236 ;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  data_overrun_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF (((overrun AND (NOT overrun_q)) AND data_overrun_irq_en) = '1') THEN
                                                                                                                     data_overrun_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF ((reset_mode_xhdl3 OR reset_irq_reg) = '1') THEN
                                                                                                                        data_overrun_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  transmit_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((reset_mode_xhdl3 OR reset_irq_reg) = '1') THEN
                                                                                                                     transmit_irq <= '0' ;
                                                                                                                  ELSE
                                                                                                                     IF (((transmit_buffer_status AND (NOT transmit_buffer_status_q)) AND transmit_irq_en) = '1') THEN
                                                                                                                        transmit_irq <= '1' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  receive_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((((NOT info_empty) AND (NOT receive_irq)) AND receive_irq_en) = '1') THEN
                                                                                                                     receive_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF ((reset_mode_xhdl3 OR release_buffer_xhdl8) = '1') THEN
                                                                                                                        receive_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  error_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((((error_status XOR error_status_q) OR (node_bus_off XOR node_bus_off_q)) AND error_warning_irq_en) = '1') THEN
                                                                                                                     error_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF (reset_irq_reg = '1') THEN
                                                                                                                        error_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  bus_error_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((set_bus_error_irq AND bus_error_irq_en) = '1') THEN
                                                                                                                     bus_error_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF ((reset_mode_xhdl3 OR reset_irq_reg) = '1') THEN
                                                                                                                        bus_error_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  arbitration_lost_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((set_arbitration_lost_irq AND arbitration_lost_irq_en) = '1') THEN
                                                                                                                     arbitration_lost_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF ((reset_mode_xhdl3 OR reset_irq_reg) = '1') THEN
                                                                                                                        arbitration_lost_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;

                                                                                                            PROCESS (clk, rst)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1') THEN
                                                                                                                  error_passive_irq <= '0';
                                                                                                               ELSif clk'event and clk = '1' then
                                                                                                                  IF ((((node_error_passive AND (NOT node_error_passive_q)) OR (((NOT node_error_passive) AND node_error_passive_q) AND node_error_active)) AND error_passive_irq_en) = '1') THEN
                                                                                                                     error_passive_irq <= '1' ;
                                                                                                                  ELSE
                                                                                                                     IF ((reset_mode_xhdl3 OR reset_irq_reg) = '1') THEN
                                                                                                                        error_passive_irq <= '0' ;
                                                                                                                     END IF;
                                                                                                                  END IF;
                                                                                                               END IF;
                                                                                                            END PROCESS;
                                                                                                            irq_reg <= bus_error_irq & arbitration_lost_irq & error_passive_irq & '0' & data_overrun_irq & error_irq & transmit_irq & receive_irq ;
                                                                                                            irq <= data_overrun_irq OR transmit_irq OR receive_irq OR error_irq OR bus_error_irq OR arbitration_lost_irq OR error_passive_irq ;

--   irq_o reset change /Kristoffer 2006-02-23                                                                 PROCESS (clk, rst)
--                                                                                                             BEGIN
--                                                                                                                IF (rst = '1') THEN
--                                                                                                                   irq_n_xhdl2 <= '1';
--                                                                                                                ELSif clk'event and clk = '1' then
--                                                                                                                   IF (reset_irq_reg = '1' or release_buffer_xhdl8='1') THEN
--                                                                                                                      irq_n_xhdl2 <= '1';
--                                                                                                                   ELSE
--                                                                                                                      IF (irq = '1') THEN
--                                                                                                                         irq_n_xhdl2 <= '0' ;
--                                                                                                                      END IF;
--                                                                                                                   END IF;
--                                                                                                                END IF;
--                                                                                                             END PROCESS;

                                                                                                            PROCESS (clk, rst, release_buffer_xhdl8)
                                                                                                            BEGIN
                                                                                                               IF (rst = '1' or release_buffer_xhdl8 = '1') THEN
                                                                                                                  irq_n_xhdl2 <= '1';
                                                                                                               ELSif clk'event and clk = '1' then

                                                                                                                   irq_n_xhdl2 <= not irq;

                                                                                                               END IF;
                                                                                                            END PROCESS;


END ARCHITECTURE RTL;
----------------------------------------------------------------------------------------------
--
-- VHDL file generated by X-HDL - Revision 3.2.53  Aug. 1, 2005
-- Tue Aug  9 07:33:50 2005
--
--      Input file         : C:/Documents and Settings/BryantI/My Documents/tmp/can_top.v
--      Design name        : can_top
--      Author             :
--      Company            : Actel
--
--      Description        :
--
--
----------------------------------------------------------------------------------------------
--
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--//  can_top.v                                                   ////
--//                                                              ////
--//                                                              ////
--//  This file is part of the CAN Protocol Controller            ////
--//  http://www.opencores.org/projects/can/                      ////
--//                                                              ////
--//                                                              ////
--//  Author(s):                                                  ////
--//       Igor Mohor                                             ////
--//       igorm@opencores.org                                    ////
--//                                                              ////
--//                                                              ////
--//  All additional information is available in the README.txt   ////
--//  file.                                                       ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--//                                                              ////
--// Copyright (C) 2002, 2003, 2004 Authors                       ////
--//                                                              ////
--// This source file may be used and distributed without         ////
--// restriction provided that this copyright statement is not    ////
--// removed from the file and that any derivative work contains  ////
--// the original copyright notice and the associated disclaimer. ////
--//                                                              ////
--// This source file is free software; you can redistribute it   ////
--// and/or modify it under the terms of the GNU Lesser General   ////
--// Public License as published by the Free Software Foundation; ////
--// either version 2.1 of the License, or (at your option) any   ////
--// later version.                                               ////
--//                                                              ////
--// This source is distributed in the hope that it will be       ////
--// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
--// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
--// PURPOSE.  See the GNU Lesser General Public License for more ////
--// details.                                                     ////
--//                                                              ////
--// You should have received a copy of the GNU Lesser General    ////
--// Public License along with this source; if not, download it   ////
--// from http://www.opencores.org/lgpl.shtml                     ////
--//                                                              ////
--// The CAN protocol is developed by Robert Bosch GmbH and       ////
--// protected by patents. Anybody who wants to implement this    ////
--// CAN IP core on silicon has to obtain a CAN protocol license  ////
--// from Bosch.                                                  ////
--//                                                              ////
--////////////////////////////////////////////////////////////////////
--
-- CVS Revision History
--
-- $Log: can_top.v,v $
-- Revision 1.48  2004/10/25 11:44:47  igorm
-- Interrupt is always cleared for one clock after the irq register is read.
-- This fixes problems when CPU is using IRQs that are edge triggered.
--
-- Revision 1.47  2004/02/08 14:53:54  mohor
-- Header changed. Address latched to posedge. bus_off_on signal added.
--
-- Revision 1.46  2003/10/17 05:55:20  markom
-- mbist signals updated according to newest convention
--
-- Revision 1.45  2003/09/30 00:55:13  mohor
-- Error counters fixed to be compatible with Bosch VHDL reference model.
-- Small synchronization changes.
--
-- Revision 1.44  2003/09/25 18:55:49  mohor
-- Synchronization changed, error counters fixed.
--
-- Revision 1.43  2003/08/20 09:57:39  mohor
-- Tristate signal tx_o is separated to tx_o and tx_oen_o. Both signals need
-- to be joined together on higher level.
--
-- Revision 1.42  2003/07/16 15:11:28  mohor
-- Fixed according to the linter.
--
-- Revision 1.41  2003/07/10 15:32:27  mohor
-- Unused signal removed.
--
-- Revision 1.40  2003/07/10 01:59:04  tadejm
-- Synchronization fixed. In some strange cases it didn't work according to
-- the VHDL reference model.
--
-- Revision 1.39  2003/07/07 11:21:37  mohor
-- Little fixes (to fix warnings).
--
-- Revision 1.38  2003/07/03 09:32:20  mohor
-- Synchronization changed.
--
-- Revision 1.37  2003/06/27 20:56:15  simons
-- Virtual silicon ram instances added.
--
-- Revision 1.36  2003/06/17 14:30:30  mohor
-- "chip select" signal cs_can_i is used only when not using WISHBONE
-- interface.
--
-- Revision 1.35  2003/06/16 13:57:58  mohor
-- tx_point generated one clk earlier. rx_i registered. Data corrected when
-- using extended mode.
--
-- Revision 1.34  2003/06/13 15:02:24  mohor
-- Synchronization is also needed when transmitting a message.
--
-- Revision 1.33  2003/06/11 14:21:35  mohor
-- When switching to tx, sync stage is overjumped.
--
-- Revision 1.32  2003/06/09 11:32:36  mohor
-- Ports added for the CAN_BIST.
--
-- Revision 1.31  2003/03/26 11:19:46  mohor
-- CAN interrupt is active low.
--
-- Revision 1.30  2003/03/20 17:01:17  mohor
-- unix.
--
-- Revision 1.28  2003/03/14 19:36:48  mohor
-- can_cs signal used for generation of the cs.
--
-- Revision 1.27  2003/03/12 05:56:33  mohor
-- Bidirectional port_0_i changed to port_0_io.
-- input cs_can changed to cs_can_i.
--
-- Revision 1.26  2003/03/12 04:39:40  mohor
-- rd_i and wr_i are active high signals. If 8051 is connected, these two signals
-- need to be negated one level higher.
--
-- Revision 1.25  2003/03/12 04:17:36  mohor
-- 8051 interface added (besides WISHBONE interface). Selection is made in
-- can_defines.v file.
--
-- Revision 1.24  2003/03/10 17:24:40  mohor
-- wire declaration added.
--
-- Revision 1.23  2003/03/05 15:33:13  mohor
-- tx_o is now tristated signal. tx_oen and tx_o combined together.
--
-- Revision 1.22  2003/03/05 15:01:56  mohor
-- Top level signal names changed.
--
-- Revision 1.21  2003/03/01 22:53:33  mohor
-- Actel APA ram supported.
--
-- Revision 1.20  2003/02/19 15:09:02  mohor
-- Incomplete sensitivity list fixed.
--
-- Revision 1.19  2003/02/19 15:04:14  mohor
-- Typo fixed.
--
-- Revision 1.18  2003/02/19 14:44:03  mohor
-- CAN core finished. Host interface added. Registers finished.
-- Synchronization to the wishbone finished.
--
-- Revision 1.17  2003/02/18 00:10:15  mohor
-- Most of the registers added. Registers "arbitration lost capture", "error code
-- capture" + few more still need to be added.
--
-- Revision 1.16  2003/02/14 20:17:01  mohor
-- Several registers added. Not finished, yet.
--
-- Revision 1.15  2003/02/12 14:25:30  mohor
-- abort_tx added.
--
-- Revision 1.14  2003/02/11 00:56:06  mohor
-- Wishbone interface added.
--
-- Revision 1.13  2003/02/09 18:40:29  mohor
-- Overload fixed. Hard synchronization also enabled at the last bit of
-- interframe.
--
-- Revision 1.12  2003/02/09 02:24:33  mohor
-- Bosch license warning added. Error counters finished. Overload frames
-- still need to be fixed.
--
-- Revision 1.11  2003/02/04 14:34:52  mohor
-- *** empty log message ***
--
-- Revision 1.10  2003/01/31 01:13:38  mohor
-- backup.
--
-- Revision 1.9  2003/01/15 13:16:48  mohor
-- When a frame with "remote request" is received, no data is stored to
-- fifo, just the frame information (identifier, ...). Data length that
-- is stored is the received data length and not the actual data length
-- that is stored to fifo.
--
-- Revision 1.8  2003/01/14 17:25:09  mohor
-- Addresses corrected to decimal values (previously hex).
--
-- Revision 1.7  2003/01/10 17:51:34  mohor
-- Temporary version (backup).
--
-- Revision 1.6  2003/01/09 21:54:45  mohor
-- rx fifo added. Not 100 % verified, yet.
--
-- Revision 1.5  2003/01/08 02:10:56  mohor
-- Acceptance filter added.
--
-- Revision 1.4  2002/12/28 04:13:23  mohor
-- Backup version.
--
-- Revision 1.3  2002/12/27 00:12:52  mohor
-- Header changed, testbench improved to send a frame (crc still missing).
--
-- Revision 1.2  2002/12/26 16:00:34  mohor
-- Testbench define file added. Clock divider register added.
--
-- Revision 1.1.1.1  2002/12/20 16:39:21  mohor
-- Initial
--
--
--
-- synopsys translate_off
--`include "can_defines.v"
-- synopsys translate_on

LIBRARY ieee;
USE ieee.std_logic_1164.all;
library grlib;
use grlib.stdlib.all;

ENTITY can_top IS
   PORT (
--      wb_clk_i                : IN std_logic;
--      wb_rst_i                : IN std_logic;
--      wb_dat_i                : IN std_logic_vector(7 DOWNTO 0);
--      wb_dat_o                : OUT std_logic_vector(7 DOWNTO 0);
--      wb_cyc_i                : IN std_logic;
--      wb_stb_i                : IN std_logic;
--      wb_we_i                 : IN std_logic;
--      wb_adr_i                : IN std_logic_vector(7 DOWNTO 0);
--      wb_ack_o                : OUT std_logic;
      rst                     : IN std_logic;
      addr                    : IN std_logic_vector(7 DOWNTO 0);
      data_in                 : IN std_logic_vector(7 DOWNTO 0);
      data_out                : OUT std_logic_vector(7 DOWNTO 0);
      cs                      : IN std_logic;
      we                      : IN std_logic;
      clk_i                   : IN std_logic;
      rx_i                    : IN std_logic;
      tx_o                    : OUT std_logic;
      bus_off_on              : OUT std_logic;
      irq_on                  : OUT std_logic;
      clkout_o                : OUT std_logic;
      -- Bist
-- port connections for Ram
--64x8

      q_dp_64x8               : IN std_logic_vector(7 DOWNTO 0);
      data_64x8               : OUT std_logic_vector(7 DOWNTO 0);
      wren_64x8               : OUT std_logic;
      rden_64x8               : OUT std_logic;
      wraddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
      --64x4

      q_dp_64x4               : IN std_logic_vector(3 DOWNTO 0);
      data_64x4               : OUT std_logic_vector(3 DOWNTO 0);
      wren_64x4x1             : OUT std_logic;
      wraddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      rdaddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
      --64x1

      q_dp_64x1               : IN std_logic;
      data_64x1               : OUT std_logic);
END ENTITY can_top;

ARCHITECTURE RTL OF can_top IS

   COMPONENT can_bsp
      PORT (
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         sample_point            : IN  std_logic;
         sampled_bit             : IN  std_logic;
         sampled_bit_q           : IN  std_logic;
         tx_point                : IN  std_logic;
         hard_sync               : IN  std_logic;
         addr                    : IN  std_logic_vector(7 DOWNTO 0);
         data_in                 : IN  std_logic_vector(7 DOWNTO 0);
         data_out                : OUT std_logic_vector(7 DOWNTO 0);
         fifo_selected           : IN  std_logic;
         reset_mode              : IN  std_logic;
         listen_only_mode        : IN  std_logic;
         acceptance_filter_mode  : IN  std_logic;
         self_test_mode          : IN  std_logic;
         release_buffer          : IN  std_logic;
         tx_request              : IN  std_logic;
         abort_tx                : IN  std_logic;
         self_rx_request         : IN  std_logic;
         single_shot_transmission: IN  std_logic;
         tx_state                : OUT std_logic;
         tx_state_q              : OUT std_logic;
         overload_request        : IN  std_logic;
         overload_frame          : OUT std_logic;
         read_arbitration_lost_capture_reg: IN  std_logic;
         read_error_code_capture_reg: IN  std_logic;
         error_capture_code      : OUT std_logic_vector(7 DOWNTO 0);
         error_warning_limit     : IN  std_logic_vector(7 DOWNTO 0);
         we_rx_err_cnt           : IN  std_logic;
         we_tx_err_cnt           : IN  std_logic;
         extended_mode           : IN  std_logic;
         rx_idle                 : OUT std_logic;
         transmitting            : OUT std_logic;
         transmitter             : OUT std_logic;
         go_rx_inter             : OUT std_logic;
         not_first_bit_of_inter  : OUT std_logic;
         rx_inter                : OUT std_logic;
         set_reset_mode          : OUT std_logic;
         node_bus_off            : OUT std_logic;
         error_status            : OUT std_logic;
         rx_err_cnt              : OUT std_logic_vector(8 DOWNTO 0);
         tx_err_cnt              : OUT std_logic_vector(8 DOWNTO 0);
         transmit_status         : OUT std_logic;
         receive_status          : OUT std_logic;
         tx_successful           : OUT std_logic;
         need_to_tx              : OUT std_logic;
         overrun                 : OUT std_logic;
         info_empty              : OUT std_logic;
         set_bus_error_irq       : OUT std_logic;
         set_arbitration_lost_irq: OUT std_logic;
         arbitration_lost_capture: OUT std_logic_vector(4 DOWNTO 0);
         node_error_passive      : OUT std_logic;
         node_error_active       : OUT std_logic;
         rx_message_counter      : OUT std_logic_vector(6 DOWNTO 0);
         acceptance_code_0       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_0       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_1       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_2       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_code_3       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_1       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_2       : IN  std_logic_vector(7 DOWNTO 0);
         acceptance_mask_3       : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_0               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_1               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_2               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_3               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_4               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_5               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_6               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_7               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_8               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_9               : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_10              : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_11              : IN  std_logic_vector(7 DOWNTO 0);
         tx_data_12              : IN  std_logic_vector(7 DOWNTO 0);
         tx                      : OUT std_logic;
         tx_next                 : OUT std_logic;
         bus_off_on              : OUT std_logic;
         go_overload_frame       : OUT std_logic;
         go_error_frame          : OUT std_logic;
         go_tx                   : OUT std_logic;
         send_ack                : OUT std_logic;
         q_dp_64x8               : IN  std_logic_vector(7 DOWNTO 0);
         data_64x8               : OUT std_logic_vector(7 DOWNTO 0);
         wren_64x8               : OUT std_logic;
         rden_64x8               : OUT std_logic;
         wraddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
         rdaddress_64x8          : OUT std_logic_vector(5 DOWNTO 0);
         q_dp_64x4               : IN  std_logic_vector(3 DOWNTO 0);
         data_64x4               : OUT std_logic_vector(3 DOWNTO 0);
         wren_64x4x1             : OUT std_logic;
         wraddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
         rdaddress_64x4x1        : OUT std_logic_vector(5 DOWNTO 0);
         q_dp_64x1               : IN  std_logic;
         data_64x1               : OUT std_logic);
   END COMPONENT;

   COMPONENT can_btl
      PORT (
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         rx                      : IN  std_logic;
         tx                      : IN  std_logic;
         baud_r_presc            : IN  std_logic_vector(5 DOWNTO 0);
         sync_jump_width         : IN  std_logic_vector(1 DOWNTO 0);
         time_segment1           : IN  std_logic_vector(3 DOWNTO 0);
         time_segment2           : IN  std_logic_vector(2 DOWNTO 0);
         triple_sampling         : IN  std_logic;
         sample_point            : OUT std_logic;
         sampled_bit             : OUT std_logic;
         sampled_bit_q           : OUT std_logic;
         tx_point                : OUT std_logic;
         hard_sync               : OUT std_logic;
         rx_idle                 : IN  std_logic;
         rx_inter                : IN  std_logic;
         transmitting            : IN  std_logic;
         transmitter             : IN  std_logic;
         go_rx_inter             : IN  std_logic;
         tx_next                 : IN  std_logic;
         go_overload_frame       : IN  std_logic;
         go_error_frame          : IN  std_logic;
         go_tx                   : IN  std_logic;
         send_ack                : IN  std_logic;
         node_error_passive      : IN  std_logic);
   END COMPONENT;

   COMPONENT can_registers
      PORT (
         clk                     : IN  std_logic;
         rst                     : IN  std_logic;
         cs                      : IN  std_logic;
         we                      : IN  std_logic;
         addr                    : IN  std_logic_vector(7 DOWNTO 0);
         data_in                 : IN  std_logic_vector(7 DOWNTO 0);
         data_out                : OUT std_logic_vector(7 DOWNTO 0);
         irq_n                   : OUT std_logic;
         sample_point            : IN  std_logic;
         transmitting            : IN  std_logic;
         set_reset_mode          : IN  std_logic;
         node_bus_off            : IN  std_logic;
         error_status            : IN  std_logic;
         rx_err_cnt              : IN  std_logic_vector(7 DOWNTO 0);
         tx_err_cnt              : IN  std_logic_vector(7 DOWNTO 0);
         transmit_status         : IN  std_logic;
         receive_status          : IN  std_logic;
         tx_successful           : IN  std_logic;
         need_to_tx              : IN  std_logic;
         overrun                 : IN  std_logic;
         info_empty              : IN  std_logic;
         set_bus_error_irq       : IN  std_logic;
         set_arbitration_lost_irq: IN  std_logic;
         arbitration_lost_capture: IN  std_logic_vector(4 DOWNTO 0);
         node_error_passive      : IN  std_logic;
         node_error_active       : IN  std_logic;
         rx_message_counter      : IN  std_logic_vector(6 DOWNTO 0);
         reset_mode              : OUT std_logic;
         listen_only_mode        : OUT std_logic;
         acceptance_filter_mode  : OUT std_logic;
         self_test_mode          : OUT std_logic;
         clear_data_overrun      : OUT std_logic;
         release_buffer          : OUT std_logic;
         abort_tx                : OUT std_logic;
         tx_request              : OUT std_logic;
         self_rx_request         : OUT std_logic;
         single_shot_transmission: OUT std_logic;
         tx_state                : IN  std_logic;
         tx_state_q              : IN  std_logic;
         overload_request        : OUT std_logic;
         overload_frame          : IN  std_logic;
         read_arbitration_lost_capture_reg: OUT std_logic;
         read_error_code_capture_reg: OUT std_logic;
         error_capture_code      : IN  std_logic_vector(7 DOWNTO 0);
         baud_r_presc            : OUT std_logic_vector(5 DOWNTO 0);
         sync_jump_width         : OUT std_logic_vector(1 DOWNTO 0);
         time_segment1           : OUT std_logic_vector(3 DOWNTO 0);
         time_segment2           : OUT std_logic_vector(2 DOWNTO 0);
         triple_sampling         : OUT std_logic;
         error_warning_limit     : OUT std_logic_vector(7 DOWNTO 0);
         we_rx_err_cnt           : OUT std_logic;
         we_tx_err_cnt           : OUT std_logic;
         extended_mode           : OUT std_logic;
         clkout                  : OUT std_logic;
         acceptance_code_0       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_mask_0       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_code_1       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_code_2       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_code_3       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_mask_1       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_mask_2       : OUT std_logic_vector(7 DOWNTO 0);
         acceptance_mask_3       : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_0               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_1               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_2               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_3               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_4               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_5               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_6               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_7               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_8               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_9               : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_10              : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_11              : OUT std_logic_vector(7 DOWNTO 0);
         tx_data_12              : OUT std_logic_vector(7 DOWNTO 0));
   END COMPONENT;


--   SIGNAL cs_sync1                 :  std_logic;
--   SIGNAL cs_sync2                 :  std_logic;
--   SIGNAL cs_sync3                 :  std_logic;
--   SIGNAL cs_ack1                  :  std_logic;
--   SIGNAL cs_ack2                  :  std_logic;
--   SIGNAL cs_ack3                  :  std_logic;
--   SIGNAL cs_sync_rst1             :  std_logic;
--   SIGNAL cs_sync_rst2             :  std_logic;
--   SIGNAL cs_can_i                 :  std_logic;
   ---------------------------------
   SIGNAL data_out_fifo_selected   :  std_logic;
   SIGNAL data_out_fifo            :  std_logic_vector(7 DOWNTO 0);
   SIGNAL data_out_regs            :  std_logic_vector(7 DOWNTO 0);
   -- Mode register
   SIGNAL reset_mode               :  std_logic;
   SIGNAL listen_only_mode         :  std_logic;
   SIGNAL acceptance_filter_mode   :  std_logic;
   SIGNAL self_test_mode           :  std_logic;
   -- Command register
   SIGNAL release_buffer           :  std_logic;
   SIGNAL tx_request               :  std_logic;
   SIGNAL abort_tx                 :  std_logic;
   SIGNAL self_rx_request          :  std_logic;
   SIGNAL single_shot_transmission :  std_logic;
   SIGNAL tx_state                 :  std_logic;
   SIGNAL tx_state_q               :  std_logic;
   SIGNAL overload_request         :  std_logic;
   SIGNAL overload_frame           :  std_logic;
   -- Arbitration Lost Capture Register
   SIGNAL read_arbitration_lost_capture_reg:  std_logic;
   -- Error Code Capture Register
   SIGNAL read_error_code_capture_reg     :  std_logic;
   SIGNAL error_capture_code       :  std_logic_vector(7 DOWNTO 0);
   -- Bus Timing 0 register
   SIGNAL baud_r_presc             :  std_logic_vector(5 DOWNTO 0);
   SIGNAL sync_jump_width          :  std_logic_vector(1 DOWNTO 0);
   -- Bus Timing 1 register
   SIGNAL time_segment1            :  std_logic_vector(3 DOWNTO 0);
   SIGNAL time_segment2            :  std_logic_vector(2 DOWNTO 0);
   SIGNAL triple_sampling          :  std_logic;
   -- Error Warning Limit register
   SIGNAL error_warning_limit      :  std_logic_vector(7 DOWNTO 0);
   -- Rx Error Counter register
   SIGNAL we_rx_err_cnt            :  std_logic;
   -- Tx Error Counter register
   SIGNAL we_tx_err_cnt            :  std_logic;
   -- Clock Divider register
   SIGNAL extended_mode            :  std_logic;
   -- This section is for BASIC and EXTENDED mode
   -- Acceptance code register
   SIGNAL acceptance_code_0        :  std_logic_vector(7 DOWNTO 0);
   -- Acceptance mask register
   SIGNAL acceptance_mask_0        :  std_logic_vector(7 DOWNTO 0);
   -- End: This section is for BASIC and EXTENDED mode
   -- This section is for EXTENDED mode
   -- Acceptance code register
   SIGNAL acceptance_code_1        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_code_2        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_code_3        :  std_logic_vector(7 DOWNTO 0);
   -- Acceptance mask register
   SIGNAL acceptance_mask_1        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_2        :  std_logic_vector(7 DOWNTO 0);
   SIGNAL acceptance_mask_3        :  std_logic_vector(7 DOWNTO 0);
   -- End: This section is for EXTENDED mode
   -- Tx data registers. Holding identifier (basic mode), tx frame information (extended mode) and data
   SIGNAL tx_data_0                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_1                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_2                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_3                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_4                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_5                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_6                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_7                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_8                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_9                :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_10               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_11               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_data_12               :  std_logic_vector(7 DOWNTO 0);
   -- End: Tx data registers
--   SIGNAL cs                       :  std_logic;
   -- Output signals from can_btl module
   SIGNAL sample_point             :  std_logic;
   SIGNAL sampled_bit              :  std_logic;
   SIGNAL sampled_bit_q            :  std_logic;
   SIGNAL tx_point                 :  std_logic;
   SIGNAL hard_sync                :  std_logic;
   -- output from can_bsp module
   SIGNAL rx_idle                  :  std_logic;
   SIGNAL transmitting             :  std_logic;
   SIGNAL transmitter              :  std_logic;
   SIGNAL go_rx_inter              :  std_logic;
   SIGNAL not_first_bit_of_inter   :  std_logic;
   SIGNAL set_reset_mode           :  std_logic;
   SIGNAL node_bus_off             :  std_logic;
   SIGNAL error_status             :  std_logic;
   SIGNAL rx_err_cnt               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL tx_err_cnt               :  std_logic_vector(7 DOWNTO 0);
   SIGNAL rx_err_cnt_dummy         :  std_logic;   --  The MSB is not displayed. It is just used for easier calculation (no counter overflow).
   SIGNAL tx_err_cnt_dummy         :  std_logic;   --  The MSB is not displayed. It is just used for easier calculation (no counter overflow).
   SIGNAL transmit_status          :  std_logic;
   SIGNAL receive_status           :  std_logic;
   SIGNAL tx_successful            :  std_logic;
   SIGNAL need_to_tx               :  std_logic;
   SIGNAL overrun                  :  std_logic;
   SIGNAL info_empty               :  std_logic;
   SIGNAL set_bus_error_irq        :  std_logic;
   SIGNAL set_arbitration_lost_irq :  std_logic;
   SIGNAL arbitration_lost_capture :  std_logic_vector(4 DOWNTO 0);
   SIGNAL node_error_passive       :  std_logic;
   SIGNAL node_error_active        :  std_logic;
   SIGNAL rx_message_counter       :  std_logic_vector(6 DOWNTO 0);
   SIGNAL tx_next                  :  std_logic;
   SIGNAL go_overload_frame        :  std_logic;
   SIGNAL go_error_frame           :  std_logic;
   SIGNAL go_tx                    :  std_logic;
   SIGNAL send_ack                 :  std_logic;
--   SIGNAL rst                      :  std_logic;
--   SIGNAL we                       :  std_logic;
--   SIGNAL addr                     :  std_logic_vector(7 DOWNTO 0);
--   SIGNAL data_in                  :  std_logic_vector(7 DOWNTO 0);
--   SIGNAL data_out                 :  std_logic_vector(7 DOWNTO 0);
   SIGNAL rx_sync_tmp              :  std_logic;
   SIGNAL rx_sync                  :  std_logic;
   -- port connections for Ram
   --64x8
   SIGNAL w_q_dp_64x8              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL w_data_64x8              :  std_logic_vector(7 DOWNTO 0);
   SIGNAL w_wren_64x8              :  std_logic;
   SIGNAL w_rden_64x8              :  std_logic;
   SIGNAL w_wraddress_64x8         :  std_logic_vector(5 DOWNTO 0);
   SIGNAL w_rdaddress_64x8         :  std_logic_vector(5 DOWNTO 0);
   --64x4
   SIGNAL w_q_dp_64x4              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL w_data_64x4              :  std_logic_vector(3 DOWNTO 0);
   SIGNAL w_wren_64x4x1            :  std_logic;
   SIGNAL w_wraddress_64x4x1       :  std_logic_vector(5 DOWNTO 0);
   SIGNAL w_rdaddress_64x4x1       :  std_logic_vector(5 DOWNTO 0);
   --64x1
   SIGNAL w_q_dp_64x1              :  std_logic;
   SIGNAL w_data_64x1              :  std_logic;
   -- From btl module
   -- Mode register
   -- Command register
   -- Arbitration Lost Capture Register
   -- Error Code Capture Register
   -- Error Warning Limit register
   -- Rx Error Counter register
   -- Tx Error Counter register
   -- Clock Divider register
   -- output from can_bsp module
   SIGNAL xhdl_148                 :  std_logic_vector(8 DOWNTO 0);
   -- The MSB is not displayed. It is just used for easier calculation (no counter overflow).
   SIGNAL xhdl_150                 :  std_logic_vector(8 DOWNTO 0);
--   SIGNAL wb_dat_o_xhdl1           :  std_logic_vector(7 DOWNTO 0);
--   SIGNAL wb_ack_o_xhdl2           :  std_logic;
   SIGNAL tx_o_xhdl3               :  std_logic;
   SIGNAL bus_off_on_xhdl4         :  std_logic;
   SIGNAL irq_on_xhdl5             :  std_logic;
   SIGNAL clkout_o_xhdl6           :  std_logic;
   SIGNAL data_64x8_xhdl7          :  std_logic_vector(7 DOWNTO 0);
   SIGNAL wren_64x8_xhdl8          :  std_logic;
   SIGNAL rden_64x8_xhdl9          :  std_logic;
   SIGNAL wraddress_64x8_xhdl10    :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x8_xhdl11    :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x4_xhdl12         :  std_logic_vector(3 DOWNTO 0);
   SIGNAL wren_64x4x1_xhdl13       :  std_logic;
   SIGNAL wraddress_64x4x1_xhdl14  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL rdaddress_64x4x1_xhdl15  :  std_logic_vector(5 DOWNTO 0);
   SIGNAL data_64x1_xhdl16         :  std_logic;
   SIGNAL rx_inter                 :  std_logic;

BEGIN
--   wb_dat_o <= wb_dat_o_xhdl1;
--   wb_ack_o <= wb_ack_o_xhdl2;
   tx_o <= tx_o_xhdl3;
   bus_off_on <= bus_off_on_xhdl4;
   irq_on <= irq_on_xhdl5;
   clkout_o <= clkout_o_xhdl6;
   data_64x8 <= data_64x8_xhdl7;
   wren_64x8 <= wren_64x8_xhdl8;
   rden_64x8 <= rden_64x8_xhdl9;
   wraddress_64x8 <= wraddress_64x8_xhdl10;
   rdaddress_64x8 <= rdaddress_64x8_xhdl11;
   data_64x4 <= data_64x4_xhdl12;
   wren_64x4x1 <= wren_64x4x1_xhdl13;
   wraddress_64x4x1 <= wraddress_64x4x1_xhdl14;
   rdaddress_64x4x1 <= rdaddress_64x4x1_xhdl15;
   data_64x1 <= data_64x1_xhdl16;
   -- port connections for Ram
   --64x8
   w_q_dp_64x8 <= q_dp_64x8 ;
   data_64x8_xhdl7 <= w_data_64x8 ;
   wren_64x8_xhdl8 <= w_wren_64x8 ;
   rden_64x8_xhdl9 <= w_rden_64x8 ;
   wraddress_64x8_xhdl10 <= w_wraddress_64x8 ;
   rdaddress_64x8_xhdl11 <= w_rdaddress_64x8 ;
   --64x4
   w_q_dp_64x4 <= q_dp_64x4 ;
   data_64x4_xhdl12 <= w_data_64x4 ;
   wren_64x4x1_xhdl13 <= w_wren_64x4x1 ;
   wraddress_64x4x1_xhdl14 <= w_wraddress_64x4x1 ;
   rdaddress_64x4x1_xhdl15 <= w_rdaddress_64x4x1 ;
   --64x1
   w_q_dp_64x1 <= q_dp_64x1 ;
   data_64x1_xhdl16 <= w_data_64x1 ;

   -- Connecting can_registers module -- Mode register -- Command register -- Arbitration Lost Capture Register -- Error Code Capture Register -- Bus Timing 0 register -- Bus Timing 1 register -- Error Warning Limit register -- Rx Error Counter register -- Tx Error Counter register -- Clock Divider register -- This section is for BASIC and EXTENDED mode -- Acceptance code register -- Acceptance mask register -- End: This section is for BASIC and EXTENDED mode -- This section is for EXTENDED mode -- Acceptance code register -- Acceptance mask register -- End: This section is for EXTENDED mode -- Tx data registers. Holding identifier (basic mode), tx frame information (extended mode) and data -- End: Tx data registers
   i_can_registers : can_registers
      PORT MAP (
         clk => clk_i,
         rst => rst,
         cs => cs,
         we => we,
         addr => addr,
         data_in => data_in,
         data_out => data_out_regs,
         irq_n => irq_on_xhdl5,
         sample_point => sample_point,
         transmitting => transmitting,
         set_reset_mode => set_reset_mode,
         node_bus_off => node_bus_off,
         error_status => error_status,
         rx_err_cnt => rx_err_cnt,
         tx_err_cnt => tx_err_cnt,
         transmit_status => transmit_status,
         receive_status => receive_status,
         tx_successful => tx_successful,
         need_to_tx => need_to_tx,
         overrun => overrun,
         info_empty => info_empty,
         set_bus_error_irq => set_bus_error_irq,
         set_arbitration_lost_irq => set_arbitration_lost_irq,
         arbitration_lost_capture => arbitration_lost_capture,
         node_error_passive => node_error_passive,
         node_error_active => node_error_active,
         rx_message_counter => rx_message_counter,
         reset_mode => reset_mode,
         listen_only_mode => listen_only_mode,
         acceptance_filter_mode => acceptance_filter_mode,
         self_test_mode => self_test_mode,
         clear_data_overrun => open,
         release_buffer => release_buffer,
         abort_tx => abort_tx,
         tx_request => tx_request,
         self_rx_request => self_rx_request,
         single_shot_transmission => single_shot_transmission,
         tx_state => tx_state,
         tx_state_q => tx_state_q,
         overload_request => overload_request,
         overload_frame => overload_frame,
         read_arbitration_lost_capture_reg => read_arbitration_lost_capture_reg,
         read_error_code_capture_reg => read_error_code_capture_reg,
         error_capture_code => error_capture_code,
         baud_r_presc => baud_r_presc,
         sync_jump_width => sync_jump_width,
         time_segment1 => time_segment1,
         time_segment2 => time_segment2,
         triple_sampling => triple_sampling,
         error_warning_limit => error_warning_limit,
         we_rx_err_cnt => we_rx_err_cnt,
         we_tx_err_cnt => we_tx_err_cnt,
         extended_mode => extended_mode,
         clkout => clkout_o_xhdl6,
         acceptance_code_0 => acceptance_code_0,
         acceptance_mask_0 => acceptance_mask_0,
         acceptance_code_1 => acceptance_code_1,
         acceptance_code_2 => acceptance_code_2,
         acceptance_code_3 => acceptance_code_3,
         acceptance_mask_1 => acceptance_mask_1,
         acceptance_mask_2 => acceptance_mask_2,
         acceptance_mask_3 => acceptance_mask_3,
         tx_data_0 => tx_data_0,
         tx_data_1 => tx_data_1,
         tx_data_2 => tx_data_2,
         tx_data_3 => tx_data_3,
         tx_data_4 => tx_data_4,
         tx_data_5 => tx_data_5,
         tx_data_6 => tx_data_6,
         tx_data_7 => tx_data_7,
         tx_data_8 => tx_data_8,
         tx_data_9 => tx_data_9,
         tx_data_10 => tx_data_10,
         tx_data_11 => tx_data_11,
         tx_data_12 => tx_data_12);


   -- Connecting can_btl module -- Bus Timing 0 register -- Bus Timing 1 register -- Output signals from this module -- output from can_bsp module
   i_can_btl : can_btl
      PORT MAP (
         clk => clk_i,
         rst => rst,
         rx => rx_sync,
         tx => tx_o_xhdl3,
         baud_r_presc => baud_r_presc,
         sync_jump_width => sync_jump_width,
         time_segment1 => time_segment1,
         time_segment2 => time_segment2,
         triple_sampling => triple_sampling,
         sample_point => sample_point,
         sampled_bit => sampled_bit,
         sampled_bit_q => sampled_bit_q,
         tx_point => tx_point,
         hard_sync => hard_sync,
         rx_idle => rx_idle,
         rx_inter => rx_inter,
         transmitting => transmitting,
         transmitter => transmitter,
         go_rx_inter => go_rx_inter,
         tx_next => tx_next,
         go_overload_frame => go_overload_frame,
         go_error_frame => go_error_frame,
         go_tx => go_tx,
         send_ack => send_ack,
         node_error_passive => node_error_passive);

--   xhdl_148 <= rx_err_cnt_dummy & rx_err_cnt(7 DOWNTO 0);
   rx_err_cnt_dummy <= xhdl_148(8);
   rx_err_cnt(7 DOWNTO 0) <= xhdl_148(7 DOWNTO 0);
--   xhdl_150 <= tx_err_cnt_dummy & tx_err_cnt(7 DOWNTO 0);
   tx_err_cnt_dummy <= xhdl_150(8);
   tx_err_cnt(7 DOWNTO 0) <= xhdl_150(7 DOWNTO 0);

   -- The MSB is not displayed. It is just used for easier calculation (no counter overflow).
   -- This section is for BASIC and EXTENDED mode -- Acceptance code register -- Acceptance mask register -- End: This section is for BASIC and EXTENDED mode -- This section is for EXTENDED mode -- Acceptance code register -- Acceptance mask register -- End: This section is for EXTENDED mode -- Tx data registers. Holding identifier (basic mode), tx frame information (extended mode) and data -- End: Tx data registers -- Tx signal -- port connections for Ram
   --64x8
   --64x4
   --64x1
   i_can_bsp : can_bsp
      PORT MAP (
         clk => clk_i,
         rst => rst,
         sample_point => sample_point,
         sampled_bit => sampled_bit,
         sampled_bit_q => sampled_bit_q,
         tx_point => tx_point,
         hard_sync => hard_sync,
         addr => addr,
         data_in => data_in,
         data_out => data_out_fifo,
         fifo_selected => data_out_fifo_selected,
         reset_mode => reset_mode,
         listen_only_mode => listen_only_mode,
         acceptance_filter_mode => acceptance_filter_mode,
         self_test_mode => self_test_mode,
         release_buffer => release_buffer,
         tx_request => tx_request,
         abort_tx => abort_tx,
         self_rx_request => self_rx_request,
         single_shot_transmission => single_shot_transmission,
         tx_state => tx_state,
         tx_state_q => tx_state_q,
         overload_request => overload_request,
         overload_frame => overload_frame,
         read_arbitration_lost_capture_reg => read_arbitration_lost_capture_reg,
         read_error_code_capture_reg => read_error_code_capture_reg,
         error_capture_code => error_capture_code,
         error_warning_limit => error_warning_limit,
         we_rx_err_cnt => we_rx_err_cnt,
         we_tx_err_cnt => we_tx_err_cnt,
         extended_mode => extended_mode,
         rx_idle => rx_idle,
         transmitting => transmitting,
         transmitter => transmitter,
         go_rx_inter => go_rx_inter,
         not_first_bit_of_inter => not_first_bit_of_inter,
         rx_inter => rx_inter,
         set_reset_mode => set_reset_mode,
         node_bus_off => node_bus_off,
         error_status => error_status,
         rx_err_cnt => xhdl_148,
         tx_err_cnt => xhdl_150,
         transmit_status => transmit_status,
         receive_status => receive_status,
         tx_successful => tx_successful,
         need_to_tx => need_to_tx,
         overrun => overrun,
         info_empty => info_empty,
         set_bus_error_irq => set_bus_error_irq,
         set_arbitration_lost_irq => set_arbitration_lost_irq,
         arbitration_lost_capture => arbitration_lost_capture,
         node_error_passive => node_error_passive,
         node_error_active => node_error_active,
         rx_message_counter => rx_message_counter,
         acceptance_code_0 => acceptance_code_0,
         acceptance_mask_0 => acceptance_mask_0,
         acceptance_code_1 => acceptance_code_1,
         acceptance_code_2 => acceptance_code_2,
         acceptance_code_3 => acceptance_code_3,
         acceptance_mask_1 => acceptance_mask_1,
         acceptance_mask_2 => acceptance_mask_2,
         acceptance_mask_3 => acceptance_mask_3,
         tx_data_0 => tx_data_0,
         tx_data_1 => tx_data_1,
         tx_data_2 => tx_data_2,
         tx_data_3 => tx_data_3,
         tx_data_4 => tx_data_4,
         tx_data_5 => tx_data_5,
         tx_data_6 => tx_data_6,
         tx_data_7 => tx_data_7,
         tx_data_8 => tx_data_8,
         tx_data_9 => tx_data_9,
         tx_data_10 => tx_data_10,
         tx_data_11 => tx_data_11,
         tx_data_12 => tx_data_12,
         tx => tx_o_xhdl3,
         tx_next => tx_next,
         bus_off_on => bus_off_on_xhdl4,
         go_overload_frame => go_overload_frame,
         go_error_frame => go_error_frame,
         go_tx => go_tx,
         send_ack => send_ack,
         q_dp_64x8 => w_q_dp_64x8,
         data_64x8 => w_data_64x8,
         wren_64x8 => w_wren_64x8,
         rden_64x8 => w_rden_64x8,
         wraddress_64x8 => w_wraddress_64x8,
         rdaddress_64x8 => w_rdaddress_64x8,
         q_dp_64x4 => w_q_dp_64x4,
         data_64x4 => w_data_64x4,
         wren_64x4x1 => w_wren_64x4x1,
         wraddress_64x4x1 => w_wraddress_64x4x1,
         rdaddress_64x4x1 => w_rdaddress_64x4x1,
         q_dp_64x1 => w_q_dp_64x1,
         data_64x1 => w_data_64x1);


   -- Multiplexing wb_dat_o from registers and rx fifo

   PROCESS (extended_mode, addr, reset_mode)
      VARIABLE data_out_fifo_selected_xhdl203  : std_logic;
   BEGIN
      IF ((((extended_mode AND (NOT reset_mode)) AND CONV_STD_LOGIC((addr >= "00010000") AND (addr<="00011100"))) OR ((NOT extended_mode) AND CONV_STD_LOGIC((addr >= "00010100") AND (addr<="00011101")))) = '1') THEN
         data_out_fifo_selected_xhdl203 := '1';
      ELSE
         data_out_fifo_selected_xhdl203 := '0';
      END IF;
      data_out_fifo_selected <= data_out_fifo_selected_xhdl203;
   END PROCESS;

   PROCESS (clk_i)
   BEGIN
      IF (clk_i'EVENT AND clk_i = '1') THEN
         IF ((cs AND (NOT we)) = '1') THEN
            IF (data_out_fifo_selected = '1') THEN
               data_out <= data_out_fifo ;
            ELSE
               data_out <= data_out_regs ;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (clk_i, rst)
   BEGIN
      IF (rst = '1') THEN
         rx_sync_tmp <= '1';
         rx_sync <= '1';
      ELSIF (clk_i'EVENT AND clk_i = '1') THEN
         rx_sync_tmp <= rx_i ;
         rx_sync <= rx_sync_tmp ;
      END IF;
   END PROCESS;
--   cs_can_i <= '1' ;

   -- Combining wb_cyc_i and wb_stb_i signals to cs signal. Than synchronizing to clk_i clock domain.

--   PROCESS (clk_i, rst)
--   BEGIN
--      IF (rst = '1') THEN
--         cs_sync1 <= '0';
--         cs_sync2 <= '0';
--         cs_sync3 <= '0';
--         cs_sync_rst1 <= '0';
--         cs_sync_rst2 <= '0';
--      ELSIF (clk_i'EVENT AND clk_i = '1') THEN
--         cs_sync1 <= ((wb_cyc_i AND wb_stb_i) AND (NOT cs_sync_rst2)) AND cs_can_i ;
--        cs_sync2 <= cs_sync1 AND (NOT cs_sync_rst2) ;
--        cs_sync3 <= cs_sync2 AND (NOT cs_sync_rst2) ;
--        cs_sync_rst1 <= cs_ack3 ;
--        cs_sync_rst2 <= cs_sync_rst1 ;
--     END IF;
--  END PROCESS;
--  cs <= cs_sync2 AND (NOT cs_sync3) ;
--
--   PROCESS (wb_clk_i)
--   BEGIN
--      IF (wb_clk_i'EVENT AND wb_clk_i = '1') THEN
--         cs_ack1 <= cs_sync3 ;
--         cs_ack2 <= cs_ack1 ;
--         cs_ack3 <= cs_ack2 ;
--      END IF;
--   END PROCESS;

   -- Generating acknowledge signal

--   PROCESS (wb_clk_i)
--   BEGIN
--      IF (wb_clk_i'EVENT AND wb_clk_i = '1') THEN
--         wb_ack_o_xhdl2 <= cs_ack2 AND (NOT cs_ack3) ;
--      END IF;
--   END PROCESS;
--   rst <= wb_rst_i ;
--   we <= wb_we_i ;
--   addr <= wb_adr_i ;
--   data_in <= wb_dat_i ;
--   wb_dat_o_xhdl1 <= data_out ;



END ARCHITECTURE RTL;
