# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#


import re
from ftg.flow_table import FlowTable
from ftg.flow_priority import FlowPriority
from ftg.flow_entry import FlowEntry
from ftg.formatter.base_formatter import BaseFormatter


class OVSAddFlowFormatter(BaseFormatter):
    formatter_name = "addflow"

# "table=0,priority=10000,in_port=1,dl_dst=xx:xx:xx:12:50:c8,actions=output:5"

    HEADER_FORMAT = "#OVS_BR_NAME=br0"
    FOOTER_FORMAT = ""
    OVS_OFCTL = "ovs-ofctl add-flow "

    def format(self):
        formatted_flow = []
        formatted_flow.append(self.get_header())

        for t_no in sorted(self._tables.keys(), key=lambda x: int(x)):
            for p_no in sorted(self._tables[t_no].get_priorities(), key=lambda x: int(x), reverse=True):
                for ent in self._tables[t_no].get_priority(p_no).get_flow_entries():
                    formatted_flow.append(
                        self.OVS_OFCTL + "$OVS_BR_NAME \'table=" + t_no + ",priority=" +
                        p_no + "," + ent.get_match_exp() + ",actions=" + ",".join(ent.get_instructions()) + "\'")

        formatted_flow.append(self.get_footer())
        return formatted_flow
