/*
 * Copyright (C) 2011 OgakiSoft
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ogakisoft.android.gestureime;

//import android.gesture.Gesture;
import ogakisoft.android.gesture.reform.Gesture;

/**
 * Data Class for gesture and assigned string
 * 
 * @author noritoshi ogaki
 * @version 1.0
 */
public class NamedGesture {
	private final Gesture gesture;
	private String name;

	public NamedGesture(Gesture gesture, String name) {
		this.gesture = gesture;
		this.name = name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public long getId() {
		return gesture.getId();
	}

	public String getName() {
		return name;
	}

	public Gesture getGesture() {
		return gesture;
	}
	
	@Override
	public String toString() {
		return null;
	}
}
