#pragma once
#include <QtNetwork>
#include "../definition.h"
#include "../structures/header.h"
#include "../definition.h"
#include "../ported_rmd6/rmd6.h"

#define default_bandwidth 0x400
namespace network{
	class serverSocket;

	class tcpServer:virtual public QTcpServer{
		Q_OBJECT
	public:
		tcpServer(quint64 buffersize=default_bandwidth,QObject *parent=NULL);
	signals:
		bool pending(const serverSocket &) const;
		void socket_error(const serverSocket &) const;
	protected:
		void incomingConnection(int handle);
	private:
		quint64 buffersize;
	};

	class serverSocket:virtual public QTcpSocket{
		Q_OBJECT
	public:
		serverSocket(quint64 buffersize=default_bandwidth,QObject *parent=NULL);
		enum aborted_reason{header_invalid,stream_open_failed,empty_filename_specified,user};
		QString path_to_save() const;
		structures::header header_data() const;
	signals:
		QString file_pending(const serverSocket &socket) const;
		QString fileStream_openFailed(const serverSocket &,const QFile::FileError &,const QString &) const;

		void receive_aborted(const serverSocket &,const aborted_reason &);
		void msg_received(const serverSocket &socket,const QString &) const;
		void data_broken(const serverSocket &socket) const;

		void file_receive_progress(const quint64 streamPos,const serverSocket &socket) const;
		void file_saved(const serverSocket &socket) const;
		void file_broken(const serverSocket &socket) const;
	private slots:
		void read_data();
		void cancel();
	private:
		enum mode{headsize,header,data} event;
		void size_event();
		void header_event();
		void data_event();
		void abort_receive(aborted_reason reason);
		bool check_canceled_then_abort();
		//The size of header needs to be larger than 0, and smaller than or equal to 0xFFFF.
		quint16 header_size;
		quint64 buffer_size;
		structures::header head_data;
		bool canceled;
		QString where_to_save;
	};
}
