#include "settingdialog.h"
#include "../validator/ipaddressvalidator.h"

SettingDialog::SettingDialog(QWidget *parent):QDialog(parent){
	this->setupUi(this);
	this->setMaximumSize(this->size());
	this->setMinimumSize(this->size());
	this->address->setValidator(new IPAddressValidator(false,this->address));;
	this->setWindowFlags(Qt::Dialog|Qt::WindowMinimizeButtonHint|Qt::WindowCloseButtonHint);
}

QHostAddress SettingDialog::IPAddress()const{return QHostAddress(this->address->text());}
quint16 SettingDialog::port()const{return this->port_control->value();}
AddressAndPort SettingDialog::addressPort()const{return AddressAndPort(QHostAddress(this->address->text()),this->port_control->value());}
QString SettingDialog::nickName()const{return this->nickName_control->text();}
bool SettingDialog::noloadMemberlist()const{return this->no_load_memberlist->isChecked();}

void SettingDialog::setPort(const quint16 port){this->port_control->setValue(port);}
void SettingDialog::setNickName(const QString &name){this->nickName_control->setText(name);}
void SettingDialog::setIPAddress(const QHostAddress &address){this->address->setText(address.toString());}
void SettingDialog::setNoloadMemberlist(const bool yesno){this->no_load_memberlist->setChecked(yesno);}
void SettingDialog::setTab(const tab id){
	switch(id){
	case SettingDialog::server:
		server:
		this->settingTab->setCurrentIndex(0);
		break;
	case SettingDialog::client:
		this->settingTab->setCurrentIndex(1);
		break;
	case SettingDialog::misc:
		this->settingTab->setCurrentIndex(2);
		break;
	default:
		goto server;
	}
}
void SettingDialog::setTabEnabled(const tab id,bool enable){
	switch(id){
	case SettingDialog::server:
		server:
		this->settingTab->setTabEnabled(0,enable);
		break;
	case SettingDialog::client:
		this->settingTab->setTabEnabled(1,enable);
		break;
	case SettingDialog::misc:
		this->settingTab->setTabEnabled(2,enable);
		break;
	default:
		goto server;
	}
}

void SettingDialog::setAddressAndPort(AddressAndPort pair){
	this->setIPAddress(pair.first);
	this->setPort(pair.second);
}
