#pragma once
#include <QtGui>
#include <QtNetwork>
#include "../definition.h"
class MemberList:virtual public QTableWidget{
	Q_OBJECT
public:
	MemberList(QWidget *parent=NULL);
public slots:
	void remove_selected();
	void remove_all_contents();
	QList<AddressAndPort> addressPortList() const;
	QStringList name() const;
	friend QDataStream &operator<<(QDataStream &out,const MemberList &value){
		QHash<QString,AddressAndPort> AddressList;
		for(int row=0;row<value.rowCount();row++){
			QStringList AddrAndPort=value.item(row,1)->text().split(":");
			AddressList.insertMulti(value.item(row,0)->text(),AddressAndPort(QHostAddress(AddrAndPort[0]),(AddrAndPort.count()==2)? AddrAndPort[1].toUShort():default_port));
		}
		out<<AddressList;
		return out;
	}

	friend QDataStream &operator>>(QDataStream &in, MemberList &value){
		QHash<QString,AddressAndPort> AddressList;
		in>>AddressList;
		value.remove_all_contents();
		for(QHash<QString,AddressAndPort>::iterator index=AddressList.begin();index!=AddressList.end();index++){
			QTableWidgetItem *name=new QTableWidgetItem(index.key()),
			*AddressPort=new QTableWidgetItem(QString("%1:%2").
											  arg(index.value().first.toString()).
											  arg(index.value().second));
			value.insertRow(value.rowCount());
			value.setItem(value.rowCount()-1,0,name);
			value.setItem(value.rowCount()-1,1,AddressPort);
		}
		return in;
	}

private:
	void keyReleaseEvent(QKeyEvent *);
};
