#include "stdafx.h"
#include "GVOShipRoute.h"
#include "GVOVector.h"


namespace {
	const float k_worldLoopThreshold = 0.5f;

	inline POINT s_denormalizedPoint( const GVONormalizedPoint & point )
	{
		POINT p = {
			static_cast<long>(::round( point.x() * k_worldWidth )),
			static_cast<long>(::round( point.y() * k_worldHeight )),
		};
		return p;
	}
}


void GVOShipRoute::addRoutePoint( const GVONormalizedPoint & point )
{
	_ASSERT( !isFixed() );

	if ( m_lines.empty() ) {
		m_lines.push_back( Line() );
	}

	Line & line = m_lines.back();
	if ( line.empty() ) {
		line.push_back( point );
		return;
	}

	GVOVector vector( s_denormalizedPoint( line.back() ), s_denormalizedPoint( point ) );
	m_length += static_cast<int64_t>(::round( vector.length() ));

	const GVONormalizedPoint & prevPoint = line.back();
	if ( prevPoint.isEqualValue( point ) ) {
		return;
	}

	// Eׂꍇ͐𕪊
	if ( prevPoint.x() < point.x() && (k_worldLoopThreshold <= (point.x() - prevPoint.x())) ) {
		// ɌČׂꍇ
		const GVONormalizedPoint leftSideSubPoint( point.x() - 1.0f, point.y() );
		const GVONormalizedPoint rightSideSubPoint( prevPoint.x() + 1.0f, prevPoint.y() );

		line.push_back( leftSideSubPoint );
		m_lines.emplace( m_lines.end(), std::move( Line{ rightSideSubPoint, point } ) );
	}
	else if ( point.x() < prevPoint.x() && (k_worldLoopThreshold <= (prevPoint.x() - point.x())) ) {
		// ɌČׂꍇ
		const GVONormalizedPoint rightSideSubPoint( point.x() + 1.0f, point.y() );
		const GVONormalizedPoint leftSideSubPoint( prevPoint.x() - 1.0f, prevPoint.y() );

		line.push_back( rightSideSubPoint );
		m_lines.emplace( m_lines.end(), std::move( Line{ leftSideSubPoint, point } ) );
	}
	else {
		line.push_back( point );
	}
}


void GVOShipRoute::jointPreviousLinesWithRoute( const GVOShipRoute & srcRoute )
{
	// A̍qHێĂȂΖB
	if ( srcRoute.isEmptyRoute() ) {
		return;
	}
	// A̍qHێĂȂΖB
	if ( isEmptyRoute() ) {
		m_lines = srcRoute.m_lines;
		return;
	}


	// Q̍qH̒𑫂
	m_length += srcRoute.m_length;


	Lines tmp = srcRoute.m_lines;

	// O̍qH̏I_ƌ݂̍qH̎n_A\Ȃ烉CqȂ΂ȂȂ

	Line & prevLine = tmp.back();
	Line & nextLine = m_lines.front();

	// Q̐_ێĂ邩mFĂ
	if ( !prevLine.empty() && !nextLine.empty() ) {
		GVONormalizedPoint prevPoint = prevLine.back();
		GVONormalizedPoint nextPoint = nextLine.front();

		// qHԂ̒𑫂
		const double betweenLength = GVOVector( s_denormalizedPoint( prevPoint ), s_denormalizedPoint( nextPoint ) ).length();
		m_length += static_cast<int64_t>(::round( betweenLength ));

		// EׂłȂ悤Ȃڑ
		if ( (std::max( prevPoint.x(), nextPoint.x() ) - std::min(prevPoint.x(), nextPoint.x())) < k_worldLoopThreshold ) {
			prevLine.insert( prevLine.end(), nextLine.begin(), nextLine.end() );
			m_lines.erase( m_lines.begin() );
		}
	}

	tmp.insert( tmp.end(), m_lines.begin(), m_lines.end() );
	m_lines.swap(tmp);

	// ǂ炩CɓqHȂACɓqHƌȂ
	setFavorite( isFavorite() | srcRoute.isFavorite() );
}
