#include "stdafx.h"
#include "GVOShipRouteList.h"




void GVOShipRouteList::closeRoute()
{
	if ( !m_shipRouteList.empty() ) {
		m_shipRouteList.back()->setFix( true );
	}
}


void GVOShipRouteList::addRoutePoint( const GVONormalizedPoint point )
{
	if ( m_shipRouteList.empty() || m_shipRouteList.back()->isFixed() ) {
		addRoute();
	}
	m_shipRouteList.back()->addRoutePoint( point );
	if ( m_observer ) {
		m_observer->onShipRouteListUpdateRoute( m_shipRouteList.back() );
	}
}


void GVOShipRouteList::removeShipRoute( GVOShipRoutePtr shipRoute )
{
	_ASSERT( shipRoute != nullptr );
	auto it = std::find( m_shipRouteList.begin(), m_shipRouteList.end(), shipRoute );
	if ( it == m_shipRouteList.end() ) {
		return;
	}
	GVOShipRoutePtr removeTarget = shipRoute;
	m_shipRouteList.erase( it );
	if ( m_observer ) {
		m_observer->onShipRouteListRemoveItem( removeTarget );
	}
}


void GVOShipRouteList::clearAllItems()
{
	m_shipRouteList.clear();
	if ( m_observer ) {
		m_observer->onShipRouteListRemoveAllItems();
	}
}


void GVOShipRouteList::addRoute()
{
	// ǉƒʒm
	m_shipRouteList.push_back( GVOShipRoutePtr( new GVOShipRoute() ) );
	if ( m_observer ) {
		m_observer->onShipRouteListAddRoute( m_shipRouteList.back() );
	}

	// ꂽ폜
	// Ƃ肠^RR[hŋ𒼂ɏĂB
	int favorits = 0;
	for ( auto route : m_shipRouteList ) {
		if ( route->isFavorite() ) {
			++favorits;
		}
	}
	const int overCount = m_shipRouteList.size() - (m_maxRouteCountWithoutFavorits + favorits);
	if ( 0 < overCount ) {
		int removeCount = 0;
		auto it = m_shipRouteList.begin();
		while ( it != m_shipRouteList.end() && removeCount < overCount) {
			if ( (*it)->isFavorite() ) {
				++it;
				continue;
			}
			auto itNext = std::next( it, 1 );
			m_shipRouteList.erase( it );
			++removeCount;
			it = itNext;
		}
	}
}


void GVOShipRouteList::joinPreviousRouteAtReverseIndex( int reverseIndex )
{
	_ASSERT( 0 <= reverseIndex );
	_ASSERT( reverseIndex < (int)m_shipRouteList.size() );

	RouteList::iterator itBase;
	itBase = m_shipRouteList.begin();
	std::advance( itBase, indexFromReverseIndex( reverseIndex ) );
	RouteList::iterator itPrev = std::prev( itBase );
	_ASSERT( itPrev != m_shipRouteList.end() );
	GVOShipRoutePtr baseRoute = *itBase;
	GVOShipRoutePtr prevRoute = *itPrev;

	m_shipRouteList.erase( itPrev );
	if ( m_observer ) {
		m_observer->onShipRouteListRemoveItem( prevRoute );
	}

	baseRoute->jointPreviousLinesWithRoute( *prevRoute );

	// ʒm
	if ( m_observer ) {
		m_observer->onShipRouteListUpdateRoute( baseRoute );
	}
}
