<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/../common/common.php");
	require_once("MDB2.php");
	
	/**
	 * AJEgɊւ@\񋟂܂B
	 * 
	 * @package logic
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ Ђ߂m[g
	 */
	class Hirameki_AccountLogic {
		/**
		 * OCs܂B
		 * 
		 * OCƁA[U\ȉ̍\̔z$_SESSION["user"]Ɋi[܂B
		 * <samp>
		 * array(
		 *     "id" => AJEgID,
		 *     "name" => [U,
		 *     "real_name" => [U̖O,
		 *     "email" => [AhX
		 * )
		 * </samp>
		 * ̂߁Ã\bhĂԑOɃZbVJnĂKv܂B
		 * 
		 * @param string $name [UB
		 * @param string $password pX[hB
		 * @return OCɐꍇTRUEAsꍇFALSEB
		 */
		public static function login($name, $password) {
			/*
			 * mF܂B
			 */
			if (empty($name)) {
				throw new ArgumentException("namełB");
			}
			if (!is_string($name)) {
				throw new ArgumentException("name^ł͂܂B");
			}
			if (empty($password)) {
				throw new ArgumentException("passwordłB");
			}
			if (!is_string($password)) {
				throw new ArgumentException("password^ł͂܂B");
			}
			
			/*
			 * f[^x[XAJEgAOCmFs܂B
			 */
			global $config;
			$con = MDB2::connect($config);
			$con->loadModule("Extended");
			
			$sql = <<< SQL_END
select
	account.id as id,
	account.name as name,
	account.real_name as real_name,
	account.email as email
from
	account,
	(
		select
			id,
			max(create_time) as latest_time
		from
			account
		group by
			id
		having
			name = :name
			and password = :password
	) as latest_account
where
	account.id = latest_account.id
	and account.create_time = latest_account.latest_time
	and account.enable = :enable
SQL_END;
			$type = array(
				"id" => "integer",
				"name" => "text",
				"real_name" => "text",
				"email" => "text"
			);
			$param = array(
				"name" => $name,
				"password" => md5($password),
				"enable" => 1
			);
			$param_type = array(
				"name" => "text",
				"password" => "text",
				"enable" => "integer"
			);
			
			$result = $con->getAll($sql, $type, $param, $param_type, MDB2_FETCHMODE_ASSOC);
			
			$con->disconnect();
			
			if (count($result) === 1) {
				$_SESSION["user"] = $result[0];
				return TRUE;
			} else {
				return FALSE;
			}
		}
	}
?>
