/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


				.text


/************************************************
  実行コンテキストエントリーアドレス
 ************************************************/
				.align	2
ctx_entry:	 	
				mov		r9, r4					/* 実行時パラメータ1を設定 */
				jmp		@r8						/* 実行開始アドレスに分岐 */
				mov		r10, r5					/* 実行時パラメータ2を設定(遅延スロット) */


/************************************************
  実行コンテキストの作成
  _kernel_cre_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb,	作成するコンテキスト [r4]
		VP              isp,		初期スタックポインタ [r5]
		FP              entry,		実行アドレス         [r6]
		VP_INT          par1,		実行時パラメータ1    [r7]
		VP_INT          par2)		実行時パラメータ2    [@(0, r15)]
 ************************************************/
				.align	2
				.global	__kernel_cre_ctx
__kernel_cre_ctx:
				add 	#-40, r5				/* スタックに領域を確保 */
				mov.l	r6, @(36, r5)			/* 実行アドレスを      r8 の領域に設定 */
				mov.l	r7, @(32, r5)			/* 実行時パラメータ1を r9 の領域に設定 */
				mov.l	@(0, r15), r0
				mov.l	r0, @(28, r5)			/* 実行時パラメータ2を r10 の領域に設定 */
				mov.l	addr_ctx_entry, r0
				mov.l	r0, @(0, r5)			/* 実行エントリポイントを pr の領域に設定 */
				rts
				mov.l	r5, @(0, r4) 			/* スタックポインタを保存(遅延スロット) */

				.align	2
addr_ctx_entry:
				.long	ctx_entry




				.end


/* end of file */
