package iax.client.protocol.call.command.send;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ControlFrame;
import iax.client.protocol.frame.ProtocolControlFrame;

/**
 * Sends an accept and after them a ringing
 */
public class Ringing {

    public static void execute(Call call) {
        call.handleSendFrame(new ProtocolControlFrame(call.getSrcCallNo(), 
                false, 
                call.getDestCallNo(), 
                call.getTimestamp(), 
                call.getOseqno(), 
                call.getIseqno(), 
                false, 
                ProtocolControlFrame.ACCEPT_SC));
        call.handleSendFrame(new ControlFrame(call.getSrcCallNo(), 
                false, 
                call.getDestCallNo(), 
                call.getTimestamp(), 
                call.getOseqno(), 
                call.getIseqno(), 
                false, 
                ControlFrame.RINGING, new byte[0]));
    }

}
