/*******************************************************************************
 * JfxMessageBox
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package jfx.messagebox;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TestJfxApplication extends Application {
    @Override
    public void start(final Stage primaryStage) {
        final VBox root = new VBox();
        root.getChildren().add(new Label("Here is JfxMessageBox samples."));

        root.setSpacing(10);

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Error dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox.show(primaryStage,
                            "Sample of error dialog.\n\nDialog option is below.\n[MessageBox.ICON_ERROR]",
                            "Error dialog", MessageBox.ICON_ERROR);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Warning dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox.show(primaryStage,
                            "Sample of Warning dialog.\n\nDialog option is below.\n[MessageBox.ICON_WARNING]",
                            "Warning dialog", MessageBox.ICON_WARNING);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Information dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox
                            .show(primaryStage,
                                    "Sample of information dialog.\n\nDialog option is below.\n[MessageBox.ICON_INFORMATION | MessageBox.OK | MessageBox.CANCEL]",
                                    "Information dialog", MessageBox.ICON_INFORMATION | MessageBox.OK
                                            | MessageBox.CANCEL);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Question dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox
                            .show(primaryStage,
                                    "Sample of question dialog.\n\nDialog option is below.\n[MessageBox.ICON_QUESTION | MessageBox.YES | MessageBox.NO | MessageBox.DEFAULT_BUTTON2]",
                                    "Question dialog", MessageBox.ICON_QUESTION | MessageBox.YES | MessageBox.NO
                                            | MessageBox.DEFAULT_BUTTON2);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Retry/Cancel dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox
                            .show(primaryStage,
                                    "Sample of Retry/Cancel dialog.\n\nDialog option is below.\n[MessageBox.ICON_QUESTION | MessageBox.RETRY | MessageBox.CANCEL]",
                                    "Retry/Cancel dialog", MessageBox.ICON_QUESTION | MessageBox.RETRY
                                            | MessageBox.CANCEL);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Abort/Retry/Ignore dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox
                            .show(primaryStage,
                                    "Sample of Abort/Retry/Ignore dialog.\n\nDialog option is below.\n[MessageBox.ICON_WARNING | MessageBox.ABORT | MessageBox.RETRY | MessageBox.IGNORE | MessageBox.DEFAULT_BUTTON2]",
                                    "Abort/Retry/Ignore dialog", MessageBox.ICON_WARNING | MessageBox.ABORT
                                            | MessageBox.RETRY | MessageBox.IGNORE | MessageBox.DEFAULT_BUTTON2);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("No style dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox.show(primaryStage, "no style!", "Simple dialog", 0);
                    showResultValue(primaryStage, result);
                }
            });
        }

        {
            final Button btnAdd = new Button();
            root.getChildren().add(btnAdd);
            btnAdd.setText("Full style dialog");
            btnAdd.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent e) {
                    final int result = MessageBox.show(primaryStage, "Full style.", "Full style dialog",
                            MessageBox.ICON_INFORMATION | MessageBox.OK | MessageBox.CANCEL | MessageBox.ABORT
                                    | MessageBox.IGNORE | MessageBox.YES | MessageBox.NO | MessageBox.RETRY
                                    | MessageBox.DEFAULT_BUTTON4);
                    showResultValue(primaryStage, result);
                }
            });
        }

        final Scene scene = new Scene(root, 500, 350);
        primaryStage.setTitle("Hello dialog world!");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void main(final String[] args) {
        launch(args);
    }

    static void showResultValue(final Stage primaryStage, final int result) {
        MessageBox.show(primaryStage, "Result value of dialog is [0x" + Integer.toHexString(result) + "]",
                "Dialog result value", MessageBox.ICON_INFORMATION);
    }
}
