class BufferedRenderer extends Renderer {
	buffer: HTMLCanvasElement;
	c: CanvasRenderingContext2D;
	size: CommonSize;

	constructor(size:CommonSize) {
		super();
		this.size = size;
		this.refresh();
	}

	clear() {
		this.c.clearRect(0, 0, this.size.width, this.size.height);
	}

	createSprite(area?:Area, distArea?:Area) {
		if (! area)
			area = new Area(0, 0, this.size.width, this.size.height);
		if (! distArea)
			distArea = new Area(0, 0, area.width, area.height)

		var canvas:HTMLCanvasElement = window.createCanvas(area.width, area.height);

		var context = canvas.getContext("2d");
		context.drawImage(
			this.buffer,
			area.x,
			area.y,
			area.width,
			area.height,
			distArea.x,
			distArea.y,
			distArea.width,
			distArea.height
		);
		return new Sprite(area.width, area.height, canvas);
	}

	renderUnit(entity:E) {
		var area = new Area(
			0,
			0,
			entity.width,
			entity.height
		);
		this.renderEntity(area, entity, this.c);
	}

	renderLayer(layer:Layer) {
		this.renderParent(layer, this.c);
	}

	renderScene(scene:Scene) {
		this.clear();
		for (var i in scene.layers) {
			this.renderLayer(scene.layers[i]);
		}
	}

	refresh() {
		delete this.buffer;
		this.buffer = window.createCanvas(this.size.width, this.size.height);
		this.c = this.buffer.getContext("2d");
	}
}