module jg {
	export class Layer extends E {
		canvas:HTMLCanvasElement;
		context:CanvasRenderingContext2D;

		constructor(scene:Scene) {
			super();
			this.entities = [];
			this.x = 0;
			this.y = 0;
			this.scene = scene;
			this.width = this.scene.game.width;
			this.height = this.scene.game.height;
			this.isUpdated = true;
		}

		hasBuffer() {
			if (this.canvas)
				return true;
			return false;
		}

		createBuffer() {
			this.refresh(true);
		}

		refresh(must?:bool) {
			if (must || this.hasBuffer()) {
				this.canvas = window.createCanvas(this.width, this.height);
				this.context = this.canvas.getContext("2d");
				this.updated();
			}
			if (this.entities) {
				for (var i=0; i<this.entities.length; i++) {
					if (this.entities[i]["refresh"])
						this.entities[i]["refresh"]();
				}
			}
		}

		deleteBuffer() {
			delete this.context;
			delete this.canvas;
		}

		destroy() {
			super.destroy();
			if (this.hasBuffer())
				this.deleteBuffer();
		}
	}
}