module jg {
/*
Copyright (c) Ubiquitous Entertainment Inc. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

	export var TWEEN_DRAW_OPTION_SETTERS = {}

	export class Tween extends Action {
		origin:any;
		target:any;
		old:any;
		easing:(t:number, b:number, c:number, d:number) => number;
		props:Object;
		otherTarget:any;
		/**
		 * @name enchant.Tween
		 * @class
		 * [lang:ja]
		 * {@link enchant.Action} を継承した、オブジェクトの特定のプロパティを、なめらかに変更したい時に用いるためのアクションクラス.
		 * アクションを扱いやすく拡張したクラス.
		 *
		 * コンストラクタに渡す設定オブジェクトに、プロパティの目標値を指定すると、
		 * アクションが実行された時に、目標値までなめらかに値を変更するようなアクションを生成する。
		 *
		 * トゥイーンのイージングも、easing プロパティで指定できる。
		 * デフォルトでは enchant.Easing.LINEAR が指定されている。
		 *
		 * @param params
		 * @constructs
		 * @config {time}
		 * @config {easing} [function]
		 * [/lang]
		 */
		constructor(params:any) {
			super(params);
			this.origin = {};
			this.target = {};
			this.old    = {};

			this.props = {};
			var excepted = ["frame", "easing", "time", "callback", "onactiontick", "onactionstart", "onactionend"];
			for (var p in params) {
				if (excepted.indexOf(p) === -1)
					this.props[p] = params[p];
			}

			if (this.easing == null) {
				// linear
				this.easing = function(t, b, c, d) {
					return c * t / d + b;
				};
			}

			this.action_start = new Trigger();
			this.action_start.handle(this, this.actionStart);

			this.action_tick.handleInsert(0, this, this.tweenActionTick);
		}

		actionStart(e:ActionEventArgs) {
			for (var prop in this.props) {
				if (prop == "filter") {
					var filter = new this.props[prop].targetClass(this.entity.scene.game);
					if (! this.entity.filter)
						this.entity.filter = new ImageFilter.FilterChain();
					this.entity.filter.add(filter);
					if (this.props[prop].autoDelete) {
						this.removed_from_timeline.handleInsert(
							0,
							this,
							function() {
								if (this.entity.filter) {
									this.entity.filter.remove(filter);
									if (this.entity.filter.count() == 0)
										delete this.entity.filter;
									this.entity.updated();
								}
							}
						);
					}
					this.target[prop] = {}
					this.origin[prop] = {}
					this.old[prop] = {}
					for (var j in this.props[prop]) {
						if (j == "targetClass" || j == "autoDelete")
							continue;
						if (this.props[prop][j].start !== undefined && this.props[prop][j].start != E.prototype.start) {
							var s = this.props[prop][j].start;
							filter.opt[j] = s;
							this.origin[prop][j] = s;
							this.old[prop][j] = s;
							this.target[prop][j] = this.props[prop][j].end;
						} else {
							filter.opt[j] = this.props[prop][j];
						}
					}
					this.otherTarget = filter;
					continue;
				}

				if (!TWEEN_DRAW_OPTION_SETTERS[prop] && typeof this.props[prop] === "object") {
					this.target[prop] = {}
					this.origin[prop] = {}
					this.old[prop] = {}
					for (var j in this.props[prop]) {
						if (typeof this.props[prop][j] === "function")
							this.target[prop][j] = this.props[prop][j].call(this.entity);
						else
							this.target[prop][j] = this.props[prop][j];
						this.origin[prop][j] = this.entity[prop][j];
						this.old[prop][j] = this.entity[prop][j];
					}
					this.otherTarget = this.entity[prop];
					continue;
				}

				if (typeof this.props[prop] === "function")
					this.target[prop] = this.props[prop].call(this.entity);
				else
					this.target[prop] = this.props[prop];

				if (TWEEN_DRAW_OPTION_SETTERS[prop])
					this.origin[prop] = this.entity.getDrawOption(prop);
				else
					this.origin[prop] = this.entity[prop];

				this.old[prop] = this.origin[prop];
			}
		}

		tweenActionTick(e:ActionTickEventArgs) {
			// if time is 0, set property to target value immediately
			var ratio = this.time === 0 ? 1 : 
				this.easing(Math.min(this.time,this.frame + e.elapsed), 0, 1, this.time)
			 	- this.easing(this.frame, 0, 1, this.time);

			for (var prop in this.target){
				if (this[prop] === undefined)
					continue;

				if (TWEEN_DRAW_OPTION_SETTERS[prop]) {
					var f = TWEEN_DRAW_OPTION_SETTERS[prop];
					this.old[prop] = f(
						this.entity, prop,
						this.old[prop],
						this.target[prop],
						this.origin[prop],
						ratio
					);
				} else if (prop == "filter") {
					for (var j in this.target[prop]) {
						this.otherTarget.opt[j] = this.old[prop][j] + (this.target[prop][j] - this.origin[prop][j]) * ratio;
						if (Math.abs(this.otherTarget.opt[j]) < 10e-8)
							this.otherTarget.opt[j] = 0;
						this.old[prop][j] = this.otherTarget.opt[j];
					}
				} else if (this.otherTarget) {
					for (var j in this.target[prop]) {
						this.otherTarget[j] = this.old[prop][j] + (this.target[prop][j] - this.origin[prop][j]) * ratio;
						if (Math.abs(this.otherTarget[j]) < 10e-8)
							this.otherTarget[j] = 0;
						this.old[prop][j] = this.otherTarget[j];
					}
				} else {
					this.entity[prop] = this.old[prop] + (this.target[prop] - this.origin[prop]) * ratio;
					if (Math.abs(this.entity[prop]) < 10e-8)
						this.entity[prop] = 0;

					this.old[prop] = this.entity[prop];
				}
			}
			this.entity.updated();
		}
	}
}

for (var p in jg.ENTITY_OPTIONS_DEFAULT_VALUES) {
	if (typeof jg.ENTITY_OPTIONS_DEFAULT_VALUES[p] == "object") {
		if (p == "translate") {
			jg.TWEEN_DRAW_OPTION_SETTERS[p] = (entity, name, old, target, origin, ratio) => {
				var ret = {
					x: old.x + (target.x - origin.x) * ratio,
					y: old.y + (target.y - origin.y) * ratio
				};
				entity.setDrawOption(name, ret);
				return ret;
			}
		} else if (p == "transform") {
			jg.TWEEN_DRAW_OPTION_SETTERS[p] = (entity, name, old, target, origin, ratio) => {
				throw "unsupported transform tween";
			}
		} else if (p == "scale") {
			jg.TWEEN_DRAW_OPTION_SETTERS[p] = (entity, name, old, target, origin, ratio) => {
				var ret = {
					x: old.x + (target.x - origin.x) * ratio,
					y: old.y + (target.y - origin.y) * ratio
				};
				entity.setDrawOption(name, ret);
				return ret;
			}
		}
	} else {
		jg.TWEEN_DRAW_OPTION_SETTERS[p] = (entity, name, old, target, origin, ratio) => {
			var ret = old + (target - origin) * ratio;
			if (Math.abs(ret) < 10e-8){
				ret = 0;
			}
			entity.setDrawOption(name, ret);
			return ret;
		}
	}
}
