module jg  {
	export class UIWindow extends E {
		padding:IRectangle;
		bg:E;

		constructor(width:number, height:number, bgImage?:any, padding?:IRectangle) {
			super();
			this.width = width;
			this.height = height;

			this.padding = padding ? padding : new Rectangle(8, 8, 8, 8);
			this.entities = [];
			if (bgImage) {
				var bg;
				if (bgImage instanceof E) {
					bg = bgImage;
				} else {
					bg = new Sprite(bgImage);
				}
				this.setBg(this.createBgImage(bg));
			} else {
				this.defaultSkin();
			}
		}

		getBg():E {
			return this.entities[0];
		}
		setBg(bg:E) {
			if (this.bg)
				this.bg.remove();
			this.bg = bg;
			this.insert(bg, 0);
		}

		createBgImage(e:E, srcPadding?:IRectangle, buf?:BufferedRenderer) {
			if (! buf)
				var buf = new BufferedRenderer(e);
			buf.renderUnit(e);
			if (buf.filter)
				buf.applyFilter(buf.c, buf.size);
			var bg = new E();
			bg.width = this.width;
			bg.height = this.height;
			bg.entities = [];
			//四隅
			var s4_1 = buf.createSprite({x: 0, y: 0, width: this.padding.left, height:this.padding.top});
			s4_1.moveTo(0, 0);
			bg.append(s4_1);
			var s4_2 = buf.createSprite({x: e.width-this.padding.right, y: 0, width: this.padding.right, height:this.padding.top});
			s4_2.moveTo(this.width-this.padding.right, 0);
			bg.append(s4_2);
			var s4_3 = buf.createSprite({x: e.width-this.padding.right, y: e.height-this.padding.bottom, width: this.padding.right, height:this.padding.bottom});
			s4_3.moveTo(this.width - this.padding.right, this.height - this.padding.bottom);
			bg.append(s4_3);
			var s4_4 = buf.createSprite({x: 0, y: e.height-this.padding.bottom, width: this.padding.left, height:this.padding.bottom});
			s4_4.moveTo(0, this.height - this.padding.bottom);
			bg.append(s4_4);

			//四片
			var h4_1 =buf.createSprite({
				x: this.padding.left,
				y: 0,
				width: e.width-this.padding.right - this.padding.left,
				height:this.padding.top
			});
			h4_1.moveTo(this.padding.left, 0);
			h4_1.width = this.width - this.padding.right - this.padding.left;
			bg.append(h4_1);
			var h4_2 = buf.createSprite({
				x: e.width - this.padding.right,
				y: this.padding.top,
				width: this.padding.right,
				height: e.height - this.padding.top - this.padding.bottom
			});
			h4_2.moveTo(this.width - this.padding.right, this.padding.top);
			h4_2.height = this.height - this.padding.top - this.padding.bottom;
			bg.append(h4_2);
			var h4_3 = buf.createSprite({
				x: this.padding.left,
				y: e.height - this.padding.bottom,
				width: e.width - this.padding.right - this.padding.left,
				height: this.padding.bottom,
			});
			h4_3.moveTo(this.padding.left, this.height - this.padding.bottom);
			h4_3.width = this.width - this.padding.right - this.padding.left;
			bg.append(h4_3);
			var h4_4 = buf.createSprite({
				x: 0,
				y: this.padding.top,
				width: this.padding.left,
				height: e.height - this.padding.top - this.padding.bottom
			});
			h4_4.moveTo(0, this.padding.top);
			h4_4.height = this.height - this.padding.top - this.padding.bottom;
			bg.append(h4_4);

			//中央
			var center = buf.createSprite({
				x: this.padding.left,
				y: this.padding.top,
				width: e.width - this.padding.left - this.padding.right,
				height: e.height - this.padding.top - this.padding.bottom
			});
			center.moveTo(this.padding.left, this.padding.top);
			center.width = this.width - this.padding.left - this.padding.right;
			center.height = this.height - this.padding.top - this.padding.bottom;
			bg.append(center);

			return bg.createSprite();
		}

		defaultSkin() {
			if (this.bg)
				this.bg.remove();
			var bgColor = JGUtil.createLinearGradient(
				new Rectangle(0, 0, this.width, this.height),
				["rgba(138,193,255,0.5)", "rgba(222, 235, 250, 0.5)"]
			);
			var dummy = new E();
			dummy.width = this.width;
			dummy.height = this.height;
			dummy.entities = [];
			var bg:Shape = new Shape(
				this.width,
				this.height,
				ShapeStyle.Fill,
				bgColor
			);
			dummy.append(bg);

			var textBg:Shape = new Shape(
				this.width-(this.padding.left+this.padding.right)+4,
				this.height-(this.padding.top+this.padding.bottom)+4,
				ShapeStyle.Fill,
				"rgba(45,73,136,0.2)"
			);
			textBg.moveTo(this.padding.left-2, this.padding.top-2);
			dummy.append(textBg);
			this.setBg(dummy.createSprite());
		}
	}
}