///<reference path="all.ts"/>
module jg {
	/**
	 * Characterクラスを量産するためのファクトリ
	 */
	export class CharacterFactory {
		/** 画像のキャラクタ列数 */
		charaCol: number;
		/** 足踏みのアニメーションフレーム数 */
		animeCnt: number;
		/** 一度の移動で移動するピクセル数 */
		movePixel: number;
		/** 移動に要する時間 */
		moveTime: number;
		/** キャラクタに指定する画像 */
		image: HTMLImageElement;
		/** キャラクタの横幅 */
		width: number;
		/** キャラクタの縦幅 */
		height: number;
		/** 足踏みに要する時間 */
		wait: number;
		/** 最初に向いている方向 */
		angle: Angle;
		/**
		 * 利用するコンストラクタ。通常はjg.Characterだが、継承したクラスなどを使いたい場合それを指定する
		 */
		createClass: any;
		/** キャラクタの方向とキャラチップの番号の相対表。{[key:Angle]: number; }形式で指定 */
		angleSeq: any;

		/**
		 * コンストラクタ
		 * @param image キャラクタに指定する画像
		 * @param width キャラクタの横幅
		 * @param height キャラクタの縦幅
		 */
		constructor(image:HTMLImageElement, width:number, height:number) {
			this.width = width;
			this.height = height;
			this.image = image;
			this.wait = 200;
			this.charaCol = 1;
			this.animeCnt = 2;
			this.moveTime = 300;
			this.movePixel = 64;
			this.angle = Angle.Down;
			this.createClass = Character;
		}

		/**
		 * キャラクタを生成する
		 * @param charaSeq 利用する画像のキャラ番号
		 * @param offset 初期x, y座標。省略時はx:0, y:0に配置される
		 * @param angle 初期方向。省略時はthis.angle
		 */
		create(charaSeq:number, offset?: CommonOffset, angle?:Angle) {
			var c:Character = new this.createClass(
				this.image,
				this.width,
				this.height,
				this.wait
			);
			var black = ["width", "height", "image", "wait", "angle"];
			for (var i in this) {
				if (typeof this[i] == "function")
					continue;
				if (black.indexOf(i) >= 0)
					continue;
				c[i] = this[i];
			}
			c.charaSeq = charaSeq;

			c.angle(angle == undefined ? this.angle : angle);

			if (offset)
				c.moveTo(offset.x, offset.y);

			return c;
		}
	}
}
